/*
 * Decompiled with CFR 0.152.
 */
package merlin.actions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import merlin.Intl;
import merlin.actions.Undo;
import merlin.data.Composite;
import merlin.data.CompositePropertyUtil;
import merlin.data.IMerlinObj;
import merlin.data.MerlinData;
import thunderheadeng.util.PropValue;
import thunderheadeng.util.TypedProp;
import thunderheadeng.util.theUtil;

public class CompElementActions {
    public static <PropT> void setProperty(TypedProp<PropT> prop, Collection<? extends IMerlinObj> objs, PropT newVal) {
        MerlinData md = Composite.getDomain(objs);
        new DefProp<PropT>(prop).set(md, objs, newVal);
    }

    public static List<IMerlinObj> flattenToLocallyDefined(TypedProp<?> prop, Collection<? extends IMerlinObj> objs) {
        return CompElementActions.flattenToLocallyDefined(prop, objs, IMerlinObj.class);
    }

    public static <T extends IMerlinObj> List<T> flattenToLocallyDefined(TypedProp<?> prop, Collection<? extends IMerlinObj> objs, Class<? extends T> objType) {
        return CompElementActions.flattenToAccepted(objs, obj -> obj.isSupportedLocallyCurrently(prop), objType);
    }

    public static <ObjT extends IMerlinObj> List<ObjT> flattenToAccepted(Collection<? extends IMerlinObj> objs, Predicate<? super ObjT> test, Class<? extends ObjT> objType) {
        ArrayList modObjs = new ArrayList();
        CompElementActions.flattenToLocallyDefined(objs, test, modObjs, objType);
        return modObjs;
    }

    private static <ObjT extends IMerlinObj> void flattenToLocallyDefined(Collection<? extends IMerlinObj> objs, Predicate<? super ObjT> test, List<? super ObjT> result, Class<? extends ObjT> objType) {
        for (IMerlinObj iMerlinObj : objs) {
            if (objType.isInstance(iMerlinObj) && test.test(objType.cast(iMerlinObj))) {
                result.add(objType.cast(iMerlinObj));
                continue;
            }
            CompElementActions.flattenToLocallyDefined(theUtil.filter(iMerlinObj.getChildren(), IMerlinObj.class), test, result, objType);
        }
    }

    public static class DefProp<ValT>
    extends TypedDefProp<IMerlinObj, ValT> {
        public DefProp(TypedProp<ValT> prop) {
            this(prop, false);
        }

        public DefProp(TypedProp<ValT> prop, boolean localOnly) {
            super(prop, IMerlinObj.class, localOnly);
        }
    }

    public static class MappedProp<ObjT extends IMerlinObj, PropT, BaseT>
    implements IObjectProp<ObjT, PropT> {
        public final IObjectProp<ObjT, BaseT> wrappedProp;
        public final BiFunction<? super ObjT, ? super BaseT, ? extends PropT> fromBase;
        public final BiFunction<? super ObjT, ? super PropT, ? extends BaseT> toBase;

        public MappedProp(IObjectProp<ObjT, BaseT> prop, BiFunction<? super ObjT, ? super BaseT, ? extends PropT> fromBase, BiFunction<? super ObjT, ? super PropT, ? extends BaseT> toBase) {
            this.wrappedProp = prop;
            this.fromBase = fromBase;
            this.toBase = toBase;
        }

        @Override
        public Collection<? extends ObjT> filterObjs(Collection<? extends ObjT> objs) {
            return this.wrappedProp.filterObjs(objs);
        }

        @Override
        public void set(MerlinData md, Collection<? extends ObjT> objs, PropT newVal) {
            Undo.begin(Intl.intl("Set Property"));
            for (IMerlinObj obj : this.filterObjs(objs)) {
                BaseT wrapped = this.toBase.apply(obj, newVal);
                this.wrappedProp.set(md, List.of(obj), wrapped);
            }
            Undo.end(md);
        }

        @Override
        public PropValue<PropT> get(MerlinData md, Collection<? extends ObjT> objs) {
            return CompositePropertyUtil.getValue(objs, obj -> this.wrappedProp.get(md, List.of(obj)).map(val -> this.fromBase.apply(obj, val)));
        }
    }

    public static class TypedDefProp<ObjT extends IMerlinObj, PropT>
    implements IObjectProp<ObjT, PropT> {
        public final TypedProp<PropT> prop;
        public final Class<ObjT> objType;
        public final boolean localOnly;

        public TypedDefProp(TypedProp<PropT> prop, Class<ObjT> objType, boolean localOnly) {
            this.prop = prop;
            this.objType = objType;
            this.localOnly = localOnly;
        }

        public Object getProp() {
            return this.prop;
        }

        protected void saveState(MerlinData md, TypedProp<PropT> prop, Collection<? extends ObjT> objs, PropT newVal) {
            List<IMerlinObj> modObjs = CompElementActions.flattenToLocallyDefined(prop, objs);
            Undo.insertUndoEntry_propRestore(md, modObjs, prop);
        }

        protected void set(MerlinData md, TypedProp<PropT> prop, ObjT obj, PropT newVal) {
            obj.set(prop, newVal);
        }

        protected PropValue<PropT> get(MerlinData md, TypedProp<PropT> prop, ObjT obj) {
            return obj.getWithDetails(prop);
        }

        protected boolean equal(MerlinData md, PropT obj1, PropT obj2) {
            return Objects.equals(obj1, obj2);
        }

        @Override
        public Collection<? extends ObjT> filterObjs(Collection<? extends ObjT> objs) {
            return this.localOnly ? CompElementActions.flattenToLocallyDefined(this.prop, objs, this.objType) : objs;
        }

        @Override
        public void set(MerlinData md, Collection<? extends ObjT> objs, PropT newVal) {
            this.saveState(md, this.prop, objs, newVal);
            Collection<ObjT> finalObjs = this.filterObjs(objs);
            for (IMerlinObj obj : finalObjs) {
                this.set(md, this.prop, obj, newVal);
            }
        }

        @Override
        public PropValue<PropT> get(MerlinData md, Collection<? extends ObjT> objs) {
            BiPredicate<Object, Object> compare = (v1, v2) -> this.equal(md, v1, v2);
            Collection<? extends ObjT> finalObjs = this.filterObjs(objs);
            return CompositePropertyUtil.getValue(finalObjs, obj -> this.get(md, this.prop, obj), compare);
        }
    }

    public static interface IObjectProp<ObjT, ValT> {
        public void set(MerlinData var1, Collection<? extends ObjT> var2, ValT var3);

        public PropValue<ValT> get(MerlinData var1, Collection<? extends ObjT> var2);

        public Collection<? extends ObjT> filterObjs(Collection<? extends ObjT> var1);
    }
}

