/*
 * Decompiled with CFR 0.152.
 */
package inferno.vis;

import inferno.vis.AbstractPropertiesTable;
import inferno.vis.AbstractTable;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.text.ParseException;
import java.util.List;
import java.util.PriorityQueue;
import javax.vecmath.Tuple3d;
import thunderheadeng.util.Global;

public class PropertiesTableAllFields
extends AbstractPropertiesTable {
    public PropertiesTableAllFields(Field[] classFields) {
        super(classFields);
    }

    @Override
    public void initModel(Field[] classFields) throws SecurityException, ClassNotFoundException {
        int i;
        this.d_fields = classFields;
        this.d_properties = new String[this.d_fields.length];
        PriorityQueue<AbstractPropertiesTable.FieldNamePair> queue = new PriorityQueue<AbstractPropertiesTable.FieldNamePair>();
        for (i = 0; i < this.d_fields.length; ++i) {
            this.d_fields[i].setAccessible(true);
            if (Modifier.isStatic(this.d_fields[i].getModifiers())) continue;
            queue.add(new AbstractPropertiesTable.FieldNamePair(this, this.d_fields[i], this.d_fields[i].getName()));
        }
        this.d_fields = new Field[queue.size()];
        this.d_properties = new String[queue.size()];
        for (i = 0; i < this.d_fields.length; ++i) {
            AbstractPropertiesTable.FieldNamePair pair = (AbstractPropertiesTable.FieldNamePair)queue.poll();
            this.d_fields[i] = pair.field;
            this.d_properties[i] = pair.name;
        }
    }

    @Override
    public void update(List<Object> data) {
        if (data != null && data.get(0) != null) {
            int row = 0;
            for (Field field : this.d_fields) {
                try {
                    Object value = field.get(data.get(0));
                    if (value instanceof Double) {
                        value = Global.format((Double)value);
                    } else if (value instanceof Tuple3d) {
                        try {
                            value = AbstractTable.format((Tuple3d)value);
                        }
                        catch (ParseException e) {
                            e.printStackTrace();
                        }
                    }
                    this.d_table.setValueAt(value, row++, 1);
                }
                catch (IllegalAccessException | IllegalArgumentException e) {
                    e.printStackTrace();
                }
            }
        } else {
            for (int row = 0; row < this.d_table.getRowCount(); ++row) {
                this.d_table.setValueAt("", row, 1);
            }
        }
    }
}

