/*
 * Decompiled with CFR 0.152.
 */
package inferno.vis;

import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.List;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;

public abstract class AbstractPropertiesTable {
    protected JTable d_table;
    private String[] d_columnNames = new String[]{"Property", "Value"};
    protected String[] d_properties;
    protected Field[] d_fields;

    public AbstractPropertiesTable() {
        this.createPropertiesTable(null);
    }

    public AbstractPropertiesTable(Field[] classFields) {
        this.createPropertiesTable(classFields);
    }

    private synchronized void createPropertiesTable(Field[] classFields) {
        try {
            this.initModel(classFields);
        }
        catch (ClassNotFoundException | SecurityException e1) {
            e1.printStackTrace();
        }
        final Object[] values = new Object[this.d_properties.length];
        JTable table = new JTable(new AbstractTableModel(){
            private static final long serialVersionUID = 5907506267694790168L;

            @Override
            public Object getValueAt(int row, int col) {
                if (row >= 0 && row < AbstractPropertiesTable.this.d_properties.length) {
                    switch (col) {
                        case 0: {
                            return AbstractPropertiesTable.this.d_properties[row];
                        }
                    }
                    return values[row];
                }
                return null;
            }

            @Override
            public int getRowCount() {
                return AbstractPropertiesTable.this.d_properties.length;
            }

            @Override
            public int getColumnCount() {
                return AbstractPropertiesTable.this.d_columnNames.length;
            }

            @Override
            public String getColumnName(int col) {
                return AbstractPropertiesTable.this.d_columnNames[col];
            }

            @Override
            public void setValueAt(Object value, int row, int col) {
                assert (col == 1);
                values[row] = value;
                this.fireTableCellUpdated(row, col);
            }
        }){
            private static final long serialVersionUID = 5764059496306031210L;

            @Override
            public String getToolTipText(MouseEvent e) {
                int colIndex;
                int realColumnIndex;
                Point p = e.getPoint();
                int rowIndex = this.rowAtPoint(p);
                Object value = this.getValueAt(rowIndex, realColumnIndex = this.convertColumnIndexToModel(colIndex = this.columnAtPoint(p)));
                if (value != null) {
                    return value.toString();
                }
                return "";
            }
        };
        table.setDefaultRenderer(Object.class, new DefaultTableCellRenderer(){
            private static final long serialVersionUID = 6390069329843694744L;

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                try {
                    Component c = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                    c.setBackground(row % 2 == 0 ? Color.white : new Color(135, 206, 250));
                    c.setForeground(Color.black);
                    return c;
                }
                catch (ConcurrentModificationException e) {
                    return null;
                }
            }
        });
        table.getTableHeader().setFont(table.getTableHeader().getFont().deriveFont(1));
        table.setRowSelectionAllowed(true);
        table.setSelectionForeground(new Color(30, 144, 255));
        table.setRowHeight(20);
        this.d_table = table;
    }

    public abstract void initModel(Field[] var1) throws SecurityException, ClassNotFoundException;

    public abstract void update(List<Object> var1);

    public void update(Object data) {
        ArrayList<Object> l = new ArrayList<Object>();
        l.add(data);
        this.update(l);
    }

    public Component getTable() {
        return this.d_table;
    }

    public class FieldNamePair
    implements Comparable<Object> {
        protected Field field;
        protected String name;

        public FieldNamePair(AbstractPropertiesTable this$0, Field field, String name) {
            this.field = field;
            this.name = name;
        }

        @Override
        public int compareTo(Object arg0) {
            FieldNamePair other = (FieldNamePair)arg0;
            return this.name.compareTo(other.name);
        }
    }
}

