/*
 * Decompiled with CFR 0.152.
 */
package inferno.sim.steering.simple;

import inferno.data2.Occupant;
import inferno.data2.Tri;
import inferno.data2.TriPoint;
import inferno.geom.SeekCurve;
import inferno.geom.Util;
import inferno.sim.DoorQueue;
import inferno.sim.KB;
import inferno.sim.OccAgent;
import inferno.sim.steering.IPathPlanner;
import inferno.sim.steering.ISteeringBehavior;
import inferno.sim.steering.LookAtUtil;
import inferno.sim.steering.LostException;
import inferno.sim.steering.PathFollow;
import inferno.sim.steering.Steer;
import inferno.sim.steering.SteerUtil;
import inferno.sim.steering.inverse.WanderRoom;
import java.io.Serializable;
import java.util.Collections;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import thunderheadeng.geometry.IParametric3D;
import thunderheadeng.geometry.LineSeg3D;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.util.Filters;
import thunderheadeng.util.theUtil;

public class MoveToGoal
implements ISteeringBehavior,
Serializable {
    static final long serialVersionUID = 1L;
    private Vector3d d_lastVel = new Vector3d();
    private final PathFollow d_pathFollow;
    private WanderRoom d_currRoomWander;

    public MoveToGoal(KB kb, OccAgent agent, IPathPlanner pathPlanner) {
        this(new PathFollow(kb, agent, pathPlanner));
    }

    public MoveToGoal(PathFollow pathFollow) {
        this.d_pathFollow = pathFollow;
    }

    @Override
    public void done(KB kb, OccAgent occ, boolean interrupted) {
    }

    @Override
    public double getTimeLimit(KB kb, OccAgent agent) {
        return Double.POSITIVE_INFINITY;
    }

    public String getName() {
        return "Direct Navigation, No Reactive Steering";
    }

    @Override
    public void doorCrossed(double t, OccAgent agent, DoorQueue door) {
        this.d_pathFollow.getPathPlanner().doorCrossed(t, agent, door);
    }

    @Override
    public PathFollow getPathFollow(OccAgent agent) {
        return this.d_pathFollow;
    }

    @Override
    public SeekCurve generateSeekCurve(KB kb, OccAgent agent) throws LostException {
        LineSeg3D curve;
        this.d_pathFollow.planPath(kb, agent);
        if (this.d_pathFollow.getSeek().isVirtual(agent.getOcc().curNode)) {
            WanderRoom wanderRoom = this.getCurrentRoomWander(kb, agent);
            SeekCurve curve2 = wanderRoom.generateSeekCurve(kb, agent);
            return new SeekCurve(curve2.curve, curve2.wallSlider, curve2.transientPathFilter, false);
        }
        Point3d curr = agent.getPos();
        TriPoint seek = this.d_pathFollow.getSeekPt();
        if (Util.epsilonEquals2d(curr, seek.p, 1.0E-6)) {
            Vector3d nextDir = SteerUtil.getPredictDir(kb, agent, this.d_pathFollow);
            curve = new LineSeg3D(curr, Util3D.add(curr, (Tuple3d)nextDir));
        } else {
            curve = new LineSeg3D(agent.getPos(), seek.p);
        }
        return Util.generateSeekCurve(kb, agent, curve, true, this.d_pathFollow.getPathPlanner().getTransientEdgeFilter(kb, agent));
    }

    public WanderRoom getCurrentRoomWander(KB kb, OccAgent agent) {
        if (this.d_currRoomWander == null || !this.d_currRoomWander.getRooms().contains(agent.getOcc().curNode)) {
            this.d_currRoomWander = new WanderRoom(kb, agent, Collections.singleton(agent.getOcc().curNode), false);
        }
        return this.d_currRoomWander;
    }

    @Override
    public Steer steer(KB world, OccAgent agent, SeekCurve seek) {
        Vector3d f = MoveToGoal.getDesiredVel(seek.curve, agent.getOcc(), world);
        if (Util.isValid(f) && f.lengthSquared() > 0.0) {
            this.d_lastVel = f;
        }
        Vector3d orient = LookAtUtil.orientToTargetIfVisible(world, agent.getOcc().lookAtSource, agent, () -> this.d_lastVel);
        return new Steer(null, seek, this.d_lastVel, orient, agent.getOcc().priority, 1.0, Filters.acceptAll(), agent.hasTightGeomRepresentation(), true, new OccAgent[0]);
    }

    public static Vector3d getDesiredVel(IParametric3D seekCurve, Occupant occ, KB world) {
        Vector3d vSeek = seekCurve.getTangent(0.0);
        if (theUtil.gt0(vSeek.length(), 0.0)) {
            vSeek.normalize();
            double maxVel = OccAgent.getMaxVel(world, occ, 0.0, vSeek);
            vSeek.scale(maxVel);
        }
        Tri triAgent = occ.tri;
        Util.projectAlongZEq(triAgent.plane, vSeek);
        assert (Util.isValid(vSeek));
        return vSeek;
    }
}

