/*
 * Decompiled with CFR 0.152.
 */
package inferno.sim.steering.powerlaw;

import inferno.data2.IAgentBodyShape;
import inferno.data2.OccLocator;
import inferno.data2.OccPriority;
import inferno.geom.Inter;
import inferno.geom.SeekCurve;
import inferno.sim.DoorQueue;
import inferno.sim.KB;
import inferno.sim.OccAgent;
import inferno.sim.steering.ISteeringBehavior;
import inferno.sim.steering.LookAtUtil;
import inferno.sim.steering.LostException;
import inferno.sim.steering.PathFollow;
import inferno.sim.steering.Steer;
import inferno.sim.steering.inverse.AvoidObstacles;
import inferno.sim.steering.inverse.ICostCalc;
import inferno.sim.steering.inverse.ISeekCalc;
import inferno.sim.steering.inverse.InvSteerUtil;
import inferno.sim.steering.inverse.OccInfo;
import inferno.sim.steering.inverse.SeekWallSeparation;
import inferno.sim.steering.inverse.Senses;
import inferno.sim.steering.simple.MoveToGoal;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import thunderheadeng.geometry.Plane3d;
import thunderheadeng.util.Filters;
import thunderheadeng.util.Pair;

public class PowerLawNavigateMesh
implements ISteeringBehavior,
Serializable {
    private static final long serialVersionUID = -1176212580497116099L;
    private ISeekCalc d_seek;
    private Steer d_lastSteer;

    public PowerLawNavigateMesh(ISeekCalc seekCalc, ICostCalc ... additionalCalcs) {
        this.d_seek = seekCalc;
        this.d_lastSteer = null;
    }

    @Override
    public void done(KB kb, OccAgent occ, boolean interrupted) {
    }

    @Override
    public void doorCrossed(double t, OccAgent agent, DoorQueue door) {
        this.d_seek.doorCrossed(t, agent, door);
    }

    @Override
    public SeekCurve generateSeekCurve(KB kb, OccAgent agent) throws LostException {
        return this.d_seek.generateSeekCurve(kb, agent);
    }

    @Override
    public PathFollow getPathFollow(OccAgent agent) {
        return this.d_seek.getPathFollow(agent);
    }

    @Override
    public Steer steer(KB world, OccAgent agent, SeekCurve seek) {
        float k = 11.0f;
        int t0 = 3;
        float radius = 0.23f;
        List<Object> avoid = new ArrayList();
        if (this.d_lastSteer != null) {
            avoid = world.findOccs(OccLocator.testCyl(agent, 3.0, new Plane3d[0]), OccLocator.exclude(agent, Filters.acceptAll()), false);
        }
        int numPeople = avoid.size();
        Vector3d prefVel = MoveToGoal.getDesiredVel(seek.curve, agent.getOcc(), world);
        Vector3d pos = new Vector3d(agent.getPos());
        Vector3d force = Inter.scale(Inter.sub(prefVel, (Tuple3d)agent.getVel()), 1.8518518518518516);
        for (OccAgent occAgent : avoid) {
            double t;
            double c;
            double radiusSq;
            Vector3d otherPos = new Vector3d(occAgent.getPos());
            double distanceSq = Inter.sub(otherPos, (Tuple3d)pos).lengthSquared();
            if (distanceSq < (radiusSq = Math.pow(radius + radius, 2.0))) {
                radiusSq = Math.pow((double)(radius + radius) - Math.sqrt(distanceSq), 2.0);
            }
            Vector3d w = Inter.sub(otherPos, (Tuple3d)pos);
            Vector3d v = Inter.sub(agent.getVel(), (Tuple3d)occAgent.getVel());
            double a = v.dot(v);
            double b = w.dot(v);
            double d = b * b - a * (c = w.dot(w) - radiusSq);
            if (!(d > 0.0) || !(a < -1.0E-5) && !(a > 1.0E-5) || !((t = (b - (d = Math.sqrt(d))) / a) > 0.0)) continue;
            double first = (double)(-k) * Math.exp(-t / (double)t0) / (a * Math.pow(t, 2.0));
            Vector3d innerSub = Inter.sub(Inter.scale(v, b), (Tuple3d)Inter.scale(w, a));
            innerSub = Inter.scale(innerSub, 1.0 / d);
            Vector3d totalSub = Inter.sub(v, (Tuple3d)innerSub);
            force.add(Inter.scale(totalSub, first *= 2.0 / t + (double)(1 / t0)));
        }
        BiFunction<OccAgent, Boolean, Pair> getGeomBodyShape = (occ, tightGeometry) -> {
            boolean isSafeShape = occ.hasVehicle() && occ.getVehicle().getFreePass();
            IAgentBodyShape geomShape = occ.getGeomCollisionShape(world, false, (boolean)tightGeometry);
            IAgentBodyShape safeGeomShape = isSafeShape ? occ.getGeomCollisionShape(world, true, (boolean)tightGeometry) : geomShape;
            return new Pair<IAgentBodyShape, IAgentBodyShape>(safeGeomShape, geomShape);
        };
        Pair pair = getGeomBodyShape.apply(agent, false);
        OccInfo oi = new OccInfo(agent, agent.getShape(), 1.0, (IAgentBodyShape)pair.v1, (IAgentBodyShape)pair.v2, OccPriority.lower(agent.getOcc().priority), Filters.acceptAll(), InvSteerUtil.getSteerMeta((OccAgent)agent).raisedPriorityFilter, new OccInfo.CachedData(world, agent), false);
        double fov = this.d_seek.getSensingFOV(world, oi);
        ArrayList<Senses.AgentFilter> filters = new ArrayList<Senses.AgentFilter>();
        double wallSenseRadius = SeekWallSeparation.getWallSensingRadius(world, oi, fov);
        double hazardSenseRadius = AvoidObstacles.getSensingRadius(world, oi);
        Senses senses = new Senses(world, new Senses.Memory(), agent, seek.curve, seek.wallSlider, hazardSenseRadius, wallSenseRadius, filters);
        Senses.WallHit wallHit = senses.senseNearestWallHit(world, agent.getLoc(), agent.getDirFacing(), 24.0, seek.transientPathFilter, oi.shapeGeom, oi.shapeGeomDefault);
        if (wallHit != null) {
            Vector3d near = new Vector3d(wallHit.loc.p);
            Vector3d ugh = new Vector3d(agent.getLoc().p);
            Vector3d n_w = Inter.sub(near, (Tuple3d)ugh);
            double d_w = n_w.lengthSquared();
            if (!(agent.getVel().dot(n_w) < 0.0) && d_w != (double)(radius * radius) && !(d_w > 576.0)) {
                double s;
                double t;
                Vector3d g;
                double inverseDet;
                double rad = 0.23;
                if (d_w < 0.0529) {
                    rad = Math.sqrt(d_w);
                }
                boolean discCollision = false;
                boolean segmentCollision = false;
                double t_min = Double.POSITIVE_INFINITY;
                Vector3d o = null;
                boolean p1 = true;
                double distance = this.distance(pos, wallHit.wall.base.n1.p);
                if (distance <= 1.0) {
                    discCollision = true;
                    t_min = distance;
                }
                if ((distance = this.distance(pos, wallHit.wall.base.n2.p)) <= 1.0) {
                    discCollision = true;
                    t_min = distance;
                    p1 = false;
                }
                Vector3d eh = new Vector3d(wallHit.wall.base.n2.p);
                eh.sub(wallHit.wall.base.n1.p);
                Vector3d normal = new Vector3d(-eh.y, eh.x, eh.z);
                normal.normalize();
                normal.scale(rad);
                Vector3d o1_temp = new Vector3d(wallHit.wall.base.n1.p);
                o1_temp.add(normal);
                Vector3d o2_temp = new Vector3d(wallHit.wall.base.n2.p);
                o2_temp.add(normal);
                Vector3d o_temp = Inter.sub(o2_temp, (Tuple3d)o1_temp);
                double D_temp = this.determinant(agent.getVel(), o_temp);
                if (D_temp != 0.0) {
                    inverseDet = 1.0 / D_temp;
                    g = new Vector3d(agent.getPos());
                    g.sub(o1_temp);
                    t = this.determinant(o_temp, g) * inverseDet;
                    s = this.determinant(agent.getVel(), g) * inverseDet;
                    if (t > 0.0 && s >= 0.0 && s <= 1.0 && t < t_min && t < (double)t0) {
                        t_min = t;
                        o = o_temp;
                        discCollision = false;
                        segmentCollision = true;
                    }
                }
                o1_temp = new Vector3d(wallHit.wall.base.n1.p);
                o1_temp.sub(normal);
                o2_temp = new Vector3d(wallHit.wall.base.n2.p);
                o2_temp.sub(normal);
                o_temp = Inter.sub(o2_temp, (Tuple3d)o1_temp);
                D_temp = this.determinant(agent.getVel(), o_temp);
                if (D_temp != 0.0) {
                    inverseDet = 1.0 / D_temp;
                    g = new Vector3d(agent.getPos());
                    g.sub(o1_temp);
                    t = this.determinant(o_temp, g) * inverseDet;
                    s = this.determinant(agent.getVel(), g) * inverseDet;
                    if (t > 0.0 && s >= 0.0 && s <= 1.0 && t < t_min && t < (double)t0) {
                        t_min = t;
                        o = o_temp;
                        discCollision = false;
                        segmentCollision = true;
                    }
                }
                Vector3d walls = new Vector3d();
                if (discCollision) {
                    if (p1) {
                        Vector3d temp = new Vector3d(agent.getPos());
                        temp.sub(wallHit.wall.base.n1.p);
                        distance = this.distance(pos, wallHit.wall.base.n1.p);
                        if (distance < 1.0) {
                            temp.scale(2.0 / (distance * distance * distance));
                        } else {
                            temp.scale(1.5);
                        }
                        walls.add(temp);
                    } else {
                        Vector3d temp = new Vector3d(agent.getPos());
                        temp.sub(wallHit.wall.base.n2.p);
                        distance = this.distance(pos, wallHit.wall.base.n2.p);
                        if (distance < 1.0) {
                            temp.scale(2.0 / (distance * distance * distance));
                        } else {
                            temp.scale(1.5);
                        }
                        walls.add(temp);
                    }
                } else if (segmentCollision) {
                    double first = (double)k * Math.exp(-(t_min / (double)t0)) * (2.0 / t_min + (double)(1 / t0));
                    Vector3d temp = new Vector3d(wallHit.wall.base.n2.p);
                    temp.sub(wallHit.wall.base.n1.p);
                    Vector3d uh = new Vector3d(-temp.y, temp.x, temp.z);
                    uh.scale(first /= Math.pow(t_min, 2.0) * this.determinant(agent.getVel(), o));
                    walls.add(uh);
                }
                force.add(walls);
            }
        }
        if (numPeople > 4) {
            force.scale(0.9);
        }
        if (numPeople > 7) {
            force.scale(0.8);
        }
        if (numPeople > 15) {
            force.scale(0.66);
        }
        if (numPeople > 19) {
            force.scale(0.46);
        }
        if (numPeople > 30) {
            force.scale(0.26);
        }
        if (numPeople > 50) {
            force.scale(1.1);
        }
        if (numPeople > 80) {
            force.scale(1.2);
        }
        if (numPeople > 100) {
            force.scale(1.3);
        }
        prefVel = Inter.add(agent.getVel(), (Tuple3d)Inter.scale(force, 0.01));
        Vector3d orient = LookAtUtil.orientToTargetIfVisible(world, agent.getOcc().lookAtSource, agent, agent::getVel);
        Object oa = null;
        this.d_lastSteer = new Steer(null, seek, prefVel, orient, agent.getOcc().priority, 1.0, Filters.rejectAll(), true, true, oa);
        return this.d_lastSteer;
    }

    @Override
    public double getTimeLimit(KB kb, OccAgent agent) {
        return this.d_seek.getTimeLimit(kb, agent);
    }

    public double distance(Vector3d a, Point3d p) {
        return Math.sqrt(Math.pow(a.x - p.x, 2.0) + Math.pow(a.y - p.y, 2.0) + Math.pow(a.z - p.z, 2.0));
    }

    public double determinant(Vector3d a, Vector3d b) {
        return a.x * b.y - a.y * b.x;
    }

    public void clamp(Vector3d v, double maxVel) {
        double len = v.length();
        if (len > maxVel) {
            double mult = maxVel / len;
            v.scale(mult);
        }
    }
}

