/*
 * Decompiled with CFR 0.152.
 */
package inferno.sim.steering.inverse;

import inferno.data2.ANode;
import inferno.geom.SeekCurve;
import inferno.sim.DoorQueue;
import inferno.sim.KB;
import inferno.sim.OccAgent;
import inferno.sim.steering.IPathPlanner;
import inferno.sim.steering.LostException;
import inferno.sim.steering.PathFollow;
import inferno.sim.steering.inverse.BehaviorWeights;
import inferno.sim.steering.inverse.ISeekCalc;
import inferno.sim.steering.inverse.IdleSeparation;
import inferno.sim.steering.inverse.OccInfo;
import inferno.sim.steering.inverse.Seek;
import inferno.sim.steering.inverse.SeekInfo;
import inferno.sim.steering.inverse.Senses;
import java.io.Serializable;
import java.util.Collection;
import javax.vecmath.Vector3d;
import thunderheadeng.geometry.IParametric3D;

public class WanderRoomSafe
implements ISeekCalc,
Serializable {
    static final long serialVersionUID = 1L;
    private final ISeekCalc d_wanderSeek;
    private final IPathPlanner d_backupPathPlanner;
    private final Collection<ANode> d_rooms;
    private ISeekCalc d_backupSeek;

    public WanderRoomSafe(ISeekCalc wanderSeek, Collection<ANode> rooms, IPathPlanner backupPlanner) {
        this.d_wanderSeek = wanderSeek;
        this.d_backupPathPlanner = backupPlanner;
        this.d_rooms = rooms;
    }

    @Override
    public Vector3d getIdleOrient(KB kb, OccAgent oa) {
        return this.getSeek().getIdleOrient(kb, oa);
    }

    @Override
    public double getTimeLimit(KB kb, OccAgent agent) {
        return this.getSeek().getTimeLimit(kb, agent);
    }

    private ISeekCalc getSeek() {
        return this.d_backupSeek != null ? this.d_backupSeek : this.d_wanderSeek;
    }

    @Override
    public void doorCrossed(double t, OccAgent agent, DoorQueue queue) {
        this.getSeek().doorCrossed(t, agent, queue);
    }

    @Override
    public PathFollow getPathFollow(OccAgent agent) {
        return this.getSeek().getPathFollow(agent);
    }

    @Override
    public SeekCurve generateSeekCurve(KB kb, OccAgent agent) throws LostException {
        ANode currRoom = agent.getOcc().curNode;
        boolean inTargetRoom = this.d_rooms.contains(currRoom);
        if (!inTargetRoom && this.d_backupSeek == null) {
            this.d_backupSeek = new Seek(kb, agent, this.d_backupPathPlanner, Double.NaN, null);
        } else if (inTargetRoom && this.d_backupSeek != null) {
            this.d_backupSeek = null;
        }
        return this.getSeek().generateSeekCurve(kb, agent);
    }

    @Override
    public void init(KB kb, OccInfo oi, IParametric3D seekCurve) {
        this.getSeek().init(kb, oi, seekCurve);
    }

    @Override
    public BehaviorWeights getWeights(KB kb, OccInfo oi, boolean isSocialDistancing) {
        return this.getSeek().getWeights(kb, oi, isSocialDistancing);
    }

    @Override
    public SeekInfo getSeekInfo(KB kb, OccInfo oi, SeekCurve seek) {
        return this.getSeek().getSeekInfo(kb, oi, seek);
    }

    @Override
    public IdleSeparation getSeparation(KB kb, OccInfo oi) {
        return this.getSeek().getSeparation(kb, oi);
    }

    @Override
    public double getSensingFOV(KB kb, OccInfo oi) {
        return this.getSeek().getSensingFOV(kb, oi);
    }

    @Override
    public Vector3d[] getSeekDirs(KB kb, OccInfo oi, SeekInfo seekInfo, IdleSeparation sep, int options) {
        return this.getSeek().getSeekDirs(kb, oi, seekInfo, sep, options);
    }

    @Override
    public boolean isDirectionAllowed(KB kb, OccAgent oa, Vector3d baseDir, Vector3d dir) {
        return this.getSeek().isDirectionAllowed(kb, oa, baseDir, dir);
    }

    @Override
    public double[] getCost(KB kb, OccInfo oi, Senses sense, SeekInfo seekInfo, Vector3d preferredDir, Vector3d dir) {
        return this.getSeek().getCost(kb, oi, sense, seekInfo, preferredDir, dir);
    }
}

