/*
 * Decompiled with CFR 0.152.
 */
package inferno.sim.steering.inverse;

import common.geom.Trig;
import inferno.data2.ANode;
import inferno.data2.OccPriority;
import inferno.data2.PolygonShape;
import inferno.data2.TriPoint;
import inferno.data2.WingedEdge;
import inferno.data2.ai.GoalUtil;
import inferno.data2.seekarea.ISeekArea;
import inferno.geom.SeekCurve;
import inferno.geom.Util;
import inferno.sim.KB;
import inferno.sim.KnownFuncs;
import inferno.sim.OccAgent;
import inferno.sim.ai.AiUtil;
import inferno.sim.steering.LostException;
import inferno.sim.steering.PathFollow;
import inferno.sim.steering.Steer;
import inferno.sim.steering.SteerUtil;
import inferno.sim.steering.inverse.InvSteerMeta;
import inferno.sim.steering.inverse.OccInfo;
import inferno.sim.steering.inverse.SeekInfo;
import inferno.sim.steering.inverse.Senses;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import javax.vecmath.AxisAngle4d;
import javax.vecmath.Matrix3d;
import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector2d;
import javax.vecmath.Vector3d;
import thunderheadeng.geometry.GeomConstants;
import thunderheadeng.geometry.IParametric3D;
import thunderheadeng.geometry.Inter2D;
import thunderheadeng.geometry.LineSeg3D;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.util.Filters;
import thunderheadeng.util.Pair;
import thunderheadeng.util.theUtil;

public class InvSteerUtil {
    public static final boolean DENSITY_WITH_FLOW_ONLY = System.getProperty("InvSteerUtil.DENSITY_WITH_FLOW_ONLY") != null;
    private static final InvSteerMeta DEF_META = new InvSteerMeta(0.0, 0.0, Filters.rejectAll(), null, InvSteerMeta.Memento.DEFAULT, false, Double.NaN, false);

    public static double clampCost(double cost) {
        if (cost > 1.0) {
            cost = 1.0;
        } else if (cost < 0.0) {
            cost = 0.0;
        }
        return cost;
    }

    public static Vector3d[] generateSampleDirs(KB kb, OccAgent agent, Vector3d baseDir, double[] angles) {
        TriPoint meshLoc = agent.getLoc();
        Vector3d alignedBaseDir = Util.projectAlongZ(meshLoc.tri.plane, baseDir);
        AxisAngle4d aa = new AxisAngle4d();
        Matrix3d mat = new Matrix3d();
        Vector3d[] dirs = new Vector3d[angles.length];
        for (int m = 0; m < angles.length; ++m) {
            double angle = angles[m];
            dirs[m] = Double.isNaN(angle) ? null : (angle == 0.0 ? alignedBaseDir : InvSteerUtil.rotateVec(alignedBaseDir, meshLoc.tri.normal, angle, aa, mat));
        }
        return dirs;
    }

    public static Vector3d rotateVec(Vector3d vec, Vector3d normal, double angle, AxisAngle4d aa, Matrix3d mat) {
        aa.set(normal, angle);
        mat.set(aa);
        Vector3d result = new Vector3d();
        mat.transform(vec, result);
        return result;
    }

    public static SeekCurve generateSeekCurve(KB kb, OccAgent agent, PathFollow pathFollow) throws LostException {
        IParametric3D curve;
        Predicate<WingedEdge> edgeFilter = pathFollow.getPathPlanner().getTransientEdgeFilter(kb, agent);
        TriPoint currLoc = agent.getLoc();
        TriPoint rawSeekPt = pathFollow.getSeekPt();
        Point3d seekPt = new Point3d(rawSeekPt.p.x, rawSeekPt.p.y, currLoc.p.z);
        Vector3d predictDir = SteerUtil.getPredictDir(kb, agent, pathFollow);
        predictDir.z = 0.0;
        Util.safeNormalize(predictDir, 1.0E-9);
        double eps = 1.0E-6;
        if (currLoc.p.epsilonEquals(seekPt, eps)) {
            LineSeg3D curve2;
            return Util.generateSeekCurve(kb, agent, curve2, (curve2 = new LineSeg3D(currLoc.p, Util3D.add(currLoc.p, (Tuple3d)predictDir))).lengthSq() > 0.0, edgeFilter);
        }
        double seekDist = seekPt.distance(currLoc.p);
        double cdist = Math.min(0.391 * seekDist, agent.getOccupantRadius() * 2.0);
        Point3d p1 = currLoc.p;
        Point3d p2 = seekPt;
        Point3d c2 = null;
        if (agent.getOcc().bodyShape instanceof PolygonShape) {
            if (p1.distance(p2) <= agent.getOcc().bodyShape.getLength()) {
                c2 = p2;
            } else {
                PolygonShape testShape;
                double angle;
                Vector3d ref;
                boolean createAndTestDefault = false;
                double curveConst = 1.5;
                double maxDistConst = 2.0;
                predictDir = SteerUtil.getPredictDir(kb, agent, pathFollow, maxDistConst * agent.getOcc().bodyShape.getLength());
                predictDir.z = 0.0;
                Util.safeNormalize(predictDir, 1.0E-9);
                Vector3d origDir = new Vector3d(predictDir);
                predictDir = Util3D.scale(predictDir, cdist);
                predictDir = Util3D.scale(predictDir, curveConst * agent.getOcc().bodyShape.getLength());
                c2 = Util3D.sub(seekPt, (Tuple3d)predictDir);
                if (p1.distance(p2) < c2.distance(p2)) {
                    createAndTestDefault = true;
                } else {
                    ref = ((PolygonShape)agent.getOcc().bodyShape).getDir();
                    angle = Trig.angle(ref, origDir);
                    testShape = ((PolygonShape)agent.getOcc().bodyShape).translateToAndRotate(c2, angle);
                    if (testShape.testCollisionWalls(kb, agent.getOcc().bodyShape.getEnclosingRadius() / 5.0)) {
                        createAndTestDefault = true;
                    }
                }
                if (createAndTestDefault && (testShape = ((PolygonShape)agent.getOcc().bodyShape).translateToAndRotate(c2 = Util3D.sub(seekPt, (Tuple3d)(predictDir = Util3D.scale(origDir, cdist))), angle = Trig.angle(ref = ((PolygonShape)agent.getOcc().bodyShape).getDir(), origDir))).testCollisionWalls(kb, agent.getOcc().bodyShape.getEnclosingRadius() / 5.0)) {
                    c2 = p2;
                }
            }
        } else {
            predictDir = Util3D.scale(predictDir, cdist);
            c2 = Util3D.sub(seekPt, (Tuple3d)predictDir);
        }
        Point3d c1 = c2;
        assert (theUtil.eq(p1.z, c1.z, 1.0E-6) && theUtil.eq(p1.z, c2.z, 1.0E-6) && theUtil.eq(p1.z, p2.z, 1.0E-6));
        return Util.generateSeekCurve(kb, agent, curve, (curve = Util.newCurve(p1, c2, p2)).length() > 0.0, edgeFilter);
    }

    public static InvSteerMeta getSteerMeta(OccAgent agent) {
        return InvSteerUtil.getSteerMeta(agent.getLastSteer());
    }

    public static InvSteerMeta getSteerMeta(Steer steer) {
        return steer != null && steer.meta instanceof InvSteerMeta ? (InvSteerMeta)steer.meta : DEF_META;
    }

    public static double getMaxVelToStop(KB kb, OccInfo oi, double dist) {
        return InvSteerUtil.getMaxVelToStop(kb, oi, dist, oi.cache.currVel);
    }

    public static double getMaxVelToStop(KB kb, OccInfo oi, double d, double v0, double t0) {
        double c;
        double v0t0;
        double b;
        if (d == 0.0) {
            return 0.0;
        }
        double ht0sq = 0.5 * t0 * t0;
        double maxDecel = oi.oa.getMaxStopAccel(kb);
        double ias = 1.0 / maxDecel;
        double a = ht0sq * ias;
        double[] result = InvSteerUtil.solveQuadratic(a, b = (v0t0 = v0 * t0) * ias + ht0sq, c = v0t0 + 0.5 * v0 * v0 * ias - d, 1.0E-9);
        if (result == null) {
            return 0.0;
        }
        double accel = Math.max(result[0], result[1]);
        if (accel == 0.0) {
            return v0;
        }
        double maxAccel = oi.oa.getMaxStartAccel(kb);
        if (accel >= maxAccel) {
            return oi.cache.maxVel;
        }
        double v1 = v0 + accel * t0;
        if (v1 <= 0.0) {
            return 0.0;
        }
        if (v1 >= oi.cache.maxVel) {
            return oi.cache.maxVel;
        }
        return v1;
    }

    public static double[] solveQuadratic(double a, double b, double c, double tol) {
        double[] result = new double[2];
        return (double[])(InvSteerUtil.solveQuadratic(a, b, c, tol, result) ? result : null);
    }

    public static boolean solveQuadratic(double a, double b, double c, double tol, double[] result) {
        if (theUtil.eq0(a, tol)) {
            return false;
        }
        double root = b * b - 4.0 * a * c;
        if (theUtil.lt0(root, tol)) {
            return false;
        }
        if (root < 0.0) {
            root = 0.0;
        }
        double i2a = 0.5 / a;
        root = Math.sqrt(root);
        result[0] = (-b + root) * i2a;
        result[1] = (-b - root) * i2a;
        return true;
    }

    public static double getMaxVelToStop(KB kb, OccInfo oi, double dist, double currSpeed) {
        if (dist == 0.0) {
            return 0.0;
        }
        double maxSpeedToStop = OccAgent.calcMaxVelToStop(currSpeed, oi.oa.getMaxStopAccel(kb), dist);
        if (maxSpeedToStop < currSpeed) {
            return 0.0;
        }
        return Math.min(maxSpeedToStop, oi.cache.maxVel);
    }

    public static double getMaxVel(KB kb, OccInfo oi, double vc, double vf, double dist) {
        if (dist == 0.0) {
            return 0.0;
        }
        double accel = oi.oa.getMaxStartAccel(kb);
        double decel = oi.oa.getMaxStopAccel(kb);
        if (vf == 0.0 && accel == decel) {
            return InvSteerUtil.getMaxVelToStop(kb, oi, dist);
        }
        double maxSpeed = OccAgent.calcMaxVel(vc, vf, accel, decel, dist);
        if (maxSpeed < vc || maxSpeed < vf) {
            return vf;
        }
        return Math.min(maxSpeed, oi.cache.maxVel);
    }

    public static boolean isSeekingGoalSpace(KB kb, OccAgent occ1, OccAgent occ2) {
        ISeekArea occ1CurrGoal = AiUtil.getCurrentSeekArea(kb, occ1);
        ISeekArea occ2CurrGoal = AiUtil.getCurrentSeekArea(kb, occ2);
        return occ1CurrGoal.contains(kb, occ2.getLoc()) || GoalUtil.overlap(kb, occ1, occ1CurrGoal, occ2, occ2CurrGoal);
    }

    public static boolean isInGoalSpace(KB kb, OccAgent occ1, OccAgent occ2) {
        ISeekArea occ1CurrGoal = AiUtil.getCurrentSeekArea(kb, occ1);
        return occ1CurrGoal.contains(kb, occ2.getLoc());
    }

    public static boolean isLeavingGoalSpace(KB kb, OccAgent occ1, OccAgent occ2) {
        ISeekArea occ1CurrGoal = AiUtil.getCurrentSeekArea(kb, occ1);
        ISeekArea occ2PrevGoal = AiUtil.getPreviousSeekArea(kb, occ2);
        assert (occ2PrevGoal != null);
        return GoalUtil.overlap(kb, occ1, occ1CurrGoal, occ2, occ2PrevGoal);
    }

    public static boolean isInTightSpace(KB kb, OccAgent occ1, OccAgent occ2) {
        ANode node1 = occ1.getOcc().curNode;
        ANode node2 = occ2.getOcc().curNode;
        if (node1 == node2 || node2 == null) {
            return false;
        }
        return !node2.hasRoomFor(occ1, kb);
    }

    public static boolean getYieldToIdler(KB kb, OccAgent occ1, OccAgent occ2) {
        return InvSteerUtil.isSeekingGoalSpace(kb, occ1, occ2) && !InvSteerUtil.isGoalUrgent(kb, occ1);
    }

    public static int compare(KB kb, OccInfo oi1, OccAgent occ2) {
        Set<OccAgent> groupMembers;
        if (oi1.oa.getOcc().isGroupLeader && oi1.oa.getOcc().occupantGroup != null && (groupMembers = oi1.oa.getOcc().occupantGroup.getMembers()) != null && groupMembers.contains(occ2)) {
            return -1;
        }
        return OccPriority.compare(oi1.oa, oi1.priority, oi1.raisedPriorityFilter, occ2, occ2.getPriority(kb), InvSteerUtil.getRaisedPriorityFilter(occ2));
    }

    public static Predicate<OccAgent> getRaisedPriorityFilter(OccAgent agent) {
        return InvSteerUtil.getSteerMeta((OccAgent)agent).raisedPriorityFilter;
    }

    public static Collection<OccAgent> getOccsAffectingDensity(KB kb, OccAgent agent, SeekInfo si, Senses senses, Collection<OccAgent> others) {
        if (DENSITY_WITH_FLOW_ONLY) {
            return theUtil.filter(others, other -> InvSteerUtil.isOccAffectingDensity(kb, agent, si, senses, other));
        }
        return others;
    }

    public static boolean isOccAffectingDensity(KB kb, OccAgent agent, SeekInfo si, Senses senses, OccAgent other) {
        if (DENSITY_WITH_FLOW_ONLY) {
            Senses.Flow flow = senses.getFlow(kb, agent, si, other, other.getVel());
            return flow.flowing;
        }
        return true;
    }

    public static DensityResult getDensityFromSpacing(KB kb, OccInfo oi, Point3d loc, Vector2d dirN, List<Pair<OccAgent, Point3d>> nearOccs) {
        DensityResult result = new DensityResult();
        Point2d fruinLoc = new Point2d();
        Vector3d occDir = new Vector3d();
        int count = nearOccs.size();
        for (int m = 0; m < count; ++m) {
            Pair<OccAgent, Point3d> nearPair = nearOccs.get(m);
            int comp = InvSteerUtil.compare(kb, oi, (OccAgent)nearPair.v1);
            if (comp < 0) continue;
            Point3d nearPos = (Point3d)nearPair.v2;
            occDir.sub(nearPos, loc);
            occDir.z = 0.0;
            Util3D.safeNormalize(occDir, 1.0E-6);
            double dot = occDir.x * dirN.x + occDir.y * dirN.y;
            if (!(dot >= -1.0E-6)) continue;
            KnownFuncs.toFruinSpace(loc, dirN, nearPos, fruinLoc);
            double density = KnownFuncs.getDensity(fruinLoc.x, fruinLoc.y);
            if (!(density > result.density)) continue;
            result.density = density;
            result.occ = (OccAgent)nearPair.v1;
        }
        return result;
    }

    public static Vector3d getCollisionVel(OccAgent agent) {
        return agent.getOcc().waiting ? GeomConstants.VEC3D_ZERO : agent.getVel();
    }

    public static double getBoundaryLayer(KB kb, OccInfo oi) {
        return oi.oa.getOcc().boundaryLayer;
    }

    public static double getDensityFromWalls(KB kb, OccInfo oi, Point3d loc, Vector2d dirN, List<WingedEdge> nearWalls) {
        double maxDensity = 0.0;
        double boundaryDist = InvSteerUtil.getBoundaryLayer(kb, oi) + oi.oa.getGeometryRadius();
        double boundaryDistSq = boundaryDist * boundaryDist;
        Point2d fruinLoc = new Point2d();
        Vector3d occDir = new Vector3d();
        int count = nearWalls.size();
        for (int m = 0; m < count; ++m) {
            WingedEdge wall = nearWalls.get(m);
            Point3d w1 = wall.v1().p;
            Point3d w2 = wall.v2().p;
            double distsq = Inter2D.distSqToNearestPtOnLineSeg(w1.x, w1.y, w2.x, w2.y, loc.x, loc.y);
            if (distsq > boundaryDistSq) continue;
            double neart = Inter2D.nearestTOnLineSeg(loc.x, loc.y, w1.x, w1.y, w2.x, w2.y);
            Point3d nearPos = Util3D.linesegPoint(w1, w2, neart);
            occDir.sub(nearPos, loc);
            double dot = occDir.x * dirN.x + occDir.y * dirN.y;
            if (dot < -1.0E-6) continue;
            occDir.sub(nearPos, loc);
            occDir.normalize();
            occDir.scale(loc.distance(nearPos));
            nearPos.add(occDir);
            KnownFuncs.toFruinSpace(loc, dirN, nearPos, fruinLoc);
            double density = KnownFuncs.getDensity(fruinLoc.x, fruinLoc.y);
            if (!(density > maxDensity)) continue;
            maxDensity = density;
        }
        return maxDensity;
    }

    public static double[] getCost(KB kb, OccInfo oi, double hitDist) {
        if (theUtil.eq0(hitDist, 1.0E-6)) {
            return new double[]{1.0, 0.0};
        }
        double vel = oi.cache.currVel;
        double speed = InvSteerUtil.getMaxVelToStop(kb, oi, hitDist, vel, oi.oa.getOcc().reacTime);
        double cost = 1.0 - speed / oi.cache.maxVel;
        return new double[]{cost, speed};
    }

    public static boolean isGoalUrgent(KB kb, OccAgent occ1) {
        ISeekArea seekGoal = AiUtil.getCurrentSeekArea(kb, occ1);
        return seekGoal.isUrgent(kb, occ1);
    }

    public static boolean canSeparate(KB kb, OccInfo occ1, SeekInfo seek1, OccAgent occ2, int priorComp, boolean sepOnlyInFront) {
        if (priorComp < 0) {
            return false;
        }
        if (priorComp == 0 && sepOnlyInFront && seek1.seekDir != null && Util.dot2d(Util3D.vector(occ1.oa.getPos(), occ2.getPos()), seek1.seekDir) < 0.0) {
            return false;
        }
        return priorComp <= 0 || !occ2.hasVehicle() || !occ1.oa.isAssisting(kb, occ2);
    }

    public static class DensityResult {
        public double density;
        public OccAgent occ;

        public DensityResult() {
            this(0.0, null);
        }

        public DensityResult(double density, OccAgent occ) {
            this.density = density;
            this.occ = occ;
        }
    }
}

