/*
 * Decompiled with CFR 0.152.
 */
package inferno.sim.steering;

import inferno.data2.ANode;
import inferno.data2.DoorDir;
import inferno.data2.Tri;
import inferno.data2.WingedEdge;
import inferno.geom.Inter;
import inferno.geom.SeekCurve;
import inferno.sim.DoorQueue;
import inferno.sim.Engine;
import inferno.sim.KB;
import inferno.sim.OccAgent;
import inferno.sim.OccGroup;
import inferno.sim.path.EdgeFilters;
import inferno.sim.path.IPath;
import inferno.sim.path.IPathSeek;
import inferno.sim.path.PathChange;
import inferno.sim.path.TriFilters;
import inferno.sim.steering.IPathPlanner;
import inferno.sim.steering.ITpSource;
import inferno.sim.steering.LookAtUtil;
import inferno.sim.steering.LostException;
import inferno.sim.steering.PathFollow;
import inferno.sim.steering.Steer;
import inferno.sim.steering.inverse.ISeekCalc;
import inferno.sim.steering.inverse.OccInfo;
import inferno.sim.steering.inverse.Seek;
import inferno.sim.steering.inverse.SeekInfo;
import inferno.sim.steering.inverse.WanderRoom;
import inferno.sim.steering.inverse.WanderRoomSafe;
import inferno.sim.steering.locallyquickest.LocalTimeEstimate;
import inferno.sim.steering.locallyquickest.LocallyQuickest;
import inferno.sim.steering.locallyquickest.PointTarget;
import inferno.sim.steering.simple.MoveToGoal;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import thunderheadeng.geometry.IParametric3D;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.util.Filters;
import thunderheadeng.util.Pair;
import thunderheadeng.util.theUtil;

public class RegroupPlanner
implements IPathPlanner,
Serializable {
    static final long serialVersionUID = 1L;
    private static final double UPDATE_INTERVAL = 2.0;
    private static final double UPDATE_UNREACHABLE_INTERVAL = 5.0;
    private static final double SENSES_UPDATE_INTERVAL = 1.0;
    private static final double DIST_TO_GOAL_UPDATE_INTERVAL = 5.0;
    private static final double DISCONNECTED_UPDATE_INTERVAL = 1.0;
    private static final double COHESION_FACTOR = theUtil.getSystemDouble("RegroupPlanner.COHESION_FACTOR", 0.0);
    private final OccAgent d_agent;
    private State d_state;
    private double d_lastStateUpdateTime = -1.7976931348623157E308;
    private double d_lastUpdateStateTime = Double.NEGATIVE_INFINITY;
    private boolean d_newState;
    private Set<OccAgent> d_unreachableGroupMembers = new HashSet<OccAgent>();
    private double d_lastUpdateUnreachableTime = -1.7976931348623157E308;
    private final IPathPlanner d_goalPathPlanner;
    private IPathPlanner d_goToLeaderPlanner;
    private IPathPlanner d_currentPlanner;
    private OccAgent d_tempLeader;
    private IPathPlanner d_goToClosestPlanner;
    private OccAgent d_closestOcc;
    private double d_distToCurrentGoal = Double.NaN;
    private double d_distToCurrentGoalUpdateTime = -1.7976931348623157E308;
    private OccGroup d_group = null;
    private SpeedState d_speedState = SpeedState.GO;
    private double d_disconnectedTimer = 0.0;
    private OccAgent d_fixedLeader;
    private boolean d_ready;
    private boolean d_requiresLeader = false;
    private double d_nextSensesUpdateTime = Double.NEGATIVE_INFINITY;
    private boolean d_isInTheWay;
    private boolean d_membersLost;
    private boolean d_doorCrossed = false;

    public static RegroupPlanner createRegroupPlanner(OccAgent agent, KB kb, IPathPlanner pathPlanner) {
        if (agent.getOcc().isGroupLeader) {
            return new RegroupPlanner(agent, kb, pathPlanner, agent);
        }
        if (agent.getOcc().occupantGroup.requiresLeader && !agent.getOcc().isGroupLeader) {
            return new RegroupPlanner(agent, kb, pathPlanner, agent.getOcc().occupantGroup.getLeader());
        }
        return new RegroupPlanner(agent, kb, pathPlanner);
    }

    private RegroupPlanner(OccAgent agent, KB kb, IPathPlanner pathPlanner) {
        this(agent, kb, pathPlanner, null, false);
    }

    private RegroupPlanner(OccAgent agent, KB kb, IPathPlanner pathPlanner, OccAgent leader) {
        this(agent, kb, pathPlanner, leader, true);
    }

    private RegroupPlanner(OccAgent agent, KB kb, IPathPlanner pathPlanner, OccAgent fixedLeader, boolean requiresLeader) {
        this.d_agent = agent;
        if (requiresLeader) {
            this.setFixedLeader(fixedLeader);
            this.d_requiresLeader = true;
        }
        this.d_goalPathPlanner = pathPlanner;
        this.d_currentPlanner = pathPlanner;
        this.initGroup(agent, kb);
    }

    public boolean initGroup(OccAgent agent, KB kb) {
        boolean bl = this.d_ready = this.d_group != null && this.d_group.isReady();
        if (Objects.equals(this.d_group, agent.getOcc().occupantGroup)) {
            return false;
        }
        this.d_group = agent.getOcc().occupantGroup;
        return true;
    }

    private static PointTarget newTarget(OccAgent leader) {
        return new PointTarget(new ITpSource.AgentTpSource(leader));
    }

    private void setFixedLeader(OccAgent fixedLeader) {
        if (fixedLeader == null) {
            return;
        }
        this.d_fixedLeader = fixedLeader;
        this.d_goToLeaderPlanner = new LocallyQuickest(this.d_agent, new LocalTimeEstimate.QueueSizes(), RegroupPlanner.newTarget(this.d_fixedLeader));
    }

    @Override
    public boolean update(KB kb, OccAgent agent, boolean forceNewPath) {
        boolean needsNewState = forceNewPath || this.d_state == null;
        boolean needsNewPath = forceNewPath;
        boolean newGroup = this.initGroup(agent, kb);
        boolean currentPlannerUpdated = false;
        if (newGroup) {
            this.d_state = null;
            needsNewState = true;
        } else if (this.d_currentPlanner != null && !needsNewState && kb.getCurrentSimTime() - this.d_lastStateUpdateTime < 2.0) {
            currentPlannerUpdated = true;
            boolean newPath = this.d_currentPlanner.update(kb, agent, forceNewPath);
            this.updateDistToGoal(kb, agent);
            if (!(needsNewState |= newPath) && !(needsNewPath |= newPath)) {
                return false;
            }
        } else {
            needsNewState = true;
        }
        IPathPlanner newPlanner = this.d_currentPlanner;
        if (needsNewState) {
            this.d_lastStateUpdateTime = kb.getCurrentSimTime();
            this.updateState(agent, kb);
            newPlanner = this.getDesiredPlanner(kb, agent);
        }
        if (newPlanner != this.d_currentPlanner || !currentPlannerUpdated) {
            this.d_currentPlanner = newPlanner;
            needsNewPath |= this.d_currentPlanner.update(kb, agent, forceNewPath);
            if (newPlanner != this.d_currentPlanner) {
                this.d_distToCurrentGoalUpdateTime = -1.7976931348623157E308;
            }
            this.updateDistToGoal(kb, agent);
        }
        return needsNewPath;
    }

    private boolean updateDistToGoal(KB kb, OccAgent agent) {
        if (this.d_currentPlanner != this.d_goToClosestPlanner || kb.getCurrentSimTime() - this.d_distToCurrentGoalUpdateTime < 5.0) {
            return false;
        }
        this.d_distToCurrentGoalUpdateTime = kb.getCurrentSimTime();
        this.d_goalPathPlanner.update(kb, agent, false);
        IPath path = this.d_goalPathPlanner.getPath(kb, agent, false);
        this.d_distToCurrentGoal = path != null ? path.length(true) : Double.POSITIVE_INFINITY;
        return true;
    }

    @Override
    public IPathPlanner.IStatus getStatus(KB kb, OccAgent agent) {
        if (this.d_currentPlanner == this.d_goToClosestPlanner) {
            return new PathToTempLeaderStatus(this.d_distToCurrentGoal);
        }
        return null;
    }

    private IPathPlanner getDesiredPlanner(KB kb, OccAgent agent) {
        if (this.d_requiresLeader && this.d_fixedLeader != null && this.d_fixedLeader != agent) {
            int rankingOfLeader;
            int ranking = this.d_group.getMembersRanking(agent);
            if (ranking < (rankingOfLeader = this.d_group.getMembersRanking(this.d_fixedLeader))) {
                return this.d_goalPathPlanner;
            }
            return this.d_goToLeaderPlanner;
        }
        if (this.d_doorCrossed) {
            this.d_doorCrossed = false;
            return this.d_goalPathPlanner;
        }
        switch (this.d_state.ordinal()) {
            case 2: {
                int ranking = this.d_group.getMembersRanking(agent);
                int rankingOfClosest = this.d_group.getMembersRanking(this.d_closestOcc);
                if (ranking >= rankingOfClosest) {
                    return this.d_goToClosestPlanner;
                }
                return this.d_goalPathPlanner;
            }
        }
        return this.d_goalPathPlanner;
    }

    @Override
    public IPath getPath(KB kb, OccAgent agent, boolean forceNewPath) {
        Engine.TIME_ACCUM.begin("REGROUP PLANNER: GET PATH");
        IPath path = this.d_currentPlanner.getPath(kb, agent, forceNewPath);
        if (this.d_currentPlanner == this.d_goToClosestPlanner) {
            path = this.d_closestOcc != null && path != null ? new PathToTempLeader(path, this.d_closestOcc) : path;
        }
        Engine.TIME_ACCUM.end("REGROUP PLANNER: GET PATH");
        return path;
    }

    protected boolean updateState(OccAgent agent, KB kb) {
        Engine.TIME_ACCUM.begin("REGROUP PLANNER: UPDATE STATE");
        if (this.d_lastUpdateStateTime == kb.getCurrentSimTime()) {
            Engine.TIME_ACCUM.end("REGROUP PLANNER: UPDATE STATE");
            return this.d_newState;
        }
        this.d_lastUpdateStateTime = kb.getCurrentSimTime();
        State newState = this.findState(agent, kb);
        this.updateIsInTheWay(kb);
        this.d_group.setDisconnected(this.groupShouldDisconnect(kb, agent, newState), kb.getCurrentSimTime());
        Engine.TIME_ACCUM.end("REGROUP PLANNER: UPDATE STATE");
        if (newState != this.d_state) {
            this.d_state = newState;
            this.d_newState = true;
            return this.d_newState;
        }
        this.d_newState = false;
        return this.d_newState;
    }

    private boolean groupShouldDisconnect(KB kb, OccAgent agent, State state) {
        if (state == State.CONNECTED) {
            return false;
        }
        if (!this.allDisconnectedStuck()) {
            return true;
        }
        if (this.d_membersLost) {
            return false;
        }
        return !this.isInTheWay(kb, true);
    }

    private boolean allDisconnectedStuck() {
        return this.d_disconnectedTimer != 0.0;
    }

    private State findState(OccAgent thisAgent, KB kb) {
        this.updateFixedLeader();
        this.updateUnreachableGroupMembers(kb);
        if (this.d_fixedLeader == null) {
            double minDist = Double.MAX_VALUE;
            OccAgent tempLeader = null;
            for (OccAgent o : this.d_group.getHighestRankingAgents()) {
                IPathPlanner.IStatus pstatus;
                double dist;
                if (this.d_unreachableGroupMembers.contains(o) || !Double.isFinite(dist = (pstatus = o.getPathStatus().plannerStatus) instanceof PathToTempLeaderStatus ? ((PathToTempLeaderStatus)pstatus).remainingDistToGoal : o.getRemainingDistance()) || !(dist < minDist)) continue;
                minDist = dist;
                tempLeader = o;
            }
            if (tempLeader != null && !Objects.equals(tempLeader, this.d_tempLeader)) {
                this.d_tempLeader = tempLeader;
            }
            if (tempLeader == null) {
                return State.CONNECTED;
            }
        } else {
            this.d_tempLeader = this.d_fixedLeader;
        }
        Set<OccAgent> connectedToLeader = RegroupPlanner.getOccsConnectedTo(this.d_tempLeader, this.d_group.getMembers(), this.d_group.getCurrentMaxDist());
        if (this.d_disconnectedTimer == 0.0 || this.d_disconnectedTimer <= kb.getCurrentSimTime()) {
            if (connectedToLeader.size() < this.d_group.getMembers().size()) {
                LinkedHashSet<OccAgent> disconnectedFromLeader = new LinkedHashSet<OccAgent>(this.d_group.getMembers());
                disconnectedFromLeader.removeAll(connectedToLeader);
                boolean allDisconnectedStuck = true;
                this.d_membersLost = false;
                for (OccAgent a : disconnectedFromLeader) {
                    if (a.isLost()) {
                        this.d_membersLost = true;
                    }
                    if (a.isLost() || a.isStuck(kb)) continue;
                    allDisconnectedStuck = false;
                    break;
                }
                this.d_disconnectedTimer = allDisconnectedStuck ? kb.getCurrentSimTime() + 1.0 : 0.0;
            } else {
                this.d_disconnectedTimer = 0.0;
            }
        }
        if (connectedToLeader.size() == this.d_group.getMembers().size() && this.d_ready) {
            return State.CONNECTED;
        }
        if (connectedToLeader.contains(thisAgent)) {
            return State.DISCONNECTED_LEADER_SIDE;
        }
        OccAgent closestOcc = this.getClosestOcc(thisAgent, connectedToLeader, kb.getParams().local_tail_tol_frac);
        if (closestOcc != null && !Objects.equals(closestOcc, this.d_closestOcc)) {
            this.d_closestOcc = closestOcc;
            this.d_goToClosestPlanner = new LocallyQuickest(thisAgent, new LocalTimeEstimate.QueueSizes(), RegroupPlanner.newTarget(this.d_closestOcc));
        }
        if (closestOcc == null) {
            this.d_closestOcc = null;
        }
        return State.DISCONNECTED_NON_LEADER_SIDE;
    }

    private void updateUnreachableGroupMembers(final KB kb) {
        if (this.d_fixedLeader != null) {
            return;
        }
        if (kb.getCurrentSimTime() < this.d_lastUpdateUnreachableTime + 5.0) {
            return;
        }
        this.d_lastUpdateUnreachableTime = kb.getCurrentSimTime();
        this.d_unreachableGroupMembers.clear();
        ANode room = null;
        boolean sameRoom = true;
        for (OccAgent agent : this.d_group.getMembers()) {
            if (room == null) {
                room = agent.getOcc().curNode;
                continue;
            }
            if (room == agent.getOcc().curNode) continue;
            sameRoom = false;
            break;
        }
        if (sameRoom) {
            return;
        }
        Predicate<Tri> triFilter = TriFilters.rejectClosed();
        final HashMap<OccAgent, Predicate<PathChange>> pathFilters = new HashMap<OccAgent, Predicate<PathChange>>(this.d_group.getMembers().size());
        for (OccAgent agent : this.d_group.getMembers()) {
            pathFilters.put(agent, agent.generatePathFilter(kb, triFilter, EdgeFilters.acceptAll(), OccAgent.PathFilterType.TRANSIENT));
        }
        ArrayList<Pair<OccAgent, Future<Boolean>>> futures = new ArrayList<Pair<OccAgent, Future<Boolean>>>(this.d_group.getMembers().size());
        ExecutorService executor = kb.getGroupExecutorWorker();
        for (final OccAgent occAgent : this.d_group.getMembers()) {
            Future<Boolean> future = executor.submit(new Callable<Boolean>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Boolean call() throws Exception {
                    PointTarget pointTarget = RegroupPlanner.newTarget(occAgent);
                    for (OccAgent agent : RegroupPlanner.this.d_group.getMembers()) {
                        Predicate pathFilter;
                        if (agent == occAgent || agent.getOcc().curNode == occAgent.getOcc().curNode) continue;
                        Map map = pathFilters;
                        synchronized (map) {
                            pathFilter = (Predicate)pathFilters.get(agent);
                        }
                        if (pointTarget.isReachable(kb, agent, pathFilter)) continue;
                        return false;
                    }
                    return true;
                }
            });
            futures.add(new Pair<OccAgent, Future<Boolean>>(occAgent, future));
        }
        for (Pair pair : futures) {
            boolean isReachable;
            try {
                isReachable = (Boolean)((Future)pair.v2).get();
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
            if (isReachable) continue;
            this.d_unreachableGroupMembers.add((OccAgent)pair.v1);
        }
        if (this.d_unreachableGroupMembers.size() == this.d_group.getMembers().size()) {
            this.d_unreachableGroupMembers.clear();
        }
    }

    private void updateFixedLeader() {
        if (this.d_requiresLeader && (this.d_fixedLeader == null || this.d_fixedLeader != this.d_group.getLeader())) {
            this.setFixedLeader(this.d_group.getLeader());
        } else if (this.d_fixedLeader != null && this.d_fixedLeader.isDone()) {
            this.d_requiresLeader = false;
            this.d_fixedLeader = null;
            this.d_goToLeaderPlanner = null;
        }
    }

    private OccAgent getClosestOcc(OccAgent agent, Set<OccAgent> agents, double tailToleranceFraction) {
        double maxDistToOcc = -1.7976931348623157E308;
        BiFunction<Double, Double, Double> fitness = (dist, angle) -> 2.0 * dist + angle;
        OccAgent closestAgent = null;
        Point3d pos = agent.getPos();
        for (OccAgent a : agents) {
            double d = pos.distance(a.getPos());
            if (!(d > maxDistToOcc)) continue;
            maxDistToOcc = d;
        }
        IParametric3D seekCurve = agent.getSeekCurve();
        Vector3d goalVel = seekCurve != null ? seekCurve.getTangent(0.0) : null;
        double goalVelLen = goalVel != null ? goalVel.length() : Double.NaN;
        double minFitness = Double.MAX_VALUE;
        for (OccAgent a : agents) {
            double f;
            Point3d otherPos = a.getPos();
            double d = pos.distance(otherPos) / maxDistToOcc;
            double angle2 = Math.PI;
            if (seekCurve != null) {
                Vector3d toAgent = Util3D.vector(pos, otherPos);
                if (!theUtil.eq0(goalVelLen, 1.0E-4) && theUtil.eq0(toAgent.z, 1.0E-4)) {
                    angle2 = Inter.angleAbs(goalVel, toAgent);
                }
            }
            if (!((f = fitness.apply(d, angle2).doubleValue()) < minFitness)) continue;
            minFitness = f;
            closestAgent = a;
        }
        if (closestAgent != null && this.d_closestOcc != null && closestAgent != this.d_closestOcc) {
            double tol;
            double dist2;
            double minTailTol = agent.getOccupantRadius() * 2.0;
            double dist1 = this.d_closestOcc.getPos().distance(pos);
            if (theUtil.eq(dist1, dist2 = closestAgent.getPos().distance(pos), tol = Math.max(minTailTol, Math.max(dist1, dist2) * tailToleranceFraction))) {
                return this.d_closestOcc;
            }
        }
        return closestAgent;
    }

    private static Set<OccAgent> getOccsConnectedTo(OccAgent firstAgent, Set<OccAgent> allAgents, double maxDistance) {
        LinkedHashSet<OccAgent> open = new LinkedHashSet<OccAgent>();
        LinkedHashSet<OccAgent> remaining = new LinkedHashSet<OccAgent>(allAgents);
        remaining.remove(firstAgent);
        LinkedHashSet<OccAgent> close = new LinkedHashSet<OccAgent>();
        open.add(firstAgent);
        double maxDistSquared = maxDistance * maxDistance;
        while (!open.isEmpty()) {
            LinkedHashSet<OccAgent> toRemoveOpen = new LinkedHashSet<OccAgent>();
            LinkedHashSet<OccAgent> toAddOpen = new LinkedHashSet<OccAgent>();
            for (OccAgent agent : open) {
                if (close.contains(agent)) continue;
                LinkedHashSet<OccAgent> toRemoveRemaining = new LinkedHashSet<OccAgent>();
                for (OccAgent other : remaining) {
                    double gap;
                    double distSquared;
                    if (close.contains(other) || open.contains(other) || !((distSquared = Math.pow(gap = Inter.getOccGap(agent.getShape(), other.getShape()), 2.0) + Math.pow(agent.getPos().z - other.getPos().z, 2.0)) <= maxDistSquared)) continue;
                    toAddOpen.add(other);
                    toRemoveRemaining.add(other);
                }
                remaining.removeAll(toRemoveRemaining);
                toRemoveOpen.add(agent);
                close.add(agent);
            }
            open.addAll(toAddOpen);
            open.removeAll(toRemoveOpen);
        }
        return close;
    }

    @Override
    public void doorCrossed(double t, OccAgent agent, DoorQueue queue) {
        this.d_doorCrossed = true;
        this.d_currentPlanner.doorCrossed(t, agent, queue);
        if (!this.d_currentPlanner.equals(this.d_goalPathPlanner)) {
            this.d_goalPathPlanner.doorCrossed(t, agent, queue);
        }
        if (this.d_goToClosestPlanner != null && !this.d_currentPlanner.equals(this.d_goToClosestPlanner)) {
            this.d_goToClosestPlanner.doorCrossed(t, agent, queue);
        }
    }

    @Override
    public Predicate<WingedEdge> getTransientEdgeFilter(KB kb, OccAgent agent) {
        return this.d_currentPlanner.getTransientEdgeFilter(kb, agent);
    }

    public boolean seeksGoal() {
        return this.d_currentPlanner == this.d_goalPathPlanner;
    }

    public State getState() {
        return this.d_state;
    }

    private static double getSpeedFraction(double timeFraction, double timeTotal) {
        double speedFraction;
        double d = speedFraction = timeTotal != 0.0 ? 1.0 - Math.min(timeFraction / timeTotal, 1.0) : 0.0;
        assert (speedFraction >= 0.0 && speedFraction <= 1.0);
        return speedFraction;
    }

    public double getMinVel() {
        return this.d_group.getMinVel();
    }

    public void updateSpeedState(KB kb, OccAgent agent) {
        OccGroup.SpeedState groupSpeedState = this.d_group.getSpeedState();
        this.d_speedState = SpeedState.GO;
        if (groupSpeedState == OccGroup.SpeedState.SLOW_DOWN && this.d_state == State.DISCONNECTED_LEADER_SIDE) {
            this.d_speedState = !this.isInTheWay(kb, false) ? SpeedState.SLOW_DOWN : SpeedState.GO;
        } else if (groupSpeedState == OccGroup.SpeedState.STOP && this.d_state == State.DISCONNECTED_LEADER_SIDE) {
            this.d_speedState = !this.isInTheWay(kb, false) ? SpeedState.STOP : SpeedState.GO;
        }
    }

    private void updateIsInTheWay(KB kb) {
        if (this.d_state != State.DISCONNECTED_LEADER_SIDE) {
            this.d_isInTheWay = false;
        } else {
            this.isInTheWay(kb, false);
        }
        this.d_group.setInTheWay(this.d_agent, this.d_isInTheWay);
    }

    private boolean isInTheWay(KB kb, boolean leaderOnly) {
        if (leaderOnly && this.d_agent != this.d_tempLeader) {
            return false;
        }
        if (kb.getCurrentSimTime() < this.d_nextSensesUpdateTime) {
            return this.d_isInTheWay;
        }
        if (this.d_agent.getOcc().curNode.shouldExitTransport()) {
            this.d_isInTheWay = true;
            return this.d_isInTheWay;
        }
        List<OccAgent> closeOccs = this.d_agent.getWaitingOccs(kb);
        Set<OccAgent> groupMembers = this.d_group.getMembers();
        this.d_isInTheWay = closeOccs.stream().anyMatch(a -> !groupMembers.contains(a) && (COHESION_FACTOR == 0.0 || a.isSlow(kb, a.getAverageSpeedAlongPath(kb, 1.0), Math.max(1.0 - COHESION_FACTOR, 0.01))));
        this.d_nextSensesUpdateTime = kb.getCurrentSimTime() + 1.0;
        return this.d_isInTheWay;
    }

    public OccAgent getTempLeader() {
        return this.d_tempLeader;
    }

    @Override
    public void setRoom(ANode room, OccAgent agent) {
        if (this.d_goalPathPlanner != null && this.d_goalPathPlanner instanceof LocallyQuickest) {
            ((LocallyQuickest)this.d_goalPathPlanner).setRoom(room, agent);
        }
        if (this.d_goToClosestPlanner != null && this.d_goToClosestPlanner instanceof LocallyQuickest) {
            ((LocallyQuickest)this.d_goToClosestPlanner).setRoom(room, agent);
        }
    }

    private static enum SpeedState {
        GO,
        SLOW_DOWN,
        STOP;

    }

    public static enum State {
        CONNECTED,
        DISCONNECTED_LEADER_SIDE,
        DISCONNECTED_NON_LEADER_SIDE;

    }

    private static class PathToTempLeaderStatus
    implements IPathPlanner.IStatus {
        static final long serialVersionUID = 1L;
        public final double remainingDistToGoal;

        public PathToTempLeaderStatus(double remainingDistToGoal) {
            this.remainingDistToGoal = remainingDistToGoal;
        }
    }

    private static class PathToTempLeader
    implements IPath,
    Serializable {
        static final long serialVersionUID = 1L;
        public final IPath path;
        public final OccAgent tempLeader;

        public PathToTempLeader(IPath path, OccAgent tempLeader) {
            this.path = path;
            this.tempLeader = tempLeader;
        }

        @Override
        public int getNumPoints(boolean fuzzy) {
            return this.path.getNumPoints(fuzzy);
        }

        @Override
        public IPathSeek pointAt(int ix) {
            return this.path.pointAt(ix);
        }

        @Override
        public Pair<ANode, DoorDir> getTargetDoor() {
            return this.path.getTargetDoor();
        }

        @Override
        public double length(boolean fuzzy) {
            double leaderDist;
            double len = this.path.length(fuzzy);
            if (fuzzy && Double.isFinite(leaderDist = this.tempLeader.getRemainingDistance())) {
                len += leaderDist;
            }
            return len;
        }

        @Override
        public double fuzzyLength() {
            double dist = this.path.fuzzyLength();
            double leaderDist = this.tempLeader.getRemainingDistance();
            if (Double.isFinite(leaderDist)) {
                dist += leaderDist;
            }
            return dist;
        }
    }

    protected static class RegroupPlannerMoveToGoal
    extends MoveToGoal {
        private static final long serialVersionUID = 7263847112620696868L;
        private RegroupPlanner pathPlanner;

        public RegroupPlannerMoveToGoal(KB kb, OccAgent agent, RegroupPlanner pathPlanner) {
            super(kb, agent, pathPlanner);
            this.pathPlanner = pathPlanner;
        }

        @Override
        public Steer steer(KB kb, OccAgent agent, SeekCurve seek) {
            this.pathPlanner.initGroup(agent, kb);
            this.pathPlanner.updateSpeedState(kb, agent);
            double speedLimit = this.pathPlanner.getState() != State.DISCONNECTED_NON_LEADER_SIDE ? this.pathPlanner.getMinVel() : Double.MAX_VALUE;
            switch (this.pathPlanner.d_speedState.ordinal()) {
                case 0: {
                    Vector3d dir = this.clampVel(RegroupPlannerMoveToGoal.getDesiredVel(seek.curve, agent.getOcc(), kb), speedLimit);
                    Vector3d orient = LookAtUtil.orientToTargetIfVisible(kb, agent.getOcc().lookAtSource, agent, () -> dir);
                    return new Steer(null, seek, dir, orient, agent.getOcc().priority, 1.0, Filters.acceptAll(), false, true, new OccAgent[0]);
                }
                case 1: {
                    double speedFraction = RegroupPlanner.getSpeedFraction(kb.getCurrentSimTime() - this.pathPlanner.d_group.slowDownStart, this.pathPlanner.d_group.slowdownTime);
                    Vector3d dir = this.clampVel(RegroupPlannerMoveToGoal.getDesiredVel(seek.curve, agent.getOcc(), kb), speedLimit);
                    dir.scale(speedFraction);
                    Vector3d orient = LookAtUtil.orientToTargetIfVisible(kb, agent.getOcc().lookAtSource, agent, () -> dir);
                    return new Steer(null, seek, dir, orient, agent.getOcc().priority, 1.0, Filters.acceptAll(), false, true, new OccAgent[0]);
                }
            }
            Vector3d dir = new Vector3d(0.0, 0.0, 0.0);
            Vector3d orient = LookAtUtil.orientToTargetIfVisible(kb, agent.getOcc().lookAtSource, agent, () -> dir);
            return new Steer(null, seek, dir, orient, agent.getOcc().priority, 1.0, Filters.acceptAll(), false, true, new OccAgent[0]);
        }

        private Vector3d clampVel(Vector3d desiredVel, double speedLimit) {
            if (desiredVel.length() <= speedLimit) {
                return desiredVel;
            }
            desiredVel.normalize();
            desiredVel.scale(speedLimit);
            return desiredVel;
        }
    }

    public static class RegroupPlannerWanderRoomSafe
    extends WanderRoomSafe {
        private static final long serialVersionUID = 1384457388754393283L;
        private final RegroupPlanner d_regroupPlanner;
        private final Seek d_regroupSeek;
        private final PathFollow d_pathFollow;

        public RegroupPlannerWanderRoomSafe(OccAgent agent, KB kb, ISeekCalc wanderSeek, Collection<ANode> rooms, IPathPlanner backupPlanner) {
            super(wanderSeek, rooms, backupPlanner);
            this.d_pathFollow = agent.getPathFollow();
            if (agent.getPathFollow() != null && agent.getPathFollow().getPathPlanner() instanceof RegroupPlanner) {
                this.d_regroupPlanner = (RegroupPlanner)agent.getPathFollow().getPathPlanner();
                this.d_regroupSeek = new Seek(kb, agent, this.d_regroupPlanner, Double.NaN, null);
            } else {
                this.d_regroupPlanner = null;
                this.d_regroupSeek = null;
            }
        }

        @Override
        public SeekCurve generateSeekCurve(KB kb, OccAgent agent) throws LostException {
            if (this.d_regroupPlanner == null) {
                return super.generateSeekCurve(kb, agent);
            }
            this.d_regroupPlanner.updateState(agent, kb);
            if (this.d_regroupPlanner.getState() == State.CONNECTED) {
                return super.generateSeekCurve(kb, agent);
            }
            return this.d_regroupSeek.generateSeekCurve(kb, agent);
        }

        @Override
        public PathFollow getPathFollow(OccAgent agent) {
            return this.d_pathFollow;
        }
    }

    protected static class RegroupPlannerSeek
    extends Seek {
        private static final long serialVersionUID = -6204531103519145474L;
        private final double leaderComfortDistance = 1.0;
        private final RegroupPlanner pathPlanner;
        private final WanderRoom wanderRoom;

        public RegroupPlannerSeek(KB kb, OccAgent agent, RegroupPlanner pathPlanner) {
            super(kb, agent, pathPlanner, Double.NaN, null);
            this.pathPlanner = pathPlanner;
            this.wanderRoom = new WanderRoom(kb, agent, Collections.singleton(agent.getOcc().curNode), true);
        }

        @Override
        protected double calcSeekSpeed(KB kb, OccInfo oi, IParametric3D seekCurve) {
            if (this.pathPlanner.d_requiresLeader && this.pathPlanner.d_fixedLeader != null && oi.oa != this.pathPlanner.d_fixedLeader && oi.oa.getPos().distance(this.pathPlanner.d_fixedLeader.getPos()) < 1.0) {
                return 0.0;
            }
            this.pathPlanner.updateSpeedState(kb, oi.oa);
            double speedLimit = this.pathPlanner.getState() != State.DISCONNECTED_NON_LEADER_SIDE ? this.pathPlanner.getMinVel() : Double.MAX_VALUE;
            switch (this.pathPlanner.d_speedState.ordinal()) {
                case 0: {
                    double speed = super.calcSeekSpeed(kb, oi, seekCurve);
                    return Math.min(speed, speedLimit);
                }
                case 1: {
                    double speedFraction = RegroupPlanner.getSpeedFraction(kb.getCurrentSimTime() - this.pathPlanner.d_group.slowDownStart, this.pathPlanner.d_group.slowdownTime);
                    double speed = Math.min(super.calcSeekSpeed(kb, oi, seekCurve), speedLimit) * speedFraction;
                    return speed;
                }
            }
            return 0.0;
        }

        @Override
        public SeekCurve generateSeekCurve(KB kb, OccAgent agent) throws LostException {
            this.pathPlanner.initGroup(agent, kb);
            if (!this.pathPlanner.d_ready) {
                SeekCurve curve = this.wanderRoom.generateSeekCurve(kb, agent);
                return curve.seeking ? new SeekCurve(curve.curve, curve.wallSlider, curve.transientPathFilter, false) : curve;
            }
            return super.generateSeekCurve(kb, agent);
        }

        @Override
        public SeekInfo getSeekInfo(KB kb, OccInfo oi, SeekCurve seek) {
            if (!this.pathPlanner.d_ready) {
                return this.wanderRoom.getSeekInfo(kb, oi, seek);
            }
            return super.getSeekInfo(kb, oi, seek);
        }
    }
}

