/*
 * Decompiled with CFR 0.152.
 */
package inferno.sim.scripting;

import inferno.sim.KB;
import java.util.ArrayList;
import java.util.List;

public class SimulationControlApi {
    public final ApiV1 v1;
    private KB d_kb;
    private List<OnUpdateFunc> d_onUpdateCallbacks;
    private List<OnExitFunc> d_onExitCallbacks;

    public SimulationControlApi(KB kb) {
        this.d_kb = kb;
        this.d_onUpdateCallbacks = new ArrayList<OnUpdateFunc>();
        this.d_onExitCallbacks = new ArrayList<OnExitFunc>();
        this.v1 = new ApiV1();
    }

    public void invokeCallbacksOnExit() {
        for (OnExitFunc f : this.d_onExitCallbacks) {
            try {
                f.onExit();
            }
            catch (RuntimeException e) {
                e.printStackTrace();
            }
        }
    }

    public void invokeCallbacksOnUpdate() {
        for (OnUpdateFunc f : this.d_onUpdateCallbacks) {
            try {
                f.onUpdate(this.d_kb.getCurrentSimTime());
            }
            catch (RuntimeException e) {
                e.printStackTrace();
            }
        }
    }

    public class ApiV1 {
        public void onUpdate(OnUpdateFunc callback) {
            SimulationControlApi.this.d_onUpdateCallbacks.add(callback);
        }

        public void onExit(OnExitFunc callback) {
            SimulationControlApi.this.d_onExitCallbacks.add(callback);
        }
    }

    @FunctionalInterface
    public static interface OnExitFunc {
        public void onExit();
    }

    @FunctionalInterface
    public static interface OnUpdateFunc {
        public void onUpdate(double var1);
    }
}

