/*
 * Decompiled with CFR 0.152.
 */
package inferno.sim.path;

import inferno.data2.ANode;
import inferno.data2.DoorDir;
import inferno.data2.Mesh;
import inferno.data2.TriPoint;
import inferno.data2.WingedEdge;
import inferno.sim.path.IPathSeek;
import java.io.Serializable;
import java.util.function.Predicate;
import javax.vecmath.Vector3d;
import thunderheadeng.util.Pair;

public class WaypointSeek
implements IPathSeek,
Serializable {
    static final long serialVersionUID = 1L;
    private final TriPoint d_pt;
    private final Predicate<WingedEdge> d_edgeFilter;
    private double d_obstDist = Double.POSITIVE_INFINITY;
    private ANode d_virtualDoor;

    public WaypointSeek(TriPoint pt, Predicate<WingedEdge> edgeFilter) {
        this(pt, edgeFilter, null);
    }

    public WaypointSeek(TriPoint pt, Predicate<WingedEdge> edgeFilter, ANode virtualDoor) {
        this.d_pt = pt;
        this.d_edgeFilter = edgeFilter;
        this.d_virtualDoor = virtualDoor;
    }

    @Override
    public WaypointSeek clone() {
        try {
            WaypointSeek seek = (WaypointSeek)super.clone();
            return seek;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    @Override
    public TriPoint updateSeekPt(TriPoint currLoc, double radius, Mesh mesh) {
        return this.d_pt;
    }

    @Override
    public TriPoint getSeekPt() {
        return this.d_pt;
    }

    @Override
    public boolean updateVisibility(TriPoint currLoc, double radius, Mesh mesh) {
        this.d_obstDist = mesh.getPathObstructionDist(currLoc, this.d_pt, radius, this.d_edgeFilter);
        return this.isVisible();
    }

    @Override
    public double getObstructionDist() {
        return this.d_obstDist;
    }

    @Override
    public Vector3d getPredictDir() {
        return null;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("[PathFollow$WaypointSeek: ");
        sb.append("isVisible=" + this.isVisible());
        sb.append(", pt=" + String.valueOf(this.d_pt.p));
        sb.append("]");
        return sb.toString();
    }

    @Override
    public boolean isVirtual(ANode node) {
        if (this.d_virtualDoor == null) {
            return false;
        }
        return !node.getDoors().contains(this.d_virtualDoor);
    }

    @Override
    public Pair<ANode, DoorDir> getTargetDoor() {
        return null;
    }
}

