/*
 * Decompiled with CFR 0.152.
 */
package inferno.sim.path;

import inferno.data2.ANode;
import inferno.data2.DoorDir;
import inferno.data2.Tri;
import inferno.data2.WingedEdge;
import inferno.sim.path.IPathHistory;
import java.io.ObjectStreamException;
import java.io.Serializable;
import thunderheadeng.util.theUtil;

public class PathChange
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final EmptyHistory EMPTY_HISTORY = new EmptyHistory();
    public Tri tri;
    public WingedEdge edge;
    public IPathHistory history;

    public PathChange() {
    }

    public PathChange(Tri tri, WingedEdge edge) {
        this(tri, edge, EMPTY_HISTORY);
    }

    public PathChange(Tri tri, WingedEdge edge, IPathHistory history) {
        this.tri = tri;
        this.edge = edge;
        this.history = history;
    }

    public DoorDir getDir() {
        if (this.edge != null && this.tri != null) {
            return this.edge.getDir(this.tri);
        }
        return null;
    }

    public PathChange set(Tri tri, WingedEdge edge) {
        return this.set(tri, edge, EMPTY_HISTORY);
    }

    public PathChange set(Tri tri, WingedEdge edge, IPathHistory history) {
        this.tri = tri;
        this.edge = edge;
        this.history = history;
        return this;
    }

    public Type getType() {
        if (this.edge != null && this.tri != null) {
            return Type.TRI_ENTER;
        }
        if (this.edge != null) {
            return Type.EDGE_ENTER;
        }
        return Type.PATH_BEGIN;
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof PathChange && ((PathChange)obj).tri == this.tri && ((PathChange)obj).edge == this.edge;
    }

    public int hashCode() {
        return 0xFE342A ^ this.tri.hashCode() + theUtil.hashCode(this.edge);
    }

    public static final class EmptyHistory
    implements IPathHistory,
    Serializable {
        private static final long serialVersionUID = 1L;

        private Object readResolve() throws ObjectStreamException {
            return EMPTY_HISTORY;
        }

        @Override
        public boolean isVisited(ANode node) {
            return false;
        }
    }

    public static enum Type {
        PATH_BEGIN,
        EDGE_ENTER,
        TRI_ENTER;

    }
}

