/*
 * Decompiled with CFR 0.152.
 */
package inferno.sim.output.json;

import inferno.data2.Mesh;
import inferno.data2.OccLocator;
import inferno.sim.KB;
import inferno.sim.OccAgent;
import inferno.sim.Param;
import inferno.sim.output.SocialDistanceTransientWriter;
import inferno.sim.output.json.AJsonInfoWriter;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import org.jscience.physics.units.SI;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.BoundingSphere;
import thunderheadeng.geometry.search.ITest;
import thunderheadeng.util.Filters;
import thunderheadeng.util.Pair;
import thunderheadeng.util.TriFunction;
import thunderheadeng.util.UnorderedPair;

public class SocialDistanceAccumulatedWriterJson
extends AJsonInfoWriter {
    private static final double UPDATE_INTERVAL = 0.5;
    private final double d_detectionRadius;
    private final ConcurrentMap<OccAgent, Map<OccAgent, Double>> d_data;
    private final ConcurrentMap<OccAgent, Double> d_lastUpdate;

    public static boolean isWriterEnabled(KB kb) {
        return kb.getParams().social_distance_csv_output;
    }

    public SocialDistanceAccumulatedWriterJson(KB kb, double detectionRadius) {
        super(kb, false);
        this.d_detectionRadius = detectionRadius;
        this.d_data = new ConcurrentHashMap<OccAgent, Map<OccAgent, Double>>();
        this.d_lastUpdate = new ConcurrentHashMap<OccAgent, Double>();
    }

    @Override
    public void open(double t, Param params) throws IOException {
        this.getWriter().open(t, new File(params.out_sd_accumulated_json));
    }

    @Override
    public void writeFrame(double t) {
        LinkedHashMap frame = new LinkedHashMap();
        for (OccAgent agent : this.d_data.keySet()) {
            LinkedHashMap<String, Object> occData = new LinkedHashMap<String, Object>();
            Map agentSdMap = (Map)this.d_data.get(agent);
            for (Keys k : Keys.values()) {
                occData.put(k.toString(), k.apply(this.getKb(), agent, agentSdMap));
            }
            frame.put(String.valueOf(agent.getOcc().getId()), occData);
        }
        this.getWriter().add(frame);
    }

    @Override
    public void consolidate() {
    }

    public void update(boolean forceUpdateAll) {
        ConcurrentHashMap distMap = new ConcurrentHashMap(this.getKb().getActiveAgents().size(), 0.75f, Runtime.getRuntime().availableProcessors());
        this.getKb().getActiveAgents().parallelStream().forEach(agent -> {
            if (!this.d_data.containsKey(agent)) {
                this.d_data.put((OccAgent)agent, new HashMap());
                this.d_lastUpdate.put((OccAgent)agent, this.getKb().getCurrentSimTime());
                return;
            }
            double dt = this.getKb().getCurrentSimTime() - (Double)this.d_lastUpdate.get(agent);
            if (dt < 0.5 & !forceUpdateAll) {
                return;
            }
            List<OccAgent> nearOccs = this.getKb().findOccs((ITest<AABox>)new BoundingSphere(agent.getPos(), this.d_detectionRadius), OccLocator.exclude(agent, Filters.acceptAll()), true);
            Mesh m = this.getKb().getMesh();
            for (OccAgent nearOcc : nearOccs) {
                double distance = distMap.computeIfAbsent(new UnorderedPair<OccAgent, OccAgent>((OccAgent)agent, nearOcc), upair -> SocialDistanceTransientWriter.getSocialDistance(m, (OccAgent)upair.v1, (OccAgent)upair.v2, this.d_detectionRadius));
                if (!Double.isFinite(distance) || !(distance <= this.d_detectionRadius)) continue;
                Map agentSdMap = (Map)this.d_data.get(agent);
                Double prevDt = (Double)agentSdMap.get(nearOcc);
                if (prevDt == null) {
                    prevDt = 0.0;
                }
                agentSdMap.put(nearOcc, prevDt + dt);
            }
            this.d_lastUpdate.put((OccAgent)agent, this.getKb().getCurrentSimTime());
        });
    }

    private static Pair<Integer, List<String>> filterByExposureTime(Map<OccAgent, Double> agentSdMap, double minTime) {
        Map<OccAgent, Double> overTime = agentSdMap.entrySet().stream().filter(entry -> (Double)entry.getValue() >= minTime).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        List overTimeIds = overTime.keySet().stream().map(agent -> Integer.toString(agent.getOcc().getId())).collect(Collectors.toList());
        return new Pair<Integer, List<String>>(overTime.size(), overTimeIds);
    }

    private static enum Keys {
        ID("id", (kb, occ, data) -> String.valueOf(occ.getOcc().getId())),
        NAME("name", (kb, occ, data) -> occ.getOcc().name),
        DETECTION_RADIUS("detectionRadius", (kb, occ, data) -> AJsonInfoWriter.convertToMapWithUnits(SI.METER, AJsonInfoWriter.formatDouble(kb.getParams().social_distance_value, 2))),
        GROUP_ID("groupId", (kb, occ, data) -> occ.getOcc().occupantGroup != null ? Integer.valueOf(occ.getOcc().occupantGroup.getID()) : "None"),
        SD("sd", (kb, occ, data) -> null),
        LONGEST_OCC("longestExposure", (kb, occ, data) -> {
            LinkedHashMap<String, Object> longestExposure = new LinkedHashMap<String, Object>();
            ArrayList contacts = new ArrayList(data.keySet());
            contacts.sort((o1, o2) -> -Double.compare((Double)data.get(o1), (Double)data.get(o2)));
            if (contacts.size() == 0) {
                return null;
            }
            OccAgent longest = (OccAgent)contacts.get(0);
            longestExposure.put("id", String.valueOf(longest.getId()));
            longestExposure.put("name", longest.getName());
            longestExposure.put("time", AJsonInfoWriter.formatDouble((Double)data.get(longest), 2));
            return longestExposure;
        }),
        OCCS_OVER_60_s("exposureOver60", (kb, occ, data) -> {
            LinkedHashMap<String, Boolean> over60Data = new LinkedHashMap<String, Boolean>();
            Pair<Integer, List<String>> exposureData = SocialDistanceAccumulatedWriterJson.filterByExposureTime(data, 60.0);
            over60Data.put("exposed", (Integer)exposureData.v1 > 0);
            over60Data.put("count", (Boolean)exposureData.v1);
            over60Data.put("ids", (Boolean)exposureData.v2);
            return over60Data;
        }),
        OCCS_OVER_300_s("exposureOver300", (kb, occ, data) -> {
            LinkedHashMap<String, Boolean> over300Data = new LinkedHashMap<String, Boolean>();
            Pair<Integer, List<String>> exposureData = SocialDistanceAccumulatedWriterJson.filterByExposureTime(data, 300.0);
            over300Data.put("exposed", (Integer)exposureData.v1 > 0);
            over300Data.put("count", (Boolean)exposureData.v1);
            over300Data.put("ids", (Boolean)exposureData.v2);
            return over300Data;
        });

        private final String key;
        private final TriFunction<KB, OccAgent, Map<OccAgent, Double>, Object> formatter;

        private Keys(String key, TriFunction<KB, OccAgent, Map<OccAgent, Double>, Object> formatter) {
            this.key = key;
            this.formatter = formatter;
        }

        public Object apply(KB kb, OccAgent occ, Map<OccAgent, Double> dataMap) {
            return this.formatter.apply(kb, occ, dataMap);
        }

        public String toString() {
            return this.key;
        }
    }
}

