/*
 * Decompiled with CFR 0.152.
 */
package inferno.sim.output.json;

import inferno.sim.KB;
import inferno.sim.OccAgent;
import inferno.sim.Param;
import inferno.sim.output.json.AOccDataWriterJson;
import inferno.sim.output.json.OccDataWriterSingleJson;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class OccDataWriterMultipleJson
extends AOccDataWriterJson {
    private Map<OccAgent, OccDataWriterSingleJson> d_writers = new LinkedHashMap<OccAgent, OccDataWriterSingleJson>();

    public OccDataWriterMultipleJson(KB kb) {
        super(kb, true);
        for (OccAgent oa : OccDataWriterMultipleJson.filterAgents(kb.getActiveAgents())) {
            OccDataWriterSingleJson writer = new OccDataWriterSingleJson(kb, false);
            writer.addAgent(oa);
            this.d_writers.put(oa, writer);
        }
    }

    public static List<String> getAllFileNames(KB kb) {
        ArrayList<String> filenames = new ArrayList<String>();
        for (OccAgent oa : kb.getAllAgentsEver()) {
            String fn = kb.getParams().out_occ_individual_json.replace("{id}", String.format("%05d_%s", oa.getOcc().getId(), oa.getOcc().name));
            filenames.add(fn);
        }
        return filenames;
    }

    @Override
    public void open(double t, Param params) throws IOException {
        for (Map.Entry<OccAgent, OccDataWriterSingleJson> entry : this.d_writers.entrySet()) {
            OccAgent oa = entry.getKey();
            OccDataWriterSingleJson writer = entry.getValue();
            String fn = params.out_occ_individual_json.replace("{id}", String.format("%05d_%s", oa.getOcc().getId(), oa.getOcc().name));
            writer.open(t, fn);
        }
    }

    @Override
    public void addAgents(double t, Collection<OccAgent> agents) {
        agents = OccDataWriterMultipleJson.filterAgents(agents);
        for (OccAgent oa : agents) {
            OccDataWriterSingleJson newWriter = new OccDataWriterSingleJson(this.getKb(), false);
            Param params = this.getKb().getParams();
            try {
                newWriter.addAgent(oa);
                String fn = params.out_occ_individual_json.replace("{id}", String.format("%05d_%s", oa.getOcc().getId(), oa.getOcc().name));
                newWriter.forceOpen(fn);
                newWriter.writeFrame(t, false);
                if (!oa.isDone()) {
                    this.d_writers.put(oa, newWriter);
                    continue;
                }
                newWriter.consolidate();
                newWriter.close();
            }
            catch (IOException e) {
                params.err.println(e.getLocalizedMessage());
            }
        }
    }

    @Override
    public void writeFrame(double t, boolean removeFinished) {
        Iterator<Map.Entry<OccAgent, OccDataWriterSingleJson>> it = this.d_writers.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<OccAgent, OccDataWriterSingleJson> entry = it.next();
            OccAgent oa = entry.getKey();
            OccDataWriterSingleJson writer = entry.getValue();
            writer.writeFrame(t, removeFinished);
            if (!removeFinished || !oa.isDone()) continue;
            writer.consolidate();
            writer.close();
            it.remove();
            this.d_writers.remove(oa);
        }
    }

    @Override
    public void consolidate() {
        for (OccDataWriterSingleJson writer : this.d_writers.values()) {
            writer.consolidate();
        }
    }

    @Override
    public void close() {
        super.close();
        for (OccDataWriterSingleJson writer : this.d_writers.values()) {
            writer.close();
        }
    }
}

