/*
 * Decompiled with CFR 0.152.
 */
package inferno.sim.output.json;

import inferno.data2.MeasurementRegion;
import inferno.sim.KB;
import inferno.sim.Param;
import inferno.sim.output.json.AJsonInfoWriter;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.ToDoubleFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import merlin.Intl;

public class MeasurementRegionWriterJson
extends AJsonInfoWriter {
    public static boolean isWriterEnabled(KB kb) {
        return !kb.getDensityRegions().isEmpty();
    }

    public MeasurementRegionWriterJson(KB kb) {
        super(kb, true);
    }

    @Override
    public void open(double t, Param params) throws IOException {
        this.getWriter().open(t, new File(params.out_measurement_regions_json));
    }

    @Override
    public void writeFrame(double t) {
        LinkedHashMap<String, Serializable> regionsFrame = new LinkedHashMap<String, Serializable>();
        regionsFrame.put(Keys.TIME.getName(), MeasurementRegionWriterJson.formatDouble(t, 2));
        List dataKeys = Stream.of(Keys.values()).filter(h -> h != Keys.TIME && h != Keys.NAME && h != Keys.REGIONS && (this.getKb().getParams().measurement_region_seekspeed || h != Keys.SEEKVEL)).collect(Collectors.toList());
        ArrayList regionsData = new ArrayList();
        for (MeasurementRegion region : this.getKb().getDensityRegions()) {
            LinkedHashMap<String, String> regionData = new LinkedHashMap<String, String>();
            dataKeys.stream().forEach(h -> regionData.put(h.getName(), (String)((Object)MeasurementRegionWriterJson.formatDouble(h.getData.applyAsDouble(region.data), 2))));
            regionData.put(Keys.NAME.getName(), region.name);
            regionsData.add(regionData);
        }
        regionsFrame.put(Keys.REGIONS.getName(), regionsData);
        this.getWriter().add(regionsFrame);
    }

    @Override
    public void consolidate() {
        LinkedHashMap<String, LinkedHashMap> finalData = new LinkedHashMap<String, LinkedHashMap>();
        ArrayList<Map<String, Object>> regionFrames = this.getWriter().readTempJsonData();
        for (Map<String, Object> frame : regionFrames) {
            double time = (Double)frame.get(Keys.TIME.getName());
            ArrayList regions = (ArrayList)frame.get(Keys.REGIONS.getName());
            for (Map region : regions) {
                String name = (String)region.get(Keys.NAME.getName());
                double density = (Double)region.get(Keys.DENSITY.getName());
                double velocity = (Double)region.get(Keys.VELOCITY.getName());
                double seekVelocity = this.getKb().getParams().measurement_region_seekspeed ? (Double)region.get(Keys.SEEKVEL.getName()) : Double.NaN;
                int count = (int)((Double)region.get(Keys.COUNT.getName())).doubleValue();
                LinkedHashMap data = finalData.containsKey(name) ? (LinkedHashMap)finalData.get(name) : new LinkedHashMap();
                LinkedHashMap densityData = data.containsKey(Keys.DENSITY.getName()) ? (LinkedHashMap)data.get(Keys.DENSITY.getName()) : new LinkedHashMap();
                LinkedHashMap velocityData = data.containsKey(Keys.VELOCITY.getName()) ? (LinkedHashMap)data.get(Keys.VELOCITY.getName()) : new LinkedHashMap();
                LinkedHashMap seekData = data.containsKey(Keys.SEEKVEL.getName()) ? (LinkedHashMap)data.get(Keys.SEEKVEL.getName()) : new LinkedHashMap();
                LinkedHashMap countData = data.containsKey(Keys.COUNT.getName()) ? (LinkedHashMap)data.get(Keys.COUNT.getName()) : new LinkedHashMap();
                densityData.put(time, density);
                velocityData.put(time, velocity);
                if (this.getKb().getParams().measurement_region_seekspeed) {
                    seekData.put(time, seekVelocity);
                }
                countData.put(time, count);
                data.put(Keys.DENSITY.getName(), densityData);
                data.put(Keys.VELOCITY.getName(), velocityData);
                data.put(Keys.SEEKVEL.getName(), seekData);
                data.put(Keys.COUNT.getName(), countData);
                finalData.put(name, data);
            }
        }
        this.getWriter().add(finalData);
    }

    private static enum Keys {
        TIME("time", Intl.intl("s"), d -> d.time),
        DENSITY("density", Intl.intl("pers/m2"), d -> d.density),
        VELOCITY("velocity", Intl.intl("m/s"), d -> d.velocity),
        SEEKVEL("seekVelocity", Intl.intl("m/s"), d -> d.seekVelocity),
        COUNT("count", Intl.intl("pers"), d -> d.count),
        NAME("name", null, null),
        REGIONS("regions", null, null);

        private final String d_name;
        private final String d_unit;
        public final ToDoubleFunction<MeasurementRegion.Data> getData;

        private Keys(String val, String unit, ToDoubleFunction<MeasurementRegion.Data> data) {
            this.d_name = val;
            this.d_unit = unit;
            this.getData = data;
        }

        public String toString() {
            return this.d_name.toString();
        }

        public String getName() {
            return this.d_name;
        }
    }
}

