/*
 * Decompiled with CFR 0.152.
 */
package inferno.sim.output.json;

import inferno.data2.ANode;
import inferno.data2.DoorDir;
import inferno.data2.WingedEdge;
import inferno.sim.DoorQueue;
import inferno.sim.DoorUsageSnapshot;
import inferno.sim.KB;
import inferno.sim.Param;
import inferno.sim.output.DoorUsageWriter;
import inferno.sim.output.json.AJsonInfoWriter;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import javax.vecmath.Vector2d;
import javax.vecmath.Vector3d;
import thunderheadeng.geometry.GeomConstants;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.util.theUtil;

public class DoorUsageWriterJson
extends AJsonInfoWriter {
    private final List<DoorUsageSnapshot> d_sortedSnapshots;
    private final List<ANode> d_sortedNodes;

    public static boolean isWriterEnabled(KB kb) {
        return true;
    }

    public DoorUsageWriterJson(KB kb) {
        super(kb, true);
        ArrayList<ANode> nodes = new ArrayList<ANode>(kb.getDoorNodes());
        Collections.sort(nodes, new Comparator<ANode>(this){

            @Override
            public int compare(ANode o1, ANode o2) {
                return o1.annotatedName.compareToIgnoreCase(o2.annotatedName);
            }
        });
        this.d_sortedNodes = nodes;
        ArrayList<DoorUsageSnapshot> snapshots = new ArrayList<DoorUsageSnapshot>(kb.getDoorNodes().size() * 2);
        for (ANode node : kb.getDoorNodes()) {
            DoorUsageWriterJson.getSnapshots(node, snapshots);
        }
        snapshots.trimToSize();
        Collections.sort(snapshots, new Comparator<DoorUsageSnapshot>(this){

            @Override
            public int compare(DoorUsageSnapshot o1, DoorUsageSnapshot o2) {
                return o1.name.compareToIgnoreCase(o2.name);
            }
        });
        this.d_sortedSnapshots = snapshots;
    }

    @Override
    public void open(double t, Param params) throws IOException {
        this.getWriter().open(t, new File(params.out_doors_json));
    }

    @Override
    public void writeFrame(double t) {
        LinkedHashMap<String, Number> doorFrame = new LinkedHashMap<String, Number>();
        int exitCount = 0;
        for (ANode n : this.d_sortedNodes) {
            exitCount += n.getExitedVia();
        }
        doorFrame.put(Keys.TIME.get(), t);
        doorFrame.put(Keys.EXITED.get(), exitCount);
        doorFrame.put(Keys.REMAINING.get(), this.getKb().getAllAgentsEver().size() - exitCount);
        HashSet<ANode> metaPrinted = new HashSet<ANode>();
        for (DoorUsageSnapshot us : this.d_sortedSnapshots) {
            LinkedHashMap<String, Number> doorUsage = new LinkedHashMap<String, Number>();
            int usage = us.updateUsage();
            doorUsage.put(Keys.USAGE.get(), usage);
            if (!metaPrinted.contains(us.node)) {
                double fullWidth = us.node.getDoorGeom().length;
                double totalBoundary = fullWidth - us.node.doorQueue.getEffWidth();
                doorUsage.put(Keys.WIDTH.get(), fullWidth);
                doorUsage.put(Keys.BOUNDARY.get(), totalBoundary);
                metaPrinted.add(us.node);
            }
            theUtil.mapPutSubObject(doorFrame, Keys.DOORS.get(), us.name, doorUsage);
        }
        if (this.getKb().hasQueueingDoors()) {
            for (ANode n : this.d_sortedNodes) {
                LinkedHashMap doorUsage;
                LinkedHashMap doors = (LinkedHashMap)doorFrame.get(Keys.DOORS.get());
                LinkedHashMap linkedHashMap = doorUsage = doors.containsKey(n.annotatedName) ? (LinkedHashMap)doors.get(n.annotatedName) : new LinkedHashMap();
                if (!this.getKb().isQueueingDoor(n)) continue;
                doorUsage.put(Keys.QUEUING_DOOR_USAGE.get(), n.getNumOccupants());
                theUtil.mapPutSubObject(doorFrame, Keys.DOORS.get(), n.annotatedName, doorUsage);
            }
        }
        this.getWriter().add(doorFrame);
    }

    @Override
    public void consolidate() {
        LinkedHashMap finalData = new LinkedHashMap();
        ArrayList<Map<String, Object>> tempData = this.getWriter().readTempJsonData();
        for (Map<String, Object> obj : tempData) {
            String time = String.valueOf(obj.get(Keys.TIME.get()));
            theUtil.mapPutSubObject(finalData, Keys.EXITED.get(), time, obj.get(Keys.EXITED.get()));
            theUtil.mapPutSubObject(finalData, Keys.REMAINING.get(), time, obj.get(Keys.REMAINING.get()));
            Map doors = (Map)obj.get(Keys.DOORS.get());
            for (Map.Entry entry : doors.entrySet()) {
                String door = (String)entry.getKey();
                Map doorData = (Map)entry.getValue();
                Map sortedDoorData = finalData.containsKey(door) ? (Map)finalData.get(door) : new LinkedHashMap();
                for (Map.Entry doorDataEntry : doorData.entrySet()) {
                    String key = (String)doorDataEntry.getKey();
                    Double value = (Double)doorDataEntry.getValue();
                    theUtil.mapPutSubObject(sortedDoorData, key, time, value);
                }
                finalData.put(door, sortedDoorData);
            }
        }
        this.getWriter().add(finalData);
    }

    private static void getSnapshots(ANode node, List<DoorUsageSnapshot> snapshots) {
        DoorQueue dq = node.doorQueue;
        if (dq == null || dq.getNode().getDoorEdges().isEmpty()) {
            return;
        }
        if (!dq.isExitDoor()) {
            assert (dq.getR1() != null && dq.getR2() != null);
            Vector3d normal = DoorUsageWriterJson.getAvgPosNormalDir(node);
            String pLbl = DoorUsageWriterJson.getLabel(normal);
            normal.negate();
            String nLbl = DoorUsageWriterJson.getLabel(normal);
            String pName = String.format("%s %s", node.annotatedName, pLbl);
            String nName = String.format("%s %s", node.annotatedName, nLbl);
            String tName = node.annotatedName;
            snapshots.add(new DoorUsageSnapshot(node, pName, DoorDir.POSITIVE, pLbl));
            snapshots.add(new DoorUsageSnapshot(node, nName, DoorDir.NEGATIVE, nLbl));
            snapshots.add(new DoorUsageSnapshot(node, tName, null, ""));
        } else {
            DoorDir dir = dq.getExitDir();
            snapshots.add(new DoorUsageSnapshot(node, node.annotatedName, dir, ""));
        }
    }

    private static Vector3d getAvgPosNormalDir(ANode door) {
        if (door.getDoorEdges().isEmpty()) {
            return new Vector3d();
        }
        Vector3d result = new Vector3d();
        for (WingedEdge edge : door.getDoorEdges()) {
            Vector3d normal;
            Vector3d dir = Util3D.vector(edge.v1().p, edge.v2().p);
            double len = Util3D.safeNormalize(dir, 0.0);
            if (len == 0.0 || Util3D.safeNormalize(normal = Util3D.cross(GeomConstants.VEC3D_ZPOS, dir), 0.0) == 0.0) continue;
            normal.scale(len);
            result.add(normal);
        }
        Util3D.safeNormalize(result, 0.0);
        WingedEdge medge = door.getDoorEdges().get(door.getDoorEdges().size() / 2);
        assert (medge.t1 != null && medge.t2 != null);
        if (DoorDir.get(door, medge.t1) != DoorDir.POSITIVE) {
            result.negate();
        }
        return result;
    }

    private static String getLabel(Vector3d dir) {
        Vector2d vec = new Vector2d(dir.x, dir.y);
        vec.normalize();
        if (vec.x >= 0.5) {
            return DoorUsageWriter.Header.XP.desc.fileStr;
        }
        if (vec.x < -0.5) {
            return DoorUsageWriter.Header.XN.desc.fileStr;
        }
        if (vec.y >= 0.5) {
            return DoorUsageWriter.Header.YP.desc.fileStr;
        }
        return DoorUsageWriter.Header.YN.desc.fileStr;
    }

    private static enum Keys implements Supplier<String>
    {
        BOUNDARY("boundary"),
        DOORS("doors"),
        EXITED("exited"),
        QUEUING_DOOR_USAGE("queueingDoorUsage"),
        REMAINING("remaining"),
        TIME("time"),
        USAGE("usage"),
        WIDTH("width");

        private final String d_val;

        private Keys(String val) {
            this.d_val = val;
        }

        public String toString() {
            return this.d_val.toString();
        }

        @Override
        public String get() {
            return this.d_val;
        }
    }
}

