/*
 * Decompiled with CFR 0.152.
 */
package inferno.sim.output.json;

import inferno.data2.AttractorSim;
import inferno.data2.OccTarget;
import inferno.data2.Tag;
import inferno.data2.Tri;
import inferno.data2.ai.IGoal;
import inferno.sim.BehaviorSim;
import inferno.sim.KB;
import inferno.sim.OccAgent;
import inferno.sim.OccEnvData;
import inferno.sim.output.json.AJsonInfoWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import thunderheadeng.util.IdentityHashSet;
import thunderheadeng.util.LinkedIdentityHashSet;
import thunderheadeng.util.theUtil;

public abstract class AOccDataWriterJson
extends AJsonInfoWriter {
    public static boolean isWriterEnabled(KB kb) {
        return true;
    }

    public AOccDataWriterJson(KB kb, boolean writeAsArray) {
        super(kb, writeAsArray);
    }

    @Override
    public void writeFrame(double t) {
    }

    public abstract void writeFrame(double var1, boolean var3);

    public abstract void addAgents(double var1, Collection<OccAgent> var3);

    protected void writeFrame(double t, OccAgent d_oa, List<Tag> d_tags) {
        LinkedHashMap<String, Object> occFrameData = new LinkedHashMap<String, Object>();
        occFrameData.put(Keys.TIME.get(), t);
        occFrameData.put(Keys.ID.get(), String.valueOf(d_oa.getId()));
        occFrameData.put(Keys.NAME.get(), d_oa.getOcc().name);
        occFrameData.put(Keys.IS_ACTIVE.get(), d_oa.isActive());
        Point3d displayPos = d_oa.getOcc().getDisplayLoc();
        LinkedHashMap<String, Double> posData = new LinkedHashMap<String, Double>();
        posData.put(Keys.X.get(), AOccDataWriterJson.formatDouble(displayPos.x, 3));
        posData.put(Keys.Y.get(), AOccDataWriterJson.formatDouble(displayPos.y, 3));
        posData.put(Keys.Z.get(), AOccDataWriterJson.formatDouble(displayPos.z, 3));
        occFrameData.put(Keys.POSITION.get(), posData);
        Vector3d vel = d_oa.getVelAdjusted(this.getKb());
        LinkedHashMap<String, Double> velData = new LinkedHashMap<String, Double>();
        velData.put(Keys.X.get(), AOccDataWriterJson.formatDouble(vel.x, 3));
        velData.put(Keys.Y.get(), AOccDataWriterJson.formatDouble(vel.y, 3));
        velData.put(Keys.Z.get(), AOccDataWriterJson.formatDouble(vel.z, 3));
        velData.put(Keys.MAGNITUDE.get(), AOccDataWriterJson.formatDouble(vel.length(), 3));
        occFrameData.put(Keys.VELOCITY.get(), velData);
        occFrameData.put(Keys.DISTANCE.get(), AOccDataWriterJson.formatDouble(d_oa.getOcc().totalDistanceMeters, 3));
        if (d_oa.getOcc().curNode != null) {
            occFrameData.put(Keys.LOCATION.get(), d_oa.getOcc().curNode.annotatedName);
            occFrameData.put(Keys.TERRAIN_TYPE.get(), d_oa.getOcc().curNode.getTerrain().description);
        } else {
            occFrameData.put(Keys.LOCATION.get(), Keys.NULL.get());
            occFrameData.put(Keys.TERRAIN_TYPE.get(), Tri.Terrain.OPEN.description);
        }
        Optional<AttractorSim> attr = d_oa.getAiCore().getAttractorInUse(this.getKb(), d_oa);
        if (attr.isPresent()) {
            occFrameData.put(Keys.ATTRACTOR.get(), attr.get().name);
        } else {
            occFrameData.put(Keys.ATTRACTOR.get(), Keys.NONE.get());
        }
        Optional<OccTarget> occTarget = d_oa.getAiCore().getOccTargetInUse(this.getKb(), d_oa);
        if (occTarget.isPresent()) {
            occFrameData.put(Keys.TARGET.get(), occTarget.get().name);
        } else {
            occFrameData.put(Keys.TARGET.get(), Keys.NONE.get());
        }
        assert (AOccDataWriterJson.getUnexpectedTag(this.getKb(), d_oa, d_tags) == null) : "The agent was tagged with an unexpected tag: " + String.valueOf(AOccDataWriterJson.getUnexpectedTag(this.getKb(), d_oa, d_tags));
        ArrayList<String> appliedTags = new ArrayList<String>();
        for (Tag tag : d_tags) {
            if (!tag.isTagged(d_oa)) continue;
            appliedTags.add(theUtil.toCamelCase(tag.name));
        }
        occFrameData.put(Keys.TAGS.get(), appliedTags);
        OccEnvData occEnv = this.getKb().getOccEnvData();
        Map<String, OccEnvData.QInfo> quantities = occEnv.getSupportedQuantities();
        Map<OccEnvData.QInfo, Double> envValues = occEnv.getValues(d_oa.getOcc());
        for (OccEnvData.QInfo qi : quantities.values()) {
            if (t < this.getKb().getFdsOutputData().getEndTime()) {
                occFrameData.put(theUtil.toCamelCase(qi.fdsName), AOccDataWriterJson.formatDouble(envValues.get(qi), 6));
                continue;
            }
            occFrameData.put(theUtil.toCamelCase(qi.fdsName), Keys.NAN.get());
        }
        this.getWriter().add(occFrameData);
    }

    protected static boolean testOutput(OccAgent agent) {
        return agent.getOcc().outputTimeHistory > 0;
    }

    protected static Collection<OccAgent> filterAgents(Collection<OccAgent> agents) {
        return theUtil.filter(agents, AOccDataWriterJson::testOutput);
    }

    protected static void calcPossibleTags(KB kb, Collection<OccAgent> occs, Set<Tag> tags) {
        tags.addAll(kb.getNodeOccTags());
        tags.addAll(kb.getAttractorOccTags());
        Set allCustomTags = kb.getTags().stream().filter(t -> !t.isPredefined()).collect(Collectors.toCollection(() -> new LinkedIdentityHashSet()));
        IdentityHashSet visitedBehaviors = new IdentityHashSet();
        for (OccAgent oa : occs) {
            if (visitedBehaviors.add(oa.getOcc().behavior)) {
                AOccDataWriterJson.getPossibleTags(oa.getOcc().behavior, tags);
            }
            Iterator tagIt = allCustomTags.iterator();
            while (tagIt.hasNext()) {
                Tag tag = (Tag)tagIt.next();
                if (!tag.isTagged(oa)) continue;
                tags.add(tag);
                tagIt.remove();
            }
        }
    }

    protected static void getPossibleTags(BehaviorSim behavior, Set<Tag> tags) {
        Consumer<Tag> addTags = tags::add;
        for (IGoal goal : behavior.deepFlatten(IGoal.class)) {
            goal.getTagRefs(addTags);
        }
    }

    protected static Tag getUnexpectedTag(KB d_kb, OccAgent d_oa, List<Tag> d_tags) {
        for (Tag tag : d_kb.getTags()) {
            if (tag.isPredefined() || !tag.isTagged(d_oa) || d_tags.contains(tag)) continue;
            return tag;
        }
        return null;
    }

    protected static enum Keys implements Supplier<String>
    {
        ATTRACTOR("trigger"),
        DISTANCE("distance"),
        ID("id"),
        IS_ACTIVE("isActive"),
        LOCATION("location"),
        MAGNITUDE("magnitude"),
        NAME("name"),
        NAN("NaN"),
        NULL("Null"),
        NONE("None"),
        POSITION("position"),
        TAGS("tagsApplied"),
        TARGET("target"),
        TERRAIN_TYPE("terrainType"),
        TIME("time"),
        USAGE("usage"),
        VELOCITY("velocity"),
        X("x"),
        Y("y"),
        Z("z");

        private final String d_val;

        private Keys(String val) {
            this.d_val = val;
        }

        public String toString() {
            return this.d_val.toString();
        }

        @Override
        public String get() {
            return this.d_val;
        }
    }
}

