/*
 * Decompiled with CFR 0.152.
 */
package inferno.sim.output;

import inferno.data2.Mesh;
import inferno.data2.OccLocator;
import inferno.io.CSVWriter;
import inferno.io.SerializedOutputStream;
import inferno.sim.KB;
import inferno.sim.OccAgent;
import inferno.sim.Output;
import inferno.sim.Param;
import inferno.sim.output.WriterIntl;
import inferno.sim.path.EdgeFilters;
import inferno.sim.path.PathGen;
import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import javax.vecmath.Point3d;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.BoundingSphere;
import thunderheadeng.geometry.search.ITest;
import thunderheadeng.util.Filters;
import thunderheadeng.util.Pair;
import thunderheadeng.util.Predicates;
import thunderheadeng.util.UnorderedPair;

public class SocialDistanceTransientWriter
implements Serializable,
Closeable {
    static final long serialVersionUID = 1L;
    public static final double SD_COLLISION_RADIUS = 0.1;
    private final KB d_kb;
    private final double d_detectionRadius;
    private final SerializedOutputStream d_strmOut;
    private final CSVWriter d_out;

    public SocialDistanceTransientWriter(KB kb, double detectionRadius) {
        this.d_kb = kb;
        this.d_detectionRadius = detectionRadius;
        this.d_strmOut = new SerializedOutputStream(kb.getParams().out_sd_transient);
        this.d_out = new CSVWriter();
    }

    public void open(Param params) throws FileNotFoundException {
        this.d_out.open(Output.openTxtStream(this.d_strmOut));
    }

    @Override
    public void close() throws IOException {
        this.d_out.close();
    }

    public void writeHeader() {
        for (Header header : Header.values()) {
            this.d_out.add(header.get());
        }
        this.d_out.nextRow();
        this.d_out.flush();
    }

    private Pair<Integer, String> filterToDist(OccAgent root, List<OccAgent> agents, double maxDistance) {
        StringBuilder sb = new StringBuilder();
        Point3d rootPos = root.getPos();
        int n = 0;
        for (OccAgent nearAgent : agents) {
            double distance = rootPos.distance(nearAgent.getPos());
            if (!(distance <= maxDistance)) continue;
            if (++n > 1) {
                sb.append(" ");
            }
            sb.append(nearAgent.getId());
        }
        return new Pair<Integer, String>(n, sb.toString());
    }

    public static double getSocialDistance(Mesh m, OccAgent a, OccAgent b, double abortDist) {
        boolean blocked = m.isPathObstructed(a.getLoc(), b.getLoc(), 0.1, EdgeFilters.acceptAll());
        if (!blocked) {
            return a.getPos().distance(b.getPos());
        }
        PathGen.PointGoal pathGoal = new PathGen.PointGoal(b.getLoc());
        PathGen.IPathResult searchResult = PathGen.getPath(m, a.getLoc().tri, null, null, a.getLoc().p, pathGoal, 0.1, abortDist, Predicates.alwaysTrue(), null);
        return searchResult.getLength();
    }

    public void writeFrame(double t) {
        if (this.d_kb.getActiveAgents().isEmpty()) {
            return;
        }
        Mesh m = this.d_kb.getMesh();
        Optional<OccAgent> maxIdAgent = this.d_kb.getActiveAgents().stream().max(Comparator.comparingInt(agent -> agent.getId()));
        ArrayList<Object> nearOccsData = new ArrayList<Object>(Collections.nCopies(maxIdAgent.get().getId() + 1, null));
        ArrayList<Object> nearestOccData = new ArrayList<Object>(Collections.nCopies(maxIdAgent.get().getId() + 1, null));
        ConcurrentHashMap distMap = new ConcurrentHashMap(this.d_kb.getActiveAgents().size(), 0.75f, Runtime.getRuntime().availableProcessors());
        this.d_kb.getActiveAgents().parallelStream().forEach(agent -> {
            List<OccAgent> nearOccs = this.d_kb.findOccs((ITest<AABox>)new BoundingSphere(agent.getPos(), this.d_detectionRadius), OccLocator.exclude(agent, Filters.acceptAll()), true);
            nearOccsData.set(agent.getId(), nearOccs);
            for (OccAgent nearOcc2 : nearOccs) {
                distMap.computeIfAbsent(new UnorderedPair<OccAgent, OccAgent>((OccAgent)agent, nearOcc2), key -> SocialDistanceTransientWriter.getSocialDistance(m, agent, nearOcc2, this.d_detectionRadius));
            }
            Optional<OccAgent> nearestOcc = nearOccs.stream().filter(nearOcc -> Double.isFinite((Double)distMap.get(new UnorderedPair<OccAgent, OccAgent>((OccAgent)agent, (OccAgent)nearOcc)))).min(Comparator.comparingDouble(nearOcc -> (Double)distMap.get(new UnorderedPair<OccAgent, OccAgent>((OccAgent)agent, (OccAgent)nearOcc))));
            nearestOccData.set(agent.getId(), nearestOcc);
        });
        this.d_kb.getActiveAgents().stream().forEach(agent -> {
            this.d_out.add(t, 2);
            this.d_out.add(agent.getId());
            this.d_out.add(agent.getName());
            if (agent.getOcc().occupantGroup != null) {
                this.d_out.add(agent.getOcc().occupantGroup.getID());
            } else {
                this.d_out.addEmpty();
            }
            Optional nearestOcc = (Optional)nearestOccData.get(agent.getId());
            if (nearestOcc.isPresent()) {
                this.d_out.add(((OccAgent)nearestOcc.get()).getId());
                this.d_out.add(((OccAgent)nearestOcc.get()).getName());
                this.d_out.add((Double)distMap.get(new UnorderedPair<OccAgent, OccAgent>((OccAgent)agent, (OccAgent)nearestOcc.get())), 2);
            } else {
                this.d_out.addEmpty();
                this.d_out.addEmpty();
                this.d_out.addEmpty();
            }
            List nearOccs = (List)nearOccsData.get(agent.getId());
            Pair<Integer, String> m1 = this.filterToDist((OccAgent)agent, nearOccs, 1.0);
            this.d_out.add(m1.v1);
            this.d_out.add(m1.v2);
            Pair<Integer, String> m2 = this.filterToDist((OccAgent)agent, nearOccs, 2.0);
            this.d_out.add(m2.v1);
            this.d_out.add(m2.v2);
            Pair<Integer, String> m3 = this.filterToDist((OccAgent)agent, nearOccs, 3.0);
            this.d_out.add(m3.v1);
            this.d_out.add(m3.v2);
            this.d_out.nextRow();
        });
        this.d_out.flush();
    }

    public static enum Header implements Supplier<WriterIntl.ColHeaderString>
    {
        TIME(WriterIntl.intl("Time (s)")),
        OCC_ID(WriterIntl.intl("ID")),
        OCC_NAME(WriterIntl.intl("Name")),
        OCC_GROUP_ID(WriterIntl.intl("Group ID")),
        CLOSEST_ID(WriterIntl.intl("Closest Occupant ID")),
        CLOSEST_NAME(WriterIntl.intl("Closest Occupant Name")),
        CLOSEST_DIST(WriterIntl.intl("Closest Occupant Distance (m)")),
        WITHIN_1M(WriterIntl.intl("Occupants Within 1m (count)")),
        WITHIN_1M_ID(WriterIntl.intl("Occupants Within 1m IDs")),
        WITHIN_2M(WriterIntl.intl("Occupants Within 2m (count)")),
        WITHIN_2M_ID(WriterIntl.intl("Occupants Within 2m IDs")),
        WITHIN_3M(WriterIntl.intl("Occupants Within 3m (count)")),
        WITHIN_3M_ID(WriterIntl.intl("Occupants Within 3m IDs"));

        public final WriterIntl.ColHeaderString val;

        private Header(WriterIntl.ColHeaderString val) {
            this.val = val;
        }

        public String toString() {
            return this.val.toString();
        }

        @Override
        public WriterIntl.ColHeaderString get() {
            return this.val;
        }
    }
}

