/*
 * Decompiled with CFR 0.152.
 */
package inferno.sim.output;

import inferno.io.CSVWriter;
import inferno.io.SerializedOutputStream;
import inferno.sim.KB;
import inferno.sim.Output;
import inferno.sim.Param;
import inferno.sim.output.WriterIntl;
import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.function.Supplier;

public class DtWriter
implements Serializable,
Closeable {
    static final long serialVersionUID = 1L;
    private final CSVWriter d_out;
    private double d_tSimLast = 0.0;
    private long d_wallAccum = 0L;
    private long d_tWallLast = System.nanoTime();
    private final SerializedOutputStream d_stream;

    public DtWriter(KB kb) {
        this.d_out = new CSVWriter();
        this.d_stream = new SerializedOutputStream(kb.getParams().out_dt_info);
    }

    public void open(Param params) throws FileNotFoundException {
        this.d_out.open(Output.openTxtStream(this.d_stream));
    }

    @Override
    public void close() throws IOException {
        this.d_out.close();
    }

    public void writeHeader(KB kb) {
        for (Header header : Header.values()) {
            this.d_out.add(header.get());
        }
        this.d_out.nextRow();
        this.d_out.flush();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        this.d_wallAccum = System.nanoTime() - this.d_tWallLast;
        out.defaultWriteObject();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.d_tWallLast = System.nanoTime();
    }

    public void writeFrame(KB kb, double t) {
        if (t == this.d_tSimLast) {
            return;
        }
        double simDt = t - this.d_tSimLast;
        this.d_tSimLast = t;
        long tWallCurr = System.nanoTime();
        double wallDt = (double)(this.d_wallAccum + tWallCurr - this.d_tWallLast) * 1.0E-9;
        this.d_wallAccum = 0L;
        this.d_tWallLast = tWallCurr;
        this.d_out.add(t);
        this.d_out.add(simDt);
        this.d_out.add(wallDt);
        this.d_out.add(wallDt / simDt);
        this.d_out.nextRow();
        this.d_out.flush();
    }

    public static enum Header implements Supplier<WriterIntl.ColHeaderString>
    {
        TIME(WriterIntl.intl("Time (s)")),
        SIM_DT(WriterIntl.intl("Sim Dt (s)")),
        WALL_DT(WriterIntl.intl("Wall Dt (s)")),
        PERFORMANCE(WriterIntl.intl("Performance - wall/sim"));

        public final WriterIntl.ColHeaderString val;

        private Header(WriterIntl.ColHeaderString val) {
            this.val = val;
        }

        public String toString() {
            return this.val.toString();
        }

        @Override
        public WriterIntl.ColHeaderString get() {
            return this.val;
        }
    }
}

