/*
 * Decompiled with CFR 0.152.
 */
package inferno.sim.occsource;

import inferno.data2.ANode;
import inferno.data2.Blockage;
import inferno.data2.DoorDir;
import inferno.data2.DoorGeom;
import inferno.data2.Occupant;
import inferno.data2.Tri;
import inferno.data2.WingedEdge;
import inferno.data2.ai.IProgressNote;
import inferno.sim.BehaviorSim;
import inferno.sim.Engine;
import inferno.sim.KB;
import inferno.sim.OccAgent;
import inferno.sim.OccGroup;
import inferno.sim.OccGroupType;
import inferno.sim.OccProfileSim;
import inferno.sim.occsource.IOccSourceFlowrate;
import inferno.sim.path.EdgeFilters;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Deque;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntPredicate;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import merlin.data.stat.AutoCurve;
import org.jscience.physics.units.SI;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.AABoxTest;
import thunderheadeng.geometry.GeomConstants;
import thunderheadeng.geometry.Plane3d;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.geometry.nmt.Edge;
import thunderheadeng.geometry.nmt.Face;
import thunderheadeng.geometry.nmt.Model;
import thunderheadeng.geometry.nmt.NmtUtil;
import thunderheadeng.io.TeciLogging;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.IdentityHashSet;
import thunderheadeng.util.LinkedIdentityHashSet;
import thunderheadeng.util.NameGenerator;
import thunderheadeng.util.Pair;
import thunderheadeng.util.Predicates;
import thunderheadeng.util.stat.ConstantCurve;
import thunderheadeng.util.stat.ICurve;
import thunderheadeng.util.stat.IUrn;
import thunderheadeng.util.stat.UniformCurve;
import thunderheadeng.util.theUtil;

public class OccSource
implements Serializable {
    static final long serialVersionUID = 1L;
    private static final Logger LOGGER = Logger.getLogger(OccSource.class.getName());
    private static final double AUTO_ORIENT_DELAY = theUtil.getSystemDouble("OccSource.autoOrientDelay", 0.5);
    private final String d_name;
    private final ANode d_component;
    private final AABox d_bounds;
    private final long d_seed;
    private final IOccSourceFlowrate d_flowrate;
    private final IUrn<OccProfileSim> d_profUrn;
    private final IUrn<BehaviorSim> d_behaviorUrn;
    private final IUrn<OccGroupType> d_groupUrn;
    private final KB d_kb;
    private final boolean d_enforceFlowrate;
    private final double d_finishTime;
    private final double d_minGeomRadius;
    private final double d_maxGeomRadius;
    private final double[] d_velRange;
    private final List<Point3d> d_spawnLocations;
    private final NameGenerator d_nameGenerator;
    private final Random d_groupRand;
    private final Random d_profileRand;
    private final Random d_behaviorRand;
    private final Random d_occSeedRand;
    private final Random d_geomRand;
    private final boolean d_emitAtMaxVel;
    private final ICurve d_initialOrient;
    private int d_numReleasedOccs = 0;
    private boolean d_stuck = false;
    private GeomChoice[] d_preferredTris;
    private GeomChoice[] d_backupTris;
    private GeomChoice[] d_lineSegments;
    private OccGroup d_groupToRelease;
    private Deque<Pair<Double, Integer>> d_autoOrientOccs = new ArrayDeque<Pair<Double, Integer>>();
    private Vector3d d_autoOrient = null;
    private static final Predicate<Tri> TRI_FILTER = t -> t.node.getElevatorLevel() == null;

    public OccSource(KB kb, String name, AABox bounds, IOccSourceFlowrate flowrate, IUrn<OccProfileSim> profUrn, IUrn<BehaviorSim> behaviorUrn, long rseed, boolean enforceFlowrate, ICurve initialOrient, boolean emitAtMaxVel, ANode component, IUrn<OccGroupType> groupUrn, List<Point3d> spawnLocs) {
        this.d_name = name;
        this.d_bounds = bounds;
        this.d_flowrate = flowrate;
        this.d_profUrn = profUrn;
        this.d_seed = rseed;
        this.d_behaviorUrn = behaviorUrn;
        this.d_groupUrn = groupUrn;
        this.d_enforceFlowrate = enforceFlowrate;
        this.d_emitAtMaxVel = emitAtMaxVel;
        this.d_initialOrient = initialOrient;
        this.d_component = component;
        this.d_spawnLocations = spawnLocs;
        if (component != null) {
            component.addOccSource(this);
        }
        this.d_kb = kb;
        this.d_finishTime = this.findFinishTime();
        double[] minMaxGeomRadii = this.findMinMaxGeomRadii();
        this.d_minGeomRadius = minMaxGeomRadii[0];
        this.d_maxGeomRadius = minMaxGeomRadii[1];
        this.d_velRange = this.findMinMaxVel();
        this.d_groupRand = new Random(this.d_seed ^ 0x45AF38EFFL);
        this.d_profileRand = new Random(this.d_seed ^ 0xAF932845FL);
        this.d_behaviorRand = new Random(this.d_seed ^ 0x478932L);
        this.d_occSeedRand = new Random(this.d_seed ^ 0xEB8329328AL);
        this.d_geomRand = new Random(this.d_seed ^ 0x57682A328FBL);
        int maxOccCount = this.d_flowrate.getMaxCount(kb.getParams().max_time);
        this.d_nameGenerator = new NameGenerator(this.d_name + "_", String.valueOf(maxOccCount).length(), false);
    }

    public String getName() {
        return this.d_name;
    }

    public AABox getBounds() {
        return this.d_bounds;
    }

    public void update(Engine engine, double dt) {
        double currentSimTime = engine.getKB().getCurrentSimTime();
        if (this.isFinished(currentSimTime)) {
            this.finish();
            return;
        }
        this.updateAutoOrient(currentSimTime);
        int toRelease = this.d_flowrate.releaseOccs(this.d_kb, dt);
        if (toRelease > 0) {
            OccGroupType groupType;
            if (this.d_groupToRelease == null && (groupType = this.d_groupUrn.getValue(this.d_groupRand)) != null && !groupType.isNoGroupType) {
                this.d_groupToRelease = groupType.createEmptyGroup(engine.getKB());
            }
            this.d_stuck = true;
            for (int i = 0; i < toRelease; ++i) {
                OccAgent agent = this.releaseOccupant(engine);
                if (agent != null && this.isAutoOrient()) {
                    this.d_autoOrientOccs.addLast(new Pair<Double, Integer>(currentSimTime + AUTO_ORIENT_DELAY, agent.getId()));
                }
                this.d_stuck &= agent == null;
                ++this.d_numReleasedOccs;
                if (this.d_groupToRelease == null || !this.d_groupToRelease.isReady()) continue;
                this.d_groupToRelease = null;
            }
        } else if (!this.d_flowrate.isFlowing(this.d_kb)) {
            this.d_stuck = false;
        }
    }

    private void updateAutoOrient(double currSimTime) {
        if (this.d_autoOrientOccs.isEmpty() || !this.isAutoOrient()) {
            return;
        }
        ArrayList<OccAgent> testAgents = new ArrayList<OccAgent>();
        while (!this.d_autoOrientOccs.isEmpty() && theUtil.le((Double)this.d_autoOrientOccs.peekFirst().v1, currSimTime, 1.0E-9)) {
            OccAgent agent = this.d_kb.getAgent((Integer)this.d_autoOrientOccs.removeFirst().v2);
            if (agent == null || agent.isDone()) continue;
            if (agent.isWaiting(this.d_kb)) {
                this.d_autoOrientOccs.addLast(new Pair<Double, Integer>(currSimTime + AUTO_ORIENT_DELAY, agent.getId()));
                continue;
            }
            testAgents.add(agent);
        }
        if (testAgents.isEmpty()) {
            return;
        }
        Vector3d firstOrient = null;
        Vector3d avgOrient = new Vector3d();
        double count = 0.0;
        for (OccAgent agent : testAgents) {
            Vector3d seekDir = agent.getSeekDir();
            if (seekDir.lengthSquared() == 0.0) continue;
            avgOrient.add(seekDir);
            count += 1.0;
            if (firstOrient != null) continue;
            firstOrient = seekDir;
        }
        if (count == 0.0) {
            return;
        }
        avgOrient.scale(1.0 / count);
        this.d_autoOrient = Util3D.safeNormalize(avgOrient, 1.0E-9) != 0.0 ? avgOrient : firstOrient;
    }

    private void finish() {
        if (this.d_groupToRelease != null) {
            this.d_groupToRelease.setIsReady(true);
            this.d_groupToRelease = null;
        }
        this.d_autoOrientOccs.clear();
    }

    private OccAgent releaseOccupant(Engine engine) {
        Pair<Point3d, ICurve> loc;
        Point3d loc2;
        OccProfileSim prof;
        long occSeed = this.d_occSeedRand.nextLong();
        BehaviorSim behavior = null;
        if (this.d_groupToRelease != null) {
            prof = this.d_groupToRelease.getNextProfile(this.d_profileRand);
            if (prof == null) {
                prof = this.d_profUrn.getValue(this.d_profileRand);
            }
            behavior = this.d_groupToRelease.getInitOccs() != null && !this.d_groupToRelease.getInitOccs().isEmpty() ? this.d_groupToRelease.getInitOccs().get((int)0).behavior : (!this.d_groupToRelease.getMembers().isEmpty() ? this.d_groupToRelease.getMembers().iterator().next().getOcc().behavior : this.d_behaviorUrn.getValue(this.d_behaviorRand));
        } else {
            prof = this.d_profUrn.getValue(this.d_profileRand);
            behavior = this.d_behaviorUrn.getValue(this.d_behaviorRand);
        }
        String newName = this.d_nameGenerator.generateName();
        Random rand = new Random();
        int maxTrials = 22;
        ArrayList attemptedLocs = new ArrayList();
        Predicate<Occupant> testOcc = !this.d_enforceFlowrate ? occ -> this.d_kb.isOccValid((Occupant)occ, true, true, true) : occ -> {
            boolean[] isectBoundary = new boolean[]{false};
            boolean[] isectBlockage = new boolean[]{false};
            OccAgent[] isectOcc = new OccAgent[]{null};
            double[] nearestOccDistSq = new double[]{Double.POSITIVE_INFINITY};
            try {
                this.d_kb.testOccLocation((Occupant)occ, true, true, true, iobj -> {
                    Blockage b;
                    if (iobj instanceof WingedEdge) {
                        isectBoundary[0] = true;
                        throw new CancellationException();
                    }
                    if (iobj instanceof Blockage && (b = (Blockage)iobj).getPreventOccPlacement()) {
                        isectBlockage[0] = true;
                    } else {
                        OccAgent iocc = (OccAgent)iobj;
                        double distSq = occ.loc.distanceSquared(iocc.getPos());
                        if (distSq < nearestOccDistSq[0]) {
                            isectOcc[0] = iocc;
                            nearestOccDistSq[0] = distSq;
                        }
                    }
                });
            }
            catch (CancellationException cancellationException) {
                // empty catch block
            }
            if (!isectBoundary[0] && !isectBlockage[0] && isectOcc[0] != null) {
                attemptedLocs.add(new Pair<Pair<Point3d, ICurve>, Double>(new Pair<Point3d, ICurve>(occ.loc, this.toInitOrient(occ.orient)), nearestOccDistSq[0]));
            } else if (!isectBoundary[0] && isectBlockage[0]) {
                attemptedLocs.add(new Pair<Pair<Point3d, ICurve>, Double>(new Pair<Point3d, ICurve>(occ.loc, this.toInitOrient(occ.orient)), occ.bodyShape.getEnclosingRadius() * occ.bodyShape.getEnclosingRadius()));
            }
            return !isectBoundary[0] && !isectBlockage[0] && isectOcc[0] == null;
        };
        Function<Occupant, OccAgent> addOcc = newOcc -> {
            OccAgent newAgent;
            Engine engine2 = engine;
            synchronized (engine2) {
                newAgent = this.d_kb.createAgent((Occupant)newOcc, true);
            }
            if (newAgent == null) {
                return null;
            }
            newAgent.init(this.d_kb, this.d_kb.getParams());
            engine.agentAdded(newAgent);
            this.d_nameGenerator.registerName(newAgent.getName());
            if (this.d_groupToRelease != null) {
                if (this.d_groupToRelease.isInitialized()) {
                    this.d_groupToRelease.joinInstantly(engine.getKB(), newAgent);
                } else {
                    this.d_groupToRelease.addOccOnInit(newAgent.getOcc());
                }
            }
            return newAgent;
        };
        Pair<Point3d, ICurve> spawnLoc = this.d_numReleasedOccs < this.d_spawnLocations.size() ? ((loc2 = this.d_spawnLocations.get(this.d_numReleasedOccs)) == null ? null : new Pair<Point3d, ICurve>(loc2, this.getInitOrient((Vector3d)null, loc2))) : null;
        if (spawnLoc != null) {
            maxTrials = 1;
            if (this.d_enforceFlowrate) {
                testOcc = Predicates.alwaysTrue();
            }
        }
        Function<ICurve, Consumer> getOccModifier = initOrient -> occ -> {
            if (initOrient != null) {
                OccProfileSim.PROP_INIT_ORIENT.applyToOcc.apply(rand, (OccProfileSim.Prop<ICurve>)OccProfileSim.PROP_INIT_ORIENT, (ICurve)initOrient, (Occupant)occ, occ.orientSeed, this.d_kb);
            }
            if (this.d_emitAtMaxVel) {
                occ.vel = Util3D.scale(occ.orient, (double)occ.maxVel);
            }
        };
        for (int tryLoc = 1; tryLoc <= maxTrials && (loc = spawnLoc != null ? spawnLoc : (maxTrials > 1 && tryLoc >= maxTrials / 2 + 1 ? this.newIdealLoc() : this.newLoc())) != null; ++tryLoc) {
            Consumer modifyOcc = getOccModifier.apply((ICurve)loc.v2);
            Occupant newOcc2 = this.d_kb.createOcc(prof, behavior, modifyOcc, occSeed, (Point3d)loc.v1, rand, newName, testOcc);
            if (newOcc2 == null) continue;
            return addOcc.apply(newOcc2);
        }
        if (!attemptedLocs.isEmpty()) {
            Pair bestLoc = (Pair)((Pair)attemptedLocs.stream().max((Comparator)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)I, lambda$releaseOccupant$6(thunderheadeng.util.Pair thunderheadeng.util.Pair ), (Lthunderheadeng/util/Pair;Lthunderheadeng/util/Pair;)I)()).get()).v1;
            Consumer modifyOcc = getOccModifier.apply((ICurve)bestLoc.v2);
            Occupant newOcc3 = this.d_kb.createOcc(prof, behavior, modifyOcc, occSeed, (Point3d)bestLoc.v1, rand, newName, Predicates.alwaysTrue());
            assert (newOcc3 != null);
            if (newOcc3 != null) {
                return addOcc.apply(newOcc3);
            }
        }
        return null;
    }

    private boolean isAutoOrient() {
        return this.d_initialOrient instanceof AutoCurve;
    }

    private double findFinishTime() {
        return this.d_flowrate.getEndTime(this.d_kb);
    }

    private Pair<Point3d, ICurve> newIdealLoc() {
        this.initGeom();
        if (this.d_component != null && this.d_component.isDoor()) {
            boolean shift = this.d_component.isExitDoor() || OccSource.isDangerousDoor(this.d_component);
            return this.sampleDoorPoint(0.5, shift);
        }
        if (this.d_backupTris.length > 0) {
            Point3d[] t = this.sampleAllTris(this.d_geomRand.nextDouble());
            assert (t != null);
            return this.samplePointInTri(this.d_geomRand, t);
        }
        if (this.d_lineSegments.length > 0) {
            Point3d[] ls = this.sampleLineSeg(0.5);
            assert (ls != null);
            return this.sampleLineSegPoint(0.5, ls[0], ls[1]);
        }
        return null;
    }

    private Pair<Point3d, ICurve> newLoc() {
        this.initGeom();
        Random rand = this.d_geomRand;
        if (this.d_component != null && this.d_component.isDoor()) {
            boolean shift = this.d_component.isExitDoor() || OccSource.isDangerousDoor(this.d_component);
            return this.sampleDoorPoint(rand.nextDouble(), shift);
        }
        if (this.d_preferredTris.length > 0) {
            Point3d[] t = this.samplePreferredTris(rand.nextDouble());
            assert (t != null);
            return this.samplePointInTri(rand, t);
        }
        if (this.d_backupTris.length > 0) {
            Point3d[] t = this.sampleAllTris(rand.nextDouble());
            assert (t != null);
            return this.samplePointInTri(rand, t);
        }
        if (this.d_lineSegments.length > 0) {
            Point3d[] ls = this.sampleLineSeg(rand.nextDouble());
            assert (ls != null);
            return this.sampleLineSegPoint(rand.nextDouble(), ls[0], ls[1]);
        }
        return null;
    }

    private static boolean isDangerousDoor(ANode door) {
        for (WingedEdge edge : door.getDoorEdges()) {
            if (!EdgeFilters.isDangerous(edge)) continue;
            return true;
        }
        return false;
    }

    public GeomChoice[] getTris() {
        return this.d_preferredTris != null ? this.d_preferredTris : new GeomChoice[]{};
    }

    public GeomChoice[] getLineSegments() {
        return this.d_lineSegments != null ? this.d_lineSegments : new GeomChoice[]{};
    }

    public Set<OccProfileSim> getAllProfiles() {
        return this.getProfiles(true);
    }

    public Set<OccProfileSim> getProfiles(boolean fromBehaviors) {
        if (this.d_groupUrn == null && !fromBehaviors) {
            return Collections.unmodifiableSet(this.d_profUrn.getWeights().keySet());
        }
        LinkedIdentityHashSet<OccProfileSim> allProfs = new LinkedIdentityHashSet<OccProfileSim>((Collection<OccProfileSim>)this.d_profUrn.getWeights().keySet());
        if (this.d_groupUrn != null) {
            for (OccGroupType groupType : this.d_groupUrn.getWeights().keySet()) {
                if (groupType.profileMap == null) continue;
                allProfs.addAll(groupType.profileMap.keySet());
            }
        }
        if (fromBehaviors) {
            IdentityHashSet visited = new IdentityHashSet();
            for (BehaviorSim behavior : this.getBehaviors()) {
                behavior.getReferencedProfiles(visited, allProfs::add);
            }
        }
        return allProfs;
    }

    public List<Double> getAllGeomAndOccRadii() {
        LinkedHashSet radii = new LinkedHashSet();
        this.getFutureProfileValues(OccProfileSim.PROP_SHAPE, shapeGen -> {
            shapeGen.getAllWidths(true, w -> radii.add(w / 2.0));
            shapeGen.getAllWidths(false, w -> radii.add(w / 2.0));
        });
        return new ArrayList<Double>(radii);
    }

    public <T> void getFutureProfileValues(OccProfileSim.IOccProp<T> prop, Consumer<? super T> result) {
        for (OccProfileSim prof : this.getProfiles(false)) {
            T val = prof.getProp(prop);
            result.accept(val);
        }
        IdentityHashSet visited = new IdentityHashSet();
        for (BehaviorSim behavior : this.getBehaviors()) {
            behavior.getFutureProfileValues(visited, prop, result);
        }
    }

    private double[] findMinMaxGeomRadii() {
        return this.findMinMaxValue(OccProfileSim.PROP_SHAPE, shape -> {
            double[] wr = shape.getWidthRange(true);
            wr[0] = wr[0] * 0.5;
            wr[1] = wr[1] * 0.5;
            return wr;
        });
    }

    /*
     * Exception decompiling
     */
    private double[] findMinMaxVel() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredReturn.rewriteExpressions(StructuredReturn.java:99)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private <T> double[] findMinMaxValue(OccProfileSim.IOccProp<T> prop, Function<T, double[]> getRange) {
        double[] range = new double[]{Double.MAX_VALUE, -1.7976931348623157E308};
        this.getFutureProfileValues(prop, val -> {
            double[] r = (double[])getRange.apply(val);
            range[0] = Math.min(range[0], r[0]);
            range[1] = Math.max(range[1], r[1]);
        });
        return range;
    }

    public boolean isFinished(double currentSimTime) {
        return currentSimTime > this.d_finishTime;
    }

    public double getMinGeomRadius() {
        return this.d_minGeomRadius;
    }

    public double getMaxGeomRadius() {
        return this.d_maxGeomRadius;
    }

    public double getMinVel() {
        return this.d_velRange[0];
    }

    public double getMaxVel() {
        return this.d_velRange[1];
    }

    private static <T> Set<T> getUnique(IUrn<T> urn) {
        LinkedIdentityHashSet unique = new LinkedIdentityHashSet();
        urn.getUnique(unique);
        return unique;
    }

    public Set<OccProfileSim> getProfiles() {
        return OccSource.getUnique(this.d_profUrn);
    }

    public Set<BehaviorSim> getBehaviors() {
        return OccSource.getUnique(this.d_behaviorUrn);
    }

    public double getFinishTime() {
        return this.d_finishTime;
    }

    public IOccSourceFlowrate getFlowrate() {
        return this.d_flowrate;
    }

    public List<Point3d> getSpawnLocations() {
        return this.d_spawnLocations;
    }

    public boolean isFlowing() {
        return this.d_flowrate.isFlowing(this.d_kb);
    }

    private Pair<Point3d, ICurve> sampleLineSegPoint(double t, Point3d p1, Point3d p2) {
        Point3d loc = Util3D.linesegPoint(p1, p2, t);
        return new Pair<Point3d, ICurve>(loc, this.getInitOrient(Util3D.vector(p1, p2), loc));
    }

    private ICurve getInitOrient(WingedEdge hintEdge, Point3d loc) {
        return this.getInitOrient(hintEdge != null ? Util3D.vector(hintEdge.p1(), hintEdge.p2()) : null, loc);
    }

    private ICurve getInitOrient(Vector3d hintEdgeDir, Point3d loc) {
        if (!this.isAutoOrient()) {
            return this.d_initialOrient;
        }
        if (this.d_autoOrient == null) {
            if (hintEdgeDir != null) {
                Vector3d doorNormal = OccSource.getEdgeNormal(hintEdgeDir);
                return this.toInitOrient(doorNormal);
            }
            return new UniformCurve(new UnitDouble(0.0, SI.RADIAN), new UnitDouble(Math.PI * 2, SI.RADIAN));
        }
        if (hintEdgeDir != null) {
            Vector3d doorNormal = OccSource.getEdgeNormal(hintEdgeDir);
            double sign = Math.signum(doorNormal.dot(this.d_autoOrient));
            if (sign != 0.0) {
                doorNormal.scale(sign);
            }
            return this.toInitOrient(doorNormal);
        }
        return this.toInitOrient(this.d_autoOrient);
    }

    private ICurve toInitOrient(Vector3d dir) {
        if (dir.z != 0.0) {
            dir = new Vector3d(dir);
            dir.z = 0.0;
        }
        double angle = Util3D.angle(GeomConstants.VEC3D_XPOS, dir, GeomConstants.VEC3D_ZPOS);
        return new ConstantCurve(new UnitDouble(angle, SI.RADIAN));
    }

    private static Vector3d getDoorNormal(WingedEdge doorEdge) {
        Point3d p1 = doorEdge.p1();
        Point3d p2 = doorEdge.p2();
        Vector3d v = Util3D.vector(p1, p2);
        return OccSource.getEdgeNormal(v);
    }

    private static Vector3d getEdgeNormal(Vector3d edgeDir) {
        Vector3d perp = new Vector3d(-edgeDir.y, edgeDir.x, edgeDir.z);
        perp.normalize();
        return perp;
    }

    private Pair<Point3d, ICurve> sampleDoorPoint(double edget, boolean shift) {
        DoorGeom dg = this.d_component.getDoorGeom();
        assert (dg != null);
        Pair<Integer, Point3d> sampledPt = dg.get(edget);
        Point3d loc = (Point3d)sampledPt.v2;
        if (!shift) {
            return new Pair<Point3d, ICurve>(loc, this.getInitOrient(dg.edges.get((Integer)sampledPt.v1), loc));
        }
        WingedEdge doorEdge = dg.edges.get((Integer)sampledPt.v1);
        Vector3d perp = OccSource.getDoorNormal(doorEdge);
        perp.scale(0.1);
        Point3d shiftedP = new Point3d(loc);
        shiftedP.add(perp);
        double side = doorEdge.whichSide(shiftedP, 0.0);
        Tri t = side > 0.0 ? doorEdge.t1 : doorEdge.t2;
        Optional<DoorDir> safeDir = !this.d_component.isExitDoor() ? doorEdge.getSafeDir() : Optional.of(doorEdge.getExitDir().opposite());
        boolean wrongSide = safeDir.map(dir -> t != doorEdge.getDestTri((DoorDir)((Object)dir))).orElse(false);
        if (wrongSide) {
            shiftedP = new Point3d(loc);
            perp.scale(-1.0);
            shiftedP.add(perp);
        }
        ICurve orient = !this.isAutoOrient() ? this.d_initialOrient : this.toInitOrient(perp);
        return new Pair<Point3d, ICurve>(shiftedP, orient);
    }

    private void initGeom() {
        this.initTris();
        if (this.d_lineSegments == null) {
            if (this.d_preferredTris.length == 0) {
                this.initLineSegments();
            } else {
                this.d_lineSegments = new GeomChoice[0];
            }
        }
    }

    private static boolean isArea(AABox box) {
        return !theUtil.eq0(box.getWidth(), 1.0E-6) && !theUtil.eq0(box.getDepth(), 1.0E-6);
    }

    private void initTris() {
        if (this.d_preferredTris != null) {
            return;
        }
        if (this.d_component != null && this.d_component.isDoor() || this.d_component == null && !OccSource.isArea(this.d_bounds)) {
            this.d_preferredTris = new GeomChoice[0];
            this.d_backupTris = new GeomChoice[0];
            return;
        }
        if (this.d_component != null) {
            ArrayList<GeomChoice> prefferedTriList = new ArrayList<GeomChoice>();
            ArrayList<GeomChoice> backupTris = new ArrayList<GeomChoice>();
            for (Tri t : this.d_component.getMesh()) {
                GeomChoice triGC = new GeomChoice(t);
                backupTris.add(triGC);
                if (t.getBlockages().isEmpty()) {
                    prefferedTriList.add(triGC);
                    continue;
                }
                boolean preferred = true;
                for (Blockage b : t.getBlockages()) {
                    if (!b.getPreventOccPlacement()) continue;
                    preferred = false;
                }
                if (!preferred) continue;
                prefferedTriList.add(triGC);
            }
            this.d_preferredTris = theUtil.toArray(prefferedTriList, GeomChoice.class);
            this.d_backupTris = theUtil.toArray(backupTris, GeomChoice.class);
        } else {
            Pair<List<GeomChoice>, List<GeomChoice>> tris = OccSource.getRegionTris(this.d_kb, this.d_bounds);
            this.d_preferredTris = theUtil.toArray((Collection)tris.v1, GeomChoice.class);
            this.d_backupTris = theUtil.toArray((Collection)tris.v2, GeomChoice.class);
        }
        if (this.d_backupTris.length + this.d_preferredTris.length == 0) {
            this.d_kb.getParams().err.printf("[b9a8f] Could not generate triangles for occupant source%n", new Object[0]);
        }
        OccSource.finalizeChoices(this.d_preferredTris);
        OccSource.finalizeChoices(this.d_backupTris);
    }

    private void initLineSegments() {
        if (this.d_lineSegments != null) {
            return;
        }
        if (this.d_component != null && !this.d_component.isDoor() || this.d_component == null && OccSource.isArea(this.d_bounds)) {
            this.d_lineSegments = new GeomChoice[0];
            return;
        }
        if (this.d_component != null) {
            this.d_lineSegments = new GeomChoice[this.d_component.getDoorEdges().size()];
            int ix = 0;
            for (WingedEdge edge : this.d_component.getDoorEdges()) {
                this.d_lineSegments[ix++] = new GeomChoice(edge);
            }
        } else {
            this.d_lineSegments = theUtil.toArray(OccSource.getRegionLineSegments(this.d_kb, this.d_bounds), GeomChoice.class);
        }
        if (this.d_lineSegments.length == 0) {
            this.d_kb.getParams().err.printf("[a83f4] Could not generate line segments for occupant source%n", new Object[0]);
        }
        OccSource.finalizeChoices(this.d_lineSegments);
    }

    private static void finalizeChoices(GeomChoice[] choices) {
        double totSize = 0.0;
        for (GeomChoice tc : choices) {
            totSize += tc.size;
        }
        double its = 1.0 / totSize;
        double size = 0.0;
        for (int i = 0; i < choices.length; ++i) {
            choices[i] = new GeomChoice(size += choices[i].size * its, choices[i].geom);
        }
    }

    private Point3d[] samplePreferredTris(double rand) {
        return OccSource.sampleGeom(rand, this.d_preferredTris);
    }

    private Point3d[] sampleAllTris(double rand) {
        return OccSource.sampleGeom(rand, this.d_backupTris);
    }

    private Point3d[] sampleLineSeg(double rand) {
        return OccSource.sampleGeom(rand, this.d_lineSegments);
    }

    private static Point3d[] sampleGeom(double rand, GeomChoice[] choices) {
        if (choices.length == 0) {
            return null;
        }
        GeomChoice finder = new GeomChoice(rand, new Point3d[0]);
        int ix = Arrays.binarySearch(choices, finder);
        if (ix < 0) {
            ix = -1 - ix;
        }
        return choices[ix].geom;
    }

    private Pair<Point3d, ICurve> samplePointInTri(Random rand, Point3d[] tri) {
        Point3d loc = new Point3d();
        double r1 = rand.nextDouble();
        double r2 = rand.nextDouble();
        double c1 = 1.0 - Math.sqrt(r1);
        double c2 = Math.sqrt(r1) * (1.0 - r2);
        double c3 = Math.sqrt(r1) * r2;
        double x = c1 * tri[0].x + c2 * tri[1].x + c3 * tri[2].x;
        double y = c1 * tri[0].y + c2 * tri[1].y + c3 * tri[2].y;
        double z = c1 * tri[0].z + c2 * tri[1].z + c3 * tri[2].z;
        loc.set(x, y, z);
        return new Pair<Point3d, ICurve>(loc, this.getInitOrient((Vector3d)null, loc));
    }

    private static void isectAABoxTris(AABox bounds, List<Tri> tris, Consumer<Face> result) {
        int[] boxid = new int[]{10463731};
        try {
            Model model = new Model();
            boolean added = false;
            for (Tri tri : tris) {
                added |= model.addPolygonFace(0, new Plane3d(tri.plane.x, tri.plane.y, tri.plane.z, tri.plane.w), tri.v[0].p, tri.v[1].p, tri.v[2].p);
            }
            if (!added) {
                return;
            }
            for (Point3d[] face : bounds.getFaces()) {
                Plane3d plane = Util3D.simplePolygonPlane(Arrays.asList(face), true);
                if (plane != null && model.addPolygonFace(plane, new Point3d[][]{face}, boxid, Collections.nCopies(4, boxid), Collections.emptyList())) continue;
                return;
            }
            for (Face eface : model.getFaces(0)) {
                Point3d tp = model.findPointInFace(eface);
                if (tp == null || !bounds.contains(tp, 1.0E-6)) continue;
                result.accept(eface);
            }
        }
        catch (CancellationException e) {
            throw e;
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private static void isectAABoxFacesTri(AABox bounds, Tri tri, Consumer<Edge> result) {
        int[] boxid = new int[]{10463731};
        try {
            Model model = new Model();
            if (!model.addPolygonFace(0, new Plane3d(tri.plane.x, tri.plane.y, tri.plane.z, tri.plane.w), tri.v[0].p, tri.v[1].p, tri.v[2].p)) {
                return;
            }
            boolean anyAdded = false;
            for (Point3d[] face : bounds.getFaces()) {
                Plane3d plane = Util3D.simplePolygonPlane(Arrays.asList(face), true);
                anyAdded |= plane != null && model.addPolygonFace(plane, new Point3d[][]{face}, boxid, Collections.nCopies(4, boxid), Collections.emptyList());
            }
            if (!anyAdded) {
                return;
            }
            IntPredicate gtest = g -> g != boxid[0];
            for (Edge edge : model.getEdges(boxid[0])) {
                if (!NmtUtil.testGroups(edge.groups, gtest)) continue;
                result.accept(edge);
            }
        }
        catch (CancellationException e) {
            throw e;
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private static Pair<List<GeomChoice>, List<GeomChoice>> getRegionTris(KB kb, AABox region) {
        if (!region.isValid()) {
            return new Pair<List<GeomChoice>, List<GeomChoice>>(Collections.emptyList(), Collections.emptyList());
        }
        List<Tri> tris = kb.getMesh().findTris(new AABoxTest(region, 1.0E-6), TRI_FILTER);
        LinkedHashMap<Point3d, Integer> pmap = new LinkedHashMap<Point3d, Integer>();
        ArrayList<Integer> resultTris = new ArrayList<Integer>();
        ArrayList faces = new ArrayList();
        OccSource.isectAABoxTris(region, tris, faces::add);
        for (Face face : faces) {
            try {
                if (face.triangulate(Face.NO_REFINEMENT, pmap, resultTris)) continue;
                LOGGER.log(Level.SEVERE, "[0xab98f] Couldn't triangulate part of occ source region");
            }
            catch (Throwable t) {
                TeciLogging.log(LOGGER, t);
            }
        }
        ArrayList points = new ArrayList(pmap.keySet());
        ArrayList<GeomChoice> backupTris = new ArrayList<GeomChoice>();
        ArrayList<GeomChoice> preferredTris = new ArrayList<GeomChoice>();
        int m = 0;
        while (m < resultTris.size()) {
            Tri meshTri;
            Point3d[] t = new Point3d[3];
            for (int n = 0; n < 3; ++n) {
                t[n] = (Point3d)points.get((Integer)resultTris.get(m++));
            }
            double area = Util3D.simplePolygonArea(Arrays.asList(t));
            GeomChoice tri = new GeomChoice(area, t);
            Point3d centroid = Util3D.simplePolygonCentroid(Arrays.asList(t));
            if (centroid == null || (meshTri = kb.getMesh().getTri(centroid)) == null) continue;
            backupTris.add(tri);
            boolean preferred = true;
            for (Blockage b : meshTri.getBlockages()) {
                if (!b.getPreventOccPlacement()) continue;
                preferred = false;
                break;
            }
            if (!preferred) continue;
            preferredTris.add(new GeomChoice(area, t));
        }
        return new Pair<List<GeomChoice>, List<GeomChoice>>(preferredTris, backupTris);
    }

    private static List<GeomChoice> getRegionLineSegments(KB kb, AABox region) {
        if (!region.isValid()) {
            return Collections.emptyList();
        }
        List<Tri> tris = kb.getMesh().findTris(new AABoxTest(region, 1.0E-6), TRI_FILTER);
        ArrayList<GeomChoice> resultEdges = new ArrayList<GeomChoice>();
        for (Tri tri : tris) {
            ArrayList edges = new ArrayList();
            OccSource.isectAABoxFacesTri(region, tri, edges::add);
            for (Edge edge : edges) {
                resultEdges.add(new GeomChoice(edge.v1.loc.distance(edge.v2.loc), edge.v1.loc, edge.v2.loc));
            }
        }
        return resultEdges;
    }

    public IProgressNote getProgress(KB kb) {
        if (this.isFinished(kb.getCurrentSimTime())) {
            return IProgressNote.PROGRESSING;
        }
        return this.d_stuck ? IProgressNote.NOT_PROGRESSING : IProgressNote.PROGRESSING;
    }

    public ANode getComponent() {
        return this.d_component;
    }

    public IUrn<OccProfileSim> getProfileUrn() {
        return this.d_profUrn;
    }

    public IUrn<BehaviorSim> getBehaviorUrn() {
        return this.d_behaviorUrn;
    }

    public boolean isEnforceFlowrate() {
        return this.d_enforceFlowrate;
    }

    public IUrn<OccGroupType> getGroupUrn() {
        return this.d_groupUrn;
    }

    public ICurve getInitialOrient() {
        return this.d_initialOrient;
    }

    public boolean getEmitAtMaxVel() {
        return this.d_emitAtMaxVel;
    }

    public long getSeed() {
        return this.d_seed;
    }

    private static /* synthetic */ int lambda$releaseOccupant$6(Pair l1, Pair l2) {
        return Double.compare((Double)l1.v2, (Double)l2.v2);
    }

    public static class GeomChoice
    implements Serializable,
    Comparable<GeomChoice> {
        static final long serialVersionUID = 1L;
        public final Point3d[] geom;
        public final double size;

        public GeomChoice(Tri t) {
            this(t.getArea(), t.v[0].p, t.v[1].p, t.v[2].p);
        }

        public GeomChoice(WingedEdge door) {
            this(door.base.n1.p.distance(door.base.n2.p), door.base.n1.p, door.base.n2.p);
        }

        public GeomChoice(double area, Point3d ... geom) {
            this.geom = geom;
            this.size = area;
        }

        @Override
        public int compareTo(GeomChoice o) {
            return Double.compare(this.size, o.size);
        }
    }
}

