/*
 * Decompiled with CFR 0.152.
 */
package inferno.sim.ai;

import inferno.data2.ANode;
import inferno.data2.AttractorSim;
import inferno.data2.CommonAnimTags;
import inferno.data2.OccTarget;
import inferno.data2.Occupant;
import inferno.data2.SplitEdge;
import inferno.data2.ai.ExitGoal;
import inferno.data2.ai.IGoal;
import inferno.data2.ai.IGoalInstance;
import inferno.data2.ai.IProgressNote;
import inferno.data2.seekarea.ISeekArea;
import inferno.sim.DoorQueue;
import inferno.sim.Engine;
import inferno.sim.EngineOp;
import inferno.sim.IRelation;
import inferno.sim.KB;
import inferno.sim.OccAgent;
import inferno.sim.ai.AGoalAiCore;
import inferno.sim.ai.AiUtil;
import inferno.sim.ai.IGoalAiCore;
import inferno.sim.path.PathGen;
import inferno.sim.steering.ISteeringBehavior;
import inferno.sim.steering.ITpSource;
import inferno.sim.steering.inverse.StandStill;
import inferno.sim.steering.locallyquickest.LocalTimeEstimate;
import inferno.sim.steering.locallyquickest.LocallyQuickest;
import inferno.sim.steering.locallyquickest.PointTarget;
import inferno.sim.steering.simple.MoveToGoal;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

public class ReqAssistedByAiCore
extends AGoalAiCore {
    private static final long serialVersionUID = 1L;
    private final ISteeringBehavior d_wait = new StandStill();
    private ISteeringBehavior d_follow = null;
    private IGoalInstance d_goalInst;
    private ISeekArea d_currSeekArea;
    private OccTarget d_occTarget;
    private boolean d_seeking = false;

    @Override
    public boolean getHasMoreToDo(KB kb, OccAgent agent) {
        return true;
    }

    @Override
    public IGoalInstance getCurrentGoalInstance(OccAgent agent) {
        return this.d_goalInst != null ? this.d_goalInst : AiUtil.getDefaultCurrGoal(agent);
    }

    @Override
    public boolean isSeeking(KB kb, OccAgent agent) {
        return this.d_seeking;
    }

    @Override
    public IProgressNote getProgress(KB kb, OccAgent agent) {
        return this.getCurrentGoalInstance(agent).getProgress(kb, agent);
    }

    @Override
    public ISteeringBehavior getSteering(OccAgent agent) {
        OccAgent assistedBy;
        if (this.d_follow == null) {
            return this.d_wait;
        }
        IRelation.AssistedBy rel = (IRelation.AssistedBy)agent.getRelation(IRelation.AssistedBy.class);
        OccAgent occAgent = assistedBy = rel != null ? rel.agentHelping : null;
        if (assistedBy != null) {
            return this.d_follow;
        }
        return this.d_wait;
    }

    @Override
    public void init(KB kb, OccAgent agent) {
        this.initGoal(kb, agent, agent.getGoalIx());
    }

    private void initGoal(KB kb, OccAgent agent, int goalIx) {
        IGoalInstance goalInstance;
        List<IGoal> goalSequence = agent.getOcc().behavior.goals;
        IGoal currentGoal = goalSequence.get(goalIx);
        this.d_goalInst = goalInstance = currentGoal.begin(kb, agent);
        this.updateState(kb, agent);
    }

    @Override
    public ISeekArea getCurrentSeekArea(KB kb, OccAgent agent) {
        return this.d_currSeekArea;
    }

    @Override
    protected void updateState(KB kb, OccAgent agent) {
        super.updateState(kb, agent);
        this.d_currSeekArea = IGoalAiCore.calcCurrentSeekArea(this, kb, agent, this.getCurrentGoalInstance(agent));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(Engine e, KB kb, OccAgent agent) {
        Occupant occ = agent.getOcc();
        occ.animTagsIdling = CommonAnimTags.INJURED_SIT.tags;
        occ.animTagsMoving = CommonAnimTags.INJURED.tags;
        try {
            OccAgent assistedBy;
            IRelation.AssistedBy rel = (IRelation.AssistedBy)agent.getRelation(IRelation.AssistedBy.class);
            OccAgent occAgent = assistedBy = rel != null ? rel.agentHelping : null;
            if (this.d_follow == null && rel != null) {
                assert (this.d_follow == null);
                double offset = assistedBy.getOccupantRadius() + agent.getOccupantRadius() + 0.05;
                ITpSource.OffsetTpSource ptSrc = new ITpSource.OffsetTpSource(assistedBy, kb.getMesh(), agent, offset);
                LocallyQuickest planner = new LocallyQuickest(agent, new LocalTimeEstimate.QueueSizes(), new PointTarget(ptSrc));
                this.d_follow = new MoveToGoal(kb, agent, planner);
            } else if (this.d_follow != null && rel == null) {
                this.d_follow.done(kb, agent, false);
                this.d_follow = null;
            }
            if (assistedBy == null) {
                return;
            }
            boolean setCoreToDefault = false;
            boolean removeRelations = false;
            List<IGoal> goalSequence = agent.getOcc().behavior.goals;
            int currentGoalIx = agent.getGoalIx();
            IGoal currentGoal = goalSequence.get(currentGoalIx);
            IGoalInstance goalInstance = this.getCurrentGoalInstance(agent);
            if (goalInstance.isReached(kb, agent)) {
                removeRelations = true;
                setCoreToDefault = true;
                goalInstance.end(kb, agent);
                if (currentGoalIx + 1 >= goalSequence.size()) {
                    agent.finish(kb);
                } else {
                    boolean resetElevState = this.d_goalInst != null ? !this.d_goalInst.wasImmediate() : false;
                    this.initGoal(kb, agent, currentGoalIx + 1);
                    agent.setGoalIx(currentGoalIx + 1, resetElevState);
                }
            } else if (ReqAssistedByAiCore.isExitCloseEnough(kb, currentGoal, agent)) {
                removeRelations = true;
                setCoreToDefault = true;
            }
            if (removeRelations && rel != null) {
                e.pushOp(new EngineOp.RemoveRelation(agent, rel));
                IRelation relHelper = rel.agentHelping.getRelation(IRelation.Assisting.class);
                if (relHelper != null) {
                    e.pushOp(new EngineOp.RemoveRelation(rel.agentHelping, relHelper));
                    occ.animTagsMoving = CommonAnimTags.DEFAULT_UPRIGHT.tags;
                    occ.animTagsIdling = occ.animTagsMoving;
                }
            }
            if (setCoreToDefault) {
                occ.animTagsMoving = CommonAnimTags.DEFAULT_UPRIGHT.tags;
                occ.animTagsIdling = occ.animTagsMoving;
                e.pushOp(new EngineOp.SetAi(AiUtil::newCore, Collections.singletonList(agent)));
            }
        }
        finally {
            this.updateState(kb, agent);
            this.d_occTarget = IGoalAiCore.calcOccTargetInUse(kb, agent, this.getCurrentGoalInstance(agent));
            agent.updateStats(kb, e.getCurrentDt());
        }
    }

    public static boolean isExitCloseEnough(KB kb, IGoal currentGoal, OccAgent agent) {
        if (currentGoal instanceof ExitGoal) {
            SplitEdge[] sedges = kb.getMesh().getShortenedEdges(agent.getGeometryRadius());
            List<ANode> exits = ((ExitGoal)currentGoal).getExits(kb);
            for (ANode exit : exits) {
                PathGen.IEdgeGoal egoal;
                if (exit.isClosed(kb, agent) || !((egoal = PathGen.newDoorGoal(exit)).getMinDistance(sedges, agent.getPos()) < 2.0)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void doorCrossed(double t, OccAgent agent, DoorQueue door) {
        this.getCurrentGoalInstance(agent).doorCrossed(agent, door);
        this.d_wait.doorCrossed(t, agent, door);
        if (this.d_follow != null) {
            this.d_follow.doorCrossed(t, agent, door);
        }
    }

    @Override
    public void preMove(KB kb, OccAgent agent, double dt) {
    }

    @Override
    public Optional<AttractorSim> getAttractorInUse(KB kb, OccAgent agent) {
        return Optional.empty();
    }

    @Override
    public Optional<OccTarget> getOccTargetInUse(KB kb, OccAgent agent) {
        return Optional.ofNullable(this.d_occTarget);
    }
}

