/*
 * Decompiled with CFR 0.152.
 */
package inferno.sim;

import inferno.data2.OccPriority;
import inferno.data2.Occupant;
import inferno.sim.KB;
import inferno.sim.OccAgent;
import inferno.sim.OccProfileSim;
import inferno.sim.occsource.OccSource;
import inferno.sim.steering.inverse.InvSteerUtil;
import inferno.util.AgentSet;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.DoubleConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import org.jscience.physics.units.SI;
import thunderheadeng.geometry.IParametric3D;
import thunderheadeng.geometry.Inter3D;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.util.LinkedIdentityHashMap;
import thunderheadeng.util.LinkedIdentityHashSet;

public class CycleBreaker
implements Serializable {
    static final long serialVersionUID = 1L;
    private Map<OccAgent, Breaker> d_cycleBreakers = Collections.emptyMap();
    private Map<OccAgent, List<OccAgent>> d_waiting = null;
    private static final Breaker s_emptyBreaker = new Breaker(new Point3d(), Collections.emptySet());

    public void update(KB kb, double dt, List<OccAgent> agents) {
        if (!kb.getParams().handle_collisions) {
            return;
        }
        List<List<OccAgent>> cycles = CycleBreaker.detectNonMovingCycles(kb, agents);
        LinkedIdentityHashMap<OccAgent, Breaker> newBreakers = new LinkedIdentityHashMap<OccAgent, Breaker>();
        for (List<OccAgent> cycle : cycles) {
            CycleBreaker.resolveCycle(kb, dt, cycle, this.d_cycleBreakers, newBreakers);
        }
        this.d_cycleBreakers = newBreakers;
        this.d_waiting = null;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.d_waiting == null) {
            this.d_waiting = Collections.emptyMap();
        }
    }

    public synchronized List<OccAgent> getWaitingOccs(KB kb, OccAgent occ) {
        if (!kb.getParams().handle_collisions) {
            return Collections.emptyList();
        }
        if (this.d_waiting == null) {
            IdentityHashMap<OccAgent, List<OccAgent>> waitingMap = new IdentityHashMap<OccAgent, List<OccAgent>>();
            Function<OccAgent, List> newList = a -> new ArrayList(5);
            for (OccAgent waiting : kb.getActiveAgents()) {
                for (OccAgent waitingOn : waiting.getAvoidOccs()) {
                    if (waitingOn == null) continue;
                    waitingMap.computeIfAbsent(waitingOn, newList).add(waiting);
                }
            }
            this.d_waiting = waitingMap;
        }
        return this.d_waiting.getOrDefault(occ, Collections.emptyList());
    }

    private static List<List<OccAgent>> detectNonMovingCycles(KB kb, List<OccAgent> agents) {
        AgentSet testedAgents = new AgentSet(agents.size());
        ArrayList<List<OccAgent>> cycles = new ArrayList<List<OccAgent>>();
        for (OccAgent agent : agents) {
            List<OccAgent> cycle = CycleBreaker.detectCycle(kb, agent, testedAgents);
            if (cycle.isEmpty()) continue;
            cycles.add(cycle);
        }
        return cycles;
    }

    private static List<OccAgent> detectCycle(KB kb, OccAgent seed, Set<OccAgent> testedAgents) {
        if (testedAgents.contains(seed)) {
            return Collections.emptyList();
        }
        OccAgent agent = seed;
        AgentSet closed = new AgentSet();
        closed.add(agent);
        while (agent != null && testedAgents.add(agent)) {
            OccAgent stopAgent = CycleBreaker.getStopAgent(kb, agent);
            if ((agent = stopAgent) == null || closed.add(agent)) continue;
            return CycleBreaker.getCycle(agent);
        }
        return Collections.emptyList();
    }

    private static List<OccAgent> getCycle(OccAgent first) {
        ArrayList<OccAgent> cycle = new ArrayList<OccAgent>();
        cycle.add(first);
        for (OccAgent curr = first.getAvoidOcc(); curr != first; curr = curr.getAvoidOcc()) {
            cycle.add(curr);
        }
        return cycle;
    }

    private static OccAgent getStopAgent(KB kb, OccAgent agent) {
        return agent.isStuck(kb) && !OccPriority.isLocallyHighest(agent.getPriority(kb)) ? agent.getAvoidOcc() : null;
    }

    private static void resolveCycle(KB kb, double dt, List<OccAgent> cycle, Map<OccAgent, Breaker> oldBreakers, Map<OccAgent, Breaker> newBreakers) {
        assert (!cycle.isEmpty() && cycle.get(cycle.size() - 1).getAvoidOcc() == cycle.get(0));
        OccAgent winner = CycleBreaker.getCycleWinner(kb, cycle, oldBreakers);
        assert (winner != null);
        newBreakers.put(winner, new Breaker(winner.getPos(), new LinkedIdentityHashSet<OccAgent>((Collection<OccAgent>)cycle)));
    }

    private static OccAgent getCycleWinner(KB kb, List<OccAgent> cycle, Map<OccAgent, Breaker> oldBreakers) {
        assert (!cycle.isEmpty());
        Predicate<OccAgent> eligibleFilter = agent -> InvSteerUtil.getSteerMeta((OccAgent)agent).tRaisedPriorityBegin < kb.getCurrentSimTime();
        List<Object> winners = Collections.emptyList();
        for (OccAgent agent2 : cycle) {
            Breaker breaker;
            if (!eligibleFilter.test(agent2) || (breaker = oldBreakers.get(agent2)) == null || agent2.getPos().epsilonEquals(breaker.lastLoc, 1.0E-6)) continue;
            if (winners.isEmpty()) {
                winners = new ArrayList();
            }
            winners.add(agent2);
        }
        if (winners.size() == 1) {
            return (OccAgent)winners.get(0);
        }
        if (!winners.isEmpty()) {
            cycle = winners;
        } else {
            for (OccAgent occ1 : cycle) {
                OccAgent occ2 = occ1.getAvoidOcc();
                if (!eligibleFilter.test(occ2) || !InvSteerUtil.isLeavingGoalSpace(kb, occ1, occ2) && !InvSteerUtil.isSeekingGoalSpace(kb, occ1, occ2) || InvSteerUtil.isLeavingGoalSpace(kb, occ2, occ2.getAvoidOcc()) || InvSteerUtil.isSeekingGoalSpace(kb, occ2, occ2.getAvoidOcc())) continue;
                if (winners.isEmpty()) {
                    winners = new ArrayList();
                }
                winners.add(occ2);
            }
            if (winners.size() == 1) {
                return (OccAgent)winners.get(0);
            }
            if (!winners.isEmpty()) {
                cycle = winners;
            }
        }
        ArrayList minPathCrossAgents = new ArrayList();
        double minPathCrossDistSq = Double.MAX_VALUE;
        ArrayList minInTheWayAgents = new ArrayList();
        double minInTheWayFactor = Double.MAX_VALUE;
        for (int m = 0; m < cycle.size(); ++m) {
            Vector3d dir2;
            double inTheWayFactor;
            Vector3d vector3d;
            OccAgent agent1 = cycle.get(m);
            if (!eligibleFilter.test(agent1)) continue;
            OccAgent agent2 = cycle.get((m + 1) % cycle.size());
            Point3d[] isects = CycleBreaker.isectSeekCurves(agent1, agent2);
            if (isects != null) {
                double d = agent1.getPos().distanceSquared(isects[0]);
                if (!(d <= minPathCrossDistSq)) continue;
                if (d < minPathCrossDistSq) {
                    minPathCrossAgents.clear();
                }
                minPathCrossAgents.add(agent1);
                minPathCrossDistSq = d;
                continue;
            }
            if (!minPathCrossAgents.isEmpty() || (vector3d = CycleBreaker.getNormalizedPathTan(agent1)) == null || !((inTheWayFactor = vector3d.dot(dir2 = Util3D.vectorN(agent1.getPos(), agent2.getPos()))) <= minInTheWayFactor)) continue;
            if (inTheWayFactor != minInTheWayFactor) {
                minInTheWayAgents.clear();
            }
            minInTheWayAgents.add(agent1);
            minInTheWayFactor = inTheWayFactor;
        }
        winners = cycle;
        if (!minInTheWayAgents.isEmpty()) {
            winners = minInTheWayAgents;
        }
        if (!minPathCrossAgents.isEmpty()) {
            winners = minPathCrossAgents;
        }
        assert (!winners.isEmpty());
        if (winners.size() == 1) {
            return (OccAgent)winners.get(0);
        }
        double min = 2.147483647E9;
        OccAgent winner = null;
        for (OccAgent occAgent : winners) {
            Occupant challenger = occAgent.getOcc();
            if (!(challenger.priority < min) && (winner == null || challenger.priority != min || challenger.id >= winner.getOcc().id)) continue;
            min = challenger.priority;
            winner = occAgent;
        }
        assert (winner != null);
        return winner;
    }

    private static Point3d[] isectSeekCurves(OccAgent agent1, OccAgent agent2) {
        Vector3d dir1 = CycleBreaker.getNormalizedPathTan(agent1);
        if (dir1 == null) {
            return null;
        }
        Vector3d dir2 = CycleBreaker.getNormalizedPathTan(agent2);
        if (dir2 == null) {
            return null;
        }
        double[] isect = Inter3D.lineLineProximityT(agent1.getPos(), dir1, agent2.getPos(), dir2, 1.0E-6);
        if (isect == null || isect[0] <= 0.0 || isect[1] <= 0.0) {
            return null;
        }
        return new Point3d[]{Util3D.linePoint(agent1.getPos(), dir1, isect[0]), Util3D.linePoint(agent2.getPos(), dir2, isect[1])};
    }

    private static Vector3d getNormalizedPathTan(OccAgent agent) {
        IParametric3D sc = agent.getSeekCurve();
        if (sc == null) {
            return null;
        }
        Vector3d dir = sc.getTangent(0.0);
        double lensq = dir.lengthSquared();
        if (lensq == 0.0) {
            return null;
        }
        dir.scale(1.0 / Math.sqrt(lensq));
        return dir;
    }

    public static double getUpdateInterval(Collection<OccAgent> agents, Collection<OccSource> sources) {
        double[] aminPersist = new double[]{Double.MAX_VALUE};
        DoubleConsumer addPersist = persist -> {
            aminPersist[0] = Math.min(persist, aminPersist[0]);
        };
        for (OccAgent agent : agents) {
            addPersist.accept(agent.getOcc().persistTime);
        }
        for (OccSource source : sources) {
            source.getFutureProfileValues(OccProfileSim.PROP_PERSIST_TIME, persist -> addPersist.accept(persist.getMin().get(SI.SECOND)));
        }
        double minPersist = aminPersist[0];
        double interval = Math.min(0.5, minPersist / 2.0);
        return interval;
    }

    public boolean isCycleBreaker(OccAgent agent) {
        return this.d_cycleBreakers.containsKey(agent);
    }

    public Set<OccAgent> getCycleToBreak(OccAgent agent) {
        return this.d_cycleBreakers.getOrDefault((Object)agent, (Breaker)CycleBreaker.s_emptyBreaker).cycle;
    }

    private static class Breaker
    implements Serializable {
        private static final long serialVersionUID = 3932081141449972243L;
        public final Point3d lastLoc;
        public final Set<OccAgent> cycle;

        public Breaker(Point3d lastLoc, Set<OccAgent> cycle) {
            this.lastLoc = lastLoc;
            this.cycle = cycle;
        }
    }
}

