/*
 * Decompiled with CFR 0.152.
 */
package inferno.io;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import inferno.io.SerializedOutputStream;
import inferno.sim.Output;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.Flushable;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Reader;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Logger;
import merlin.Intl;
import org.jscience.physics.units.NonSI;
import org.jscience.physics.units.Unit;
import thunderheadeng.io.TeciLogging;

public class JSONWriter
implements Serializable,
Closeable,
Flushable {
    static final long serialVersionUID = 1L;
    private static final Logger LOGGER = Logger.getLogger(JSONWriter.class.getName());
    private transient PrintStream d_out;
    private File d_file;
    private boolean d_writeAsArray;
    private boolean d_isFirstElement = true;

    public JSONWriter(boolean writeAsArray) {
        this.d_writeAsArray = writeAsArray;
    }

    public void open(double t) throws FileNotFoundException, IOException {
        if (t != 0.0 && this.d_writeAsArray) {
            String line;
            BufferedReader br = new BufferedReader(new FileReader(this.d_file));
            StringBuilder old_contents = new StringBuilder();
            while ((line = br.readLine()) != null) {
                old_contents.append(line);
                old_contents.append("\n");
            }
            if (old_contents.length() > 0) {
                old_contents.deleteCharAt(old_contents.length() - 1);
            }
            this.d_out = Output.openTxtStream(new SerializedOutputStream(this.d_file.getAbsolutePath()));
            this.d_out.append(old_contents.toString());
        } else {
            this.d_out = Output.openTxtStream(new SerializedOutputStream(this.d_file.getAbsolutePath()));
            if (this.d_writeAsArray) {
                String arrayString = "{\n\t\"data\": [";
                this.d_out.append(arrayString);
            }
        }
    }

    public void forceOpen(File file) throws IOException {
        this.setFile(file);
        this.open(0.0);
    }

    public void open(double t, File file) throws IOException {
        this.setFile(file);
        this.open(t);
    }

    @Override
    public void flush() {
        if (this.d_out != null) {
            this.d_out.flush();
        }
    }

    private void add(String str) {
        try {
            if (this.d_out != null && str != null) {
                if (this.d_writeAsArray) {
                    String updateString;
                    String string = updateString = this.d_isFirstElement ? "\n\t\t" + str.replaceAll("\n", "\n\t\t") : ",\n\t\t" + str.replaceAll("\n", "\n\t\t");
                    if (this.d_isFirstElement) {
                        this.d_isFirstElement = false;
                    }
                    this.d_out.append(updateString);
                } else if (this.d_isFirstElement) {
                    this.d_out.append(str);
                } else {
                    this.d_out.close();
                    this.d_out = Output.openTxtStream(new SerializedOutputStream(this.d_file.getAbsolutePath()));
                    this.d_out.append(str);
                }
                this.d_out.flush();
                this.d_isFirstElement = false;
            }
        }
        catch (IOException e) {
            TeciLogging.log(LOGGER, e);
        }
    }

    public void add(Object obj) {
        Gson gson = new GsonBuilder().setPrettyPrinting().serializeSpecialFloatingPointValues().disableHtmlEscaping().create();
        this.add(gson.toJson(obj));
    }

    public PrintStream getStream() {
        return this.d_out;
    }

    public void setFile(File f) {
        this.d_file = f;
    }

    public File getFile() {
        return this.d_file;
    }

    public void deleteFile() {
        if (!this.d_file.delete()) {
            TeciLogging.log(LOGGER, new Error(String.format(Intl.intl("Failed to delete JSON file \"%s\""), this.d_file.getName())));
        }
    }

    @Override
    public void close() {
        if (this.d_out != null) {
            this.d_out.close();
        }
    }

    public void closeAndDeleteFile() throws IOException {
        this.close();
        this.deleteFile();
    }

    public void stopWritingAsArray() {
        String closingArrayString = "\n\t]\n}";
        this.d_out.append(closingArrayString);
        this.d_writeAsArray = false;
    }

    public ArrayList<Map<String, Object>> readTempJsonData() {
        if (this.d_writeAsArray && this.d_out != null) {
            Gson gson = new GsonBuilder().setPrettyPrinting().setLenient().create();
            try {
                this.stopWritingAsArray();
                this.close();
                FileReader reader = new FileReader(this.d_file);
                Map map = gson.fromJson((Reader)reader, LinkedHashMap.class);
                reader.close();
                ArrayList data = (ArrayList)map.get("data");
                this.open(0.0);
                return data;
            }
            catch (Exception exc) {
                TeciLogging.log(LOGGER, exc);
            }
        }
        return new ArrayList<Map<String, Object>>();
    }

    public static String getUnitString(String base, Unit unit) {
        if (unit != null && !unit.equals(Unit.ONE)) {
            if (unit.equals(NonSI.DEGREE_ANGLE)) {
                return String.format("%s(%s)", base, "deg");
            }
            return String.format("%s(%s)", base, unit);
        }
        return base;
    }
}

