/*
 * Decompiled with CFR 0.152.
 */
package inferno.elevator;

import inferno.data2.ANode;
import inferno.sim.DoorQueue;
import inferno.sim.IFormationLeaderAgent;
import inferno.sim.KB;
import inferno.sim.OccAgent;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.function.DoubleSupplier;

public interface ITimeEstimate {
    public static final ITimeEstimate FOREVER = new Forever();

    public Status getStatus(KB var1, OccAgent var2);

    public static Status getStatusFromTime(KB kb, double t) {
        if (Double.isInfinite(t)) {
            return Status.FUTURE_UNKNOWN;
        }
        return kb.getCurrentSimTime() < t ? Status.FUTURE_KNOWN : Status.PAST;
    }

    public double getTime(KB var1, OccAgent var2, DoubleSupplier var3);

    public boolean isPhysicallyClosed();

    public static enum Status {
        FUTURE_UNKNOWN(false),
        FUTURE_KNOWN(false),
        PAST(true);

        public final boolean past;

        private Status(boolean past) {
            this.past = past;
        }
    }

    public static class Forever
    implements ITimeEstimate,
    Serializable {
        private static final long serialVersionUID = 5305759104951693646L;

        @Override
        public Status getStatus(KB kb, OccAgent agent) {
            return Status.FUTURE_UNKNOWN;
        }

        @Override
        public double getTime(KB kb, OccAgent agent, DoubleSupplier getTransportDepartTimeRem) {
            return Double.POSITIVE_INFINITY;
        }

        @Override
        public boolean isPhysicallyClosed() {
            return true;
        }

        public String toString() {
            return "Forever";
        }
    }

    public static class VariableOccSize
    implements ITimeEstimate,
    Serializable {
        private static final long serialVersionUID = 1L;
        private ANode d_pickupNode;
        private int d_nominalLoad;
        private DoorQueue d_doorQueue;

        public VariableOccSize(ANode pickupNode, int nominalLoad, DoorQueue doorQueue) {
            this.d_pickupNode = pickupNode;
            this.d_doorQueue = doorQueue;
            this.d_nominalLoad = nominalLoad;
        }

        @Override
        public Status getStatus(KB kb, OccAgent agent) {
            return ITimeEstimate.getStatusFromTime(kb, this.getTime(kb, agent, null));
        }

        @Override
        public double getTime(KB kb, OccAgent agent, DoubleSupplier getTransportDepartTimeRem) {
            int formationCorrespondingOccCount;
            if (agent.getOcc().curNode == this.d_pickupNode) {
                return 0.0;
            }
            IFormationLeaderAgent formationLeader = agent.getOcc().formationLeader;
            if (formationLeader != null && formationLeader.isFreePassDoor(this.d_doorQueue)) {
                return 0.0;
            }
            int correspondingOccCount = agent.getCorrespondingOccCount();
            if (formationLeader == null && correspondingOccCount == 1) {
                return 0.0;
            }
            int curOccCount = this.d_pickupNode.getCorrespondingNumOccupants() + this.d_pickupNode.getEnteringCount();
            int formationOccsInside = 0;
            List<OccAgent> formation = formationLeader != null ? formationLeader.getFormation() : Collections.singletonList(agent);
            for (OccAgent a : formation) {
                if (!this.d_pickupNode.getEnteringAgents().contains(a)) continue;
                formationOccsInside += a.getCorrespondingOccCount();
            }
            double maxAvailableOccCount = this.d_nominalLoad - curOccCount + formationOccsInside;
            int n = formationCorrespondingOccCount = formationLeader != null ? formationLeader.getFormationCorrespondingOccCount() : agent.getCorrespondingOccCount();
            if (formationCorrespondingOccCount > this.d_nominalLoad) {
                return Double.POSITIVE_INFINITY;
            }
            if ((double)(formationCorrespondingOccCount - formationOccsInside) > maxAvailableOccCount) {
                return kb.getCurrentSimTime() + 2000000.0;
            }
            return 0.0;
        }

        @Override
        public boolean isPhysicallyClosed() {
            return false;
        }

        public String toString() {
            return "VariableOccSize";
        }
    }

    public static class Offset
    implements ITimeEstimate,
    Serializable {
        private static final long serialVersionUID = 6805030393164715309L;
        public final double tOffset;

        public Offset(double tOffset) {
            this.tOffset = tOffset;
        }

        @Override
        public Status getStatus(KB kb, OccAgent agent) {
            if (Double.isInfinite(this.tOffset)) {
                return Status.FUTURE_UNKNOWN;
            }
            return this.tOffset > 0.0 ? Status.FUTURE_KNOWN : Status.PAST;
        }

        @Override
        public double getTime(KB kb, OccAgent agent, DoubleSupplier getTransportDepartTimeRem) {
            return kb.getCurrentSimTime() + this.tOffset;
        }

        @Override
        public boolean isPhysicallyClosed() {
            return true;
        }

        public String toString() {
            return "Offset=" + this.tOffset;
        }
    }

    public static class Specific
    implements ITimeEstimate,
    Serializable {
        private static final long serialVersionUID = 852920724311182539L;
        private double d_t;

        public Specific(double t) {
            this.d_t = t;
        }

        @Override
        public Status getStatus(KB kb, OccAgent agent) {
            return ITimeEstimate.getStatusFromTime(kb, this.d_t);
        }

        @Override
        public double getTime(KB kb, OccAgent agent, DoubleSupplier getTransportDepartTimeRem) {
            return this.d_t;
        }

        @Override
        public boolean isPhysicallyClosed() {
            return true;
        }

        public String toString() {
            return "t=" + this.d_t;
        }
    }
}

