/*
 * Decompiled with CFR 0.152.
 */
package inferno.elevator;

import inferno.data2.ANode;
import inferno.elevator.ElevatorDoorTimeEstimate;
import inferno.elevator.ElevatorLevel;
import inferno.elevator.ITimeEstimate;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.Util3D;

public class ElevatorUtil {
    public static void processLevelForPickup(ElevatorLevel elevatorLevel, int nominalLoad) {
        for (ANode door : elevatorLevel.pickupNode.getDoors()) {
            ITimeEstimate.VariableOccSize nextOpenEst = new ITimeEstimate.VariableOccSize(elevatorLevel.pickupNode, nominalLoad, door.doorQueue);
            door.setTransporting(nextOpenEst);
        }
    }

    public static boolean isLevelClosed(ElevatorLevel elevatorLevel) {
        return elevatorLevel.pickupNode.getDoors().stream().allMatch(ANode::isPhysicallyClosed);
    }

    public static Vector3d getTeleportVector(ANode a, ANode b) {
        AABox aBounds = a.getGeometryBounds();
        AABox bBounds = b.getGeometryBounds();
        return Util3D.vector(aBounds.getMin(), bBounds.getMin());
    }

    public static double getSignedTeleportDist(ANode a, ANode b) {
        Point3d aMin = a.getGeometryBounds().getMin();
        Point3d bMin = b.getGeometryBounds().getMin();
        return aMin.distance(bMin) * Math.signum(bMin.z - aMin.z);
    }

    public static double getAbsTeleportDist(ANode a, ANode b) {
        Point3d aMin = a.getGeometryBounds().getMin();
        Point3d bMin = b.getGeometryBounds().getMin();
        return aMin.distance(bMin);
    }

    public static ElevatorDoorTimeEstimate getDefaultTimeEstimate(ElevatorLevel elevLvl) {
        return new ElevatorDoorTimeEstimate(elevLvl);
    }
}

