/*
 * Decompiled with CFR 0.152.
 */
package inferno.elevator;

import inferno.data2.ANode;
import inferno.data2.ai.GoalUtil;
import inferno.data2.ai.IGoalInstance;
import inferno.data2.ai.IProgressNote;
import inferno.data2.ai.ISeekGoal;
import inferno.data2.ai.ISeekGoalInstance;
import inferno.data2.ai.RoomGoal;
import inferno.data2.ai.WaitUntilInsideGoal;
import inferno.data2.seekarea.ISeekArea;
import inferno.data2.seekarea.RoomSeekArea;
import inferno.elevator.Elevator;
import inferno.elevator.ElevatorLevel;
import inferno.sim.DoorQueue;
import inferno.sim.KB;
import inferno.sim.OccAgent;
import inferno.sim.steering.ISteeringBehavior;
import inferno.sim.steering.inverse.ElevatorSteeringBehavior;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import thunderheadeng.util.Filters;
import thunderheadeng.util.LinkedIdentityHashSet;
import thunderheadeng.util.Predicates;
import thunderheadeng.util.theUtil;

public class ElevatorGoal
implements ISeekGoal,
Serializable {
    static final long serialVersionUID = 1L;
    private final Set<Elevator> d_elevators;
    private final boolean d_useAnyElevator;
    private final int d_targetLevelID;

    public ElevatorGoal(boolean useAnyElevator, List<Elevator> elevators, Integer targetLevelID) {
        this.d_useAnyElevator = useAnyElevator;
        this.d_elevators = elevators.isEmpty() ? Collections.emptySet() : new LinkedIdentityHashSet<Elevator>((Collection<Elevator>)elevators);
        this.d_targetLevelID = targetLevelID != null ? targetLevelID : -1;
    }

    public Predicate<Elevator> getElevatorFilter() {
        return this.d_useAnyElevator ? Predicates.alwaysTrue() : Filters.accept(this.d_elevators);
    }

    @Override
    public boolean isImmediate() {
        return false;
    }

    @Override
    public ISeekGoalInstance begin(KB kb, OccAgent agent) {
        ArrayList<ANode> rooms = new ArrayList<ANode>();
        ArrayList<ANode> dischargeNodes = new ArrayList<ANode>();
        for (Elevator e : this.d_elevators) {
            dischargeNodes.add(this.getTargetLevel((Elevator)e).pickupNode);
            if (!e.isDoubleDeck()) continue;
            dischargeNodes.add(e.getUpperLevelFor((ElevatorLevel)this.getTargetLevel((Elevator)e)).pickupNode);
        }
        for (Elevator e : this.d_elevators) {
            for (ElevatorLevel level : e.getLevels()) {
                rooms.add(level.pickupNode);
            }
        }
        ElevatorGoal.sortRooms(rooms, agent.getLoc().p.z);
        return new ElevatorGoalInstance(this, kb, rooms, dischargeNodes, agent);
    }

    private static void sortRooms(List<ANode> rooms, final double occHeight) {
        Collections.sort(rooms, new Comparator<ANode>(){

            @Override
            public int compare(ANode o1, ANode o2) {
                if (o1 == o2) {
                    return 0;
                }
                double h1 = o1.getGeometryBounds().getCenter().z;
                double h2 = o2.getGeometryBounds().getCenter().z;
                boolean h1Eq = theUtil.eq(h1, occHeight, 0.001);
                boolean h2Eq = theUtil.eq(h2, occHeight, 0.001);
                if (h1Eq && h2Eq) {
                    return 0;
                }
                if (h1Eq) {
                    return -1;
                }
                if (h2Eq) {
                    return 1;
                }
                int comp1 = Double.compare(h1, occHeight);
                int comp2 = Double.compare(h2, occHeight);
                if (comp1 == 0 && comp2 == 0) {
                    return 0;
                }
                if (comp1 == 0) {
                    return -1;
                }
                if (comp2 == 0) {
                    return 1;
                }
                if (comp1 < 0 && comp2 < 0) {
                    return Double.compare(h2, h1);
                }
                return Double.compare(h1, h2);
            }
        });
    }

    public int hashCode() {
        return -1883595 + GoalUtil.setHashCode(this.d_elevators) + this.d_targetLevelID;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ElevatorGoal)) {
            return false;
        }
        ElevatorGoal eg = (ElevatorGoal)obj;
        return GoalUtil.setsEqual(this.d_elevators, eg.d_elevators);
    }

    public Set<Elevator> getElevators() {
        return this.d_elevators;
    }

    public int getTargetLevelID() {
        return this.d_targetLevelID;
    }

    public ElevatorLevel getTargetLevel(Elevator elevator) {
        ElevatorLevel level = elevator.getLevel(this.d_targetLevelID);
        if (level != null) {
            return level;
        }
        return elevator.getDefaultDischargeLevel();
    }

    public boolean useAnyElevator() {
        return this.d_useAnyElevator;
    }

    public class ElevatorGoalInstance
    implements ISeekGoalInstance,
    Serializable {
        static final long serialVersionUID = 1L;
        private ElevatorGoalState d_state;
        private WaitUntilInsideGoal.Instance d_waitGoalInstance;
        private final KB d_kb;
        private boolean d_needsNewSteering;
        private ElevatorSteeringBehavior d_elevatorSteering;
        private double d_waitEndTime;
        private final ElevatorGoal d_elevatorGoal;

        public ElevatorGoalInstance(ElevatorGoal elevatorGoal, KB kb, List<ANode> rooms, List<ANode> dischargeNodes, OccAgent agent) {
            this.d_elevatorGoal = elevatorGoal;
            this.d_kb = kb;
            this.d_elevatorSteering = new ElevatorSteeringBehavior(rooms, kb);
            this.d_waitGoalInstance = (WaitUntilInsideGoal.Instance)new WaitUntilInsideGoal(dischargeNodes).begin(kb, agent);
            this.d_state = ElevatorGoalState.GO_TO_ROOM;
            this.d_needsNewSteering = false;
        }

        @Override
        public boolean canInterrupt(KB kb, OccAgent agent) {
            switch (this.d_state.ordinal()) {
                case 0: {
                    return true;
                }
                case 1: {
                    return false;
                }
            }
            assert (false);
            return false;
        }

        @Override
        public void preMove(KB kb, OccAgent agent, double dt) {
            switch (this.d_state.ordinal()) {
                case 0: {
                    break;
                }
                case 1: {
                    this.d_waitGoalInstance.preMove(kb, agent, dt);
                }
            }
        }

        @Override
        public ISteeringBehavior generateSteeringBehavior(KB kb, OccAgent occ) {
            switch (this.d_state.ordinal()) {
                case 0: {
                    return this.d_elevatorSteering;
                }
                case 1: {
                    return this.d_waitGoalInstance.generateSteeringBehavior(kb, occ);
                }
            }
            return null;
        }

        @Override
        public IGoalInstance.IdleInfo getIdleInfo(KB kb, OccAgent agent) {
            switch (this.d_state.ordinal()) {
                case 0: {
                    return this.d_elevatorSteering.getCurrentRoomGoal() != null ? this.d_elevatorSteering.getCurrentRoomGoal().getIdleInfo(kb, agent) : null;
                }
                case 1: {
                    return IGoalInstance.idleStatus(this.d_waitEndTime);
                }
            }
            assert (false);
            return IGoalInstance.unknownIdleStatus();
        }

        @Override
        public ISeekArea end(KB kb, OccAgent occ) {
            return IGoalInstance.getCurrentAreaAsRoom(kb, occ);
        }

        @Override
        public boolean needsNewSteeringBehavior(KB kb, OccAgent occ) {
            return this.d_needsNewSteering;
        }

        @Override
        public ISeekArea update(KB kb, OccAgent agent) {
            this.d_needsNewSteering = false;
            if (this.d_state.equals((Object)ElevatorGoalState.GO_TO_ROOM) && this.d_elevatorSteering.getCurrentRoomGoal().isReached(this.d_kb, agent)) {
                Set<ANode> waitRooms;
                double travelTime;
                this.d_state = ElevatorGoalState.WAIT;
                this.d_needsNewSteering = true;
                ElevatorLevel source = agent.getOcc().curNode.getElevatorLevel();
                assert (source != null);
                if (source == null) {
                    travelTime = Double.POSITIVE_INFINITY;
                    waitRooms = Collections.singleton(agent.getOcc().curNode);
                } else {
                    Elevator e = source.getElevator();
                    ElevatorLevel target = ElevatorGoal.this.getTargetLevel(e);
                    travelTime = source.getTravelTime(target);
                    waitRooms = new LinkedIdentityHashSet<ANode>((Collection<ANode>)theUtil.map(e.getLevels(), l -> l.pickupNode));
                }
                this.d_waitEndTime = travelTime;
                this.d_waitGoalInstance.update(kb, agent);
                return new RoomSeekArea(waitRooms, 2);
            }
            switch (this.d_state.ordinal()) {
                case 0: {
                    return null;
                }
                case 1: {
                    return this.d_waitGoalInstance.update(kb, agent);
                }
            }
            assert (false);
            return null;
        }

        @Override
        public boolean isReached(KB kb, OccAgent occ) {
            if (this.d_state.equals((Object)ElevatorGoalState.GO_TO_ROOM)) {
                return false;
            }
            return this.d_waitGoalInstance.isReached(kb, occ);
        }

        @Override
        public ISeekArea getSeekArea(KB kb, OccAgent occ) {
            switch (this.d_state.ordinal()) {
                case 0: {
                    return this.d_elevatorSteering.getCurrentRoomGoal() != null ? this.d_elevatorSteering.getCurrentRoomGoal().getSeekArea(kb, occ) : IGoalInstance.getCurrentAreaAsPoint(kb, occ);
                }
                case 1: {
                    return this.d_waitGoalInstance.getSeekArea(kb, occ);
                }
            }
            assert (false);
            return null;
        }

        @Override
        public IProgressNote getProgress(KB kb, OccAgent occ) {
            switch (this.d_state.ordinal()) {
                case 0: {
                    return this.d_elevatorSteering.getCurrentRoomGoal().getProgress(kb, occ);
                }
                case 1: {
                    return this.d_waitGoalInstance.getProgress(kb, occ);
                }
            }
            return null;
        }

        @Override
        public void doorCrossed(OccAgent agent, DoorQueue door) {
            switch (this.d_state.ordinal()) {
                case 0: {
                    this.d_elevatorSteering.getCurrentRoomGoal().doorCrossed(agent, door);
                    break;
                }
                case 1: {
                    this.d_waitGoalInstance.doorCrossed(agent, door);
                    break;
                }
            }
        }

        @Override
        public ISeekGoal getGoal() {
            return this.d_elevatorGoal;
        }

        public RoomGoal.Instance getRoomGoal() {
            return this.d_elevatorSteering.getCurrentRoomGoal();
        }
    }

    private static enum ElevatorGoalState {
        GO_TO_ROOM,
        WAIT;

    }
}

