/*
 * Decompiled with CFR 0.152.
 */
package inferno.elevator;

import inferno.elevator.Elevator;
import inferno.elevator.ElevatorLevel;
import inferno.elevator.ITimeEstimate;
import inferno.sim.KB;
import inferno.sim.OccAgent;
import java.io.Serializable;
import java.util.function.BooleanSupplier;
import java.util.function.DoubleSupplier;

public class ElevatorDoorTimeEstimate
implements ITimeEstimate,
Serializable {
    private static final long serialVersionUID = 1L;
    private final ElevatorLevel d_level;

    public ElevatorDoorTimeEstimate(ElevatorLevel level) {
        this.d_level = level.getElevator().getLowerLevelFor(level);
    }

    @Override
    public boolean isPhysicallyClosed() {
        return true;
    }

    @Override
    public ITimeEstimate.Status getStatus(KB kb, OccAgent agent) {
        Elevator elev = this.d_level.getElevator();
        switch (elev.getState()) {
            case READY: {
                return ITimeEstimate.Status.FUTURE_KNOWN;
            }
            case AT_FLOOR: {
                if (elev.getCurrentLevel() == this.d_level) {
                    return ITimeEstimate.Status.PAST;
                }
                return ITimeEstimate.Status.FUTURE_KNOWN;
            }
            case MOVING_TO_FLOOR: {
                return ITimeEstimate.Status.FUTURE_KNOWN;
            }
        }
        assert (false);
        return ITimeEstimate.Status.PAST;
    }

    @Override
    public double getTime(KB kb, OccAgent agent, DoubleSupplier getTransportDepartTimeRem) {
        Elevator elev = this.d_level.getElevator();
        BooleanSupplier testInside = () -> agent.getOcc().curNode.getElevatorLevel() != null && agent.getOcc().curNode.getElevatorLevel().getElevator() == elev;
        double currTime = kb.getCurrentSimTime();
        switch (elev.getState()) {
            case READY: {
                double tReady = Math.max(currTime, this.d_level.tFirstAvailable);
                if (elev.getCurrentLevel() == this.d_level) {
                    return tReady + this.d_level.openTime;
                }
                return tReady + elev.getCurrentLevel().getTravelTimeTot(this.d_level);
            }
            case AT_FLOOR: {
                assert (elev.getCurrentLevel() != this.d_level) : "Elevator doors should already be open at the active level";
                if (elev.getCurrentLevel() == this.d_level) {
                    return Double.NEGATIVE_INFINITY;
                }
                DoubleSupplier departTime = getTransportDepartTimeRem != null && testInside.getAsBoolean() ? getTransportDepartTimeRem : null;
                double tDischarged = this.getDischargeEndTime(kb, elev, departTime);
                return Math.max(tDischarged, this.d_level.tFirstAvailable) + elev.getCurrentLevel().getTravelTimeTot(this.d_level);
            }
            case MOVING_TO_FLOOR: {
                if (elev.getTargetLevel() == this.d_level) {
                    return currTime + elev.getTimeToRelease();
                }
                double dischargeTime = testInside.getAsBoolean() ? elev.getOpenTime() : elev.getDischargeTimeEstimate(kb);
                double tReady = Math.max(currTime + elev.getTimeToRelease() + dischargeTime, this.d_level.tFirstAvailable);
                return tReady + elev.getTargetLevel().getTravelTimeTot(this.d_level);
            }
        }
        assert (false);
        return Double.NEGATIVE_INFINITY;
    }

    private double getDischargeEndTime(KB kb, Elevator elev, DoubleSupplier getTransportDepartTimeRem) {
        if (getTransportDepartTimeRem != null) {
            double minTime = elev.getAtFloorStartTime() + elev.getOpenTime();
            double departTime = kb.getCurrentSimTime() + getTransportDepartTimeRem.getAsDouble();
            return Math.max(minTime, departTime);
        }
        double dischargeTime = elev.getDischargeTimeEstimate(kb);
        return Math.max(elev.getAtFloorStartTime() + dischargeTime, kb.getCurrentSimTime());
    }

    public String toString() {
        return "TimeEstimate for " + String.valueOf(this.d_level);
    }
}

