/*
 * Decompiled with CFR 0.152.
 */
package inferno.elevator;

import common.data.ElevatorType;
import common.data.IElevatorTimingModel;
import inferno.data2.ANode;
import inferno.data2.DoorDir;
import inferno.data2.Occupant;
import inferno.data2.TriPoint;
import inferno.elevator.ElevatorLevel;
import inferno.elevator.ElevatorLevelPairs;
import inferno.elevator.ElevatorUtil;
import inferno.elevator.IElevatorSorter;
import inferno.elevator.ITimeEstimate;
import inferno.elevator.PrioritySorter;
import inferno.sim.KB;
import inferno.sim.KnownFuncs;
import inferno.sim.OccAgent;
import inferno.sim.path.DoorQueueEstimate;
import inferno.sim.steering.PathFollow;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import thunderheadeng.geometry.Util;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.util.theUtil;

public class Elevator
implements Serializable {
    private static final long serialVersionUID = 1L;
    private ElevatorState d_state;
    private final String d_name;
    private final ANode d_initNode;
    private final Map<Integer, ElevatorLevel> d_outOfServiceLevels;
    private final Map<Integer, ElevatorLevel> d_inServiceLevels;
    private final ArrayList<ElevatorLevel> d_allLevels;
    private final Map<ElevatorLevel, ElevatorLevel> d_maxTravelTimes;
    private final ANode d_travelingNode;
    private ElevatorLevel d_currentLevel;
    private ElevatorLevel d_activeLevel;
    private final IElevatorTimingModel d_timingModel;
    private boolean d_dischargeActive;
    private boolean d_pickupActive;
    private double d_tRemTravel;
    private double d_lastVel = 0.0;
    private double d_tDoorsClose;
    private double d_tAtFloorStarted = Double.NEGATIVE_INFINITY;
    private final boolean d_isDoubleDeck;
    private ElevatorLevelPairs d_levelPairs;
    private double d_openDelay;
    private double d_closeDelay;
    private double d_tLastUpdate;
    private double d_rFactor;
    private double d_maxDensity;
    private Vector3d d_initOffset;
    private final double d_callDistance;
    private final double d_detectEnteringOccDist;
    private IElevatorSorter d_prioritySorter;
    private final ElevatorType d_type;
    private Direction lastMovingTravelDir = Direction.SAME;

    public Elevator(String name, ElevatorType type, ANode travelingNode, double openDelay, double closeDelay, double rFactor, double maxDensity, ANode initNode, double callDistance, boolean isDoubleDeck, IElevatorTimingModel timingModel) {
        this.d_allLevels = new ArrayList();
        this.d_maxTravelTimes = new IdentityHashMap<ElevatorLevel, ElevatorLevel>();
        this.d_name = name;
        this.d_type = type;
        this.d_travelingNode = travelingNode;
        this.d_openDelay = openDelay;
        this.d_closeDelay = closeDelay;
        this.d_rFactor = rFactor;
        this.d_maxDensity = maxDensity;
        this.d_initNode = initNode;
        this.d_timingModel = timingModel;
        this.d_isDoubleDeck = isDoubleDeck;
        this.d_initOffset = ElevatorUtil.getTeleportVector(this.d_travelingNode, this.d_initNode);
        this.d_callDistance = callDistance;
        this.d_prioritySorter = new PrioritySorter(Collections.EMPTY_LIST);
        this.d_detectEnteringOccDist = 7.0;
        this.d_outOfServiceLevels = new LinkedHashMap<Integer, ElevatorLevel>();
        this.d_inServiceLevels = new LinkedHashMap<Integer, ElevatorLevel>();
        this.setActiveLevel(null);
        this.d_state = ElevatorState.READY;
        this.d_dischargeActive = false;
        this.d_pickupActive = false;
        this.d_tLastUpdate = Double.NaN;
    }

    private void readObject(ObjectInputStream in) throws ClassNotFoundException, IOException {
        in.defaultReadObject();
        this.d_outOfServiceLevels.values().forEach(l -> l.setElevator(this));
        this.d_inServiceLevels.values().forEach(l -> l.setElevator(this));
    }

    public void init() {
        ElevatorLevel initLevel = this.d_initNode.getElevatorLevel();
        for (ElevatorLevel elevLvl : this.d_allLevels) {
            if (this.d_levelPairs.isUpperLevel(elevLvl)) {
                initLevel = this.d_levelPairs.getUpperLevel(initLevel);
            }
            this.configureElevatorNode(elevLvl.pickupNode, this.d_rFactor);
        }
        this.d_currentLevel = this.d_initNode.getElevatorLevel();
        assert (this.d_state == ElevatorState.READY);
        this.setDoorTimes(null);
    }

    public void endInit() {
        this.d_allLevels.trimToSize();
        Collections.sort(this.d_allLevels, (l1, l2) -> Integer.compare(l1.levelId, l2.levelId));
        this.updateLevelPairs();
        this.updateElevatorPos(this.d_initOffset);
        this.updateMaxTravelTimes();
    }

    private void updateMaxTravelTimes() {
        this.d_maxTravelTimes.clear();
        for (int m = 0; m < this.d_allLevels.size(); ++m) {
            ElevatorLevel src = this.d_allLevels.get(m);
            ElevatorLevel farthest = this.d_allLevels.stream().filter(l -> l != src).max((l1, l2) -> {
                double t1 = src.getTravelTimeTot((ElevatorLevel)l1);
                double t2 = src.getTravelTimeTot((ElevatorLevel)l2);
                return Double.compare(t1, t2);
            }).orElse(null);
            if (farthest == null && this.d_allLevels.size() == 1) {
                farthest = src;
            }
            this.d_maxTravelTimes.put(src, farthest);
        }
    }

    public ElevatorLevel getMaxTravelTimeTarget(ElevatorLevel source) {
        return this.d_maxTravelTimes.get(source);
    }

    public double getDischargeTimeEstimate(KB kb) {
        Elevator elev = this;
        double flowrate = 0.0;
        for (ANode door : elev.getTravelingNode().getDoors()) {
            ANode destNode = door.doorQueue.getAdjNode(elev.getTravelingNode());
            DoorDir dir = door.doorQueue.getDir(destNode);
            flowrate += door.doorQueue.getNominalFlowrate(kb, dir);
        }
        if (flowrate == 0.0) {
            return Double.POSITIVE_INFINITY;
        }
        int occCount = elev.getNominalLoad();
        double t = (double)occCount / flowrate;
        return Math.max(t, elev.getOpenTime());
    }

    public void update(KB kb) {
        double t = kb.getCurrentSimTime();
        if (Double.isNaN(this.d_tLastUpdate)) {
            this.d_tLastUpdate = t;
        }
        assert (this.d_tLastUpdate <= t);
        this.updateLevelsInService(kb);
        this.updateState(kb);
    }

    public void addLevel(ElevatorLevel elevLvl) {
        assert (elevLvl.getElevator() == null || elevLvl.getElevator() == this);
        elevLvl.setElevator(this);
        if (elevLvl.tFirstAvailable <= 0.0) {
            this.d_inServiceLevels.put(elevLvl.levelId, elevLvl);
        } else {
            this.d_outOfServiceLevels.put(elevLvl.levelId, elevLvl);
        }
        this.d_allLevels.add(elevLvl);
    }

    public void addLevels(List<ElevatorLevel> levels) {
        for (ElevatorLevel level : levels) {
            this.addLevel(level);
        }
    }

    public ElevatorLevel getCurrentLevel() {
        return this.d_currentLevel;
    }

    public String getName() {
        return this.d_name;
    }

    public ElevatorState getState() {
        return this.d_state;
    }

    public ElevatorLevel getLevel(int levelId) {
        Integer iid = levelId;
        ElevatorLevel level = this.d_inServiceLevels.get(iid);
        if (level != null) {
            return level;
        }
        return this.d_outOfServiceLevels.get(iid);
    }

    public List<ElevatorLevel> getLevels() {
        return this.d_allLevels;
    }

    private void configureElevatorNode(ANode node, Double szFactor) {
        node.setRadiusModifier(szFactor);
        int n = this.getNominalLoad();
        node.setMaxOccupants(n, false);
    }

    public boolean getDischargeActive() {
        return this.d_dischargeActive;
    }

    public double getOpenTime() {
        return this.d_openDelay;
    }

    public double getCloseDelay() {
        return this.d_closeDelay;
    }

    public double getSizeFactor() {
        return this.d_rFactor;
    }

    public double getMaxDensity() {
        return this.d_maxDensity;
    }

    public double getCallDistance() {
        return this.d_callDistance;
    }

    public ANode getInitNode() {
        return this.d_initNode;
    }

    public int getNominalLoad() {
        return Math.max(1, KnownFuncs.maxPersons(this.d_travelingNode.getArea(), this.d_maxDensity));
    }

    public boolean isDoubleDeck() {
        return this.d_isDoubleDeck;
    }

    public ElevatorLevel getUpperLevelFor(ElevatorLevel level) {
        if (!this.isDoubleDeck()) {
            return level;
        }
        return this.getDoubleDeckLevelPairs().isUpperLevel(level) ? level : this.d_levelPairs.getUpperLevel(level);
    }

    public ElevatorLevel getLowerLevelFor(ElevatorLevel level) {
        if (!this.isDoubleDeck()) {
            return level;
        }
        return this.getDoubleDeckLevelPairs().isLowerLevel(level) ? level : this.d_levelPairs.getLowerLevel(level);
    }

    public ElevatorLevel getActiveLevel() {
        return this.d_activeLevel;
    }

    public ElevatorLevel getTargetLevel() {
        return this.d_activeLevel;
    }

    private ElevatorLevel pollNextDischargeLevel() {
        ElevatorLevel upper = this.getUpperLevelFor(this.d_activeLevel);
        if (this.d_activeLevel != null) {
            assert (!this.d_activeLevel.isDischargeRequested() && !upper.isDischargeRequested());
            this.d_activeLevel.clearCall();
            if (upper != this.d_activeLevel) {
                upper.clearCall();
            }
        }
        ElevatorLevel result = this.d_inServiceLevels.values().stream().filter(level -> level.isDischargeRequested()).min(this.d_prioritySorter).map(this::getLowerLevelFor).orElse(null);
        return result;
    }

    public ANode getTravelingNode() {
        return this.d_travelingNode;
    }

    public ElevatorLevelPairs getDoubleDeckLevelPairs() {
        return this.d_levelPairs;
    }

    private void beginState(KB kb, ElevatorState state) {
        this.d_state = state;
        double t = kb.getCurrentSimTime();
        double dt = Double.isNaN(this.d_tLastUpdate) ? t : t - this.d_tLastUpdate;
        switch (state.ordinal()) {
            case 1: {
                if (this.d_pickupActive) {
                    this.setTimesForBeginService(kb.getCurrentSimTime(), this.getMovingToTime(true));
                }
                if (!this.d_dischargeActive) break;
                ElevatorLevel dischargeLevel = this.pollNextDischargeLevel();
                if (dischargeLevel != null) {
                    this.setActiveLevel(dischargeLevel);
                    this.d_activeLevel.isDischargeLevel = true;
                    double travelTime = this.getMovingToTime(true);
                    this.setTimesForBeginService(kb.getCurrentSimTime(), travelTime);
                    break;
                }
                this.beginState(kb, ElevatorState.READY);
                break;
            }
            case 2: {
                this.d_tAtFloorStarted = kb.getCurrentSimTime();
                this.d_currentLevel = this.d_activeLevel;
                this.setDoorTimes(null);
                Vector3d offset = this.getElevatorOffset(dt);
                this.updateOccupantLoc(offset);
                this.updateElevatorPos(offset);
                this.d_lastVel = 0.0;
                this.d_tDoorsClose = kb.getCurrentSimTime() + this.d_openDelay;
                if (!this.d_dischargeActive) break;
                this.performDischarge(kb);
                break;
            }
            case 0: {
                this.setDoorTimes(null);
                this.setActiveLevel(null);
                this.d_pickupActive = false;
                this.d_dischargeActive = false;
                break;
            }
        }
    }

    private void updateDoorsClosed(KB kb) {
        double tEntered = this.detectOccEntered(this.d_activeLevel);
        double tExited = this.d_activeLevel.pickupNode.getTimeLastPersonExited();
        if (this.isDoubleDeck()) {
            tEntered = Math.max(tEntered, this.detectOccEntered(this.d_levelPairs.getUpperLevel(this.d_activeLevel)));
            tExited = Math.max(tExited, this.d_levelPairs.getUpperLevel((ElevatorLevel)this.d_activeLevel).pickupNode.getTimeLastPersonExited());
        }
        double tLastAction = Math.max(tEntered, tExited);
        this.d_tDoorsClose = Math.max(this.d_tDoorsClose, tLastAction + this.d_closeDelay);
        double tEntering = this.detectOccEntering(kb);
        this.d_tDoorsClose = Math.max(this.d_tDoorsClose, tEntering + this.d_closeDelay);
        int nominalLoad = KnownFuncs.maxPersons(this.d_activeLevel.pickupNode.getArea(), this.d_maxDensity);
        ElevatorUtil.processLevelForPickup(this.d_activeLevel, nominalLoad);
        ElevatorLevel upperLevel = this.getUpperLevelFor(this.d_activeLevel);
        if (upperLevel != this.d_activeLevel) {
            ElevatorUtil.processLevelForPickup(upperLevel, nominalLoad);
        }
    }

    private void updateState(KB kb) {
        double t = kb.getCurrentSimTime();
        double dt = Double.isNaN(this.d_tLastUpdate) ? t : t - this.d_tLastUpdate;
        this.d_tLastUpdate = t;
        switch (this.d_state.ordinal()) {
            case 2: {
                if (this.d_pickupActive) {
                    boolean dischargeRequested;
                    ElevatorLevel upperLevel = this.getUpperLevelFor(this.d_activeLevel);
                    boolean bl = dischargeRequested = this.d_activeLevel.isDischargeRequested() || upperLevel.isDischargeRequested();
                    if (dischargeRequested) {
                        this.d_pickupActive = false;
                        this.d_dischargeActive = true;
                    }
                }
                if (this.d_pickupActive) {
                    this.updateDoorsClosed(kb);
                    if (!theUtil.ge(kb.getCurrentSimTime(), this.d_tDoorsClose, 1.0E-6)) break;
                    this.d_dischargeActive = true;
                    this.d_pickupActive = false;
                    this.beginState(kb, ElevatorState.MOVING_TO_FLOOR);
                    break;
                }
                if (!this.d_dischargeActive) break;
                if (this.isDischargeFinished(kb, this.d_currentLevel)) {
                    this.d_currentLevel.isDischargeLevel = false;
                    if (this.getCurrentUsage().size() > 0) {
                        this.updateDoorsClosed(kb);
                        if (theUtil.le(kb.getCurrentSimTime(), this.d_tDoorsClose, 1.0E-6)) {
                            this.d_pickupActive = true;
                            this.d_dischargeActive = false;
                            this.beginState(kb, ElevatorState.AT_FLOOR);
                            break;
                        }
                        this.beginState(kb, ElevatorState.MOVING_TO_FLOOR);
                        break;
                    }
                    this.beginState(kb, ElevatorState.READY);
                    break;
                }
                if (!theUtil.gt(kb.getCurrentSimTime(), this.d_tDoorsClose, 1.0E-6) || !this.isLevelClosed(this.d_currentLevel)) break;
                this.beginState(kb, ElevatorState.READY);
                break;
            }
            case 1: {
                this.d_tRemTravel -= dt;
                Vector3d offset = this.getElevatorOffset(dt);
                this.d_lastVel = offset.length() > 0.0 ? offset.length() / dt : 0.0;
                this.updateOccupantLoc(offset);
                this.updateElevatorPos(offset);
                if (!(this.d_tRemTravel <= 0.0)) break;
                this.beginState(kb, ElevatorState.AT_FLOOR);
                break;
            }
        }
    }

    private boolean isDischargeFinished(KB kb, ElevatorLevel dischargeLevel) {
        boolean dischargeRequested = dischargeLevel.isDischargeRequested() || this.getUpperLevelFor(dischargeLevel).isDischargeRequested();
        dischargeLevel.clearRequestedDischarge();
        this.getUpperLevelFor(dischargeLevel).clearRequestedDischarge();
        return !dischargeRequested;
    }

    private boolean isLevelClosed(ElevatorLevel elevatorLevel) {
        ElevatorLevel upperLevel = this.getUpperLevelFor(elevatorLevel);
        return ElevatorUtil.isLevelClosed(elevatorLevel) && (elevatorLevel == upperLevel || ElevatorUtil.isLevelClosed(upperLevel));
    }

    private void updateLevelsInService(KB kb) {
        double t = kb.getCurrentSimTime();
        LinkedHashMap<Integer, ElevatorLevel> nowInService = Collections.EMPTY_MAP;
        for (ElevatorLevel elevLevel : this.d_outOfServiceLevels.values()) {
            if (!(elevLevel.tFirstAvailable <= t)) continue;
            if (nowInService.isEmpty()) {
                nowInService = new LinkedHashMap<Integer, ElevatorLevel>();
            }
            nowInService.put(elevLevel.levelId, elevLevel);
        }
        if (!nowInService.isEmpty()) {
            this.d_outOfServiceLevels.keySet().removeAll(nowInService.keySet());
            this.d_inServiceLevels.putAll((Map<Integer, ElevatorLevel>)nowInService);
        }
    }

    private void updateElevatorPos(Vector3d offset) {
        if (theUtil.gt(offset.length(), 0.0, 1.0E-6)) {
            offset.add(this.d_travelingNode.getAnimOffset());
            this.d_travelingNode.setAnimationXform(offset, this.d_travelingNode.getAnimRot());
            if (this.isDoubleDeck()) {
                ANode upperNode = this.getUpperLevelFor((ElevatorLevel)this.getDefaultDischargeLevel()).pickupNode;
                upperNode.setAnimationXform(offset, upperNode.getAnimRot());
            }
        }
    }

    private List<OccAgent> getCurrentUsage() {
        ArrayList<OccAgent> occAgents = new ArrayList<OccAgent>();
        for (ElevatorLevel level : this.getLevels()) {
            occAgents.addAll(level.pickupNode.getCurrentUsage());
        }
        return occAgents;
    }

    private Vector3d getElevatorOffset(double dt) {
        Vector3d travelVec = ElevatorUtil.getTeleportVector(this.d_currentLevel.pickupNode, this.d_activeLevel.pickupNode);
        double scale = 0.0;
        if (this.d_state == ElevatorState.MOVING_TO_FLOOR) {
            double intervalTime = this.getMovingToTime(true) - Math.max(0.0, this.d_tRemTravel);
            double timeUntilMove = this.d_currentLevel.closeTime;
            double timeUntilStop = timeUntilMove + this.getMovingToTime(false);
            if (intervalTime > timeUntilMove) {
                if (intervalTime < timeUntilStop) {
                    double dist = this.getTimingModel().getDist(intervalTime - timeUntilMove, travelVec.length());
                    Point3d travelLoc = this.d_travelingNode.getGeometryBounds().getMin();
                    travelLoc.add(this.d_travelingNode.getAnimOffset());
                    Point3d currentLoc = this.d_currentLevel.pickupNode.getGeometryBounds().getMin();
                    Vector3d currentVector = new Vector3d();
                    currentVector.sub(travelLoc, currentLoc);
                    return Util3D.sub(Util3D.scale(Util3D.normalize(travelVec), dist), (Tuple3d)currentVector);
                }
                if (intervalTime < timeUntilStop + dt) {
                    travelVec = new Vector3d(this.d_activeLevel.pickupNode.getGeometryBounds().getMin());
                    Point3d subVec = this.d_travelingNode.getGeometryBounds().getMin();
                    subVec.add(this.d_travelingNode.getAnimOffset());
                    travelVec.sub(subVec);
                    scale = 1.0;
                }
            }
        }
        travelVec = Util3D.scale(travelVec, scale);
        return travelVec;
    }

    public double getAtFloorStartTime() {
        return this.d_tAtFloorStarted;
    }

    public boolean isLevelInService(int levelId) {
        return this.d_inServiceLevels.containsKey(levelId);
    }

    protected void beginPickup(KB kb, int levelId) {
        assert (this.d_state == ElevatorState.READY);
        assert (this.isLevelInService(levelId));
        ElevatorLevel target = this.d_inServiceLevels.get(levelId);
        this.setActiveLevel(this.getLowerLevelFor(target));
        this.d_pickupActive = true;
        this.beginState(kb, ElevatorState.MOVING_TO_FLOOR);
    }

    protected void beginDischarge(KB kb, int levelId) {
        assert (this.d_state == ElevatorState.READY);
        assert (this.isLevelInService(levelId));
        this.d_dischargeActive = true;
        this.beginState(kb, ElevatorState.MOVING_TO_FLOOR);
    }

    protected void changePickupTo(double currentSimTime, int levelId) {
        double arrivedTime;
        assert (this.d_state == ElevatorState.MOVING_TO_FLOOR);
        assert (this.isLevelInService(levelId));
        double intervalTime = this.getMovingToTime(true) - Math.max(0.0, this.d_tRemTravel);
        if (intervalTime > (arrivedTime = this.d_currentLevel.closeTime + this.getMovingToTime(false))) {
            return;
        }
        this.d_pickupActive = true;
        ElevatorLevel prevLvl = this.d_activeLevel;
        ElevatorLevel target = this.d_inServiceLevels.get(levelId);
        this.setActiveLevel(this.getLowerLevelFor(target));
        assert (prevLvl != null);
        if (prevLvl == null) {
            return;
        }
        this.setTimesForBeginService(currentSimTime, this.getMovingToTime(true) - intervalTime);
    }

    private void setDoorTimes(ITimeEstimate timeToActiveOpen) {
        ElevatorLevel activeLevel = null;
        ElevatorLevel activeUpper = null;
        if (this.d_state != ElevatorState.READY) {
            activeLevel = this.d_activeLevel;
            activeUpper = this.getUpperLevelFor(activeLevel);
            if (timeToActiveOpen != null) {
                activeLevel.pickupNode.setTransporting(timeToActiveOpen);
                activeUpper.pickupNode.setTransporting(timeToActiveOpen);
            } else {
                ElevatorUtil.processLevelForPickup(activeLevel, this.getNominalLoad());
                if (activeUpper != activeLevel) {
                    ElevatorUtil.processLevelForPickup(activeUpper, this.getNominalLoad());
                }
            }
        }
        for (ElevatorLevel level : this.getLevels()) {
            if (level == activeLevel || level == activeUpper) continue;
            level.pickupNode.setDoorsTransporting(ElevatorUtil.getDefaultTimeEstimate(level));
        }
    }

    protected double getPickupProgress() {
        assert (this.d_state == ElevatorState.MOVING_TO_FLOOR && this.d_pickupActive);
        double pickupTime = this.getMovingToTime(true);
        return (pickupTime - this.d_tRemTravel) / pickupTime;
    }

    public double getTimeToRelease() {
        assert (this.isRemTravelConsistent());
        return Math.max(0.0, this.d_tRemTravel);
    }

    private boolean isRemTravelConsistent() {
        switch (this.d_state.ordinal()) {
            case 0: 
            case 2: {
                return this.d_tRemTravel <= 0.0;
            }
            case 1: {
                return this.d_tRemTravel > 0.0;
            }
        }
        return false;
    }

    public boolean isOpeningForPickup() {
        return this.d_state == ElevatorState.MOVING_TO_FLOOR && this.d_tRemTravel < this.d_activeLevel.openTime;
    }

    public boolean isOpen() {
        return this.d_state == ElevatorState.AT_FLOOR;
    }

    private double detectOccEntered(ElevatorLevel level) {
        return level.pickupNode.getTimeLastPersonEntered();
    }

    private double detectOccEntering(KB kb) {
        if (!this.d_activeLevel.pickupNode.getEnteringAgents().isEmpty()) {
            return kb.getCurrentSimTime();
        }
        if (!this.d_activeLevel.pickupNode.hasRoomForOneMore(kb)) {
            return Double.NEGATIVE_INFINITY;
        }
        for (ANode door : this.d_activeLevel.pickupNode.getDoors()) {
            DoorDir enterDir;
            DoorQueueEstimate.OccQueue queue;
            DoorQueueEstimate dqueue;
            if (door.isInternalDoor() || door.isExitDoor() || (dqueue = kb.getPathEstimates().getQueue(door)) == null || (queue = dqueue.getQueue(enterDir = door.doorQueue.getDir(this.d_activeLevel.pickupNode))).size() == 0) continue;
            DoorQueueEstimate.OccDist od = queue.get(0);
            if (od.dist > this.d_detectEnteringOccDist) continue;
            if (!kb.getParams().reactive_steering && od.occ.getOcc().formationLeader == null) {
                return kb.getCurrentSimTime();
            }
            int queueBegin = queue.getQueueBegin();
            if (queueBegin != -1 && queueBegin <= 0) continue;
            return kb.getCurrentSimTime();
        }
        return Double.NEGATIVE_INFINITY;
    }

    private void updateOccupantLoc(Vector3d elevatorOffset) {
        Consumer<Vector3d> processLevel = offset -> {
            for (OccAgent agent : this.getCurrentUsage()) {
                if (agent.getOcc().xform == null) {
                    agent.getOcc().xform = Util.translateMat(offset.x, offset.y, offset.z);
                    continue;
                }
                Util3D.xform(agent.getOcc().xform, offset);
                Vector3d transVector = new Vector3d();
                agent.getOcc().xform.get(transVector);
                transVector.add((Tuple3d)offset);
                agent.getOcc().xform = Util.translateMat(transVector.x, transVector.y, transVector.z);
            }
        };
        processLevel.accept(elevatorOffset);
    }

    private void performDischarge(KB kb) {
        ANode discharge = this.d_currentLevel.pickupNode;
        Consumer<ANode> performDischarge = dischargeNode -> {
            LinkedHashSet<OccAgent> occsToMove = new LinkedHashSet<OccAgent>(this.getCurrentUsage());
            for (OccAgent oa : occsToMove) {
                if (this.d_levelPairs.isUpperLevel(oa.getOcc().curNode.getElevatorLevel())) {
                    dischargeNode = this.getUpperLevelFor((ElevatorLevel)dischargeNode.getElevatorLevel()).pickupNode;
                }
                Occupant occ = oa.getOcc();
                if (occ.xform != null) {
                    occ.loc = Util3D.xform(occ.xform, occ.loc);
                    occ.xform = null;
                }
                occ.tri = kb.getMesh().getTri(occ.loc);
                occ.displayLoc = new TriPoint(occ.tri, occ.loc);
                oa.moveToNode(kb, null, (ANode)dischargeNode, kb.getCurrentSimTime());
                PathFollow pathfollow = oa.getPathFollow();
                if (pathfollow == null) continue;
                pathfollow.getPathPlanner().setRoom((ANode)dischargeNode, oa);
            }
        };
        performDischarge.accept(discharge);
    }

    private double getMovingToTime(boolean total) {
        if (this.d_currentLevel == this.d_activeLevel) {
            return total ? this.d_currentLevel.openTime : 0.0;
        }
        return total ? this.d_currentLevel.getTravelTimeTot(this.d_activeLevel) : this.d_currentLevel.getTravelTime(this.d_activeLevel);
    }

    private void setTimesForBeginService(double currentSimTime, double pickupTimeRemaining) {
        double tPickupOpen = currentSimTime + pickupTimeRemaining;
        ITimeEstimate.Specific pickupOpenEst = new ITimeEstimate.Specific(tPickupOpen);
        this.setDoorTimes(pickupOpenEst);
        this.d_tRemTravel = pickupTimeRemaining;
    }

    public void setFloorPriority(IElevatorSorter prioritySorter) {
        this.d_prioritySorter = prioritySorter;
    }

    public List<Integer> getTopPriorityFloors() {
        return Collections.unmodifiableList(this.d_prioritySorter.getPriorityFloors());
    }

    public Comparator<ElevatorLevel> getFloorSorter() {
        return this.d_prioritySorter;
    }

    private void updateLevelPairs() {
        this.d_levelPairs = new ElevatorLevelPairs();
        if (!this.isDoubleDeck()) {
            return;
        }
        ArrayList<ElevatorLevel> levels = new ArrayList<ElevatorLevel>(this.getLevels());
        assert (levels.size() % 2 == 0);
        levels.sort((l1, l2) -> {
            double z1 = l1.pickupNode.getGeometryBounds().getMinZ();
            double z2 = l2.pickupNode.getGeometryBounds().getMinZ();
            return Double.compare(z1, z2);
        });
        for (int i = 0; i < levels.size(); i += 2) {
            this.d_levelPairs.put(levels.get(i), levels.get(i + 1));
        }
    }

    public Collection<ElevatorLevel> getInServiceLevels() {
        return this.d_inServiceLevels.values();
    }

    public Collection<ElevatorLevel> getOutOfServiceLevels() {
        return this.d_outOfServiceLevels.values();
    }

    public ElevatorType getType() {
        return this.d_type;
    }

    public IElevatorTimingModel getTimingModel() {
        return this.d_timingModel;
    }

    public Direction getLastMovingTravelDir() {
        return this.lastMovingTravelDir;
    }

    private void setActiveLevel(ElevatorLevel newActiveLevel) {
        this.d_activeLevel = newActiveLevel;
        if (this.d_activeLevel != null && this.d_currentLevel != null) {
            Direction currentTravelDir = this.getDirection(this.d_currentLevel.levelId, this.d_activeLevel.levelId);
            if (currentTravelDir.moving) {
                this.lastMovingTravelDir = currentTravelDir;
            }
            assert (currentTravelDir != Direction.INDETERMINATE);
        }
    }

    public ElevatorLevel getDefaultDischargeLevel() {
        return this.getTravelingNode().getElevatorLevel();
    }

    public Direction getDirection(int from, int to) {
        if (from == to) {
            return Direction.SAME;
        }
        ElevatorLevel fromLevel = this.getLevel(from);
        if (fromLevel == null) {
            return Direction.INDETERMINATE;
        }
        ElevatorLevel toLevel = this.getLevel(to);
        if (toLevel == null) {
            return Direction.INDETERMINATE;
        }
        return fromLevel.pickupNode.getGeometryBounds().getMinZ() <= toLevel.pickupNode.getGeometryBounds().getMinZ() ? Direction.UP : Direction.DOWN;
    }

    public ElevatorLevel getNextInserviceLevel() {
        int upper;
        Direction travelDirection = this.getDirection(this.d_currentLevel.levelId, this.d_activeLevel == null ? this.d_currentLevel.levelId : this.d_activeLevel.levelId);
        if (!travelDirection.moving) {
            return this.d_currentLevel;
        }
        ArrayList<ElevatorLevel> sortedInServiceLevels = new ArrayList<ElevatorLevel>(theUtil.filter(this.d_allLevels, l -> this.isLevelInService(l.levelId)));
        Point3d currentLoc = this.d_travelingNode.getGeometryBounds().getMin();
        currentLoc.add(this.d_travelingNode.getAnimOffset());
        double currentZ = currentLoc.getZ();
        int lower = 0;
        int mid = upper = sortedInServiceLevels.size() - 1;
        while ((lower + upper) / 2 != mid) {
            mid = (lower + upper) / 2;
            ElevatorLevel level = sortedInServiceLevels.get(mid);
            double levelZ = level.pickupNode.getGeometryBounds().getMinZ();
            double diff = levelZ - currentZ;
            if (theUtil.ge(diff, 0.0, 1.0E-6)) {
                upper = mid;
                continue;
            }
            if (!theUtil.le(diff, 0.0, 1.0E-6)) continue;
            lower = mid;
        }
        if (travelDirection.equals((Object)Direction.UP)) {
            return sortedInServiceLevels.get(upper);
        }
        if (travelDirection.equals((Object)Direction.DOWN)) {
            return sortedInServiceLevels.get(lower);
        }
        return this.d_currentLevel;
    }

    public boolean canStop(ElevatorLevel level) {
        Point3d travelingPos = this.d_travelingNode.getGeometryBounds().getMin();
        travelingPos.add(this.d_travelingNode.getAnimOffset());
        Point3d targetPos = level.pickupNode.getGeometryBounds().getMin();
        return this.getTimingModel().canStop(travelingPos.distance(targetPos), this.d_lastVel);
    }

    public static enum Direction {
        UP(true),
        DOWN(true),
        SAME(false),
        INDETERMINATE(false);

        public final boolean moving;

        private Direction(boolean moving) {
            this.moving = moving;
        }

        public Direction opposite() {
            switch (this.ordinal()) {
                case 0: {
                    return DOWN;
                }
                case 1: {
                    return UP;
                }
            }
            return SAME;
        }
    }

    public static enum ElevatorState {
        READY,
        MOVING_TO_FLOOR,
        AT_FLOOR;

    }
}

