/*
 * Decompiled with CFR 0.152.
 */
package inferno.data2.ai;

import common.data.WaitMode;
import inferno.data2.Tag;
import inferno.data2.ai.GoalUtil;
import inferno.data2.ai.IIdleGoal;
import inferno.data2.ai.IIdleGoalInstance;
import inferno.data2.ai.IProgressNote;
import inferno.data2.seekarea.ISeekArea;
import inferno.sim.DoorQueue;
import inferno.sim.KB;
import inferno.sim.OccAgent;
import inferno.sim.occsource.OccSource;
import inferno.sim.steering.ISteeringBehavior;
import inferno.sim.steering.SteerUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Objects;
import java.util.function.Predicate;
import thunderheadeng.util.Pair;
import thunderheadeng.util.Predicates;
import thunderheadeng.util.theUtil;

public class WaitUntilTaggedGoal
implements IIdleGoal,
Serializable {
    static final long serialVersionUID = 1L;
    public final Predicate<OccSource> occSourceFilter;
    public final Predicate<OccAgent> occFilter;
    public final Predicate<Tag> tagFilter;
    public final WaitMode mode;
    private double d_calcTime = Double.NEGATIVE_INFINITY;
    private boolean d_finished = false;

    public WaitUntilTaggedGoal(WaitMode mode, Predicate<OccSource> occSourceFilter, Predicate<OccAgent> occFilter, Predicate<Tag> stateFilter) {
        this.mode = mode;
        this.occSourceFilter = occSourceFilter;
        this.occFilter = occFilter;
        this.tagFilter = stateFilter;
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof WaitUntilTaggedGoal && ((WaitUntilTaggedGoal)obj).mode == this.mode && ((WaitUntilTaggedGoal)obj).occSourceFilter.equals(this.occSourceFilter) && ((WaitUntilTaggedGoal)obj).occFilter.equals(this.occFilter) && ((WaitUntilTaggedGoal)obj).tagFilter.equals(this.tagFilter);
    }

    public int hashCode() {
        return 0x5483FE5 ^ Objects.hash(this.occSourceFilter, this.occFilter, this.tagFilter, this.mode);
    }

    @Override
    public boolean isImmediate() {
        return false;
    }

    @Override
    public IIdleGoalInstance begin(KB kb, OccAgent agent) {
        return new Instance(this);
    }

    public static class Instance
    implements IIdleGoalInstance {
        private static final long serialVersionUID = 4771359501271989083L;
        private WaitUntilTaggedGoal waitUntilTaggedGoal;

        public Instance(WaitUntilTaggedGoal waitUntilTaggedGoal) {
            this.waitUntilTaggedGoal = waitUntilTaggedGoal;
        }

        @Override
        public WaitUntilTaggedGoal getGoal() {
            return this.waitUntilTaggedGoal;
        }

        @Override
        public ISteeringBehavior generateSteeringBehavior(KB kb, OccAgent agent) {
            return SteerUtil.newIdleSteer(kb, agent, GoalUtil.toIdleParams(this.waitUntilTaggedGoal.mode));
        }

        @Override
        public boolean canInterrupt(KB kb, OccAgent agent) {
            return true;
        }

        @Override
        public Pair<ISeekArea, Serializable> interrupt(KB kb, OccAgent agent) {
            return new Pair<Object, Instance>(null, this);
        }

        @Override
        public boolean resume(KB kb, OccAgent agent, Object resumePacket) {
            return true;
        }

        @Override
        public void doorCrossed(OccAgent agent, DoorQueue door) {
        }

        @Override
        public IProgressNote getProgress(KB kb, OccAgent occ) {
            return IProgressNote.NOT_PROGRESSING;
        }

        @Override
        public synchronized void preMove(KB kb, OccAgent agent, double dt) {
            if (this.waitUntilTaggedGoal.d_calcTime == kb.getCurrentSimTime()) {
                return;
            }
            this.waitUntilTaggedGoal.d_calcTime = kb.getCurrentSimTime();
            this.waitUntilTaggedGoal.d_finished = this.calcFinished(kb);
        }

        @Override
        public boolean isReached(KB kb, OccAgent occ) {
            return this.waitUntilTaggedGoal.d_finished;
        }

        @Override
        public double getEndTime(KB kb) {
            return Double.POSITIVE_INFINITY;
        }

        private boolean calcFinished(KB kb) {
            double simTime = kb.getCurrentSimTime();
            if (!Predicates.alwaysFalse(this.waitUntilTaggedGoal.occSourceFilter)) {
                for (OccSource os : theUtil.filter(kb.getOccSources(), this.waitUntilTaggedGoal.occSourceFilter)) {
                    if (os.isFinished(simTime)) continue;
                    return false;
                }
            }
            if (Predicates.alwaysTrue(this.waitUntilTaggedGoal.occFilter)) {
                BitSet taggedAgents = new BitSet();
                for (Tag tag : kb.getTags()) {
                    if (!this.waitUntilTaggedGoal.tagFilter.test(tag)) continue;
                    tag.getTaggedAgents().forEach(taggedAgents::set);
                }
                return taggedAgents.cardinality() == kb.getAllAgentsEver().size();
            }
            if (!Predicates.alwaysFalse(this.waitUntilTaggedGoal.occFilter)) {
                ArrayList<Tag> tags = new ArrayList<Tag>(theUtil.filter(kb.getTags(), this.waitUntilTaggedGoal.tagFilter));
                for (OccAgent agent : theUtil.filter(kb.getAllAgentsEver(), this.waitUntilTaggedGoal.occFilter)) {
                    if (!tags.stream().noneMatch(t -> t.isTagged(agent))) continue;
                    return false;
                }
            }
            return true;
        }
    }
}

