/*
 * Decompiled with CFR 0.152.
 */
package inferno.data2.ai;

import common.data.WaitMode;
import inferno.data2.PredefTag;
import inferno.data2.ai.GoalUtil;
import inferno.data2.ai.IIdleGoal;
import inferno.data2.ai.IIdleGoalInstance;
import inferno.data2.ai.IProgressNote;
import inferno.data2.seekarea.ISeekArea;
import inferno.sim.DoorQueue;
import inferno.sim.KB;
import inferno.sim.OccAgent;
import inferno.sim.steering.ISteeringBehavior;
import inferno.sim.steering.SteerUtil;
import java.io.Serializable;
import java.util.Objects;
import thunderheadeng.util.Pair;

public class WaitUntilEndGoal
implements IIdleGoal,
Serializable {
    static final long serialVersionUID = 1L;
    public final WaitMode mode;
    private double d_calcTime = Double.NEGATIVE_INFINITY;
    private boolean d_finished = false;

    public WaitUntilEndGoal(WaitMode mode) {
        this.mode = mode;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !obj.getClass().equals(this.getClass())) {
            return false;
        }
        return ((WaitUntilEndGoal)obj).mode == this.mode;
    }

    public int hashCode() {
        return 0xFA73BA3 ^ Objects.hash(this.mode);
    }

    @Override
    public boolean isImmediate() {
        return false;
    }

    @Override
    public IIdleGoalInstance begin(KB kb, OccAgent agent) {
        return new Instance(this);
    }

    public static class Instance
    implements IIdleGoalInstance {
        private static final long serialVersionUID = 4771359501271989083L;
        private WaitUntilEndGoal goal;

        public Instance(WaitUntilEndGoal waitUntilTaggedGoal) {
            this.goal = waitUntilTaggedGoal;
        }

        @Override
        public boolean isAlwaysTerminal() {
            return true;
        }

        @Override
        public WaitUntilEndGoal getGoal() {
            return this.goal;
        }

        @Override
        public boolean isSkippable(KB kb, OccAgent agent) {
            return true;
        }

        @Override
        public ISteeringBehavior generateSteeringBehavior(KB kb, OccAgent agent) {
            return SteerUtil.newIdleSteer(kb, agent, GoalUtil.toIdleParams(this.goal.mode));
        }

        @Override
        public boolean canInterrupt(KB kb, OccAgent agent) {
            return true;
        }

        @Override
        public Pair<ISeekArea, Serializable> interrupt(KB kb, OccAgent agent) {
            return new Pair<Object, Instance>(null, this);
        }

        @Override
        public boolean resume(KB kb, OccAgent agent, Object resumePacket) {
            return true;
        }

        @Override
        public void doorCrossed(OccAgent agent, DoorQueue door) {
        }

        @Override
        public IProgressNote getProgress(KB kb, OccAgent occ) {
            return IProgressNote.NOT_PROGRESSING;
        }

        @Override
        public synchronized void preMove(KB kb, OccAgent agent, double dt) {
            if (this.goal.d_calcTime == kb.getCurrentSimTime()) {
                return;
            }
            this.goal.d_finished = this.calcFinished(kb);
            this.goal.d_calcTime = kb.getCurrentSimTime();
        }

        @Override
        public boolean isReached(KB kb, OccAgent occ) {
            return this.goal.d_finished;
        }

        @Override
        public double getEndTime(KB kb) {
            return Double.POSITIVE_INFINITY;
        }

        private boolean calcFinished(KB kb) {
            double simTime = kb.getCurrentSimTime();
            return kb.getOccSources().stream().allMatch(os -> os.isFinished(simTime)) && kb.getActiveAgents().stream().noneMatch(agent -> agent.getHasMoreToDo(kb));
        }

        @Override
        public ISeekArea end(KB kb, OccAgent occ) {
            kb.tag(PredefTag.REMOVED, occ);
            occ.getOcc().removeWhenFinished = false;
            return IIdleGoalInstance.super.end(kb, occ);
        }
    }
}

