/*
 * Decompiled with CFR 0.152.
 */
package inferno.data2;

import inferno.data2.ANode;
import inferno.data2.DoorGeom;
import inferno.data2.EdgeData;
import inferno.data2.IAgentBodyShape;
import inferno.data2.PolygonShape;
import inferno.data2.SplitDoor;
import inferno.data2.SplitEdge;
import inferno.data2.Tri;
import inferno.data2.TriEdge;
import inferno.data2.TriPoint;
import inferno.data2.Vertex;
import inferno.data2.WingedEdge;
import inferno.data2.WingedEdgeUse;
import inferno.geom.Inter;
import inferno.geom.PreciseGeom;
import inferno.geom.Util;
import inferno.sim.Engine;
import inferno.sim.KB;
import inferno.sim.Param;
import inferno.sim.path.EdgeFilters;
import inferno.sim.path.PathChange;
import inferno.sim.path.PathFilters;
import inferno.util.IdSet;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.PriorityQueue;
import java.util.RandomAccess;
import java.util.Stack;
import java.util.TreeMap;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.DoubleSupplier;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple2d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector2d;
import javax.vecmath.Vector3d;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.Inter2D;
import thunderheadeng.geometry.Inter3D;
import thunderheadeng.geometry.RTree;
import thunderheadeng.geometry.Util2D;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.geometry.search.Containment;
import thunderheadeng.geometry.search.IResult;
import thunderheadeng.geometry.search.ITest;
import thunderheadeng.util.CachedValue;
import thunderheadeng.util.Filters;
import thunderheadeng.util.IdentityHashSet;
import thunderheadeng.util.LinkedIdentityHashMap;
import thunderheadeng.util.LinkedIdentityHashSet;
import thunderheadeng.util.ListMap;
import thunderheadeng.util.Pair;
import thunderheadeng.util.Predicates;
import thunderheadeng.util.mtproc.MTProcessor;
import thunderheadeng.util.theUtil;

public class Mesh
implements Serializable {
    static final long serialVersionUID = 1L;
    private static final Logger LOGGER = Logger.getLogger(Mesh.class.getName());
    private final Param d_param;
    private final Vertex[] d_verts;
    private final WingedEdge[] d_edges;
    private final Tri[] d_tris;
    private final WingedEdge[] d_boundaryEdges;
    private NavigableMap<Double, TrimInfo> d_trimmedMeshes;
    private transient CachedValue<List<Map.Entry<Double, TrimInfo>>> d_cachedTrimmedMeshEntries = new CachedValue();
    private double d_tModified = 0.0;
    private transient RTree<Tri> d_triFinder;
    private transient Double d_cachedModelExtents = null;
    private transient MTProcessor d_mtproc = null;
    private static final double TRI_EPSILON = 1.0E-6;
    private static final Vector3d Z_NEG = new Vector3d(0.0, 0.0, -1.0);
    private static final Point3d ZERO_PT = new Point3d(0.0, 0.0, 0.0);

    public Mesh(Param param, Collection<WingedEdge> edges, Collection<Tri> tris) {
        this.d_param = param;
        LinkedIdentityHashSet<Vertex> verts = new LinkedIdentityHashSet<Vertex>();
        for (WingedEdge edge : edges) {
            verts.add(edge.base.n1);
            verts.add(edge.base.n2);
        }
        for (Tri tri : tris) {
            for (int m = 0; m < 3; ++m) {
                verts.add(tri.v[m]);
            }
        }
        this.d_verts = verts.toArray(new Vertex[verts.size()]);
        Arrays.sort(this.d_verts, Comparator.comparing(v -> v.id));
        this.d_edges = edges.toArray(new WingedEdge[edges.size()]);
        this.d_tris = tris.toArray(new Tri[tris.size()]);
        ArrayList<WingedEdge> boundaryEdges = new ArrayList<WingedEdge>(this.d_edges.length);
        for (WingedEdge edge : this.d_edges) {
            if (!edge.isBoundary()) continue;
            boundaryEdges.add(edge);
        }
        this.d_boundaryEdges = boundaryEdges.toArray(new WingedEdge[boundaryEdges.size()]);
        this.generateTriFinder();
        this.d_trimmedMeshes = new TreeMap<Double, TrimInfo>();
    }

    private MTProcessor getMtProc(KB kb) {
        if (this.d_mtproc == null) {
            this.d_mtproc = new MTProcessor(Engine.getNumProcThreads(), MTProcessor.Schedule.GUIDED, kb.getThreadPool());
        }
        return this.d_mtproc;
    }

    public Param getParam() {
        return this.d_param;
    }

    private void generateTriFinder() {
        this.d_triFinder = new RTree();
        for (Tri tri : this.d_tris) {
            this.d_triFinder.insert(tri.getBoundingBox(), tri);
        }
        AABox modelBounds = this.d_triFinder.getBoundingBox();
        this.d_cachedModelExtents = modelBounds.getMin().distance(modelBounds.getMax());
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        for (Vertex vertex : this.d_verts) {
            vertex.writeAdjacency(out);
        }
        for (Serializable serializable : this.d_tris) {
            ((Tri)serializable).writeAdjacency(out);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        for (Vertex vertex : this.d_verts) {
            vertex.readAdjacency(in);
        }
        for (Serializable serializable : this.d_tris) {
            ((Tri)serializable).readAdjacency(in);
        }
        this.generateTriFinder();
        this.d_cachedTrimmedMeshEntries = new CachedValue();
    }

    public double dtModified() {
        return this.d_tModified;
    }

    public void markModified(double t) {
        this.d_tModified = t;
    }

    public WingedEdge[] getBoundaryEdges() {
        return this.d_boundaryEdges;
    }

    public void initTriFlags(DoubleSupplier getMaxInverseTriSearchDist) {
        double[] searchDistSq = new double[]{Double.NaN};
        ExecutorService es = null;
        for (Tri tri : this.d_tris) {
            if (theUtil.ge0(tri.normal.z, 1.0E-12)) continue;
            tri.flags |= 2;
            if (Double.isNaN(searchDistSq[0])) {
                searchDistSq[0] = getMaxInverseTriSearchDist.getAsDouble();
                searchDistSq[0] = searchDistSq[0] * searchDistSq[0];
            }
            if (es == null) {
                es = Executors.newFixedThreadPool(Engine.getNumProcThreads());
            }
            es.submit(() -> Mesh.markTrisNearInverseTri(tri, searchDistSq[0]));
        }
        if (es != null) {
            es.shutdown();
            try {
                es.awaitTermination(Long.MAX_VALUE, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void markTrisNearInverseTri(Tri seedTri, double searchDistSq) {
        IdentityHashSet closed = new IdentityHashSet();
        closed.add(seedTri);
        ArrayDeque<Tri> open = new ArrayDeque<Tri>();
        open.push(seedTri);
        while (!open.isEmpty()) {
            Tri tri;
            Tri tri2 = tri = (Tri)open.pop();
            synchronized (tri2) {
                tri.flags |= 1;
            }
            for (int m = 0; m < 3; ++m) {
                double distsq;
                WingedEdge edge = tri.eu[m].wedge;
                Tri adjTri = edge.getAdjTri(tri);
                if (adjTri == null || !closed.add(adjTri) || !((distsq = Mesh.distSqToTri(edge, seedTri)) <= searchDistSq)) continue;
                open.push(adjTri);
            }
        }
    }

    private static double distSqToTri(WingedEdge edge, Tri tri) {
        double minDistSq = Double.MAX_VALUE;
        double[] st = new double[2];
        for (int m = 0; m < 3; ++m) {
            WingedEdge tedge = tri.eu[m].wedge;
            if (tedge == edge) {
                return 0.0;
            }
            Inter3D.getNearestTLinesegLineSeg(edge.p1().x, edge.p1().y, 0.0, edge.p2().x, edge.p2().y, 0.0, tedge.p1().x, tedge.p1().y, 0.0, tedge.p2().x, tedge.p2().y, 0.0, 1.0E-9, st);
            Point3d pedge = edge.get(st[0]);
            Point3d ptedge = tedge.get(st[1]);
            double distSq = Util2D.distanceSq(pedge.x, pedge.y, ptedge.x, ptedge.y);
            if (!(distSq < minDistSq)) continue;
            minDistSq = distSq;
        }
        return minDistSq;
    }

    public Tri getTri(Point3d isect, Point3d l1, Point3d l2) {
        TreeMap<Double, TriPoint> isects = new TreeMap<Double, TriPoint>();
        Vector3d lineDir = Inter.normalize(Inter.vector(l1, l2));
        for (Tri tri : this.d_tris) {
            Point3d isectResult = Mesh.lineTriIntersection(l1, lineDir, tri);
            if (isectResult == null) continue;
            TriPoint p = new TriPoint(tri, isectResult);
            isects.put(l1.distanceSquared(isectResult), p);
        }
        if (isects.isEmpty()) {
            return null;
        }
        TriPoint result = (TriPoint)isects.values().iterator().next();
        isect.set(result.p);
        return result.tri;
    }

    public List<Tri> findTris(ITest<AABox> test) {
        return this.findTris(test, Filters.acceptAll(Tri.class));
    }

    public List<Tri> findTris(ITest<AABox> test, final Predicate<Tri> filter) {
        final ArrayList<Tri> result = new ArrayList<Tri>();
        this.d_triFinder.find(test, new IResult<Tri>(){

            @Override
            public void mark(Tri obj, Containment ctmt) {
                if (!filter.test(obj)) {
                    return;
                }
                result.add(obj);
            }
        });
        return result;
    }

    public Collection<WingedEdge> findEdges(ITest<AABox> test) {
        return this.findEdges(test, Filters.acceptAll(WingedEdge.class));
    }

    public Collection<WingedEdge> findEdges(ITest<AABox> test, Predicate<WingedEdge> filter) {
        List<Tri> tris = this.findTris(test);
        IdentityHashSet<WingedEdge> edges = new IdentityHashSet<WingedEdge>();
        AABox bounds = new AABox();
        for (Tri tri : tris) {
            for (int m = 0; m < 3; ++m) {
                WingedEdge edge = tri.eu[m].wedge;
                if (edges.contains(edge) || !filter.test(edge)) continue;
                bounds.reset();
                bounds.add(edge.p1());
                bounds.add(edge.p2());
                if (!test.test((AABox)bounds).positive) continue;
                edges.add(edge);
            }
        }
        return edges;
    }

    public Tri getTri(final Point3d p) {
        final Tri[] result = new Tri[]{null};
        try {
            this.d_triFinder.find(new ITest<AABox>(){

                @Override
                public Containment test(AABox bb) {
                    return bb.contains(p, 1.0E-6) ? Containment.INTERSECTS : Containment.OUTSIDE;
                }
            }, new IResult<Tri>(){

                @Override
                public void mark(Tri obj, Containment ctmt) {
                    assert (ctmt != Containment.INSIDE);
                    double pDist = obj.plane.dot(p);
                    if (Math.abs(pDist) <= 1.0E-6 && obj.containsExact(p)) {
                        result[0] = obj;
                        throw new CancellationException();
                    }
                }
            });
        }
        catch (CancellationException cancellationException) {
            // empty catch block
        }
        return result[0];
    }

    public List<Tri> getTris(final Point3d p) {
        final ArrayList<Tri> tris = new ArrayList<Tri>(2);
        this.d_triFinder.find(new ITest<AABox>(){

            @Override
            public Containment test(AABox bb) {
                return bb.contains(p, 1.0E-6) ? Containment.INTERSECTS : Containment.OUTSIDE;
            }
        }, new IResult<Tri>(){

            @Override
            public void mark(Tri obj, Containment ctmt) {
                assert (ctmt != Containment.INSIDE);
                double pDist = obj.plane.dot(p);
                if (Math.abs(pDist) <= 1.0E-6 && obj.containsExact(p)) {
                    tris.add(obj);
                }
            }
        });
        return tris;
    }

    public List<Tri> getTris(final Point3d p, final double tolerance) {
        final ArrayList<Tri> tris = new ArrayList<Tri>(2);
        this.d_triFinder.find(new ITest<AABox>(){

            @Override
            public Containment test(AABox bb) {
                return bb.contains(p, 1.0E-6) ? Containment.INTERSECTS : Containment.OUTSIDE;
            }
        }, new IResult<Tri>(){

            @Override
            public void mark(Tri obj, Containment ctmt) {
                assert (ctmt != Containment.INSIDE);
                double pDist = obj.plane.dot(p);
                if (Math.abs(pDist) <= 1.0E-6 && !obj.test(p, tolerance).equals((Object)Tri.PointTest.OUTSIDE)) {
                    tris.add(obj);
                }
            }
        });
        return tris;
    }

    public List<EdgeDist> getCloseBoundaries(Tri tri, Point3d pt, ANode currNode, double maxRadius, Predicate<PathChange> edgeCrossFilter) {
        return this.getCloseBoundaries(tri, pt, currNode, maxRadius, maxRadius, edgeCrossFilter);
    }

    public List<EdgeDist> getCloseBoundaries(Tri tri, Point3d pt, ANode currNode, double maxRadius, double maxSearchRadius, Predicate<PathChange> edgeCrossFilter) {
        Predicate<PathChange> includeFilter = Mesh.acceptBoundaries(edgeCrossFilter);
        return this.getCloseEdges(tri, pt, currNode, maxRadius, maxSearchRadius, includeFilter);
    }

    public List<EdgeDist> getCloseEdges(Tri tri, Point3d pt, ANode currNode, double maxRadius, Predicate<PathChange> includeFilter) {
        return this.getCloseEdges(tri, pt, currNode, maxRadius, maxRadius, includeFilter);
    }

    public List<EdgeDist> getCloseEdges(Tri tri, Point3d pt, ANode currNode, double maxRadius, double maxSearchRadius, Predicate<PathChange> includeFilter) {
        ArrayList<EdgeDist> closeEdges = new ArrayList<EdgeDist>();
        this.getCloseEdges(tri, pt, currNode, maxRadius, maxSearchRadius, includeFilter, closeEdges::add);
        if (!closeEdges.isEmpty()) {
            Collections.sort(closeEdges);
        }
        return closeEdges;
    }

    public void getCloseEdges(Tri tri, Point3d pt, ANode currNode, double maxRadius, double maxSearchRadius, Predicate<PathChange> includeFilter, Consumer<EdgeDist> closeEdges) {
        if (maxRadius == 0.0) {
            return;
        }
        double maxSearchDistSq = maxSearchRadius * maxSearchRadius;
        double maxDistSq = maxRadius * maxRadius;
        IdSet closed = new IdSet();
        ArrayDeque<CloseEdgeNode> open = new ArrayDeque<CloseEdgeNode>();
        open.add(new CloseEdgeNode(null, tri, Collections.emptyMap()));
        PathChange pc = new PathChange();
        ListMap<EPoint2d, Vector2d> pivotThresholds = new ListMap<EPoint2d, Vector2d>();
        EPoint2d tempPt2d = new EPoint2d();
        Vector2d[] pivots = new Vector2d[3];
        while (!open.isEmpty()) {
            int m;
            CloseEdgeNode node = (CloseEdgeNode)open.remove();
            for (m = 0; m < 3; ++m) {
                Vertex v = node.tri.v[m];
                double distsq = Mesh.distsq2d(v.p, pt);
                if (distsq > maxSearchDistSq) {
                    pivots[m] = null;
                    continue;
                }
                tempPt2d.set(v.p.x, v.p.y);
                Vector2d threshold = (Vector2d)pivotThresholds.get(tempPt2d);
                if (threshold == null && Mesh.isPivotVert(v)) {
                    threshold = new Vector2d(v.p.x - pt.x, v.p.y - pt.y);
                    Util2D.safeNormalize(threshold, 1.0E-9);
                    pivotThresholds.put(new EPoint2d((Tuple2d)tempPt2d), threshold);
                }
                pivots[m] = threshold;
            }
            for (m = 0; m < 3; ++m) {
                Tri destTri;
                Tri side;
                double distSq;
                Tri adjTri = node.tri.t[m];
                WingedEdgeUse eu = node.tri.eu[m];
                WingedEdge edge = eu.wedge;
                if (edge == node.edge || adjTri != null && closed.contains(adjTri) || (distSq = Mesh.nearestDistToEdgeSq(pt, edge)) > maxSearchDistSq) continue;
                boolean vertical = Mesh.isVertical(edge);
                Map<EPoint2d, PivotVert> pivotSides = Collections.emptyMap();
                if (!vertical) {
                    Vector2d pivotThreshold1 = pivots[m];
                    Vector2d pivotThreshold2 = pivots[(m + 1) % 3];
                    if ((pivotThreshold1 != null || pivotThreshold2 != null) && (!Mesh.testPivot(node.pivotSides, pivotSides = new ListMap(), pt, pivotThreshold1, edge, eu.n1(), eu.n2().p, tempPt2d) || !Mesh.testPivot(node.pivotSides, pivotSides, pt, pivotThreshold2, edge, eu.n2(), eu.n1().p, tempPt2d))) continue;
                }
                Tri tri2 = side = !vertical ? Mesh.whichSide(edge, pt) : null;
                if (side != null) {
                    destTri = edge.getAdjTri(side);
                } else if (edge.isInternal()) {
                    destTri = edge.getAdjTri(tri);
                } else {
                    ANode adjNode = edge.getAdjNode(currNode);
                    destTri = edge.getTri(adjNode);
                }
                if (distSq <= maxDistSq && includeFilter.test(pc.set(destTri, edge))) {
                    closeEdges.accept(new EdgeDist(edge, distSq, destTri));
                }
                if (adjTri == null || vertical || edge.isBoundary()) continue;
                open.add(new CloseEdgeNode(edge, adjTri, pivotSides));
            }
            closed.add(node.tri);
        }
    }

    private static boolean isPivotVert(Vertex v) {
        for (Tri tri : v.t) {
            for (int m = 0; m < 3; ++m) {
                WingedEdge edge = tri.eu[m].wedge;
                if (edge.v1() != v && edge.v2() != v || !Mesh.isVertical(edge)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isVertical(WingedEdge edge) {
        Point3d l1 = edge.p1();
        Point3d l2 = edge.p2();
        double dx = l2.x - l1.x;
        double dy = l2.y - l1.y;
        return theUtil.eq0(dx * dx + dy * dy, 1.0E-9);
    }

    private static boolean testPivot(Map<EPoint2d, PivotVert> prevSides, Map<EPoint2d, PivotVert> currSides, Point3d thresholdPt, Vector2d thresholdDir, WingedEdge edge, Vertex pivotPt, Point3d otherEdgePt, EPoint2d tempPt2d) {
        if (thresholdDir != null) {
            tempPt2d.set(pivotPt.p.x, pivotPt.p.y);
            PivotVert prevSide = prevSides.get(tempPt2d);
            Boolean newSide = null;
            double newSideV = Mesh.whichSide(thresholdPt, thresholdDir, otherEdgePt);
            if (!theUtil.eq0(newSideV, 1.0E-9)) {
                newSide = newSideV > 0.0;
                if (prevSide != null && newSide != prevSide.dir) {
                    if (prevSide.vert != pivotPt) {
                        return false;
                    }
                    newSide = prevSide.dir;
                }
            } else {
                Boolean bl = newSide = prevSide != null ? Boolean.valueOf(prevSide.dir) : null;
            }
            if (newSide != null) {
                Vertex vert = prevSide != null ? prevSide.vert : pivotPt;
                currSides.put(new EPoint2d((Tuple2d)tempPt2d), new PivotVert(vert, newSide));
            }
        }
        return true;
    }

    private static double whichSide(Point3d l1, Vector2d lDir, Point3d p) {
        double dx = p.x - l1.x;
        double dy = p.y - l1.y;
        double lensq = dx * dx + dy * dy;
        if (theUtil.gt0(lensq, 1.0E-9)) {
            double ilen = 1.0 / Math.sqrt(lensq);
            dx *= ilen;
            dy *= ilen;
        }
        return Util2D.cross(lDir.x, lDir.y, dx, dy);
    }

    private static double distsq2d(Point3d p1, Point3d p2) {
        double dx = p2.x - p1.x;
        double dy = p2.y - p1.y;
        return dx * dx + dy * dy;
    }

    private static Tri whichSide(WingedEdge edge, Point3d p) {
        if (edge.t1 == null) {
            return edge.t2;
        }
        if (edge.t2 == null) {
            return edge.t1;
        }
        double side = edge.whichSide(p, 1.0E-6);
        if (side == 0.0) {
            return null;
        }
        if (side > 0.0) {
            return edge.t1;
        }
        return edge.t2;
    }

    private static double nearestDistToEdgeSq(Point3d testPoint, WingedEdge edge) {
        Point3d p1 = edge.base.n1.p;
        Point3d p2 = edge.base.n2.p;
        return Inter2D.distSqToNearestPtOnLineSeg(p1.x, p1.y, p2.x, p2.y, testPoint.x, testPoint.y);
    }

    private static boolean isBoundaryHit(WingedEdge edge, Predicate<PathChange> pathFilter, PathChange pc, Tri enterTri, Point3d p, Vector3d dir, double radius, double edgeEnterT) {
        Pair<Vector3d, Point3d> norm;
        if (radius == 0.0) {
            double side;
            if (theUtil.lt0(edgeEnterT, 1.0E-6)) {
                return false;
            }
            if (theUtil.eq0(edgeEnterT, 1.0E-6) && (side = edge.whichSide(dir, 1.0E-9)) != 0.0) {
                enterTri = edge.getTri(side);
            }
            return edge.isBoundary() || !pathFilter.test(pc.set(enterTri, edge));
        }
        double side = edge.whichSide(dir, 1.0E-9);
        if (side == 0.0) {
            if (!edge.isBoundary() && pathFilter.test(pc.set(null, edge))) {
                return false;
            }
        } else {
            enterTri = edge.getTri(side);
            if (!edge.isBoundary() && pathFilter.test(pc.set(enterTri, edge))) {
                return false;
            }
        }
        if ((norm = Util.getWallNorm(edge, p)) == null) {
            return side != 0.0;
        }
        Vector3d wallNorm = (Vector3d)norm.v1;
        double dot = wallNorm.x * dir.x + wallNorm.y * dir.y;
        return theUtil.lt0(dot, 1.0E-6);
    }

    public double getModelExtents() {
        return this.d_cachedModelExtents;
    }

    public EdgeCrossing getBoundaryHit(Tri tri, Point3d source, Vector3d dir, Predicate<PathChange> pathFilter, double maxT, IAgentBodyShape shape) {
        double radius = shape.getEnclosingRadius();
        double[] st = new double[2];
        IdentityHashSet traversedTris = new IdentityHashSet();
        PriorityQueue<QueuedTri> open = new PriorityQueue<QueuedTri>();
        WingedEdge bcrossEdge = null;
        double bcrossT = Double.MAX_VALUE;
        open.add(new QueuedTri(tri, 0.0));
        traversedTris.add(tri);
        double ttol = 1.0E-6 / dir.length();
        PathChange pc = new PathChange();
        boolean isVehicle = shape instanceof PolygonShape;
        while (!open.isEmpty()) {
            QueuedTri front = (QueuedTri)open.remove();
            tri = front.tri;
            for (int m = 0; m < 3; ++m) {
                double[] tempSt;
                Tri adjTri = tri.t[m];
                if (adjTri != null && !traversedTris.add(adjTri)) continue;
                WingedEdgeUse eu = tri.eu[m];
                if (!isVehicle ? !Mesh.movingSphereLineSegIsect2d(source, radius, dir, eu.wedge.base.n1.p, eu.wedge.base.n2.p, st, 1.0E-6) : !Mesh.movingSphereLineSegIsect2d(source, radius, dir, eu.wedge.base.n1.p, eu.wedge.base.n2.p, tempSt = new double[]{st[0], st[1]}, 1.0E-6) || !Mesh.movingPolygonLineSegIsect2d(eu.wedge, (PolygonShape)shape, dir, st, 1.0E-6)) continue;
                double edgeEnterT = st[0];
                double edgeExitT = st[1];
                if (theUtil.ge(edgeEnterT, maxT, ttol) || theUtil.lt0(edgeExitT, ttol) || theUtil.eq0(edgeExitT, ttol) && radius != 0.0) continue;
                if (Mesh.isBoundaryHit(eu.wedge, pathFilter, pc, adjTri, source, dir, radius, edgeEnterT)) {
                    if (!(edgeEnterT < bcrossT)) continue;
                    bcrossT = Math.max(0.0, edgeEnterT);
                    bcrossEdge = eu.wedge;
                    if (!(bcrossT < maxT)) continue;
                    maxT = bcrossT;
                    continue;
                }
                if (adjTri == null || eu.wedge.isExit()) continue;
                open.add(new QueuedTri(adjTri, Mesh.nearestDistToEdgeSq(source, eu.wedge)));
            }
        }
        if (bcrossEdge == null || bcrossT > maxT) {
            return null;
        }
        return new EdgeCrossing(null, bcrossEdge, null, null, null, null, bcrossT, EdgeCrossing.Type.BOUNDARY);
    }

    public static boolean movingPolygonLineSegIsect2d(WingedEdge wedge, PolygonShape shape, Vector3d dir, double[] t, double tol) {
        Point3d[] edgePoints = new Point3d[]{wedge.p1(), wedge.p2()};
        return Inter.movingCPolyCPoly2d(shape.getPoints(), dir, edgePoints, t, tol);
    }

    public static boolean movingSphereLineSegIsect2d(Point3d sphereCenter, double sphereRadius, Vector3d sphereVel, Point3d l1, Point3d l2, double[] t, double epsilon) {
        if (sphereRadius == 0.0) {
            Point3d isect = Inter.copRayLineSeg(new Point3d(sphereCenter.x, sphereCenter.y, 0.0), new Vector3d(sphereVel.x, sphereVel.y, 0.0), new Point3d(l1.x, l1.y, 0.0), new Point3d(l2.x, l2.y, 0.0), t, epsilon);
            if (isect != null) {
                t[1] = t[0];
            }
            return isect != null;
        }
        double cx = (l1.x + l2.x) * 0.5;
        double cy = (l1.y + l2.y) * 0.5;
        double ax = l2.x - l1.x;
        double ay = l2.y - l1.y;
        double az = 0.0;
        double capLen = Math.sqrt(ax * ax + ay * ay);
        if (capLen != 0.0) {
            double icaplen = 1.0 / capLen;
            ax *= icaplen;
            ay *= icaplen;
        } else {
            ay = 0.0;
            ax = 0.0;
            az = 1.0;
            capLen = 1.0;
        }
        boolean isected = Inter3D.rayCapsuleIsect(sphereCenter.x, sphereCenter.y, 0.0, sphereVel.x, sphereVel.y, 0.0, cx, cy, 0.0, ax, ay, az, capLen, sphereRadius, t, epsilon);
        if (!isected) {
            return false;
        }
        return !theUtil.eq(t[0], t[1], epsilon);
    }

    private static double[] lineSegCapsuleIsect2d(Point3d l1, Point3d l2, Point3d c1, Point3d c2, double r, double epsilon) {
        double[] t;
        Vector3d ldir = Inter.vector(l1, l2);
        boolean result = Mesh.movingSphereLineSegIsect2d(l1, r, ldir, c1, c2, t = new double[2], epsilon);
        if (!result) {
            return null;
        }
        thunderheadeng.geometry.Util.clampTs(t, 0.0, 1.0);
        if (theUtil.eq(t[0], t[1], epsilon)) {
            return null;
        }
        assert (t[0] < t[1]);
        return t;
    }

    public EdgeCrossing getCrossedEdges(Tri tri, Point3d source, Vector3d dir, Predicate<PathChange> pathFilter, double maxT) throws CrossedEdgesException {
        try {
            return this.getCrossedEdgesImpl(tri, source, dir, null, null, pathFilter, maxT);
        }
        catch (CrossedEdgesException e) {
            LOGGER.log(Level.SEVERE, e.toString(), e);
            throw e;
        }
    }

    public EdgeCrossing getCrossedEdges(Tri tri, Point3d source, Tri destTri, Point3d dest, Predicate<PathChange> pathFilter) throws CrossedEdgesException {
        if (tri == destTri) {
            return null;
        }
        try {
            Vector3d dir = Util3D.vector(source, dest);
            Util3D.safeNormalize(dir, 0.0);
            return this.getCrossedEdgesImpl(tri, source, dir, destTri, dest, pathFilter, Double.MAX_VALUE);
        }
        catch (CrossedEdgesException e) {
            LOGGER.log(Level.SEVERE, e.toString(), e);
            throw e;
        }
    }

    private EdgeCrossing getCrossedEdgesImpl(Tri tri, Point3d source, Vector3d dir, Tri destTri, Point3d dest, Predicate<PathChange> pathFilter, double maxT) throws CrossedEdgesException {
        Predicate<Tri> isFinished;
        if (maxT == Double.MAX_VALUE) {
            double extent = this.getModelExtents() * 1.5;
            maxT = extent / dir.length();
        }
        if (dest == null) {
            dest = Util3D.linePoint(source, dir, maxT);
        }
        if (destTri != null) {
            assert (dest != null);
            isFinished = t -> t == destTri;
        } else {
            Point3d finalDest = dest;
            isFinished = t -> t.containsExact(finalDest);
        }
        if (isFinished.test(tri)) {
            return null;
        }
        double[] st = new double[2];
        IdentityHashSet traversedTris = new IdentityHashSet();
        ArrayDeque<EdgeCrossNode> open = new ArrayDeque<EdgeCrossNode>();
        open.add(new EdgeCrossNode(tri, null));
        PathChange pc = new PathChange();
        while (!open.isEmpty()) {
            EdgeCrossNode node = (EdgeCrossNode)open.pop();
            tri = node.tri;
            if (!traversedTris.add(tri)) continue;
            for (int m = 0; m < 3; ++m) {
                Tri adjTri = tri.t[m];
                if (adjTri != null && traversedTris.contains(adjTri)) continue;
                WingedEdgeUse eu = tri.eu[m];
                Util.CopLineLine isectTest = node.crossing == null ? Util.copLineSegLineSegExact(source, dest, eu.wedge.base.n1.p, eu.wedge.base.n2.p, st) : Util.copLineLineSegExact(source, dest, eu.wedge.base.n1.p, eu.wedge.base.n2.p, st);
                if (isectTest != Util.CopLineLine.INTERSECT) {
                    if (isectTest != Util.CopLineLine.COLINEAR) continue;
                    traversedTris.add(adjTri);
                    continue;
                }
                double dirCrossT = st[0] * maxT;
                if (dirCrossT < 0.0) {
                    dirCrossT = 0.0;
                }
                double edgeCrossT = st[1];
                Point3d crossLoc = Util3D.linesegPoint(eu.wedge.base.n1.p, eu.wedge.base.n2.p, edgeCrossT);
                boolean boundary = Mesh.isBoundaryHit(eu.wedge, pathFilter, pc, adjTri, source, dir, 0.0, dirCrossT);
                EdgeCrossing.Type ctype = boundary ? EdgeCrossing.Type.BOUNDARY : (eu.wedge.isExit() ? EdgeCrossing.Type.EXIT : EdgeCrossing.Type.CROSS);
                Tri crossedTri = adjTri == null ? tri : adjTri;
                EdgeCrossing crossing = new EdgeCrossing(node.crossing, eu.wedge, crossLoc, crossedTri, dest, new Vector3d(dir), dirCrossT, ctype);
                if (ctype.terminal || isFinished.test(adjTri)) {
                    crossing.finalizeCrossings();
                    return crossing;
                }
                if (node.crossing == null && st[0] == 0.0) {
                    Point3d l1 = eu.n1().p;
                    Point3d l2 = eu.n2().p;
                    double orient = PreciseGeom.orient2d(l1.x, l1.y, l2.x, l2.y, dest.x, dest.y);
                    if (orient > 0.0) continue;
                }
                EdgeCrossNode newNode = new EdgeCrossNode(adjTri, crossing);
                open.push(newNode);
            }
        }
        throw new CrossedEdgesException();
    }

    public EdgeCrossing getCrossedEdgesNoEx(Tri tri, Point3d source, Vector3d dir, double maxT) {
        try {
            return this.getCrossedEdgesImpl(tri, source, dir, null, null, Predicates.alwaysTrue(), maxT);
        }
        catch (CrossedEdgesException e) {
            return null;
        }
    }

    private static Point3d lineTriIntersection(Point3d l1, Vector3d lineDir, Tri tri) {
        Point3d isect = Inter.linePlane(l1, lineDir, tri.plane, 0.0);
        if (isect == null) {
            return null;
        }
        return tri.containsExact(isect) ? isect : null;
    }

    public static Predicate<PathChange> acceptBoundaries(Predicate<PathChange> filter) {
        return Mesh.rejectBoundaries(filter).negate();
    }

    private static Predicate<PathChange> rejectBoundaries(Predicate<PathChange> filter) {
        Predicate<WingedEdge> edgeFilter = EdgeFilters.rejectAllBoundaries();
        return Predicates.and(PathFilters.filterEdges(edgeFilter), filter);
    }

    public boolean isPathObstructed(TriPoint source, TriPoint dest, double radius, Predicate<WingedEdge> edgeCrossFilter) {
        return this.isPathObstructed(source.tri, source.p, dest.tri, dest.p, radius, edgeCrossFilter);
    }

    public static Tri whichSide(WingedEdge edge, Vector3d dir, double tol) {
        double side = edge.whichSide(dir, tol);
        if (side == 0.0) {
            return null;
        }
        if (side > 0.0) {
            return edge.t1;
        }
        return edge.t2;
    }

    public boolean isPathObstructed(Tri srcTri, Point3d source, Tri dstTri, Point3d dest, double radius, Predicate<WingedEdge> edgeCrossFilter) {
        return Double.isFinite(this.getPathObstructionDist(srcTri, source, dstTri, dest, radius, edgeCrossFilter));
    }

    public double getPathObstructionDist(TriPoint source, TriPoint dest, double radius, Predicate<WingedEdge> edgeCrossFilter) {
        return this.getPathObstructionDist(source.tri, source.p, dest.tri, dest.p, radius, edgeCrossFilter);
    }

    public double getPathObstructionDist(Tri srcTri, Point3d source, Tri dstTri, Point3d dest, double radius, Predicate<WingedEdge> edgeCrossFilter) {
        if (srcTri == null) {
            return Double.POSITIVE_INFINITY;
        }
        double[] st = new double[2];
        IdentityHashSet traversedTris = new IdentityHashSet();
        Vector3d vec = Util3D.vector(source, dest);
        Util.projectAlongZEq(srcTri.plane, vec);
        if (Util.safeNormalize(vec, 1.0E-9) == 0.0) {
            if (srcTri == dstTri || dstTri == null) {
                return Double.POSITIVE_INFINITY;
            }
            WingedEdge sharedEdge = Util.getSharedEdge(srcTri, dstTri);
            if (sharedEdge == null) {
                return Double.POSITIVE_INFINITY;
            }
            return sharedEdge.isBoundary() || !edgeCrossFilter.test(sharedEdge) ? 0.0 : Double.POSITIVE_INFINITY;
        }
        if (dstTri != null && dstTri != srcTri && theUtil.eq(Math.abs(vec.z), 1.0, 1.0E-12) && !theUtil.eq0(srcTri.plane.z, 1.0E-12)) {
            return 0.0;
        }
        Predicate<PathChange> doubleCheckFilter = Predicates.always(dstTri == null);
        Tri endTri = null;
        double maxDist = Double.POSITIVE_INFINITY;
        Stack<Pair<Object, Tri>> open = new Stack<Pair<Object, Tri>>();
        open.add(new Pair<Object, Tri>(null, srcTri));
        PathChange pc = new PathChange();
        while (!open.isEmpty()) {
            double dist;
            boolean inFinalTri;
            Pair triEntry = (Pair)open.pop();
            Tri prevTri = (Tri)triEntry.v1;
            Tri tri = (Tri)triEntry.v2;
            traversedTris.add(tri);
            boolean bl = dstTri != null ? tri == dstTri : (inFinalTri = Inter.pointOnPoly(dest, tri.plane, 1.0E-6, tri.v[0].p, tri.v[1].p, tri.v[2].p));
            if (inFinalTri && (dist = Util3D.tOnLine(source, vec, dest)) < maxDist) {
                endTri = tri;
                maxDist = dist;
            }
            for (int m = 0; m < 3; ++m) {
                Tri adjTri = tri.t[m];
                WingedEdgeUse eu = tri.eu[m];
                if (adjTri != null && traversedTris.contains(adjTri) || eu.wedge.isExit() && dstTri == null || !Mesh.movingSphereLineSegIsect2d(source, radius, vec, eu.wedge.base.n1.p, eu.wedge.base.n2.p, st, 1.0E-6)) continue;
                double edgeEnterDist = st[0];
                double edgeExitDist = st[1];
                if (theUtil.ge(edgeEnterDist, maxDist, 1.0E-6) || prevTri == null && theUtil.lt0(edgeExitDist, 1.0E-6) || radius != 0.0 && theUtil.eq0(edgeExitDist, 1.0E-6)) continue;
                if (edgeExitDist < 0.0) {
                    edgeExitDist = 0.0;
                }
                if (edgeEnterDist < 0.0) {
                    edgeEnterDist = 0.0;
                }
                if (eu.wedge.isBoundary() || eu.wedge.isExit() && dstTri != null || !edgeCrossFilter.test(eu.wedge) && (endTri == null || !theUtil.eq((edgeEnterDist + edgeExitDist) * 0.5, maxDist, 1.0E-6))) {
                    if (edgeEnterDist >= maxDist) continue;
                    if (Mesh.isBoundaryHit(eu.wedge, doubleCheckFilter, pc, adjTri, source, vec, radius, edgeEnterDist)) {
                        endTri = null;
                        maxDist = edgeEnterDist;
                        continue;
                    }
                }
                if (adjTri == null) continue;
                if (prevTri == null && theUtil.eq0(edgeEnterDist, 1.0E-6)) {
                    Point3d l1 = eu.n1().p;
                    Point3d l2 = eu.n2().p;
                    double orient = PreciseGeom.orient2d(l1.x, l1.y, l2.x, l2.y, dest.x, dest.y);
                    if (orient > 0.0) continue;
                }
                open.push(new Pair<Tri, Tri>(tri, adjTri));
            }
        }
        if (dstTri != null && endTri == null) {
            assert (!Double.isInfinite(maxDist));
            return maxDist;
        }
        if (endTri != null) {
            return Double.POSITIVE_INFINITY;
        }
        return maxDist;
    }

    public ShapeTrace traceMovingShape(TriPoint source, Vector3d vec, Predicate<PathChange> pathFilter, double maxT, IAgentBodyShape shape) {
        EdgeCrossing wallHit;
        EdgeCrossing crossing;
        try {
            crossing = this.getCrossedEdges(source.tri, source.p, vec, pathFilter, maxT);
        }
        catch (CrossedEdgesException e) {
            return null;
        }
        if (crossing != null && crossing.type.terminal) {
            maxT = crossing.t;
        }
        if ((wallHit = this.getBoundaryHit(source.tri, source.p, vec, pathFilter, maxT, shape)) == null) {
            WingedEdge exit;
            TriPoint loc;
            if (crossing == null) {
                loc = Util.traceInTri(source.tri, source.p, vec, maxT);
                exit = null;
            } else {
                loc = new TriPoint(crossing.enterLoc.tri, crossing.destPt);
                exit = crossing.type == EdgeCrossing.Type.EXIT ? crossing.edge : null;
            }
            return new ShapeTrace(loc, maxT, null, exit);
        }
        TriPoint result = EdgeCrossing.find(source, vec, crossing, wallHit.t);
        return new ShapeTrace(result, wallHit.t, wallHit.edge, null);
    }

    public boolean isEdgeTravellable(WingedEdge edge, double radius) {
        SplitEdge[] shortenedEdges = this.getShortenedEdges(radius);
        assert (shortenedEdges != null);
        SplitEdge sedge = shortenedEdges[edge.id];
        return sedge == null ? true : sedge.splits.length > 0;
    }

    public TriPoint getUnobstructedPointOnEdge(double r, TriPoint edgePt, WingedEdge edge) {
        SplitEdge sedge = this.getShortenedEdge(r, edge);
        if (sedge == null) {
            return edgePt;
        }
        Point3d closest = sedge.findClosest(edgePt.p);
        return closest == null ? null : new TriPoint(edgePt.tri, closest, edge);
    }

    public SplitEdge getShortenedEdge(double r, WingedEdge edge) {
        SplitEdge[] shortenedEdges = this.getShortenedEdges(r);
        assert (shortenedEdges != null);
        return shortenedEdges[edge.id];
    }

    public TriPoint projectToMesh(Point3d pt) {
        Vector3d adjustDir;
        PtBBIntersectTest test = new PtBBIntersectTest(pt);
        PtBBIntersectResult result = new PtBBIntersectResult(pt);
        try {
            this.d_triFinder.find(test, result);
        }
        catch (CancellationException cancellationException) {
            // empty catch block
        }
        if (result.ptMap.isEmpty()) {
            return null;
        }
        TriPoint loc = (TriPoint)result.ptMap.values().iterator().next();
        if (!theUtil.eq0(loc.tri.plane.getNormal().z, 1.0E-6)) {
            return loc;
        }
        double closestDistSq = 1.0E-4;
        Tri closestTri = null;
        int closestEdge = -1;
        double closestEdgeT = Double.NaN;
        ArrayDeque<Tri> open = new ArrayDeque<Tri>();
        IdSet<Tri> closed = new IdSet<Tri>();
        open.push(loc.tri);
        closed.add(loc.tri);
        while (!open.isEmpty()) {
            Tri tri = (Tri)open.pop();
            for (int m = 0; m < 3; ++m) {
                Tri adjTri = tri.eu[m].wedge.getAdjTri(tri);
                if (adjTri == null || !closed.add(adjTri)) continue;
                if (theUtil.eq0(adjTri.plane.getNormal().z, 1.0E-6)) {
                    open.push(adjTri);
                    continue;
                }
                for (int n = 0; n < 3; ++n) {
                    WingedEdgeUse eu = adjTri.eu[n];
                    if (eu.wedge.isBoundary()) continue;
                    Point3d l1 = eu.n1().p;
                    Point3d l2 = eu.n2().p;
                    double distsq = Inter2D.distSqToNearestPtOnLineSeg(l1.x, l1.y, l2.x, l2.y, pt.x, pt.y);
                    if (!(distsq < closestDistSq)) continue;
                    closestDistSq = distsq;
                    closestTri = adjTri;
                    closestEdge = n;
                    closestEdgeT = Inter2D.nearestTOnLineSeg(pt.x, pt.y, l1.x, l1.y, l2.x, l2.y);
                }
            }
        }
        if (closestTri == null) {
            return null;
        }
        Point3d closestPt = closestTri.eu[closestEdge].get(closestEdgeT);
        if (closestTri.containsExact(closestPt)) {
            return new TriPoint(closestTri, closestPt);
        }
        if (theUtil.eq0(closestEdgeT, 1.0E-6) || theUtil.eq(closestEdgeT, 1.0, 1.0E-6)) {
            int sharedVertIx = theUtil.eq0(closestEdgeT, 1.0E-6) ? closestEdge : (closestEdge + 1) % 3;
            WingedEdgeUse eu1 = closestTri.eu[(sharedVertIx + 2) % 3];
            WingedEdgeUse eu2 = closestTri.eu[sharedVertIx];
            Vector3d v1 = Util3D.vector(eu1.n2().p, eu1.n1().p);
            Vector3d v2 = Util3D.vector(eu2.n1().p, eu2.n2().p);
            adjustDir = Util3D.add(v1, (Tuple3d)v2);
            adjustDir.normalize();
        } else {
            WingedEdgeUse eu = closestTri.eu[closestEdge];
            Vector3d edir = Util3D.vector(eu.n1().p, eu.n2().p);
            adjustDir = Util3D.cross(closestTri.normal, edir);
            adjustDir.normalize();
        }
        for (int m = 1; m < 10; ++m) {
            double movet = (double)m * 1.0E-8;
            Point3d p = Util3D.linePoint(closestPt, adjustDir, movet);
            if (!closestTri.containsExact(p)) continue;
            return new TriPoint(closestTri, p);
        }
        return null;
    }

    private static Vector3d addToGoalDir(Point3d pOrigin, Point3d pOnPath, Vector3d cToGoal) {
        Vector3d pToC = Inter.vector(pOrigin, pOnPath);
        double pcDist = pToC.length();
        double cgDist = cToGoal.length();
        double dist = pcDist + cgDist;
        Vector3d dir = new Vector3d(pToC);
        dir.normalize();
        dir.scale(dist);
        return dir;
    }

    private static Vector3d calcGoalDir(Point3d pOrigin, Stack<Point3d> wayPoints) {
        assert (!wayPoints.isEmpty());
        Point3d lastPoint = wayPoints.pop();
        Vector3d dir = new Vector3d();
        dir.sub(lastPoint, pOrigin);
        double totalLen = dir.length();
        while (!wayPoints.isEmpty()) {
            Point3d wayPoint = wayPoints.pop();
            totalLen += lastPoint.distance(wayPoint);
            lastPoint = wayPoint;
        }
        dir.normalize();
        dir.scale(totalLen);
        return dir;
    }

    private static Vector3d dirToGoalThroughEdge(Point3d p, Point3d e1p, Point3d e2p, Vector3d e1d, Vector3d e2d, double parallelTol) {
        boolean e1goal = e1d.equals(ZERO_PT);
        boolean e2goal = e2d.equals(ZERO_PT);
        if (e1goal && e2goal) {
            Point3d closest = Inter.nearPointOnLineSeg(p, e1p, e2p);
            Vector3d dir = new Vector3d();
            dir.sub(closest, p);
            return dir;
        }
        if (e1goal) {
            Vector3d dir = new Vector3d();
            dir.sub(e1p, p);
            return dir;
        }
        if (e2goal) {
            Vector3d dir = new Vector3d();
            dir.sub(e2p, p);
            return dir;
        }
        assert (e1d.dot(e2d) >= 0.0);
        Point3d goal1 = new Point3d();
        goal1.add(e1p, e1d);
        Point3d goal2 = new Point3d();
        goal2.add(e2p, e2d);
        Stack<Point3d> wayPoints = new Stack<Point3d>();
        if (goal1.equals(goal2)) {
            wayPoints.push(goal1);
        } else {
            Point3d goalDirIsect = new Point3d();
            double tol = parallelTol * e1p.distanceSquared(e2p);
            if (!Inter.lineLineProximity(e1p, e1d, e2p, e2d, goalDirIsect, null, tol)) {
                wayPoints.push(Inter.nearPointOnLineSeg(p, goal1, goal2));
            } else {
                double e1dLen;
                double e1pGoalDist = e1p.distance(goalDirIsect);
                if (e1pGoalDist <= (e1dLen = e1d.length())) {
                    wayPoints.push(goal1);
                    wayPoints.push(goalDirIsect);
                } else {
                    wayPoints.push(Inter.nearPointOnLineSeg(p, goal1, goal2));
                }
            }
        }
        Point3d nearesetGoal = (Point3d)wayPoints.peek();
        Point3d closestOnEdge = new Point3d();
        if (Inter.lineSegLineSegProximity(e1p, e2p, p, nearesetGoal, closestOnEdge, null, 0.0)) {
            wayPoints.push(closestOnEdge);
            return Mesh.calcGoalDir(p, wayPoints);
        }
        Vector3d e1Vec = Mesh.addToGoalDir(p, e1p, e1d);
        Vector3d e2Vec = Mesh.addToGoalDir(p, e2p, e2d);
        return e1Vec.lengthSquared() <= e2Vec.lengthSquared() ? e1Vec : e2Vec;
    }

    private static boolean isEdgeMergeableVert(Vertex vert) {
        for (Tri adjTri : vert.t) {
            for (WingedEdgeUse weu : adjTri.eu) {
                if (weu.wedge.base.n1 != vert && weu.wedge.base.n2 != vert || !weu.wedge.isBoundary()) continue;
                return false;
            }
        }
        return true;
    }

    private static Vertex[] mergeEdges(Vertex[] e1, Vertex[] e2) {
        Vector3d dir2;
        Vertex shared;
        if (e1[0] == e2[0] || e1[0] == e2[1]) {
            shared = e1[0];
        } else if (e1[1] == e2[0] || e1[1] == e2[1]) {
            shared = e1[1];
        } else {
            return null;
        }
        if (!Mesh.isEdgeMergeableVert(shared)) {
            return null;
        }
        Vector3d dir1 = Inter.normalize(Util3D.vectorN(e1[0].p, e1[1].p));
        double dot = dir1.dot(dir2 = Inter.normalize(Util3D.vectorN(e2[0].p, e2[1].p)));
        if (theUtil.eq(Math.abs(dot), 1.0, 1.0E-9)) {
            Vertex oppPoint1 = shared == e1[0] ? e1[1] : e1[0];
            Vertex oppPoint2 = shared == e2[0] ? e2[1] : e2[0];
            return new Vertex[]{oppPoint1, oppPoint2};
        }
        return null;
    }

    public List<WingedEdge> getGoalEdges() {
        ArrayList<WingedEdge> edges = new ArrayList<WingedEdge>();
        for (WingedEdge e : this.d_edges) {
            EdgeData ed = e.data;
            if (ed.type != 3) continue;
            edges.add(e);
        }
        return edges;
    }

    public Tri[] getTouchingTris(Tri triHint, Point3d p) {
        for (Vertex v : triHint.v) {
            if (!p.epsilonEquals(v.p, 1.0E-6)) continue;
            return v.t;
        }
        for (int m = 0; m < 3; ++m) {
            WingedEdge edge = triHint.eu[m].wedge;
            double edgeDist = Inter.nearDistToLineSeg(p, edge.base.n1.p, edge.base.n2.p);
            if (!(edgeDist < 1.0E-6)) continue;
            Tri mateTri = edge.getAdjTri(triHint);
            if (mateTri != null) {
                return new Tri[]{triHint, mateTri};
            }
            return new Tri[]{triHint};
        }
        return new Tri[]{triHint};
    }

    public static TriEdge[] getTouchingEdges(Tri triHint, WingedEdge startEdge, Vertex startVertex, Point3d p) {
        Serializable nearestElem = null;
        if (startVertex != null) {
            nearestElem = startVertex;
        } else if (startEdge != null) {
            nearestElem = startEdge;
        } else {
            double nearestDistSq = Double.POSITIVE_INFINITY;
            for (Vertex v : triHint.v) {
                double distSq = p.distanceSquared(v.p);
                if (!(distSq <= 1.0E-12) || !(distSq < nearestDistSq)) continue;
                nearestDistSq = distSq;
                nearestElem = v;
            }
            for (int m = 0; m < 3; ++m) {
                WingedEdge edge = triHint.eu[m].wedge;
                double edgeDistSq = Inter3D.distSqToNearestPtOnLineSeg(edge.base.n1.p, edge.base.n2.p, p);
                if (!(edgeDistSq <= 1.0E-12) || !(edgeDistSq < nearestDistSq)) continue;
                nearestDistSq = edgeDistSq;
                nearestElem = edge;
            }
        }
        if (nearestElem instanceof Vertex) {
            Serializable v = nearestElem;
            ArrayList<TriEdge> edges = new ArrayList<TriEdge>(4);
            for (int n = 0; n < 3; ++n) {
                WingedEdgeUse eu = triHint.eu[n];
                if (eu.n1() != v && eu.n2() != v) continue;
                edges.add(new TriEdge(triHint, eu.wedge));
                Tri adj = eu.wedge.getAdjTri(triHint);
                if (adj == null) continue;
                edges.add(new TriEdge(adj, eu.wedge));
            }
            return (TriEdge[])theUtil.toArray(edges);
        }
        if (nearestElem instanceof WingedEdge) {
            WingedEdge edge = (WingedEdge)nearestElem;
            Tri mateTri = edge.getAdjTri(triHint);
            TriEdge e1 = new TriEdge(triHint, edge);
            if (mateTri != null) {
                TriEdge e2 = new TriEdge(mateTri, edge);
                return new TriEdge[]{e1, e2};
            }
            return new TriEdge[]{e1};
        }
        return new TriEdge[0];
    }

    public ANode[] getTouchingNodes(Tri triHint, Point3d p) {
        Tri[] touchingTris = this.getTouchingTris(triHint, p);
        ArrayList<ANode> nodes = new ArrayList<ANode>();
        for (Tri tri : touchingTris) {
            if (nodes.contains(tri.node)) continue;
            nodes.add(tri.node);
        }
        return nodes.toArray(new ANode[nodes.size()]);
    }

    public Vertex[] getVerts() {
        return this.d_verts;
    }

    public WingedEdge[] getEdges() {
        return this.d_edges;
    }

    public Tri[] getTris() {
        return this.d_tris;
    }

    public SplitEdge[] getShortenedEdges(double radius) {
        Map.Entry<Double, TrimInfo> entry = this.d_trimmedMeshes.ceilingEntry(radius);
        SplitEdge[] shortened = entry != null ? entry.getValue().edges : null;
        return shortened;
    }

    public Map<ANode, SplitDoor> getShortenedDoors(double radius) {
        Map.Entry<Double, TrimInfo> entry = this.d_trimmedMeshes.ceilingEntry(radius);
        return entry != null ? entry.getValue().doors : Collections.emptyMap();
    }

    public SplitDoor getShortenedDoor(double radius, ANode door) {
        return this.getShortenedDoors(radius).get(door);
    }

    public double getCachedRadius(double radius) {
        Map.Entry<Double, TrimInfo> entry = this.d_trimmedMeshes.ceilingEntry(radius);
        return entry != null ? entry.getKey() : this.d_trimmedMeshes.lastEntry().getKey();
    }

    public Point3d[] getEdgeSegment(WingedEdge edge, Point3d seekPt, double radius) {
        SplitEdge se = this.getShortenedEdges(radius)[edge.id];
        if (se == null) {
            return new Point3d[]{edge.base.n1.p, edge.base.n2.p};
        }
        return se.findSegment(seekPt);
    }

    public DoorSegmentEndpoint[] getNearestTraversableDoorSegment(double radius, ANode door, WingedEdge doorEdge, Point3d seekPt) {
        assert (doorEdge != null);
        SplitDoor sd = this.getShortenedDoor(radius, doorEdge.getDoorNode());
        if (sd == null) {
            return new DoorSegmentEndpoint[]{new DoorSegmentEndpoint(0, 0.0), new DoorSegmentEndpoint(door.getDoorEdges().size() - 1, 1.0)};
        }
        Pair<Integer, Point3d>[] result = sd.findSegmentDetailed(seekPt, door.getDoorEdges().indexOf(doorEdge));
        if (result == null) {
            return null;
        }
        DoorGeom dg = door.getDoorGeom();
        Function<Pair, DoorSegmentEndpoint> toEndpoint = pair -> {
            WingedEdge edge = dg.edges.get((Integer)pair.v1);
            return new DoorSegmentEndpoint((Integer)pair.v1, Util3D.tOnLineSeg(edge.p1(), edge.p2(), (Point3d)pair.v2));
        };
        return new DoorSegmentEndpoint[]{toEndpoint.apply(result[0]), toEndpoint.apply(result[1])};
    }

    private static boolean isShrinkable(WingedEdge edge) {
        return !edge.isBoundary() && !edge.isBlocking();
    }

    private static boolean shouldShrinkFrom(WingedEdge shrinkable, WingedEdge edge) {
        if (edge.isBoundary()) {
            return true;
        }
        return !shrinkable.isInBlockingRegion() && edge.isBlocking();
    }

    private List<Map.Entry<Double, TrimInfo>> getTrimmedEdgesList() {
        return this.d_cachedTrimmedMeshEntries.get(() -> new ArrayList(this.d_trimmedMeshes.entrySet()));
    }

    private static <T> List<T> asRandomAccessList(Collection<T> coll) {
        return coll instanceof List && coll instanceof RandomAccess ? (List)coll : new ArrayList<T>(coll);
    }

    public void reshrinkEdgesFromBoundary(KB kb, Collection<WingedEdge> changedBoundaryEdges) {
        if (this.d_trimmedMeshes.isEmpty()) {
            return;
        }
        MTProcessor mtproc = this.getMtProc(kb);
        LinkedIdentityHashSet<WingedEdge> internalEdges = new LinkedIdentityHashSet<WingedEdge>();
        internalEdges.addAll(theUtil.filter(changedBoundaryEdges, e -> Mesh.isShrinkable(e)));
        List<WingedEdge> testEdges = Mesh.asRandomAccessList(changedBoundaryEdges);
        try {
            ArrayList tempEdges = new ArrayList(mtproc.getNumThreads());
            for (int m = 0; m < mtproc.getNumThreads(); ++m) {
                tempEdges.add(new LinkedIdentityHashSet());
            }
            double maxRadius = (Double)this.d_trimmedMeshes.lastKey();
            mtproc.process(testEdges, (edge, tix, ix) -> {
                Collection edges = (Collection)tempEdges.get(tix);
                this.getCloseEdges((WingedEdge)edge, maxRadius, nearEdge -> {
                    if (Mesh.isShrinkable(nearEdge) && !internalEdges.contains(nearEdge)) {
                        edges.add(nearEdge);
                    }
                });
            });
            internalEdges.addAll(theUtil.flatMap(tempEdges, elist -> elist));
            this.reshrinkInternalEdgesFromBoundary(kb, internalEdges);
        }
        catch (ExecutionException e1) {
            throw new RuntimeException(e1.getCause());
        }
    }

    public void reshrinkInternalEdgesFromBoundary(KB kb, Collection<WingedEdge> edges) {
        if (edges.isEmpty() || this.d_trimmedMeshes.isEmpty()) {
            return;
        }
        MTProcessor mtproc = this.getMtProc(kb);
        List<WingedEdge> edgeList = Mesh.asRandomAccessList(edges);
        List<Map.Entry<Double, TrimInfo>> entries = this.getTrimmedEdgesList();
        try {
            mtproc.process(entries.size() * edgeList.size(), ix -> {
                Map.Entry entry = (Map.Entry)entries.get(ix / edgeList.size());
                WingedEdge wedge = (WingedEdge)edgeList.get(ix % edgeList.size());
                TrimInfo ti = (TrimInfo)entry.getValue();
                SplitEdge[] shortenedTs = ti.edges;
                if (Mesh.isShrinkable(wedge)) {
                    shortenedTs[wedge.id] = this.shrinkInternalEdgeFromBoundary(wedge, ti.radius);
                }
            });
            mtproc.process(entries, (entry, tix, ix) -> {
                TrimInfo ti = (TrimInfo)entry.getValue();
                Map<ANode, SplitDoor> trimmedDoors = this.getTrimmedDoors(((TrimInfo)entry.getValue()).edges);
                entry.setValue(new TrimInfo(ti.radius, ti.edges, trimmedDoors));
            });
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e.getCause());
        }
    }

    public void getCloseEdges(WingedEdge seedEdge, double radius, Consumer<WingedEdge> result) {
        Point3d pedge1 = seedEdge.base.n1.p;
        Point3d pedge2 = seedEdge.base.n2.p;
        Stack open = new Stack();
        IdentityHashSet closedEdges = new IdentityHashSet();
        IdentityHashSet closedTris = new IdentityHashSet();
        Predicate<Tri> openTri = tri -> {
            if (tri != null && closedTris.add(tri)) {
                open.push(tri);
                return true;
            }
            return false;
        };
        openTri.test(seedEdge.t1);
        openTri.test(seedEdge.t2);
        while (!open.isEmpty()) {
            Tri tri2 = (Tri)open.pop();
            for (int m = 0; m < 3; ++m) {
                double[] wholeEdgeIsect;
                WingedEdge wedge = tri2.eu[m].wedge;
                if (wedge == seedEdge || !closedEdges.add(wedge) || (wholeEdgeIsect = Mesh.lineSegCapsuleIsect2d(pedge1, pedge2, wedge.base.n1.p, wedge.base.n2.p, radius, 1.0E-6)) == null) continue;
                result.accept(wedge);
                openTri.test(tri2.t[m]);
            }
        }
    }

    public void shrinkInternalEdgesFromBoundary(Collection<Double> radii) {
        for (Double radius : radii) {
            SplitEdge[] trimmedMesh = this.shrinkInternalEdgesFromBoundary(radius);
            Map<ANode, SplitDoor> trimmedDoors = this.getTrimmedDoors(trimmedMesh);
            this.d_trimmedMeshes.put(radius, new TrimInfo(radius, trimmedMesh, trimmedDoors));
        }
        this.d_cachedTrimmedMeshEntries.clear();
    }

    private Map<ANode, SplitDoor> getTrimmedDoors(SplitEdge[] splitEdges) {
        LinkedIdentityHashMap<ANode, SplitDoor> result = new LinkedIdentityHashMap<ANode, SplitDoor>();
        for (WingedEdge edge : this.d_edges) {
            if (!edge.isDoor() || edge.getDoorNode().getDoorGeom() == null) continue;
            result.computeIfAbsent(edge.getDoorNode(), door -> {
                int m;
                DoorGeom dg = door.getDoorGeom();
                assert (dg != null);
                List<WingedEdge> dedges = dg.edges;
                ArrayList<Double> splits = new ArrayList<Double>();
                for (m = 0; m < dedges.size(); ++m) {
                    WingedEdge dedge = dedges.get(m);
                    SplitEdge sedge = splitEdges[dedge.id];
                    if (sedge == null) {
                        splits.add(dg.vt[m]);
                        splits.add(dg.vt[m + 1]);
                        continue;
                    }
                    for (double splitT : sedge.splits) {
                        splits.add(dg.toDoorT(m, splitT));
                    }
                }
                m = 2;
                while (m < splits.size()) {
                    double currt;
                    double prevt = (Double)splits.get(m - 1);
                    if (theUtil.eq(prevt, currt = ((Double)splits.get(m)).doubleValue(), 1.0E-9)) {
                        splits.remove(m);
                        splits.remove(m - 1);
                        continue;
                    }
                    m += 2;
                }
                if (splits.isEmpty()) {
                    return new SplitDoor((ANode)door, new double[0]);
                }
                if (splits.size() == 2 && theUtil.eq0((Double)splits.get(0), 1.0E-9) && theUtil.eq((Double)splits.get(1), 1.0, 1.0E-9)) {
                    return null;
                }
                return new SplitDoor((ANode)door, theUtil.toDoubleArray(splits));
            });
        }
        return result;
    }

    private SplitEdge[] shrinkInternalEdgesFromBoundary(double radius) {
        SplitEdge[] shortenedTs = new SplitEdge[this.d_edges.length];
        for (WingedEdge wedge : this.d_edges) {
            if (!Mesh.isShrinkable(wedge)) continue;
            shortenedTs[wedge.id] = this.shrinkInternalEdgeFromBoundary(wedge, radius);
        }
        return shortenedTs;
    }

    private static Point3d pOnEdge(WingedEdge edge, double t) {
        return Util3D.linesegPoint(edge.base.n1.p, edge.base.n2.p, t);
    }

    private SplitEdge shrinkInternalEdgeFromBoundary(WingedEdge internalEdge, double radius) {
        TreeMap<Double, List<WingedEdge>> edgeHoles = new TreeMap<Double, List<WingedEdge>>();
        double t1 = 0.0;
        double t2 = 1.0;
        Point3d pedge1 = internalEdge.base.n1.p;
        Point3d pedge2 = internalEdge.base.n2.p;
        Stack<Tri> open = new Stack<Tri>();
        IdentityHashSet closedEdges = new IdentityHashSet();
        IdentityHashSet closedTris = new IdentityHashSet();
        if (internalEdge.t1 != null) {
            open.add(internalEdge.t1);
        }
        if (internalEdge.t2 != null) {
            open.add(internalEdge.t2);
        }
        while (!open.isEmpty()) {
            Tri tri = (Tri)open.pop();
            if (!closedTris.add(tri)) continue;
            for (int m = 0; m < 3; ++m) {
                Tri adjTri;
                double[] wholeEdgeIsect;
                WingedEdge wedge = tri.eu[m].wedge;
                if (wedge == internalEdge || !closedEdges.add(wedge) || (wholeEdgeIsect = Mesh.lineSegCapsuleIsect2d(pedge1, pedge2, wedge.base.n1.p, wedge.base.n2.p, radius, 1.0E-6)) == null) continue;
                if (Mesh.shouldShrinkFrom(internalEdge, wedge)) {
                    double isect0 = wholeEdgeIsect[0] * (t2 - t1) + t1;
                    double isect1 = wholeEdgeIsect[1] * (t2 - t1) + t1;
                    if (wholeEdgeIsect[0] == 0.0) {
                        isect0 = 0.0;
                    }
                    if (wholeEdgeIsect[1] == 1.0) {
                        isect1 = 1.0;
                    }
                    Mesh.addShrinkMarkers(edgeHoles, wedge, isect0, isect1);
                    if (wholeEdgeIsect[0] == 0.0) {
                        t1 = wholeEdgeIsect[1] * (t2 - t1) + t1;
                        pedge1 = Mesh.pOnEdge(internalEdge, t1);
                    }
                    if (wholeEdgeIsect[1] == 1.0) {
                        t2 = wholeEdgeIsect[0] * (t2 - t1) + t1;
                        pedge2 = Mesh.pOnEdge(internalEdge, t2);
                    }
                    if (t1 >= t2) {
                        return new SplitEdge(internalEdge, new double[0]);
                    }
                }
                if ((adjTri = tri.t[m]) == null) continue;
                open.push(adjTri);
            }
        }
        return Mesh.convertToSplitEdge(internalEdge, edgeHoles);
    }

    private static void addShrinkMarkers(Map<Double, List<WingedEdge>> edgeHoles, WingedEdge marker, double isect0, double isect1) {
        List<WingedEdge> markers1 = edgeHoles.get(isect0);
        if (markers1 == null) {
            markers1 = new LinkedList<WingedEdge>();
            edgeHoles.put(isect0, markers1);
        }
        markers1.add(marker);
        List<WingedEdge> markers2 = edgeHoles.get(isect1);
        if (markers2 == null) {
            markers2 = new LinkedList<WingedEdge>();
            edgeHoles.put(isect1, markers2);
        }
        markers2.add(marker);
    }

    public static double length2d(WingedEdge edge) {
        Point3d p1 = edge.base.n1.p;
        Point3d p2 = edge.base.n2.p;
        double dx = p1.x - p2.x;
        double dy = p1.y - p2.y;
        return Math.sqrt(dx * dx + dy * dy);
    }

    private static SplitEdge convertToSplitEdge(WingedEdge wedge, Map<Double, List<WingedEdge>> holeMarkers) {
        double[] ts;
        if (holeMarkers.isEmpty()) {
            return null;
        }
        Iterator<Map.Entry<Double, List<WingedEdge>>> holeMarkerIt = holeMarkers.entrySet().iterator();
        IdentityHashSet holeOpen = new IdentityHashSet();
        while (holeMarkerIt.hasNext()) {
            boolean isStartMarker = holeOpen.isEmpty();
            for (WingedEdge holeMarker : holeMarkerIt.next().getValue()) {
                if (holeOpen.add(holeMarker)) continue;
                holeOpen.remove(holeMarker);
            }
            if (isStartMarker || holeOpen.isEmpty()) continue;
            holeMarkerIt.remove();
        }
        assert (holeOpen.isEmpty());
        ArrayList<Double> nonHoles = new ArrayList<Double>();
        double[] holeTs = theUtil.toDoubleArray(holeMarkers.keySet());
        if (holeTs[0] != 0.0) {
            nonHoles.add(0.0);
            nonHoles.add(holeTs[0]);
        }
        for (int m = 1; m < holeTs.length - 1; m += 2) {
            nonHoles.add(holeTs[m]);
            nonHoles.add(holeTs[m + 1]);
        }
        if (holeTs[holeTs.length - 1] != 1.0) {
            nonHoles.add(holeTs[holeTs.length - 1]);
            nonHoles.add(1.0);
        }
        if ((ts = theUtil.toDoubleArray(nonHoles)).length == 2 && ts[0] == 0.0 && ts[1] == 1.0) {
            return null;
        }
        return new SplitEdge(wedge, ts);
    }

    public static Tri getSharedTri(WingedEdge e1, WingedEdge e2) {
        if (e1.t1 != null && (e1.t1 == e2.t1 || e1.t1 == e2.t2)) {
            return e1.t1;
        }
        if (e1.t2 != null && (e1.t2 == e2.t1 || e1.t2 == e2.t2)) {
            return e1.t2;
        }
        assert (false) : "Edges do not share a triangle: " + String.valueOf(e1) + ", " + String.valueOf(e2);
        return null;
    }

    private static class CloseEdgeNode {
        public final WingedEdge edge;
        public final Tri tri;
        public final Map<EPoint2d, PivotVert> pivotSides;

        public CloseEdgeNode(WingedEdge edge, Tri tri, Map<EPoint2d, PivotVert> pivotSides) {
            this.edge = edge;
            this.tri = tri;
            this.pivotSides = pivotSides;
        }
    }

    private static class EPoint2d
    extends Point2d {
        private static final long serialVersionUID = 1L;

        public EPoint2d() {
        }

        public EPoint2d(Tuple2d p) {
            super(p);
        }

        @Override
        public boolean equals(Object obj) {
            return obj == this || obj instanceof Tuple2d && super.epsilonEquals((Tuple2d)obj, 1.0E-9);
        }
    }

    public static final class EdgeDist
    implements Comparable<EdgeDist> {
        public final WingedEdge edge;
        public final double distSq;
        public final Tri destTri;

        public EdgeDist(WingedEdge edge, double distSq, Tri destTri) {
            this.edge = edge;
            this.distSq = distSq;
            this.destTri = destTri;
        }

        @Override
        public int compareTo(EdgeDist o) {
            return Double.compare(this.distSq, o.distSq);
        }
    }

    private static class PivotVert {
        public final Vertex vert;
        public final boolean dir;

        public PivotVert(Vertex vert, boolean dir) {
            this.vert = vert;
            this.dir = dir;
        }
    }

    private static class QueuedTri
    implements Comparable<QueuedTri> {
        public final Tri tri;
        public final double criteria;

        public QueuedTri(Tri tri, double criteria) {
            this.tri = tri;
            this.criteria = criteria;
        }

        @Override
        public int compareTo(QueuedTri o) {
            return Double.compare(this.criteria, o.criteria);
        }
    }

    public static class EdgeCrossing
    implements Comparable<EdgeCrossing> {
        public EdgeCrossing parent;
        public final WingedEdge edge;
        public final TriPoint enterLoc;
        public final Vector3d tangentVel;
        public final Point3d destPt;
        public final double t;
        public final Type type;

        public EdgeCrossing(EdgeCrossing parent, WingedEdge edge, Point3d loc, Tri dstTri, Point3d dstPt, Vector3d tangentVel, double t, Type type) {
            this.parent = parent;
            this.enterLoc = new TriPoint(dstTri, loc, edge);
            this.destPt = dstPt;
            this.edge = edge;
            this.t = t;
            this.tangentVel = tangentVel;
            this.type = type;
        }

        @Override
        public int compareTo(EdgeCrossing o) {
            return Double.compare(this.t, o.t);
        }

        public TriPoint traverseInTriangle(double t) {
            return Util.traverseSingleTriangle(this.enterLoc, this.tangentVel, t - this.t);
        }

        public static TriPoint find(TriPoint start, Vector3d startDir, EdgeCrossing lastCrossing, double t) {
            EdgeCrossing crossing = lastCrossing;
            while (crossing != null && t <= crossing.t) {
                crossing = crossing.parent;
            }
            if (crossing == null) {
                return Util.traceInTri(start.tri, start.p, startDir, t);
            }
            return new TriPoint(crossing.enterLoc.tri, Util3D.linePoint(crossing.enterLoc.p, crossing.tangentVel, t - crossing.t));
        }

        public List<EdgeCrossing> flatten() {
            ArrayDeque<EdgeCrossing> queue = new ArrayDeque<EdgeCrossing>();
            EdgeCrossing currcross = this;
            while (currcross != null) {
                queue.addFirst(currcross);
                currcross = currcross.parent;
            }
            return new ArrayList<EdgeCrossing>(queue);
        }

        public void finalizeCrossings() {
            EdgeCrossing crossing = this;
            Util.projectAlongZ(crossing.destPt, crossing.destPt, crossing.enterLoc.tri.plane);
            Util.projectAlongZEq(crossing.enterLoc.tri.plane, crossing.tangentVel);
            EdgeCrossing nextCrossing = crossing;
            crossing = crossing.parent;
            while (crossing != null) {
                double tdiff = nextCrossing.t - crossing.t;
                if (theUtil.gt0(tdiff, 1.0E-6)) {
                    crossing.tangentVel.sub(nextCrossing.enterLoc.p, crossing.enterLoc.p);
                    crossing.tangentVel.scale(1.0 / tdiff);
                } else {
                    crossing.tangentVel.set(0.0, 0.0, 0.0);
                }
                nextCrossing = crossing;
                crossing = crossing.parent;
            }
        }

        public boolean isValid(SplitEdge[] sedges) {
            EdgeCrossing crossing = this;
            while (crossing != null) {
                SplitEdge sedge = sedges[crossing.edge.id];
                if (sedge != null) {
                    if (!sedge.isTravellable()) {
                        return false;
                    }
                    double t = sedge.get(crossing.enterLoc.p);
                    if (!sedge.isCrossable(t)) {
                        return false;
                    }
                }
                crossing = crossing.parent;
            }
            return true;
        }

        public static enum Type {
            BOUNDARY(true),
            EXIT(true),
            CROSS(false);

            public final boolean terminal;

            private Type(boolean terminal) {
                this.terminal = terminal;
            }
        }
    }

    public static class CrossedEdgesException
    extends Exception {
        private static final long serialVersionUID = 1L;

        @Override
        public String getLocalizedMessage() {
            return "Could not finish edge crossing";
        }
    }

    private static class EdgeCrossNode {
        public final Tri tri;
        public final EdgeCrossing crossing;

        public EdgeCrossNode(Tri tri, EdgeCrossing crossing) {
            this.tri = tri;
            this.crossing = crossing;
        }
    }

    public static class ShapeTrace
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public final TriPoint loc;
        public final double t;
        public final WingedEdge boundary;
        public final WingedEdge exit;

        public ShapeTrace(TriPoint loc, double t, WingedEdge boundary, WingedEdge exit) {
            this.loc = loc;
            this.t = t;
            this.boundary = boundary;
            this.exit = exit;
        }
    }

    private static class PtBBIntersectTest
    implements ITest<AABox> {
        private final Point3d d_pt;

        public PtBBIntersectTest(Point3d pt) {
            this.d_pt = pt;
        }

        @Override
        public Containment test(AABox bb) {
            Point3d max = bb.getMax();
            Point3d min = bb.getMin();
            if (theUtil.ge(this.d_pt.x, min.x, 1.0E-6) && theUtil.le(this.d_pt.x, max.x, 1.0E-6) && theUtil.ge(this.d_pt.y, min.y, 1.0E-6) && theUtil.le(this.d_pt.y, max.y, 1.0E-6)) {
                return Containment.INTERSECTS;
            }
            return Containment.OUTSIDE;
        }
    }

    private static class PtBBIntersectResult
    implements IResult<Tri> {
        private final Point3d d_pt;
        public final NavigableMap<Double, TriPoint> ptMap;

        public PtBBIntersectResult(Point3d pt) {
            this.d_pt = pt;
            this.ptMap = new TreeMap<Double, TriPoint>();
        }

        @Override
        public void mark(Tri mt, Containment ctmt) {
            assert (ctmt != Containment.INSIDE);
            Point3d ptTri = Mesh.lineTriIntersection(this.d_pt, Z_NEG, mt);
            if (ptTri != null) {
                double zDist = Math.abs(ptTri.z - this.d_pt.z);
                this.ptMap.put(zDist, new TriPoint(mt, ptTri));
                if (zDist <= 1.0E-6) {
                    throw new CancellationException();
                }
            }
        }
    }

    private static class TrimInfo
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public final double radius;
        public final SplitEdge[] edges;
        public final Map<ANode, SplitDoor> doors;

        public TrimInfo(double radius, SplitEdge[] edges, Map<ANode, SplitDoor> doors) {
            this.radius = radius;
            this.edges = edges;
            this.doors = doors;
        }
    }

    public static class DoorSegmentEndpoint
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public final int edgeIx;
        public final double t;

        public DoorSegmentEndpoint(int edgeIx, double t) {
            this.edgeIx = edgeIx;
            this.t = t;
        }
    }
}

