/*
 * Decompiled with CFR 0.152.
 */
package common.io.pfr;

import common.io.pfr.PFRFile;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import thunderheadeng.util.TeciProps;

public class PFRReader {
    public static TeciProps read(File pfrFile) throws IOException {
        TeciProps props;
        try (BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(pfrFile), Charset.forName("UTF-8")));){
            props = new TeciProps();
            props.load(br);
            PFRFile.Version version = PFRReader.getVersion(props);
            if (version.compareTo(PFRFile.Version.V01) >= 0) {
                TeciProps teciProps = props;
                return teciProps;
            }
        }
        try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(pfrFile));){
            props = new TeciProps();
            props.load(in);
            TeciProps teciProps = props;
            return teciProps;
        }
    }

    public static PFRFile.Version getVersion(TeciProps props) {
        int version = props.getInt(PFRFile.VERSION);
        if (version >= 0 && version < PFRFile.Version.values().length) {
            return PFRFile.Version.values()[version];
        }
        return PFRFile.Version.V00;
    }
}

