/*
 * Decompiled with CFR 0.152.
 */
package common.geom;

import java.util.HashMap;
import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import thunderheadeng.delaunay.Mesh;
import thunderheadeng.delaunay.TriangulatorInfo;
import thunderheadeng.geometry.Inter3D;

public class Intersect {
    public static boolean circlePoly(Point3d circleLoc, double circleRad, Point3d[] pol) {
        if (pol == null || pol.length == 0) {
            return false;
        }
        if (Inter3D.pointInPoly(1.0E-6, circleLoc, pol)) {
            return true;
        }
        double radSq = Math.pow(circleRad, 2.0);
        for (int i = 0; i < pol.length; ++i) {
            Point3d p1 = pol[i];
            Point3d p2 = pol[(i + 1) % pol.length];
            if (!(Inter3D.distSqToNearestPtOnLineSeg(p1, p2, circleLoc) <= radSq)) continue;
            return true;
        }
        return false;
    }

    public static Point3d[] findConvexHull(Point3d[] input) {
        if (input == null || input.length == 0) {
            return null;
        }
        Mesh m = new Mesh();
        double z = input[0].z;
        for (Point3d p : input) {
            assert (p.z == z);
            m.addPoint(p.x, p.y);
        }
        m.triangulateConvexHull(0, 0.0);
        TriangulatorInfo result = m.getOutput(4);
        HashMap<Integer, Integer> nodeMap = new HashMap<Integer, Integer>();
        for (int i = 0; i < result.edges.length - 1; i += 2) {
            nodeMap.put(result.edges[i], result.edges[i + 1]);
        }
        Point3d[] convexHull = new Point3d[result.edges.length / 2];
        Point2d start = result.points[result.edges[0]];
        int currentID = result.edges[0];
        convexHull[0] = new Point3d(start.x, start.y, z);
        for (int i = 0; i < convexHull.length - 1; ++i) {
            currentID = (Integer)nodeMap.get(currentID);
            Point2d p = result.points[currentID];
            convexHull[i + 1] = new Point3d(p.x, p.y, z);
        }
        return convexHull;
    }
}

