/*
 * Decompiled with CFR 0.152.
 */
package common.data;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import merlin.Intl;
import org.jscience.physics.units.SI;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.Global;
import thunderheadeng.util.theUtil;

public interface IElevatorTimingModel {
    public static final AccelModel DEF_MODEL = new AccelModel(1.2, 2.5);

    public double getTime(double var1);

    public double getDist(double var1, double var3);

    public boolean canStop(double var1, double var3);

    public String getModelName();

    public static class AccelModel
    implements IElevatorTimingModel,
    Serializable {
        static final long serialVersionUID = 2L;
        public final double accel;
        public final double maxVel;

        public AccelModel(double accel, double maxVel) {
            this.accel = accel;
            this.maxVel = maxVel;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || !obj.getClass().equals(this.getClass())) {
                return false;
            }
            AccelModel m = (AccelModel)obj;
            return this.accel == m.accel && this.maxVel == m.maxVel;
        }

        public int hashCode() {
            return 0xFA792345 ^ Objects.hash(this.accel, this.maxVel);
        }

        @Override
        public double getTime(double dist) {
            double time;
            double tAccelToMaxVel;
            double distAccelToMaxVel;
            if ((dist = Math.abs(dist) * 0.5) > (distAccelToMaxVel = 0.5 * this.accel * (tAccelToMaxVel = this.maxVel / this.accel) * tAccelToMaxVel)) {
                double distLinear = dist - distAccelToMaxVel;
                double tLinear = distLinear / this.maxVel;
                time = tLinear + tAccelToMaxVel;
            } else {
                time = Math.sqrt(dist * 2.0 / this.accel);
            }
            return 2.0 * time >= 1.0E-6 ? 2.0 * time : 0.0;
        }

        @Override
        public double getDist(double t, double distGoal) {
            double tDecel;
            double tMaxVel;
            double tAccel;
            double tAccelMax = this.maxVel / this.accel;
            double dAccelDecelMax = 0.5 * this.accel * tAccelMax * tAccelMax * 2.0;
            double tMaxVelTot = (distGoal - dAccelDecelMax) / this.maxVel;
            double peakVelocity = this.maxVel;
            if (theUtil.lt(dAccelDecelMax, distGoal, 1.0E-6)) {
                tAccel = Math.min(t, tAccelMax);
                tMaxVel = Math.min(Math.max(0.0, t - tAccelMax), tMaxVelTot);
                tDecel = Math.max(0.0, t - tAccelMax - tMaxVelTot);
            } else {
                double tHalfDuration = Math.sqrt(distGoal / this.accel);
                tAccel = Math.min(t, tHalfDuration);
                tMaxVel = 0.0;
                tDecel = Math.max(0.0, t - tHalfDuration);
                peakVelocity = this.accel * tHalfDuration;
            }
            double dAccel = 0.5 * this.accel * tAccel * tAccel;
            double dMaxVel = peakVelocity * tMaxVel;
            double dDecel = peakVelocity * tDecel - 0.5 * this.accel * tDecel * tDecel;
            return dAccel + dMaxVel + dDecel;
        }

        @Override
        public boolean canStop(double distance, double initVel) {
            return theUtil.le(initVel / this.accel, distance, 1.0E-6);
        }

        @Override
        public String getModelName() {
            return Intl.intl("Acceleration");
        }

        public String toString() {
            return String.format(Intl.intl("%1$s up to %2$s"), Global.format(new UnitDouble(this.accel, SI.METER.divide(SI.SECOND.pow(2)))), Global.format(new UnitDouble(this.maxVel, SI.METER.divide(SI.SECOND))));
        }
    }

    public static class DistModel
    implements IElevatorTimingModel,
    Serializable {
        static final long serialVersionUID = 4L;
        private static final double coeff = 10000.0;
        public final Map<Double, Double> timeMap;
        public final double defaultVel;
        private final Map<Integer, Double> getTimeMap = new HashMap<Integer, Double>();

        public DistModel(Map<Double, Double> timeMap, double defaultVel) {
            this.timeMap = timeMap;
            this.defaultVel = defaultVel;
            for (Map.Entry<Double, Double> entry : this.timeMap.entrySet()) {
                this.getTimeMap.put(this.toKey(entry.getKey()), entry.getValue());
            }
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || !obj.getClass().equals(this.getClass())) {
                return false;
            }
            DistModel dm = (DistModel)obj;
            return this.defaultVel == dm.defaultVel && this.getTimeMap.equals(dm.getTimeMap);
        }

        public int hashCode() {
            return 0xAF983623 ^ Objects.hash(this.defaultVel, this.getTimeMap);
        }

        private int toKey(double dist) {
            return (int)(dist * 10000.0);
        }

        @Override
        public double getTime(double dist) {
            int key = this.toKey(dist);
            Double time = this.getTimeMap.get(key);
            return time != null ? time : Math.abs(dist) / this.defaultVel;
        }

        @Override
        public double getDist(double t, double distGoal) {
            int key = this.toKey(distGoal);
            Double time = this.getTimeMap.get(key);
            return time != null ? t / time * distGoal : this.defaultVel * t;
        }

        @Override
        public boolean canStop(double distance, double initVel) {
            return true;
        }

        @Override
        public String getModelName() {
            return Intl.intl("Legacy Pickup/Discharge");
        }

        public String toString() {
            return this.getModelName();
        }
    }

    public static class VelModel
    implements IElevatorTimingModel,
    Serializable {
        static final long serialVersionUID = 3L;
        public final double vel;

        public VelModel(double vel) {
            this.vel = vel;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || !obj.getClass().equals(this.getClass())) {
                return false;
            }
            VelModel m = (VelModel)obj;
            return this.vel == m.vel;
        }

        public int hashCode() {
            return 0x69823F ^ Objects.hashCode(this.vel);
        }

        @Override
        public double getTime(double dist) {
            return (dist = Math.abs(dist)) / this.vel >= 1.0E-6 ? dist / this.vel : 0.0;
        }

        @Override
        public double getDist(double t, double distGoal) {
            return t * this.vel;
        }

        @Override
        public boolean canStop(double distance, double initVel) {
            return true;
        }

        @Override
        public String getModelName() {
            return Intl.intl("Velocity");
        }

        public String toString() {
            return String.format(Intl.intl("Constant %s"), Global.format(new UnitDouble(this.vel, SI.METER.divide(SI.SECOND))));
        }
    }
}

