/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.access;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.access.GetIteratorFlattenableNodeGen;
import com.oracle.truffle.js.nodes.access.GetMethodNode;
import com.oracle.truffle.js.nodes.access.IsObjectNode;
import com.oracle.truffle.js.nodes.access.PropertyGetNode;
import com.oracle.truffle.js.nodes.function.JSFunctionCallNode;
import com.oracle.truffle.js.nodes.unary.IsCallableNode;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSArguments;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.Strings;
import com.oracle.truffle.js.runtime.Symbol;
import com.oracle.truffle.js.runtime.builtins.JSAsyncFromSyncIteratorObject;
import com.oracle.truffle.js.runtime.objects.IteratorRecord;
import com.oracle.truffle.js.runtime.objects.Undefined;

@ImportStatic(value={Symbol.class, Strings.class})
public abstract class GetIteratorFlattenableNode
extends JavaScriptBaseNode {
    protected final boolean async;
    protected final JSContext context;

    protected GetIteratorFlattenableNode(boolean async, JSContext context) {
        this.async = async;
        this.context = context;
    }

    public abstract IteratorRecord execute(Object var1);

    public static GetIteratorFlattenableNode create(boolean async, JSContext context) {
        return GetIteratorFlattenableNodeGen.create(async, context);
    }

    @Specialization(guards={"isObjectNode.executeBoolean(iteratedObject)"}, limit="1")
    protected final IteratorRecord getIteratorFlattenable(Object iteratedObject, @Cached @Cached.Shared(value="isObject") IsObjectNode isObjectNode, @Cached @Cached.Exclusive IsObjectNode isIteratorObjectNode, @Cached IsCallableNode isCallableNode, @Cached(value="create(context, SYMBOL_ASYNC_ITERATOR)") GetMethodNode getAsyncIteratorMethodNode, @Cached(value="create(context, SYMBOL_ITERATOR)") GetMethodNode getIteratorMethodNode, @Cached(value="createCall()") JSFunctionCallNode iteratorCallNode, @Cached(value="create(NEXT, context)") PropertyGetNode getNextMethodNode, @Cached InlinedBranchProfile errorBranch) {
        Object iterator;
        boolean alreadyAsync = false;
        Object method = Undefined.instance;
        if (this.async) {
            method = getAsyncIteratorMethodNode.executeWithTarget(iteratedObject);
            alreadyAsync = true;
        }
        if (!this.async || !isCallableNode.executeBoolean(method)) {
            method = getIteratorMethodNode.executeWithTarget(iteratedObject);
            alreadyAsync = false;
        }
        if (method == Undefined.instance) {
            iterator = iteratedObject;
            alreadyAsync = true;
        } else {
            iterator = iteratorCallNode.executeCall(JSArguments.create(iteratedObject, method, new Object[0]));
        }
        if (!isIteratorObjectNode.executeBoolean(iterator)) {
            errorBranch.enter((Node)this);
            throw Errors.createTypeErrorNotAnObject(iterator, this);
        }
        Object nextMethod = getNextMethodNode.getValue(iterator);
        if (!isCallableNode.executeBoolean(nextMethod)) {
            errorBranch.enter((Node)this);
            throw Errors.createTypeErrorNotAFunction(nextMethod, this);
        }
        IteratorRecord iteratorRecord = IteratorRecord.create(iterator, nextMethod, false);
        if (this.async && !alreadyAsync) {
            return this.createAsyncFromSyncIterator(iteratorRecord, getNextMethodNode);
        }
        return iteratorRecord;
    }

    @Specialization(guards={"!isObjectNode.executeBoolean(obj)"}, limit="1")
    protected final IteratorRecord unsupported(Object obj, @Cached @Cached.Shared(value="isObject") IsObjectNode isObjectNode) {
        throw Errors.createTypeErrorNotAnObject(obj, this);
    }

    private IteratorRecord createAsyncFromSyncIterator(IteratorRecord syncIteratorRecord, PropertyGetNode getNextMethodNode) {
        JSAsyncFromSyncIteratorObject asyncIterator = JSAsyncFromSyncIteratorObject.create(this.context, this.getRealm(), syncIteratorRecord);
        Object nextMethod = getNextMethodNode.getValue((Object)asyncIterator);
        return IteratorRecord.create((Object)asyncIterator, nextMethod, false);
    }
}

