/*
 * Decompiled with CFR 0.152.
 */
package results.nativebuffered.mv;

import java.awt.Dimension;
import java.awt.event.ComponentEvent;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.function.Function;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import org.jscience.physics.units.SI;
import org.jscience.physics.units.Unit;
import results.nativebuffered.session.Session;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.ConvexHull;
import thunderheadeng.geometry.Plane3d;
import thunderheadeng.io.nativexfer.ANativeObject;
import thunderheadeng.io.nativexfer.INativeObject;
import thunderheadeng.io.nativexfer.Native;
import thunderheadeng.io.nativexfer.NativeManager;
import thunderheadeng.scene3d.nativebuffered.Camera;
import thunderheadeng.scene3d.nativebuffered.RenderComponent;
import thunderheadeng.scene3d.nativebuffered.SurfaceProps;
import thunderheadeng.scene3d.nativebuffered.VideoCompressor;
import thunderheadeng.scene3d.nativebuffered.Viewport;
import thunderheadeng.scene3d.nativebuffered.nb3dUtil;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.JniTaskProgress;
import thunderheadeng.util.TaskProgress;
import thunderheadeng.video.IVideoCompressor;

public class ResultsSceneView
extends ANativeObject {
    private static final long serialVersionUID = 3142687284201642111L;
    private static final String PROP_REPAINT = "Repaint";
    private final SceneRenderComp d_rcomp = new SceneRenderComp(new SurfaceProps());

    public ResultsSceneView(Session session) {
        this.d_rcomp.setRenderer((w, vp) -> {
            this.exec(Methods.render, vp);
            Native.manager.flush();
        });
        this.d_rcomp.addPropertyChangeListener(PROP_REPAINT, e -> {
            this.exec(Methods.markDirty, new Object[0]);
            Native.manager.flush();
        });
        this.exec(Methods.init, session, this.d_rcomp.getRenderSurface());
    }

    public RenderComponent getComponent() {
        return this.d_rcomp;
    }

    @Override
    public Class<?> resolveNativeClass() {
        return ResultsSceneView.class;
    }

    private void exec(Methods method, Object ... args) {
        Native.manager.execMethod(ResultsSceneView.class, (INativeObject)this, method, args);
    }

    private <T> T exec(Methods method, Function<NativeManager, T> get, Object ... args) {
        return Native.manager.exec(ResultsSceneView.class, (INativeObject)this, (Enum)method, get, args);
    }

    public void render() {
        Dimension size = this.d_rcomp.getSize();
        this.render(new Viewport(0, 0, size.width, size.height));
    }

    public void render(Viewport vp) {
        this.d_rcomp.renderUpdate(vp);
    }

    public AABox getBounds(ObjectSet objs) {
        return this.exec(Methods.getBounds, nb3dUtil::readAABox, objs.ordinal());
    }

    public void resetCamera(AABox bounds, Vector3d view, Vector3d up, Collection<? extends Camera> cameras) {
        this.exec(Methods.resetCamera, bounds, view, up, cameras.size(), cameras);
    }

    public void animateFloors(double t) {
        this.exec(Methods.animateFloors, t);
        Native.manager.flush();
    }

    public void pickPoint(Point3d ray1, Point3d ray2, boolean append) {
        this.exec(Methods.pickPoint, ray1, ray2, append);
        Native.manager.flush();
    }

    public void pickBox(ConvexHull box, boolean append) {
        double[] coords = new double[4 * box.getPlanes().length];
        int ix = 0;
        for (Plane3d plane : box.getPlanes()) {
            coords[ix++] = plane.x;
            coords[ix++] = plane.y;
            coords[ix++] = plane.z;
            coords[ix++] = plane.w;
        }
        this.exec(Methods.pickBox, coords.length, coords, append);
        Native.manager.flush();
    }

    public void createMovie(Session session, TaskProgress progress, String filename, IVideoCompressor compressor, Dimension size, UnitDouble framerate, double speed, UnitDouble[] trange, boolean lod) throws IOException {
        assert (compressor instanceof VideoCompressor);
        if (!(compressor instanceof VideoCompressor)) {
            return;
        }
        IOException[] thrown = new IOException[]{null};
        Native.invokeAndWait(() -> {
            try (JniTaskProgress jniProgress = new JniTaskProgress(progress);){
                this.createMovie(this.getKey(), session.getKey(), filename, jniProgress.getBuffer(), ((VideoCompressor)compressor).getKey(), size.width, size.height, framerate.get(Unit.ONE.divide(SI.SECOND)), speed, trange[0].get(SI.SECOND), trange[1].get(SI.SECOND), lod);
            }
            catch (IOException e) {
                thrown[0] = e;
            }
            catch (Throwable t) {
                thrown[0] = new IOException(t);
            }
        });
        if (thrown[0] != null) {
            throw thrown[0];
        }
    }

    private native void createMovie(int var1, int var2, String var3, ByteBuffer var4, int var5, int var6, int var7, double var8, double var10, double var12, double var14, boolean var16) throws IOException;

    public void createScreenshot(Session session, String filename, Dimension size, boolean lod) throws IOException {
        try {
            Native.manager.execThrowable(ResultsSceneView.class, (INativeObject)this, (Enum)Methods.createScreenshot, session, filename, size.width, size.height, lod);
        }
        catch (IOException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new IOException(t);
        }
    }

    static {
        nb3dUtil.registerTypes();
    }

    private static class SceneRenderComp
    extends RenderComponent {
        private static final long serialVersionUID = 1086444550260834033L;
        private Viewport d_vp = null;

        public SceneRenderComp(SurfaceProps props) {
            super(props);
        }

        @Override
        protected synchronized void forceRender(Viewport clippingVP) {
            this.addViewport(clippingVP);
            this.fireRepaint();
        }

        public void renderUpdate(Viewport vp) {
            this.addViewport(vp);
            super.forceRender(this.d_vp);
            this.d_vp = null;
        }

        private void addViewport(Viewport vp) {
            if (this.d_vp != null) {
                this.d_vp = new Viewport(this.d_vp.x(), this.d_vp.y(), this.d_vp.w(), this.d_vp.h());
                this.d_vp.add(vp);
            } else {
                this.d_vp = vp;
            }
        }

        private void fireRepaint() {
            this.firePropertyChange(ResultsSceneView.PROP_REPAINT, false, true);
        }

        @Override
        protected void processComponentEvent(ComponentEvent e) {
            super.processComponentEvent(e);
            switch (e.getID()) {
                case 101: 
                case 102: {
                    this.fireRepaint();
                }
            }
        }
    }

    private static enum Methods {
        init,
        render,
        markDirty,
        getBounds,
        resetCamera,
        animateFloors,
        createScreenshot,
        pickPoint,
        pickBox;

    }

    public static enum ObjectSet {
        ALL,
        SELECTED;

    }
}

