/*
 * Decompiled with CFR 0.152.
 */
package results.nativebuffered.mv;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Stream;
import javax.swing.JSeparator;
import merlin.MerlinPrefs;
import org.jscience.physics.units.SI;
import org.jscience.physics.units.Unit;
import results.api.Events;
import results.api.IView;
import results.nativebuffered.mv.MVActions;
import results.nativebuffered.mv.MVCameras;
import results.nativebuffered.mv.MVMedia;
import results.nativebuffered.mv.MVTools;
import results.nativebuffered.mv.MVViewProps;
import results.nativebuffered.mv.ResultsSceneView;
import results.nativebuffered.mv.SceneMode;
import results.nativebuffered.mv.Selector;
import results.nativebuffered.session.Session;
import results.nativebuffered.session.SessionMediator;
import thunderheadeng.gui.Utils;
import thunderheadeng.gui.animate.StatusView;
import thunderheadeng.gui.animate.TimeView;
import thunderheadeng.gui.colorscheme.ColorMgr;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.gui.guiStatusMessage;
import thunderheadeng.gui.guiToolBar;
import thunderheadeng.gui.tool.IDeviceManager;
import thunderheadeng.gui.tool.Tool;
import thunderheadeng.scene3d.nativebuffered.ModelScene;
import thunderheadeng.scene3d.navtools.IToolController;
import thunderheadeng.scene3d.picking.GeomPicker;
import thunderheadeng.util.IBindable;
import thunderheadeng.util.IEventObserver;
import thunderheadeng.util.IEventRecord;
import thunderheadeng.util.TypedProp;

public class ModelView
extends guiPanel
implements IView,
IEventObserver,
IToolController {
    private static final long serialVersionUID = -3525461376158352262L;
    private final SessionMediator d_mediator;
    private final Session d_session;
    private final ColorMgr d_colors;
    private final ResultsSceneView d_sceneView;
    private final TimeView d_timeView;
    private final StatusView d_statusView;
    private final MVActions d_actions;
    private final guiStatusMessage d_statusMsg;
    private final MVTools d_tools;
    private final MVCameras d_cameras;
    private final MVViewProps d_viewProps;
    private final MVMedia d_record;
    private final List<IBindable> d_bindables;
    private final Map<SceneMode, ModeInfo> d_modeInfos;
    private final ModelScene d_toolScene3d = new ModelScene();
    private final ModelScene d_toolScene2d = new ModelScene();

    public ModelView(SessionMediator mediator) {
        this.d_bindables = new ArrayList<IBindable>();
        this.d_session = mediator.getSession();
        this.d_mediator = mediator;
        this.d_colors = new ColorMgr();
        this.d_sceneView = new ResultsSceneView(this.d_session);
        this.d_record = new MVMedia(mediator, this.d_sceneView);
        this.d_bindables.add(this.d_record);
        this.d_timeView = new TimeView(mediator, this.d_session, 3, this.d_record.createRecordUI());
        this.d_bindables.add(this.d_timeView);
        this.d_statusMsg = new guiStatusMessage();
        this.d_statusView = new StatusView(mediator, this.d_session);
        this.d_statusView.getBarInfo().bar.setStatusMessage(this.d_statusMsg);
        this.d_bindables.add(this.d_statusView);
        this.d_actions = new MVActions(mediator);
        this.d_bindables.add(this.d_actions);
        this.d_tools = new MVTools(mediator, this.d_sceneView.getComponent(), this.d_sceneView.getComponent(), new Selector(this.d_sceneView, this.d_session), this, () -> this.d_sceneView.getBounds(ResultsSceneView.ObjectSet.ALL));
        this.d_bindables.add(this.d_tools);
        this.d_cameras = new MVCameras(mediator, () -> this.d_tools.mgr.getCurrentTool() == this.d_tools.modGameRoamTool, this.d_sceneView);
        this.d_bindables.add(this.d_cameras);
        this.d_viewProps = new MVViewProps(mediator, this.d_sceneView);
        this.d_bindables.add(this.d_viewProps);
        this.d_modeInfos = new HashMap<SceneMode, ModeInfo>();
        this.d_modeInfos.put(SceneMode.MODE2D, this.createMode2d());
        this.d_modeInfos.put(SceneMode.MODE3D, this.createMode3d());
        guiToolBar tb = new guiToolBar();
        tb.setFloatable(false);
        Consumer<guiToolBar> addTB = tbchild -> {
            tbchild.setFloatable(false);
            Utils.noToolBarFocus(tbchild);
            tb.add((Component)tbchild);
        };
        addTB.accept(this.d_cameras.createCameraSelectionToolbar());
        tb.addSeparator();
        addTB.accept(this.d_tools.createNavToolbar());
        tb.addSeparator();
        addTB.accept(this.d_cameras.createCameraResetToolBar());
        tb.addSeparator();
        addTB.accept(this.d_viewProps.createViewPropsToolBar());
        tb.addSeparator();
        guiToolBar fsettb = this.d_viewProps.createFloorSettingsToolBar();
        fsettb.setFloatable(false);
        tb.add(fsettb);
        Utils.noToolBarFocus(tb);
        this.setLayout(new BorderLayout());
        this.add((Component)tb, "North");
        this.add((Component)this.d_sceneView.getComponent(), "Center");
        guiPanel spanel1 = new guiPanel(new BorderLayout());
        spanel1.add((Component)this.d_timeView.getViewUI(), "Center");
        spanel1.add((Component)new JSeparator(), "South");
        guiPanel spanel = new guiPanel(new BorderLayout());
        spanel.add((Component)spanel1, "Center");
        spanel.add(this.d_statusView.getViewUI(), "South");
        this.add((Component)spanel, "South");
        this.sync();
    }

    @Override
    public void connect() {
        this.d_mediator.getEvents().addObserver(this);
        this.d_bindables.forEach(IBindable::connect);
    }

    @Override
    public void disconnect() {
        this.d_bindables.forEach(IBindable::disconnect);
        this.d_mediator.getEvents().removeObserver(this);
    }

    @Override
    public <T> T getPreference(TypedProp<T> pref) {
        return MerlinPrefs.instance().getSystemOverLocal(pref);
    }

    @Override
    public boolean endTool(Tool tool, boolean cancelled) {
        return this.d_tools.mgr.endTool(tool, cancelled);
    }

    @Override
    public void backgroundTaskStarted(Runnable cancel) {
    }

    @Override
    public void backgroundTaskEnded(Runnable cancelOp) {
    }

    private void sync() {
        this.syncMode();
        this.d_timeView.sync();
        this.d_statusView.sync();
    }

    private void syncMode() {
    }

    public void resetCameras(ResultsSceneView.ObjectSet objs, boolean allCameras) {
        if (allCameras) {
            this.d_cameras.resetCameras(Stream.of(Session.PredefCamera.values()), objs);
        } else {
            this.d_cameras.resetCamera(objs);
        }
    }

    private ModeInfo createMode2d() {
        ModeInfo mode = new ModeInfo();
        return mode;
    }

    private ModeInfo createMode3d() {
        ModeInfo mode = new ModeInfo();
        return mode;
    }

    @Override
    public Component getViewUI() {
        return this;
    }

    @Override
    public void update(thunderheadeng.util.Events events) {
        IEventRecord<Session> sevts = events.getEvents(Session.class, new Class[0]);
        if (sevts.isChanged(this.d_session, (Object)Events.PATHFINDER_RESULTS_ATTACHED) || sevts.isChanged(this.d_session, (Object)Events.PATHFINDER_RESULTS_DETACHED)) {
            this.sync();
        } else if (SceneMode.isChanged(this.d_session, events)) {
            this.syncMode();
        }
        if (sevts.getChangedObjs(new Object[]{Events.PATHFINDER_RESULTS_ATTACHED, Events.FDS_RESULTS_ATTACHED}).contains(this.d_session)) {
            this.resetCameras(ResultsSceneView.ObjectSet.ALL, true);
        }
        this.render();
    }

    protected void render() {
        this.d_sceneView.render();
    }

    @Override
    public Component getRenderComp() {
        return this.d_sceneView.getComponent();
    }

    @Override
    public ModelScene[] getToolScenes() {
        return new ModelScene[]{this.d_toolScene3d, this.d_toolScene2d};
    }

    @Override
    public ColorMgr getColors() {
        return this.d_colors;
    }

    @Override
    public guiStatusMessage getStatusMessage() {
        return this.d_statusMsg;
    }

    @Override
    public GeomPicker getSnapper() {
        return null;
    }

    @Override
    public Unit[] getLengthUnits() {
        return new Unit[]{SI.METER, SI.METER};
    }

    @Override
    public Session getAnimSession() {
        return this.d_session;
    }

    @Override
    public IDeviceManager getDevices() {
        return this.d_tools.mgr.getDevices();
    }

    private static class ModeInfo {
        private ModeInfo() {
        }
    }
}

