/*
 * Decompiled with CFR 0.152.
 */
package merlin.util;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Stream;
import merlin.actions.Undo;
import merlin.data.ICompElement;
import merlin.data.IMerlinObj;
import merlin.data.IRestorable;
import merlin.data.MerlinData;
import merlin.data.property.IDisplayProp;
import merlin.data.scenario.Scenario;
import merlin.util.MerlinDepSnapshot;
import merlin.util.MerlinUtil;
import thunderheadeng.dependencies.DLink;
import thunderheadeng.dependencies.DepCallback;
import thunderheadeng.dependencies.DepSnapshot;
import thunderheadeng.util.IPropertySet;
import thunderheadeng.util.LinkedIdentityHashMap;
import thunderheadeng.util.LinkedIdentityHashSet;
import thunderheadeng.util.Nullable;
import thunderheadeng.util.Predicates;
import thunderheadeng.util.stat.IUrn;
import thunderheadeng.util.stat.InfiniteUrn;
import thunderheadeng.util.stat.Urn;

public class Dependencies {
    public static void getObjReferences(MerlinData md, Predicate<? super Scenario> scenarios, Predicate<? super IMerlinObj> referencedTest, DepSnapshot.RefConsumer<? super IMerlinObj, ? super IMerlinObj> references) {
        Dependencies.getObjReferences(md, scenarios, Predicates.alwaysTrue(), referencedTest, references);
    }

    public static <T extends IMerlinObj> LinkedIdentityHashSet<T> getObjReferences(MerlinData md, Predicate<? super Scenario> scenarios, Class<T> type, Predicate<? super T> referencedTest) {
        LinkedIdentityHashSet result = new LinkedIdentityHashSet();
        Dependencies.getObjReferences(md, scenarios, (Class<? extends IMerlinObj> t) -> type.isAssignableFrom((Class<?>)t), (? super IMerlinObj o) -> referencedTest.test(o), (? super IMerlinObj src, DLink link, ? super IMerlinObj target) -> result.add(target));
        return result;
    }

    public static <T> void getObjReferences(MerlinData md, Predicate<? super Scenario> scenarios, Class<T> type, Predicate<? super T> referencedTest, DepSnapshot.RefConsumer<? super IMerlinObj, ? super T> references) {
        Dependencies.getObjReferences(md, scenarios, (Class<? extends IMerlinObj> t) -> type.isAssignableFrom((Class<?>)t), (? super IMerlinObj o) -> referencedTest.test(o), (? super IMerlinObj src, DLink link, ? super IMerlinObj target) -> references.accept((IMerlinObj)src, link, (Object)target));
    }

    private static Predicate<Object> toPredicate(Predicate<Class<? extends IMerlinObj>> types, Predicate<? super IMerlinObj> referencedTest) {
        Predicate<Object> typeTest;
        Predicate<Object> predicate = Predicates.alwaysTrue(types) ? o -> o instanceof IMerlinObj : (typeTest = Predicates.alwaysFalse(types) ? Predicates.alwaysFalse() : o -> o instanceof IMerlinObj && types.test(((IMerlinObj)o).getClass()));
        Predicate objTest = Predicates.alwaysTrue(referencedTest) ? Predicates.alwaysTrue() : (Predicates.alwaysFalse(referencedTest) ? Predicates.alwaysFalse() : o -> referencedTest.test((IMerlinObj)o));
        return Predicates.and(typeTest, objTest);
    }

    public static void getObjReferences(MerlinData md, Predicate<? super Scenario> scenarios, Predicate<Class<? extends IMerlinObj>> types, Predicate<? super IMerlinObj> referencedTest, DepSnapshot.RefConsumer<? super IMerlinObj, ? super IMerlinObj> references) {
        Predicate<Object> test = Dependencies.toPredicate(types, referencedTest);
        MerlinDepSnapshot deps = new MerlinDepSnapshot(md, scenarios, test);
        deps.start(md, md.getChildren());
        deps.getObjReferences(IMerlinObj.class, IMerlinObj.class, test, references);
    }

    public static <T extends IMerlinObj> void getObjReferences(MerlinData md, Predicate<? super Scenario> scenarios, Collection<? extends IMerlinObj> sourceObjs, Class<T> type, Predicate<? super T> referencedTest, DepSnapshot.RefConsumer<? super IMerlinObj, ? super T> references) {
        Dependencies.getObjReferences(md, scenarios, sourceObjs, (Class<? extends IMerlinObj> t) -> type.isAssignableFrom((Class<?>)t), (? super IMerlinObj o) -> referencedTest.test(o), (? super IMerlinObj src, DLink link, ? super IMerlinObj target) -> references.accept((IMerlinObj)src, link, (Object)target));
    }

    public static void getObjReferences(MerlinData md, Predicate<? super Scenario> scenarios, Collection<? extends IMerlinObj> sourceObjs, Predicate<Class<? extends IMerlinObj>> types, Predicate<? super IMerlinObj> referencedTest, DepSnapshot.RefConsumer<? super IMerlinObj, ? super IMerlinObj> references) {
        Predicate<Object> test = Dependencies.toPredicate(types, referencedTest);
        MerlinDepSnapshot deps = new MerlinDepSnapshot(md, scenarios, test);
        deps.takeSnapshot(sourceObjs);
        deps.getObjReferences(IMerlinObj.class, IMerlinObj.class, test, references);
    }

    public static <SrcT extends ICompElement, ValT, RefT> DepCallback<MerlinData, SrcT, ValT, RefT> newDependency(IPropertySet.Prop<ValT> prop, DLink link, Class<RefT> refType, DepCallback.StreamRefs<MerlinData, SrcT, ValT, RefT> streamRefs, Predicate<? super RefT> replFilter, DepCallback.ReplaceDependencyVal<MerlinData, SrcT, ValT, RefT> replaceRef) {
        return Dependencies.newDependency(prop, link, refType, streamRefs, replFilter != null ? (md, src) -> replFilter : null, replaceRef);
    }

    public static <SrcT extends ICompElement, ValT, RefT> DepCallback<MerlinData, SrcT, ValT, RefT> newDependencyGeneric(IPropertySet.Prop<ValT> prop, DLink link, Class refType, RefT unused, DepCallback.StreamRefs<MerlinData, SrcT, ValT, RefT> streamRefs, DepCallback.GetReplacementFilter<MerlinData, SrcT, RefT> getReplFilter, DepCallback.ReplaceDependencyVal<MerlinData, SrcT, ValT, RefT> replaceRef) {
        return Dependencies.newDependency(prop, link, refType, streamRefs, getReplFilter, replaceRef);
    }

    public static <SrcT extends ICompElement, ValT, RefT> DepCallback<MerlinData, SrcT, ValT, RefT> newDependency(IPropertySet.Prop<ValT> prop, DLink link, Class<RefT> refType, DepCallback.StreamRefs<MerlinData, SrcT, ValT, RefT> streamRefs, DepCallback.GetReplacementFilter<MerlinData, SrcT, RefT> getReplFilter, DepCallback.ReplaceDependencyVal<MerlinData, SrcT, ValT, RefT> replaceRef) {
        assert (prop != null);
        return new DepCallback<MerlinData, ICompElement, Object, Object>(link, refType, streamRefs, getReplFilter, new DepCallback.ReplaceDep<MerlinData, ICompElement, Object, Object>((md, src) -> {
            Optional oval = src.getNullableProp(prop);
            assert (oval.isPresent());
            return oval.orElse(Nullable.getNull()).val;
        }, (md, src, ref) -> Dependencies.defaultUndoPropRestore(md, src, prop), (md, src, val) -> src.setProp(prop, val), replaceRef));
    }

    public static <T> void defaultUndoPropRestore(MerlinData md, ICompElement src, IPropertySet.Prop<T> prop) {
        if (src.isWrapperProp(prop)) {
            if (src instanceof IRestorable) {
                IRestorable rest = (IRestorable)((Object)src);
                Undo.insertUndoEntry_restore(md, rest);
                return;
            }
            if (!$assertionsDisabled) {
                String string;
                Object[] objectArray = new Object[3];
                objectArray[0] = src.getClass().getSimpleName();
                objectArray[1] = IRestorable.class.getSimpleName();
                if (prop instanceof IDisplayProp) {
                    IDisplayProp dprop = (IDisplayProp)((Object)prop);
                    string = dprop.getDisplayName();
                } else {
                    string = prop.toString();
                }
                objectArray[2] = string;
                throw new AssertionError((Object)String.format("%s must implement %s in order to use property, %s", objectArray));
            }
        }
        Undo.insertUndoEntry_propRestore(md, src, prop);
    }

    public static <SrcT extends ICompElement, RefT> DepCallback<MerlinData, SrcT, RefT, RefT> newDependencyAsValue(IPropertySet.Prop<RefT> prop, DLink link, Class<RefT> refType, Predicate<? super RefT> replacementFilter) {
        return Dependencies.newDependency(prop, link, refType, (MerlinData md, SrcT src, ValT val) -> Stream.of(val), replacementFilter, (MerlinData md, SrcT src, ValT val, RefT old, RefT replacement) -> {
            assert (val == old);
            return replacement;
        });
    }

    public static <SrcT extends ICompElement, RefT> DepCallback<MerlinData, SrcT, Set<RefT>, RefT> newDependencyInSet(IPropertySet.Prop<Set<RefT>> prop, DLink link, Class<RefT> refType, Predicate<? super RefT> replacementFilter) {
        return Dependencies.newDependency(prop, link, refType, (MerlinData md, SrcT src, ValT set) -> set.stream(), replacementFilter, (MerlinData md, SrcT src, ValT val, RefT old, RefT replacement) -> Dependencies.replaceSetValue(val, old, replacement));
    }

    public static <RefT> boolean replaceSetValue(IPropertySet.Prop<Set<RefT>> prop, ICompElement src, RefT old, RefT replacement) {
        if (!src.getProp(prop).isPresent() || !src.getProp(prop).get().contains(old)) {
            return false;
        }
        Set objs = Dependencies.replaceSetValue(src.getProp(prop).orElse(Collections.emptySet()), old, replacement);
        src.setProp(prop, objs);
        return true;
    }

    public static <RefT> Set<RefT> replaceSetValue(Set<RefT> val, RefT old, RefT replacement) {
        Set<Object> objs = new LinkedIdentityHashSet<RefT>(val);
        if (!objs.remove(old) && replacement == null) {
            return val;
        }
        if (replacement != null) {
            objs.add(replacement);
        }
        if (objs.isEmpty()) {
            objs = Collections.emptySet();
        } else if (objs.size() == 1) {
            objs = Collections.singleton(objs.iterator().next());
        }
        return objs;
    }

    public static <SrcT extends ICompElement, RefT> DepCallback<MerlinData, SrcT, IUrn<RefT>, RefT> newDependencyInUrn(IPropertySet.Prop<IUrn<RefT>> prop, DLink link, Class<RefT> refType, Predicate<? super RefT> replacementFilter) {
        return Dependencies.newDependency(prop, link, refType, (MerlinData md, SrcT src, ValT urn) -> urn.stream(), replacementFilter, (MerlinData md, SrcT src, ValT urn, RefT old, RefT replacement) -> Dependencies.replaceUrnValue(urn, old, replacement));
    }

    public static <T> boolean replaceUrnValue(IPropertySet.Prop<IUrn<T>> prop, ICompElement src, T old, T repl) {
        IUrn<T> prev = src.getProp(prop).get();
        IUrn<T> result = Dependencies.replaceUrnValue(prev, old, repl);
        if (result == prev) {
            return false;
        }
        src.setProp(prop, result);
        return true;
    }

    public static <T> IUrn<T> replaceUrnValue(IUrn<T> urn, T old, T repl) {
        Map<T, Double> oldDists = urn.getWeights();
        if (!oldDists.containsKey(old)) {
            return urn;
        }
        LinkedIdentityHashMap<Object, Double> dists = new LinkedIdentityHashMap<Object, Double>(oldDists.size());
        Double toDistribute = null;
        boolean containsRepl = repl != null && oldDists.containsKey(repl) && oldDists.get(repl) != 0.0;
        for (Map.Entry<T, Double> entry : oldDists.entrySet()) {
            if (entry.getValue() == 0.0) continue;
            if (entry.getKey() == old) {
                if (repl != null && !containsRepl) {
                    dists.put(repl, entry.getValue());
                    continue;
                }
                toDistribute = entry.getValue();
                continue;
            }
            dists.put(entry.getKey(), entry.getValue());
        }
        if (dists.isEmpty()) {
            return new Urn<Object>(new Object[0]);
        }
        if (containsRepl && toDistribute != null) {
            dists.merge(repl, toDistribute, Double::sum);
        } else if (toDistribute != null) {
            double toDist = toDistribute / (double)dists.size();
            dists.replaceAll((v, d) -> d + toDist);
        }
        return new InfiniteUrn(dists);
    }

    public static <SrcT extends ICompElement, RefT> DepCallback<MerlinData, SrcT, RefT[], RefT> newDependencyInArray(IPropertySet.Prop<RefT[]> prop, DLink link, Class<RefT> refType, Predicate<? super RefT> replacementFilter, boolean compress) {
        return Dependencies.newDependency(prop, link, refType, (MerlinData md, SrcT src, ValT arr) -> Stream.of(arr), replacementFilter, (MerlinData md, SrcT src, ValT urn, RefT old, RefT replacement) -> Dependencies.replaceArrayValue(urn, old, replacement, compress));
    }

    public static <T> T[] replaceArrayValue(T[] arr, T old, T repl, boolean compress) {
        T[] newArr = Arrays.copyOf(arr, arr.length);
        Arrays.asList(newArr).replaceAll(m -> m == old ? repl : m);
        if (compress && newArr.length > 1 && MerlinUtil.isUniform(newArr, (m1, m2) -> m1 == m2)) {
            newArr = Arrays.copyOf(newArr, 1);
        }
        return newArr;
    }

    public static final <SrcT, RefT> DepCallback<MerlinData, SrcT, RefT, RefT> newDependencyContainedBy(Class<RefT> refType) {
        return new DepCallback<MerlinData, Object, Object, RefT>(DLink.CONTAINED_BY, refType, (md, src, val) -> Stream.of(val), (Predicate)null, null);
    }

    public static final <SrcT, RefT> DepCallback<MerlinData, SrcT, RefT, RefT> newDependencyNoReplace(Class<RefT> refType) {
        return new DepCallback<MerlinData, Object, Object, RefT>(DLink.STRONG, refType, (md, src, val) -> Stream.of(val), (Predicate)null, null);
    }
}

