/*
 * Decompiled with CFR 0.152.
 */
package merlin.mv.tools;

import merlin.data.MerlinData;
import merlin.geom.Geometry;
import merlin.manip.RotateManip;
import merlin.mv.ModelView;
import merlin.mv.tools.MerlinToolHooks;
import merlin.mv.tools.TransformToolHelper;
import thunderheadeng.scene3d.nativebuffered.INativeDisplayProps;
import thunderheadeng.scene3d.nativebuffered.ModelScene;
import thunderheadeng.scene3d.tools.transform.RotateTool;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.units.UnitPoint3D;

public class RotateTool
extends thunderheadeng.scene3d.tools.transform.RotateTool {
    private final TransformToolHelper<RotateManip> d_helper;

    public RotateTool(MerlinData md, ModelView mv, RotateManip xform, ModelScene toolScene, INativeDisplayProps dispProps) {
        super(mv, xform, toolScene, dispProps, new MerlinToolHooks(md));
        this.d_helper = new TransformToolHelper<RotateManip>(this, xform);
    }

    @Override
    public void activate() {
        super.activate();
        this.d_helper.activate();
    }

    @Override
    public void deactivate() {
        this.d_helper.deactivate();
        super.deactivate();
    }

    @Override
    public boolean cancel() {
        return this.d_helper.tryCancel(() -> super.cancel());
    }

    @Override
    protected void setTransform(RotateTool.RotInfo ri) {
        RotateManip rot = this.d_helper.getProps();
        rot.pause();
        super.setTransform(ri);
        if (ri.base != null) {
            rot.setBase(new UnitPoint3D(ri.base, Geometry.LENGTH_UNIT));
        }
        if (ri.axis != null) {
            rot.setRotateAxis(ri.axis);
        }
        if (!Double.isNaN(ri.angle)) {
            rot.setAngle(new UnitDouble(ri.angle, Geometry.ANGLE_UNIT));
        }
        rot.resume();
    }
}

