/*
 * Decompiled with CFR 0.152.
 */
package merlin.mv.tools;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CancellationException;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import merlin.data.MerlinData;
import merlin.data.egress.geom.EgressRoom;
import merlin.geom.GeomUtil;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.AABoxTest;
import thunderheadeng.geometry.Inter3D;
import thunderheadeng.geometry.LineSegRTreeTest;
import thunderheadeng.geometry.Plane3d;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.geometry.nmt.Edge;
import thunderheadeng.geometry.nmt.Face;
import thunderheadeng.geometry.nmt.Model;
import thunderheadeng.geometry.objs.LineSeg;
import thunderheadeng.geometry.objs.elem.IPrimElements;
import thunderheadeng.geometry.search.Containment;
import thunderheadeng.geometry.search.IResult;
import thunderheadeng.geometry.search.ITest;
import thunderheadeng.scene3d.geom.IDisplayableGeomSrc;
import thunderheadeng.scene3d.picking.GeomType;
import thunderheadeng.scene3d.picking.IsectInfo;
import thunderheadeng.util.LinkedIdentityHashMap;
import thunderheadeng.util.theUtil;

public class RoomToolUtil {
    public static Collection<IsectInfo> findRoomIsects(MerlinData md, Runnable validateProgress, Point3d rayBegin, Vector3d rayDir) {
        Collection<GeomUtil.FindResult> rooms = GeomUtil.findRooms(md, validateProgress, rayBegin, rayDir, Double.POSITIVE_INFINITY, 0);
        if (rooms.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<IsectInfo> iis = new ArrayList<IsectInfo>(rooms.size());
        for (GeomUtil.FindResult fr : rooms) {
            validateProgress.run();
            Vector3d normal = fr.faceNormal;
            iis.add(new IsectInfo(GeomType.FACE, fr.room, fr.p, null, () -> normal, IPrimElements.NONE, null, null));
        }
        return iis;
    }

    public static void project(MerlinData md, Point3d p1, Point3d p2, List<Projection> result) {
        Point3d[][] attempts;
        for (Point3d[] attempt : attempts = new Point3d[][]{{p1, p2}, {p2, p1}}) {
            if (!RoomToolUtil.projectOneWay(md, attempt[0], attempt[1], result)) continue;
            return;
        }
    }

    private static boolean projectOneWay(MerlinData md, Point3d p1, Point3d p2, List<Projection> result) {
        Vector3d dir = Util3D.vector(p1, p2);
        ArrayDeque<ProjectionNode> open = new ArrayDeque<ProjectionNode>();
        ArrayList<Projection> tProjections = new ArrayList<Projection>();
        RoomToolUtil.findProjections(md, null, p1, p2, dir, tProjections);
        for (Projection proj : tProjections) {
            open.addLast(new ProjectionNode(null, proj));
        }
        while (!open.isEmpty()) {
            ProjectionNode node = (ProjectionNode)open.pollLast();
            if (node.projection.seg.p2.epsilonEquals(p2, 1.0E-6)) {
                node.flatten(result);
                return true;
            }
            Point3d newP1 = node.projection.seg.p2;
            tProjections.clear();
            RoomToolUtil.findProjections(md, node.projection.seg, newP1, p2, Util3D.vector(newP1, p2), tProjections);
            if (tProjections.isEmpty() && open.isEmpty()) {
                node.flatten(result);
                return false;
            }
            for (Projection proj : tProjections) {
                open.addLast(new ProjectionNode(node, proj));
            }
        }
        return false;
    }

    private static boolean findProjections(MerlinData md, final LineSeg prevSeg, final Point3d p1, final Point3d p2, final Vector3d dir, final List<Projection> result) {
        final ArrayList tsegs = new ArrayList();
        try {
            md.geomLocation.getLocator().find((ITest<AABox>)new AABoxTest(new AABox(p1, p1), 1.0E-6), (IResult<? super IDisplayableGeomSrc>)new IResult<IDisplayableGeomSrc>(){

                @Override
                public void mark(IDisplayableGeomSrc obj, Containment ctmt) {
                    if (!(obj instanceof EgressRoom)) {
                        return;
                    }
                    EgressRoom er = (EgressRoom)obj;
                    tsegs.clear();
                    boolean endFound = RoomToolUtil.findProjections(er.getModel(), prevSeg, p1, p2, dir, tsegs);
                    if (endFound) {
                        result.clear();
                    }
                    for (LineSeg ls : tsegs) {
                        result.add(new Projection(er, ls));
                    }
                    if (endFound) {
                        throw new CancellationException();
                    }
                }
            }, 0);
        }
        catch (CancellationException e) {
            return true;
        }
        return false;
    }

    private static boolean findProjections(Model model, LineSeg prevSeg, Point3d p1, Point3d endPt, Vector3d dir, List<LineSeg> result) {
        List<Face> faces = RoomToolUtil.findFaces(model, p1);
        if (faces.isEmpty()) {
            return false;
        }
        Point3d midPoint = Util3D.getMidPoint(p1, endPt);
        for (Face face : faces) {
            Vector3d[] testDirs;
            if (theUtil.eq0(face.plane.z, 1.0E-6)) {
                double zScale = face.getBounds().getHeight() * 1.1;
                if (prevSeg != null && RoomToolUtil.eq2d(prevSeg.p1, prevSeg.p2, 1.0E-6)) {
                    Vector3d tdir = Util3D.vectorN(prevSeg.p1, prevSeg.p2);
                    tdir.scale(zScale);
                    testDirs = new Vector3d[]{tdir};
                } else {
                    testDirs = new Vector3d[]{new Vector3d(0.0, 0.0, zScale), new Vector3d(0.0, 0.0, -zScale)};
                }
            } else {
                testDirs = new Vector3d[]{RoomToolUtil.projectAlongZ(face.plane, dir)};
            }
            for (Vector3d fdir : testDirs) {
                Point3d p2 = Util3D.add(p1, (Tuple3d)fdir);
                List<Edge> edges = model.findEdge(new LineSegRTreeTest(p1, p2));
                double mint = Double.MAX_VALUE;
                Tuple3d minIsect = null;
                for (Edge edge : edges) {
                    double[] isect;
                    if (!edge.faces.contains(face) || (isect = Inter3D.getLineSegLineSegIntersection(p1, p2, edge.curve.get(0.0), edge.curve.get(1.0), 1.0E-6, 1.0E-6)) == null || isect[0] >= mint || theUtil.eq0(isect[0], 1.0E-6)) continue;
                    mint = isect[0];
                    minIsect = edge.curve.get(isect[1]);
                }
                if (minIsect == null && RoomToolUtil.pointInFace(model, face, endPt) && RoomToolUtil.pointInFace(model, face, midPoint)) {
                    mint = 1.0;
                    minIsect = endPt;
                }
                if (minIsect == null || !RoomToolUtil.pointInFace(model, face, Util3D.getMidPoint(p1, minIsect))) continue;
                boolean endReached = minIsect.epsilonEquals(endPt, 1.0E-6);
                if (endReached) {
                    result.clear();
                }
                result.add(new LineSeg(p1, (Point3d)minIsect));
                if (!endReached) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean pointInFace(Model model, Face face, Point3d p) {
        Point3d projp = face.plane.projectOntoPlane(p);
        if (!Model.compare(projp, p)) {
            return false;
        }
        return model.testPointOnFace((Face)face, (Point3d)projp).on;
    }

    private static boolean eq2d(Point3d p1, Point3d p2, double tol) {
        double maxDiff = Math.max(Math.abs(p1.x - p2.x), Math.abs(p1.y - p2.y));
        return maxDiff <= tol;
    }

    private static List<Face> findFaces(Model model, Point3d p) {
        ArrayList<Face> faces = new ArrayList<Face>();
        for (Face face : model.findFaces(new AABox(p, p))) {
            if (!RoomToolUtil.pointInFace(model, face, p)) continue;
            faces.add(face);
        }
        return faces;
    }

    private static Point3d projectAlongZ(Plane3d plane, Point3d p) {
        if (plane.z == 0.0) {
            return p;
        }
        double newz = -(plane.w + plane.x * p.x + plane.y * p.y) / plane.z;
        if (theUtil.eq(newz, p.z, 0.0)) {
            return p;
        }
        return new Point3d(p.x, p.y, newz);
    }

    private static Vector3d projectAlongZ(Plane3d plane, Vector3d dir) {
        if (dir.x == 0.0 && dir.y == 0.0 || plane.z == 0.0 || plane.x * dir.x + plane.y * dir.y + plane.z * dir.z == 0.0) {
            return dir;
        }
        double dirz = (-plane.x * dir.x - plane.y * dir.y) / plane.z;
        if (theUtil.eq(dirz, dir.z, 0.0)) {
            return dir;
        }
        return new Vector3d(dir.x, dir.y, dirz);
    }

    public static Map<EgressRoom, List<LineSeg>> convertToMap(Collection<Projection> projections) {
        LinkedIdentityHashMap<EgressRoom, List<LineSeg>> projMap = new LinkedIdentityHashMap<EgressRoom, List<LineSeg>>();
        for (Projection proj : projections) {
            ArrayList<LineSeg> segs = (ArrayList<LineSeg>)projMap.get(proj.room);
            if (segs == null) {
                segs = new ArrayList<LineSeg>();
                projMap.put(proj.room, segs);
            }
            segs.add(proj.seg);
        }
        return projMap;
    }

    public static class Projection {
        public final EgressRoom room;
        public final LineSeg seg;

        public Projection(EgressRoom room, LineSeg seg) {
            this.room = room;
            this.seg = seg;
        }
    }

    public static class ProjectionNode {
        public final ProjectionNode parent;
        public final Projection projection;

        public ProjectionNode(ProjectionNode parent, Projection projection) {
            this.parent = parent;
            this.projection = projection;
        }

        public void flatten(List<Projection> result) {
            if (this.parent != null) {
                this.parent.flatten(result);
            }
            result.add(this.projection);
        }
    }
}

