/*
 * Decompiled with CFR 0.152.
 */
package merlin.mv.tools;

import java.awt.Cursor;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import merlin.builders.AgentDropper;
import merlin.data.MerlinData;
import merlin.data.egress.geom.IEgressOccupiable;
import merlin.geom.GeomUtil;
import merlin.geom.Geometry;
import merlin.mv.ModelView;
import merlin.mv.tools.MerlinTool;
import merlin.util.MerlinUtil;
import thunderheadeng.scene3d.navtools.AToolFunction;
import thunderheadeng.scene3d.navtools.CursorTool;
import thunderheadeng.scene3d.navtools.IToolFunction;
import thunderheadeng.scene3d.navtools.SnapMode;
import thunderheadeng.scene3d.picking.DefaultFilter;
import thunderheadeng.scene3d.picking.GeomType;
import thunderheadeng.scene3d.picking.ISnapConstraint;
import thunderheadeng.scene3d.picking.IsectInfo;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.units.UnitPoint3D;
import thunderheadeng.util.CachedFunction;
import thunderheadeng.util.IFilteredCollection;
import thunderheadeng.util.Pair;
import thunderheadeng.util.theUtil;

public class NewAgentTool
extends MerlinTool<AgentDropper> {
    private final MerlinData d_md;

    public NewAgentTool(ModelView mv) {
        super(mv, (IToolFunction<? extends CursorTool>)new Func());
        this.d_md = mv.getData();
        this.setSnapInfo(SnapMode.FILTERED_TWO_PASS, new DefaultFilter());
    }

    private void updateOrentation() {
        ((AgentDropper)this.props()).pause();
        UnitPoint3D agentLocation = ((AgentDropper)this.props()).getLocation();
        Point3d mouseLocation = this.getP1().getFinalSnapLocation();
        if (mouseLocation == null) {
            mouseLocation = this.getP1().referenceSnap;
        }
        UnitDouble newOrient = GeomUtil.getOccOrient(agentLocation.getPoint3dValue(Geometry.LENGTH_UNIT), mouseLocation);
        ((AgentDropper)this.props()).setOrientation(newOrient);
        ((AgentDropper)this.props()).resume();
    }

    private void updateLocation() {
        ((AgentDropper)this.props()).pause();
        Runnable selectRoomPoint = () -> {
            IsectInfo result = this.getP1().getFinalSnap();
            if (result != null && result.obj instanceof IEgressOccupiable) {
                ((AgentDropper)this.props()).setLocation((IEgressOccupiable)result.obj, new UnitPoint3D(result.isectPoint, Geometry.LENGTH_UNIT));
            } else {
                assert (result == null) : "result should be null or have an IEgressOccupiable as the object";
                ((AgentDropper)this.props()).setLocation(null, new UnitPoint3D(this.getP1().referenceSnap, Geometry.LENGTH_UNIT));
            }
        };
        selectRoomPoint.run();
        ((AgentDropper)this.props()).resume();
    }

    @Override
    public boolean cancel() {
        boolean canceled = super.cancel();
        ((AgentDropper)this.props()).reset();
        return canceled;
    }

    @Override
    public void activate() {
        super.activate();
        ((AgentDropper)this.props()).reset();
    }

    protected static class Func
    extends AToolFunction<NewAgentTool> {
        protected Func() {
        }

        @Override
        public Cursor getCursor(NewAgentTool tool) {
            return null;
        }

        @Override
        public void mousePressed(NewAgentTool tool, MouseEvent e) {
            if (e.getButton() != 1) {
                return;
            }
            tool.updateLocation();
        }

        @Override
        public void mouseDragged(NewAgentTool tool, MouseEvent e) {
            if (!tool.isDragging(1) || !tool.dragAboveTolerance(0)) {
                return;
            }
            tool.updateOrentation();
        }

        @Override
        public void mouseReleased(NewAgentTool tool, MouseEvent e) {
            if (e.getButton() == 3) {
                tool.cancel();
                return;
            }
            if (e.getButton() != 1) {
                return;
            }
            ((AgentDropper)tool.props()).createAndAddAgent(e.getComponent());
            tool.finish();
        }

        @Override
        public void mouseMoved(NewAgentTool tool, MouseEvent e) {
            tool.updateLocation();
        }

        @Override
        public ISnapConstraint getSnapConstraint(NewAgentTool tool) {
            return tool.isDragging(1) ? null : tool.new Constraint();
        }
    }

    public class Constraint
    implements ISnapConstraint {
        @Override
        public Pair<Point3d, Collection<IsectInfo>> snapRay(Runnable validateProgress, Vector3d viewDir, Point3d rayBegin, Vector3d rayDir) {
            return null;
        }

        @Override
        public Collection<IsectInfo> snapPoint(Runnable validateProgress, Point3d p) {
            try (MerlinData.ReadLock lock = NewAgentTool.this.d_md.lockRead();){
                AgentDropper props = (AgentDropper)NewAgentTool.this.props();
                Pair<IEgressOccupiable, UnitPoint3D> roomLoc = props.findRoom(MerlinUtil.getUPoint3D(p), Double.POSITIVE_INFINITY);
                if (roomLoc == null) {
                    Collection<IsectInfo> collection = null;
                    return collection;
                }
                Set<IsectInfo> set = Collections.singleton(new IsectInfo(GeomType.FACE, roomLoc.v1, ((UnitPoint3D)roomLoc.v2).getPoint3dValue(Geometry.LENGTH_UNIT)));
                return set;
            }
        }

        @Override
        public Collection<IsectInfo> snapPoint(Runnable validateProgress, Collection<IsectInfo> snaps, Vector3d projectionDir) {
            try (MerlinData.ReadLock lock = NewAgentTool.this.d_md.lockRead();){
                AgentDropper props = (AgentDropper)NewAgentTool.this.props();
                Collection<IsectInfo> mapped = theUtil.map(snaps, new CachedFunction<IsectInfo, IsectInfo>(ii -> {
                    validateProgress.run();
                    Pair<IEgressOccupiable, UnitPoint3D> roomLoc = props.findRoom(MerlinUtil.getUPoint3D(ii.isectPoint), Double.POSITIVE_INFINITY);
                    if (roomLoc == null) {
                        return null;
                    }
                    return new IsectInfo(GeomType.FACE, roomLoc.v1, ((UnitPoint3D)roomLoc.v2).getPoint3dValue(Geometry.LENGTH_UNIT));
                }));
                IFilteredCollection<IsectInfo> iFilteredCollection = theUtil.filter(mapped, isect -> isect != null);
                return iFilteredCollection;
            }
        }

        @Override
        public ISnapConstraint transform(Matrix4d xform) {
            return this;
        }
    }
}

