/*
 * Decompiled with CFR 0.152.
 */
package merlin.mv.manip;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import merlin.Intl;
import merlin.MerlinApp;
import merlin.actions.AMerlinOp;
import merlin.actions.Delete;
import merlin.actions.FloorSortActions;
import merlin.actions.SubtractAction;
import merlin.actions.UIHook;
import merlin.actions.Undo;
import merlin.actions.geomops.SeparateGeom;
import merlin.data.IMerlinObj;
import merlin.data.IRestorable;
import merlin.data.MerlinData;
import merlin.data.egress.geom.EgressRoom;
import merlin.data.egress.geom.IEgressComp;
import merlin.gui.IPropEditor;
import merlin.gui.PropPanel;
import merlin.mv.ModelView;
import merlin.mv.gui.HandleManipPanel;
import thunderheadeng.geometry.IMutableGeomSrc;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.scene3d.manip.HandleEvent;
import thunderheadeng.scene3d.manip.HandleMgr;
import thunderheadeng.scene3d.manip.IHandleListener;
import thunderheadeng.scene3d.picking.PointConstraint;

public class HandleHook
implements IHandleListener {
    private final ModelView d_mv;
    private final HandleMgr d_handleMgr;
    private IPropEditor d_nullPanel;
    private final HandleManipPanel d_handleManipPanel;

    public HandleHook(ModelView mv, HandleMgr handleMgr) {
        this.d_mv = mv;
        this.d_handleMgr = handleMgr;
        this.d_handleManipPanel = new HandleManipPanel(this.d_handleMgr, this.d_mv.getRenderComp());
        this.d_handleMgr.addListener(this);
    }

    public HandleMgr getManager() {
        return this.d_handleMgr;
    }

    @Override
    public void handleChanged(HandleEvent evt) {
        HandleEvent.Type type = evt.getType();
        switch (type) {
            case MOD_STARTED: {
                this.begin();
                break;
            }
            case HANDLES_MODIFIED: {
                this.updateHandles();
                break;
            }
            case ACTIVE_HANDLE_CHANGED: {
                break;
            }
            case MOD_ENDED: {
                this.end();
                if (!evt.isCommitted()) break;
                this.commit(this.d_handleMgr.getCurrentSourceObj(), evt.getNewNode());
                break;
            }
            case SOURCE_REMOVED: {
                if (!evt.isCommitted()) break;
                this.removeSource(this.d_handleMgr.getCurrentSourceObj(), evt.getNewNode());
            }
        }
    }

    protected void updateHandles() {
        if (this.d_handleMgr.isModifying() && this.canManip()) {
            this.d_handleManipPanel.update();
        }
    }

    protected void begin() {
        PropPanel toolPropsPanel = this.d_mv.getToolPropsPanel();
        this.d_nullPanel = toolPropsPanel.getEditor();
        if (this.canManip()) {
            this.d_handleManipPanel.update();
            toolPropsPanel.setEditor(this.d_handleManipPanel);
        }
    }

    private boolean canManip() {
        return !(this.d_handleMgr.getManipConstraint() instanceof PointConstraint);
    }

    protected void end() {
        PropPanel toolPropsPanel = this.d_mv.getToolPropsPanel();
        toolPropsPanel.setEditor(this.d_nullPanel);
    }

    protected void removeSource(IMutableGeomSrc src, IGeomNode newNode) {
        assert (newNode.isGeomEmpty(true));
        assert (!src.getGeom().isGeomEmpty(true));
        assert (src instanceof IMerlinObj);
        if (src instanceof IMerlinObj) {
            IMerlinObj obj = (IMerlinObj)((Object)src);
            UIHook.run(null, "ManipListener.removeSource", new RemoveTask(obj, newNode), 0);
        }
    }

    protected void commit(IMutableGeomSrc src, IGeomNode newNode) {
        UIHook.run(null, "ManipListener.commit", new CommitTask(src, newNode), 0);
    }

    private static class RemoveTask
    extends AMerlinOp {
        private final IMerlinObj d_src;

        public RemoveTask(IMerlinObj src, IGeomNode newNode) {
            this.d_src = src;
        }

        @Override
        public void run(MerlinApp app, MerlinData md) {
            try (MerlinData.WriteLock lock = md.lockWrite();){
                IMerlinObj iMerlinObj = this.d_src;
                if (iMerlinObj instanceof IMerlinObj) {
                    IMerlinObj obj = iMerlinObj;
                    Delete.uiDelete(app, md, List.of(obj), true);
                }
            }
        }
    }

    private static class CommitTask
    extends AMerlinOp {
        private final IMutableGeomSrc d_src;
        private final IGeomNode d_newNode;

        public CommitTask(IMutableGeomSrc src, IGeomNode newNode) {
            this.d_src = src;
            this.d_newNode = newNode;
        }

        @Override
        public void run(MerlinApp app, MerlinData md) {
            try (MerlinData.WriteLock lock = md.lockWrite();){
                Undo.begin(Intl.intl("Edit"));
                if (this.d_src instanceof IRestorable) {
                    Undo.insertUndoEntry_restore(md, (IRestorable)((Object)this.d_src));
                } else {
                    Undo.insertEntry_breakChain(md);
                }
                this.d_src.setGeom(this.d_newNode);
                ArrayList toClean = new ArrayList();
                if (this.d_src instanceof EgressRoom) {
                    SubtractAction.subtract(app, md, 0, toClean::add, (EgressRoom)this.d_src);
                    SeparateGeom.separate(md, Arrays.asList((EgressRoom)this.d_src), toClean::add, (key, child) -> {});
                }
                if (this.d_src instanceof IEgressComp) {
                    FloorSortActions.updateComponentFloors(md, Arrays.asList((IEgressComp)this.d_src));
                }
                EgressRoom.cleanup(md, toClean);
                Undo.end(md);
            }
        }
    }
}

