/*
 * Decompiled with CFR 0.152.
 */
package merlin.mv.gui.behaviors;

import java.awt.Component;
import java.awt.Dimension;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import merlin.Intl;
import merlin.builders.ChangeProfilePropActionBuilder;
import merlin.data.MerlinData;
import merlin.data.egress.agents.IProfileProp;
import merlin.data.egress.agents.OccProfile;
import merlin.data.egress.scripting.ChangeProfileProp;
import merlin.data.property.IDisplayProp;
import merlin.gui.guiUtil;
import merlin.mv.gui.behaviors.ANewBehaviorActionPnl;
import merlin.mv.gui.behaviors.ActionCreatePnl;
import merlin.mv.gui.behaviors.BehaviorPnl;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.guiComboBox;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.gui.value.IValEditor;
import thunderheadeng.util.CachedValue;
import thunderheadeng.util.IPropertySet;
import thunderheadeng.util.Pair;

public class NewChangeProfilePropPnl
extends ANewBehaviorActionPnl<ChangeProfilePropActionBuilder> {
    private static final long serialVersionUID = 1L;
    private final MerlinData d_data;
    private static final CachedValue<List<Object>> s_cachedComboValues = new CachedValue();

    public NewChangeProfilePropPnl(MerlinData md) {
        super(new Object[0]);
        this.d_data = md;
        this.addSection(new BehaviorPnl());
        this.addSeparator();
        this.addSection(new ActionCreatePnl());
    }

    public static guiComboBox<Object> createPropCombo(boolean allowMixed) {
        Function<Object, String> getName = prop -> {
            if (prop == null) {
                return Intl.intl("<mixed>");
            }
            if (prop instanceof IDisplayProp) {
                return ((IDisplayProp)prop).getDisplayName();
            }
            return prop.toString();
        };
        Function<Object, String> getTooltip = prop -> {
            if (prop instanceof IDisplayProp) {
                String str = ((IDisplayProp)prop).getDisplayDesc();
                String replaced = str.replace("\n", "<br>");
                return !replaced.equals(str) ? "<html>" + replaced : str;
            }
            return null;
        };
        List comboItems = s_cachedComboValues.get(() -> {
            TreeMap props = new TreeMap();
            OccProfile.streamProfileProps().filter(ChangeProfileProp.PROP_FILTER).forEach(nprop -> props.computeIfAbsent(nprop.getGroupDisplayName(), g -> new ArrayList()).add(nprop.asProp()));
            ArrayList comboList = new ArrayList();
            for (Map.Entry entry : props.entrySet()) {
                Collections.sort((List)entry.getValue(), (p1, p2) -> ((String)getName.apply(p1)).compareToIgnoreCase((String)getName.apply(p2)));
                comboList.add(entry.getKey());
                comboList.addAll((Collection)entry.getValue());
            }
            return comboList;
        });
        Predicate<Object> allowableChoices = allowMixed ? o -> o == null || o instanceof IPropertySet.Prop : o -> o instanceof IPropertySet.Prop;
        guiComboBox<Object> propCB = guiUtil.newCombo(o -> new Pair<String, String>((String)getName.apply(o), (String)getTooltip.apply(o)), comboItems);
        propCB.setSelectionFilter(allowableChoices);
        propCB.setMinimumSize(propCB.getPreferredSize());
        final ListCellRenderer baseRenderer = propCB.getRenderer();
        propCB.setRenderer(new DefaultListCellRenderer(){
            private static final long serialVersionUID = 1L;

            @Override
            public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                Component result = baseRenderer.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                if (value instanceof String) {
                    result.setFont(result.getFont().deriveFont(1));
                } else if (result instanceof JLabel && value != null) {
                    JLabel lbl = (JLabel)result;
                    lbl.setText("    " + lbl.getText());
                }
                return result;
            }
        });
        return propCB;
    }

    @Override
    public void activate() {
        guiComboBox<Object> d_propCB = NewChangeProfilePropPnl.createPropCombo(false);
        guiDialog dlg = new guiDialog(guiUtil.getWindow(this), Intl.intl("Change Profile Property"), 9);
        dlg.getButton(1).setText(ANewBehaviorActionPnl.CREATE);
        PropertyChangeListener propChangeListener = e -> {
            dlg.validate();
            if (dlg.isShowing()) {
                dlg.pack();
            }
        };
        IValEditor[] editor = new IValEditor[]{null};
        Runnable updateEditor = () -> {
            if (editor[0] != null) {
                editor[0].removeValueListener(propChangeListener);
            }
            IDisplayProp nprop = (IDisplayProp)d_propCB.getSelectedItem();
            editor[0] = nprop.newValueEditor(this.d_data, true).get();
            editor[0].addValueListener(propChangeListener);
        };
        IProfileProp<?, ?> prop = ((ChangeProfilePropActionBuilder)this.props()).get(ChangeProfileProp.PROFILE_PROP);
        d_propCB.setSelectedItem(prop);
        updateEditor.run();
        editor[0].setValue(((ChangeProfilePropActionBuilder)this.props()).get(ChangeProfileProp.VALUE));
        Runnable updatePnl = () -> {
            guiPanel mainPnl = dlg.getDialogPane();
            mainPnl.removeAll();
            GridBagHelper gb = new GridBagHelper(mainPnl);
            gb.addRow(ChangeProfileProp.PROFILE_PROP.getNameWithColon(), d_propCB, 0, 1.0);
            guiLabel valueLbl = new guiLabel(ChangeProfileProp.VALUE.getNameWithColon());
            valueLbl.setPreferredSize(new Dimension(valueLbl.getPreferredSize().width, new JTextField().getPreferredSize().height));
            gb.add(new Object[]{valueLbl, GridBagHelper.Anchor.TOP_LEFT});
            editor[0].add(gb);
            gb.nextRow();
            gb.finalizeRows();
            dlg.validate();
            if (dlg.isShowing()) {
                dlg.pack();
                dlg.repaint();
            }
        };
        d_propCB.addItemListener(e -> {
            if (e.getStateChange() != 1) {
                return;
            }
            Object newSel = e.getItem();
            IPropertySet.Prop prop = (IPropertySet.Prop)newSel;
            updateEditor.run();
            editor[0].setValue(prop.defVal);
            updatePnl.run();
        });
        updatePnl.run();
        if (dlg.doModal() != 1) {
            this.cancel();
            return;
        }
        ((ChangeProfilePropActionBuilder)this.props()).set(ChangeProfileProp.PROFILE_PROP, (IProfileProp)d_propCB.getSelectedItem());
        ((ChangeProfilePropActionBuilder)this.props()).setDelayedCommit((md, props) -> {
            Object val = editor[0].commit(this.d_data);
            ((ChangeProfilePropActionBuilder)this.props()).set(ChangeProfileProp.VALUE, val);
        });
        this.create();
        ((ChangeProfilePropActionBuilder)this.props()).setDelayedCommit((md, props) -> {});
    }
}

