/*
 * Decompiled with CFR 0.152.
 */
package merlin.mv.gui;

import java.awt.Dimension;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.function.BiFunction;
import java.util.function.DoubleUnaryOperator;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.swing.AbstractButton;
import javax.vecmath.Point3d;
import merlin.Intl;
import merlin.MerlinApp;
import merlin.actions.CompElementActions;
import merlin.data.ICompElement;
import merlin.data.MerlinData;
import merlin.data.OccGroupTypeObj;
import merlin.data.OccSourceObj;
import merlin.data.egress.agents.EgressAgent;
import merlin.data.egress.agents.IProfileProp;
import merlin.data.egress.agents.OccProfile;
import merlin.data.egress.geom.IEgressComp;
import merlin.data.egress.scripting.Behavior;
import merlin.data.stat.DisabledCurve;
import merlin.data.value.IFunction1d;
import merlin.geom.Geometry;
import merlin.gui.DiscreteChooser;
import merlin.gui.DistributionEditor;
import merlin.gui.guiUtil;
import merlin.gui.labels.WrappedComp;
import merlin.gui.stat.CompactDistributedValPnl;
import merlin.gui.value.MultiValEditor;
import merlin.gui.value.Point3dListEditor;
import merlin.gui.value.PopupValEditor;
import merlin.mv.gui.SelectionEditorPanel;
import org.jscience.physics.units.Unit;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.guiComboBox;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiMultiStateCheckBox;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.gui.value.IValEditor;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.units.UnitDoubleVR;
import thunderheadeng.util.PropValue;
import thunderheadeng.util.stat.ICurve;
import thunderheadeng.util.stat.IDistributedVal;
import thunderheadeng.util.stat.IUrn;
import thunderheadeng.util.stat.Urn;

public class OccSourcePanel {
    private SelectionEditorPanel.EditorPanel d_flowratePnl = new SelectionEditorPanel.EditorPanel();
    private SelectionEditorPanel.EditorPanel d_distPnl = new SelectionEditorPanel.EditorPanel();
    private SelectionEditorPanel.EditorPanel d_miscPnl = new SelectionEditorPanel.EditorPanel();
    private CompPanel d_componentPanel;

    public OccSourcePanel(MerlinData md) {
        IValEditor flowRate = OccSourceObj.PROP_FLOW_RATE.newValueEditor(md, false).get();
        DistributionEditor<OccProfile> profilesDistEd = new DistributionEditor<OccProfile>(md, Intl.intl("Profile"), md.profiles, OccProfile.class, null);
        DistributionEditor<Behavior> behaviorsDistEd = new DistributionEditor<Behavior>(md, Intl.intl("Behavior"), md.behaviors, Behavior.class, null);
        Supplier<guiComboBox> newYesNoBox = () -> guiUtil.newCombo(Boolean.valueOf(true), Intl.intl("Yes"), false, Intl.intl("No"));
        guiComboBox cbEnforceFlowRate = newYesNoBox.get();
        Dimension d = cbEnforceFlowRate.getPreferredSize();
        cbEnforceFlowRate.setPreferredSize(new Dimension(d.width + 5, d.height));
        WrappedComp<guiLabel> enforceFlowrateLbl = SelectionEditorPanel.lblOverride(this.d_flowratePnl, OccSourceObj.PROP_ENFORCE_FLOWRATE);
        PopupValEditor<List> spawnLocs = new PopupValEditor<List>(PopupValEditor.Mode.HTML, List.class, Intl.intl("Occupant Locations"), () -> new Point3dListEditor(md.getUnitSystem().getLength(), Intl.intl("NOTE: If a row is empty, the occupant location will be generated randomly within the occupant source region. Similarly, if there are more occupants generated than rows in the table, the additional occupants will be given random locations. The Flow Rate determines the number of occupants.")), list -> {
            if (list == null) {
                return Intl.intl("&lt;mixed&gt;");
            }
            if (list.isEmpty()) {
                return Intl.intl("&lt;random&gt;");
            }
            Point3d first = (Point3d)list.get(0);
            Object result = "";
            if (first == null) {
                result = Intl.intl("&lt;random&gt;");
            } else {
                Unit lunit = md.getUnitSystem().getLength();
                DoubleUnaryOperator convert = v -> UnitDouble.convert(v, Geometry.LENGTH_UNIT, lunit);
                result = String.format("(%.1f, %.1f, %.1f) %s", convert.applyAsDouble(first.x), convert.applyAsDouble(first.y), convert.applyAsDouble(first.z), lunit);
            }
            if (list.size() > 1) {
                result = (String)result + "...";
            }
            return result;
        }, events -> events.getEvents(MerlinData.class, new Class[0]).containsChange(MerlinData.UNITSYSTEM_CHANGED));
        WrappedComp<guiMultiStateCheckBox> overrideInitOrient = SelectionEditorPanel.checkBoxOverride(Intl.intl("Initial Orient:"), "<html>" + Intl.intl("The initial orientation of generated occupants (orientation is defined by the angle<br>going counter-clockwise from the +X axis).<br>If this box is unchecked, the initial orientation is determined by the occupants'<br>properties or their profile."), OccSourceObj.PROP_INIT_ORIENT);
        CompactDistributedValPnl initOrient = new CompactDistributedValPnl(Intl.intl("Initial Orientation"), 7, UnitDoubleVR.UNBOUNDED, t -> ICurve.class.isAssignableFrom((Class<?>)t) && !t.equals(DisabledCurve.class));
        guiUtil.link((AbstractButton)overrideInitOrient.comp, initOrient);
        this.d_componentPanel = new CompPanel(md);
        DistributionEditor<OccGroupTypeObj> groupTemplateDistEd = new DistributionEditor<OccGroupTypeObj>(md, Intl.intl("Movement Group Template"), md.occGroupTypes, OccGroupTypeObj.class, null);
        guiComboBox emitMaxVel = newYesNoBox.get();
        GridBagHelper gb = new GridBagHelper(this.d_flowratePnl);
        gb.rowSpace = 1;
        gb.addRow(SelectionEditorPanel.lblOverride(this.d_flowratePnl, OccSourceObj.PROP_FLOW_RATE), flowRate);
        gb.addRow(enforceFlowrateLbl, cbEnforceFlowRate);
        gb.add(SelectionEditorPanel.lblOverride(this.d_flowratePnl, OccSourceObj.PROP_SPAWN_LOCS));
        spawnLocs.add(gb);
        gb.nextRow();
        gb = new GridBagHelper(this.d_distPnl);
        gb.rowSpace = 1;
        gb.addRow(SelectionEditorPanel.lblOverride(this.d_distPnl, OccSourceObj.PROP_PROFILE_DIST), profilesDistEd);
        gb.addRow(SelectionEditorPanel.lblOverride(this.d_distPnl, OccSourceObj.PROP_BEHAVIOR_DIST), behaviorsDistEd);
        gb.addRow(SelectionEditorPanel.lblOverride(this.d_distPnl, OccSourceObj.PROP_COMPONENT), this.d_componentPanel);
        gb = new GridBagHelper(this.d_miscPnl);
        gb.rowSpace = 1;
        gb.addRow(SelectionEditorPanel.lblOverride(this.d_miscPnl, OccSourceObj.PROP_GROUP_TEMPLATE_DIST), groupTemplateDistEd);
        gb.addRow(SelectionEditorPanel.lblOverride(this.d_miscPnl, OccSourceObj.PROP_EMIT_AT_MAX_VEL), emitMaxVel);
        gb.addRow(overrideInitOrient, initOrient);
        this.d_flowratePnl.addConnection(new OccSourceFlowrateConn((MultiValEditor)flowRate.getComponent()));
        this.d_flowratePnl.addConnection(new BoolUrnConn(new CompElementActions.DefProp<IUrn<Boolean>>(OccSourceObj.PROP_ENFORCE_FLOWRATE), cbEnforceFlowRate, Intl.intl("Set Enforce Flow Rate")));
        this.d_flowratePnl.addConnection(new SelectionEditorPanel.ValEditorConn(new CompElementActions.DefProp<List<Point3d>>(OccSourceObj.PROP_SPAWN_LOCS), spawnLocs));
        this.d_distPnl.addConnection(new SelectionEditorPanel.DistributionConn(new CompElementActions.DefProp<IUrn<OccProfile>>(OccSourceObj.PROP_PROFILE_DIST), profilesDistEd, Intl.intl("Set Occupant Source Profile Distribution")));
        this.d_distPnl.addConnection(new SelectionEditorPanel.DistributionConn(new CompElementActions.DefProp<IUrn<Behavior>>(OccSourceObj.PROP_BEHAVIOR_DIST), behaviorsDistEd, Intl.intl("Set Occupant Source Behavior Distribution")));
        this.d_distPnl.addConnection(new OccSourceCompConn((Object)new CompElementActions.DefProp<IEgressComp>(OccSourceObj.PROP_COMPONENT), this.d_componentPanel));
        groupTemplateDistEd.setExtraObjs(data -> Collections.singleton(data.occGroupTypes.NO_GROUP_TYPE));
        this.d_miscPnl.addConnection(new SelectionEditorPanel.DistributionConn(new CompElementActions.DefProp<IUrn<OccGroupTypeObj>>(OccSourceObj.PROP_GROUP_TEMPLATE_DIST), groupTemplateDistEd, Intl.intl("Set Occupant Source Movement Group Template Distribution")));
        this.d_miscPnl.addConnection(new BoolUrnConn(new CompElementActions.DefProp<IUrn<Boolean>>(OccSourceObj.PROP_EMIT_AT_MAX_VEL), emitMaxVel, Intl.intl("Set Emit at Max. Velocity")));
        OccSourcePanel.addProfilePropConnections(this.d_miscPnl, OccProfile.PROP_INIT_ORIENT, (guiMultiStateCheckBox)overrideInitOrient.comp, curveProp -> new SelectionEditorPanel.CurveConn<IDistributedVal<UnitDouble>>((Class<IDistributedVal<UnitDouble>>)ICurve.class, (CompElementActions.IObjectProp<ICompElement, IDistributedVal<UnitDouble>>)curveProp, initOrient));
    }

    private static <EdT, OccT, ProfT> void addProfilePropConnections(SelectionEditorPanel.EditorPanel editor, IProfileProp<OccT, ProfT> prop, guiMultiStateCheckBox cb, Function<CompElementActions.IObjectProp<ICompElement, ProfT>, SelectionEditorPanel.IPropConnection> newValConn) {
        EgressAgent.AgentProfProp agentProp = EgressAgent.asAgentProfProp(prop);
        editor.addConnection(new SelectionEditorPanel.BoolPropConnection(new CompElementActions.MappedProp<ICompElement, Boolean, EgressAgent.AgentValue>(new CompElementActions.DefProp(agentProp, true), (obj, aval) -> aval.isLocal(), (obj, local) -> {
            EgressAgent.AgentValue existingVal = (EgressAgent.AgentValue)obj.getSupportedValue(agentProp);
            return new EgressAgent.AgentValue((boolean)local, existingVal.value());
        }), cb));
        BiFunction<ICompElement, EgressAgent.AgentValue, Object> getVal = (obj, aval) -> aval.value();
        editor.addConnection(newValConn.apply(new CompElementActions.MappedProp<ICompElement, Object, EgressAgent.AgentValue>(new CompElementActions.DefProp(agentProp, true), getVal, (obj, baseVal) -> new EgressAgent.AgentValue<Object>(true, baseVal))));
    }

    public List<SelectionEditorPanel.EditorPanel> getPanels() {
        return Arrays.asList(this.d_flowratePnl, this.d_distPnl, this.d_miscPnl);
    }

    private static class CompPanel
    extends guiPanel {
        private static final long serialVersionUID = -5264040439448268249L;
        private final DiscreteChooser<IEgressComp> componentChooser;

        public CompPanel(MerlinData md) {
            Predicate<IEgressComp> filter = OccSourceObj.occsAllowedFilter();
            this.componentChooser = new DiscreteChooser<IEgressComp>(md, Intl.intl("Select Component"), IEgressComp.class, filter);
            GridBagHelper gb = new GridBagHelper(this);
            gb.addRow(this.componentChooser);
        }

        public IEgressComp getValue() {
            return this.componentChooser.getObj();
        }

        public void setValue(PropValue<IEgressComp> property) {
            this.componentChooser.setObj(property);
        }
    }

    private static class OccSourceFlowrateConn
    extends SelectionEditorPanel.ASinglePropConnection<MultiValEditor<IFunction1d>> {
        public OccSourceFlowrateConn(MultiValEditor<IFunction1d> comp) {
            super(new CompElementActions.DefProp<IFunction1d>(OccSourceObj.PROP_FLOW_RATE), comp);
            comp.addValueListener(e -> this.onControlChanged());
        }

        @Override
        public void setProp(Object prop, Collection<? extends ICompElement> objs, MultiValEditor<IFunction1d> comp) {
            IFunction1d sourceFlowrate = (IFunction1d)comp.getValue();
            if (sourceFlowrate == null) {
                return;
            }
            SelectionEditorPanel.setPropRecursive(Intl.intl("Set Occ Source Flowrate"), (CompElementActions.IObjectProp)prop, objs, sourceFlowrate);
        }

        @Override
        public void initFromProp(Object prop, Collection<? extends ICompElement> objs, MultiValEditor<IFunction1d> comp) {
            Object val = ((CompElementActions.IObjectProp)prop).get(MerlinApp.getApp().getData(), objs);
            if (val instanceof IFunction1d) {
                comp.setValue((IFunction1d)val);
            } else if (val == ICompElement.NON_UNIFORM || val == ICompElement.NOT_SUPPORTED) {
                comp.setValue(null);
            }
            comp.setModified(false);
        }
    }

    private static class BoolUrnConn
    extends SelectionEditorPanel.ASinglePropConnection<guiComboBox<Boolean>> {
        private final String undoStr;

        public BoolUrnConn(Object prop, guiComboBox<Boolean> control, String undoStr) {
            super(prop, control);
            this.undoStr = undoStr;
            control.addActionListener(e -> this.onControlChanged());
        }

        @Override
        public void setProp(Object prop, Collection<? extends ICompElement> objs, guiComboBox<Boolean> comp) {
            Boolean val = comp.getSelectedItem();
            Urn<Boolean> urn = new Urn<Boolean>(val);
            SelectionEditorPanel.setPropRecursive(this.undoStr, (CompElementActions.IObjectProp)prop, objs, urn);
        }

        @Override
        public void initFromProp(Object prop, Collection<? extends ICompElement> objs, guiComboBox<Boolean> comp) {
            Object val = ((CompElementActions.IObjectProp)prop).get(MerlinApp.getApp().getData(), objs);
            if (val == ICompElement.NON_UNIFORM || val == ICompElement.NOT_SUPPORTED) {
                comp.setSelectedItem(null);
            } else if (val instanceof IUrn) {
                Boolean value = (Boolean)((IUrn)val).getValue(new Random());
                comp.setSelectedItem(value);
            }
            comp.setModified(false);
        }
    }

    private static class OccSourceCompConn
    extends SelectionEditorPanel.ASinglePropConnection<CompPanel> {
        public OccSourceCompConn(Object prop, CompPanel control) {
            super(prop, control);
            Runnable action = () -> this.onControlChanged();
            control.componentChooser.addCommitAction(action);
        }

        @Override
        public void setProp(Object prop, Collection<? extends ICompElement> objs, CompPanel comp) {
            IEgressComp val = comp.getValue();
            SelectionEditorPanel.setPropRecursive(Intl.intl("Set Occupant Source Component"), (CompElementActions.IObjectProp)prop, objs, val);
        }

        @Override
        public void initFromProp(Object prop, Collection<? extends ICompElement> objs, CompPanel comp) {
            PropValue<IEgressComp> property;
            Object val = ((CompElementActions.IObjectProp)prop).get(MerlinApp.getApp().getData(), objs);
            if (Objects.equals(val, ICompElement.NON_UNIFORM)) {
                property = PropValue.nonUniform();
            } else {
                IEgressComp component = (IEgressComp)val;
                property = PropValue.of(component);
            }
            boolean enable = true;
            for (ICompElement iCompElement : objs) {
                if (!(iCompElement instanceof OccSourceObj) || !((OccSourceObj)iCompElement).getType().equals((Object)OccSourceObj.OccSourceType.REGION)) continue;
                enable = false;
                break;
            }
            comp.setValue(property);
            comp.setEnabled(enable);
            comp.setModified(false);
        }
    }
}

