/*
 * Decompiled with CFR 0.152.
 */
package merlin.mv.gui;

import java.util.concurrent.Semaphore;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import merlin.Intl;
import merlin.builders.AgentDropper;
import merlin.data.IMerlinObj;
import merlin.data.MerlinData;
import merlin.data.egress.agents.OccProfile;
import merlin.data.egress.scripting.Behavior;
import merlin.gui.APropEditPanel;
import merlin.gui.IPropEditCommand;
import merlin.gui.MerlinComboBox;
import merlin.gui.MerlinUDF;
import merlin.mv.gui.LocationPanel;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.guiCheckBox;
import thunderheadeng.gui.guiUnitDoubleField;
import thunderheadeng.gui.guiUtil;
import thunderheadeng.units.UnitDouble;

public class NewAgentPanel
extends APropEditPanel<AgentDropper> {
    private static final long serialVersionUID = -5247964537358776929L;
    private MerlinData d_data;
    private APropEditPanel<AgentDropper> d_createPanel;
    private APropEditPanel<AgentDropper> d_locPanel;
    private APropEditPanel<AgentDropper> d_propsPanel;

    public NewAgentPanel(MerlinData data) {
        super(new Object[0]);
        this.d_data = data;
        this.d_propsPanel = new PropsPanel(this.d_data);
        this.d_locPanel = new LocPanel();
        this.d_createPanel = new CreateBtPanel();
        this.addSection(this.d_propsPanel);
        this.addSeparator();
        this.addSection(this.d_locPanel);
        this.addSeparator();
        this.addSection(this.d_createPanel);
    }

    @Override
    public void setProps(AgentDropper props) {
        super.setProps(props);
        this.d_createPanel.setProps(props);
        this.d_locPanel.setProps(props);
        this.d_propsPanel.setProps(props);
    }

    private static class PropsPanel
    extends APropEditPanel<AgentDropper> {
        private static final long serialVersionUID = -8492778769575221471L;
        private final MerlinData d_md;
        private final MerlinComboBox<OccProfile> d_profileCB;
        private final MerlinComboBox<Behavior> d_behaviorCB;
        private final guiCheckBox d_orientationCB;
        private final guiUnitDoubleField d_orientation;
        private final Semaphore d_lock = new Semaphore(1);

        public PropsPanel(MerlinData md) {
            super(AgentDropper.PROFILE_CHANGED, AgentDropper.BEHAVIOR_CHANGED, AgentDropper.CREATE_AGENT);
            this.d_md = md;
            this.d_profileCB = this.initComboBox(new MerlinComboBox(this.d_md, OccProfile.class, (IMerlinObj[])new OccProfile[0]));
            this.d_behaviorCB = this.initComboBox(new MerlinComboBox(this.d_md, Behavior.class, (IMerlinObj[])new Behavior[0]));
            this.d_orientationCB = this.initButton(new guiCheckBox(Intl.intl("Orientation:")), new IPropEditCommand[0]);
            this.d_orientation = this.initValueField(new MerlinUDF(7), new IPropEditCommand[0]);
            guiUtil.link((AbstractButton)this.d_orientationCB, this.d_orientation);
            GridBagHelper gb = new GridBagHelper(this);
            gb.rowSpace = 1;
            gb.addRow(Intl.intl("Profile:"), this.d_profileCB, 1.0);
            gb.addRow(Intl.intl("Behavior:"), this.d_behaviorCB, 1.0);
            gb.addRow(this.d_orientationCB, this.d_orientation, 1.0);
        }

        @Override
        protected void updateFromProps(AgentDropper props) {
            if (!this.d_lock.tryAcquire()) {
                return;
            }
            this.d_profileCB.setSelectedItem(props.getParentProfile());
            this.d_behaviorCB.setSelectedItem(props.getBehavior());
            this.d_orientationCB.setSelected(props.isDefinedLocally(OccProfile.PROP_INIT_ORIENT));
            this.d_orientation.setValue(props.getOrientation());
            this.d_lock.release();
        }

        @Override
        protected void updateToProps(AgentDropper props) {
            if (!this.d_lock.tryAcquire()) {
                return;
            }
            props.pause();
            props.setProfile((OccProfile)this.d_profileCB.getSelectedItem());
            props.setBehavior((Behavior)this.d_behaviorCB.getSelectedItem());
            if (this.d_orientationCB.isSelected()) {
                props.setOrientation((UnitDouble)this.d_orientation.getValue());
            } else {
                props.removeOrientation();
            }
            props.resume();
            this.d_lock.release();
        }
    }

    private static class LocPanel
    extends LocationPanel<AgentDropper> {
        private static final long serialVersionUID = 3376930554778086182L;

        public LocPanel() {
            super(6, AgentDropper.LOC_CHANGED);
        }

        @Override
        protected void updateToProps(AgentDropper props) {
            ((AgentDropper)this.props()).setLocation(this.getValue());
        }

        @Override
        protected void updateFromProps(AgentDropper props) {
            this.setValue(props.getLocation());
        }
    }

    private static class CreateBtPanel
    extends APropEditPanel<AgentDropper> {
        private static final long serialVersionUID = 2540141589483680525L;
        private JButton d_createBtn = this.initButton(new JButton(Intl.intl("Create")), (c, hardValidate) -> {
            if (!this.validateData(hardValidate, hardValidate)) {
                return;
            }
            ((AgentDropper)this.props()).createAndAddAgent(c);
        });

        public CreateBtPanel() {
            super(AgentDropper.LOC_CHANGED, AgentDropper.PROFILE_CHANGED);
            this.add(this.d_createBtn);
        }

        @Override
        protected void updateFromProps(AgentDropper props) {
            this.d_createBtn.setEnabled(props.canCreate());
        }

        @Override
        protected void updateToProps(AgentDropper props) {
        }
    }
}

