/*
 * Decompiled with CFR 0.152.
 */
package merlin.mv.displays;

import java.awt.Color;
import java.util.Collection;
import javax.vecmath.Point3d;
import javax.vecmath.Point3f;
import merlin.MerlinApp;
import merlin.data.ICompElement;
import merlin.data.MerlinData;
import merlin.data.OccGroupObj;
import merlin.data.Proxy;
import merlin.data.egress.agents.EgressAgent;
import merlin.data.egress.agents.OccProfile;
import merlin.mv.displays.AAgentDisplay;
import merlin.mv.displays.AgentDisplayType;
import thunderheadeng.geometry.IMutableGeomSrc;
import thunderheadeng.scene3d.manip.HandleMgr;
import thunderheadeng.util.IPropertySet;

public class AgentDisplay
extends AAgentDisplay {
    private static final long serialVersionUID = 1538991380325537024L;
    public final AgentDisplayType type;
    public final EgressAgent agent;

    public AgentDisplay(AgentDisplayType type, EgressAgent agent) {
        this.type = type;
        this.agent = agent;
        this.nativeConstructed(this.resolveNativeClass());
    }

    public EgressAgent getAgent() {
        return this.agent;
    }

    @Override
    protected AgentDisplayType getDisplayType() {
        return this.type;
    }

    @Override
    protected long getProfileSeed() {
        return this.agent.getProfileSeed();
    }

    @Override
    protected long getOrientSeed() {
        return this.agent.getOrientSeed();
    }

    @Override
    protected Point3d getLocation() {
        return this.agent.getLocPoint();
    }

    @Override
    protected OccProfile getProfile() {
        return this.agent.getProfile();
    }

    @Override
    protected boolean isTestAgent() {
        return false;
    }

    @Override
    public Point3f getColor() {
        return this.agent.getProfile().getProperty(OccProfile.PROP_COLOR);
    }

    @Override
    public Point3f getGroupColor() {
        return this.getGroupColor(OccGroupObj.PROP_COLOR);
    }

    @Override
    public Point3f getGroupTemplateColor() {
        return this.getGroupColor(OccGroupObj.PROP_TEMPLATE_COLOR);
    }

    private Point3f getGroupColor(IPropertySet.Prop<Color> property) {
        Collection<Object> proxyParents;
        IMutableGeomSrc proxyAgent;
        HandleMgr handleMgr = MerlinApp.getApp().getModelView().getHandleMgr();
        IMutableGeomSrc iMutableGeomSrc = proxyAgent = handleMgr.isModifying(this.agent) ? handleMgr.getCurrentSourceObj() : this.agent;
        if (proxyAgent instanceof ICompElement && (proxyParents = Proxy.getProxyParents((ICompElement)((Object)proxyAgent), false)) != null) {
            for (Object o : proxyParents) {
                OccGroupObj group;
                Boolean groupEnabled;
                if (!(o instanceof OccGroupObj) || (groupEnabled = (group = (OccGroupObj)o).getProperty(MerlinData.ENABLED)) instanceof Boolean && !groupEnabled.booleanValue()) continue;
                Color groupColor = ((OccGroupObj)o).getProperty(property);
                if (groupColor == null) {
                    return null;
                }
                return AgentDisplay.toP3f(groupColor);
            }
        }
        return null;
    }

    @Override
    protected Point3f getBehaviorColor() {
        return AgentDisplay.toP3f(this.getAgent().getBehavior().getColor());
    }

    private static Point3f toP3f(Color c) {
        float[] ccomps = new float[4];
        c.getComponents(ccomps);
        return new Point3f(ccomps[0], ccomps[1], ccomps[2]);
    }

    public Object getSelectionObj() {
        return this.agent;
    }
}

