/*
 * Decompiled with CFR 0.152.
 */
package merlin.mv.displays;

import java.util.Observable;
import java.util.Observer;
import merlin.data.ImportedGeom;
import merlin.geom.IMerlinGeomSrc;
import merlin.mv.ModelView;
import merlin.mv.displays.GeomDispMgr;
import merlin.mv.displays.IMerlinDisplay;
import merlin.mv.displays.IPropsDisplay;
import merlin.util.MerlinProps;
import thunderheadeng.scene3d.text.EmptyTextSrc;
import thunderheadeng.scene3d.text.IDisplayableTextSrc;

public abstract class APropsDisplay<T extends MerlinProps>
implements Observer,
IPropsDisplay<T> {
    private final ModelView d_mv;
    private final MerlinProps.WeakRef<T> d_builder;
    private final GeomDispMgr.Display d_geomDisplay;

    public APropsDisplay(ModelView mv) {
        this.d_mv = mv;
        this.d_builder = new MerlinProps.WeakRef(this);
        this.d_geomDisplay = new GeomDispMgr.Display(mv.getDisplayProps(), this.constructGeom());
    }

    protected abstract IMerlinGeomSrc constructGeom(T var1);

    protected IDisplayableTextSrc constructText(T builder) {
        return new EmptyTextSrc();
    }

    protected abstract Object[] getInterestingChanges();

    private IMerlinGeomSrc constructGeom() {
        IMerlinGeomSrc source = null;
        if (!this.d_builder.isNull()) {
            source = this.constructGeom(this.d_builder.val());
        }
        return source == null ? new ImportedGeom("") : source;
    }

    private IDisplayableTextSrc constructText() {
        if (!this.d_builder.isNull()) {
            return this.constructText(this.d_builder.val());
        }
        return new EmptyTextSrc();
    }

    @Override
    public void update(Observable o, Object arg) {
        Object[] changes = this.getInterestingChanges();
        if (!this.d_builder.isNull() && (changes.length == 0 || ((MerlinProps)this.d_builder.val()).aPropChanged(changes))) {
            this.updateDisplay();
            this.d_mv.repaint();
        }
    }

    @Override
    public void setProps(T props) {
        this.d_builder.set(props);
        this.updateDisplay();
    }

    private void updateDisplay() {
        this.d_geomDisplay.setSource(this.constructGeom());
        this.d_geomDisplay.setTextSource(this.constructText());
    }

    @Override
    public IMerlinDisplay getDisplay() {
        return this.d_geomDisplay;
    }

    protected ModelView getModelView() {
        return this.d_mv;
    }
}

