/*
 * Decompiled with CFR 0.152.
 */
package merlin.manip;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.IntFunction;
import javax.vecmath.Matrix4d;
import merlin.Intl;
import merlin.MerlinApp;
import merlin.actions.AMerlinOp;
import merlin.actions.TransformAction;
import merlin.actions.UIHook;
import merlin.actions.Undo;
import merlin.actions.copypaste.Copy;
import merlin.data.ICompElement;
import merlin.data.IMerlinObj;
import merlin.data.MerlinData;
import merlin.geom.IMerlinGeomSrc;
import merlin.mv.ModelView;
import merlin.mv.displays.GlobalDisplayMgr;
import merlin.mv.displays.IMerlinDispMgr;
import merlin.util.MerlinProps;
import merlin.util.MerlinUtil;
import thunderheadeng.geometry.IMutableGeomSrc;
import thunderheadeng.geometry.manip.IHandle;
import thunderheadeng.geometry.objs.IDOF;
import thunderheadeng.geometry.objs.transform.ITransform;
import thunderheadeng.geometry.objs.transform.IdentityXform;
import thunderheadeng.geometry.objs.transform.TransformInfo;
import thunderheadeng.geometry.objs.transform.TransformUtil;
import thunderheadeng.gui.Application;
import thunderheadeng.scene3d.manip.HandleMgr;
import thunderheadeng.scene3d.nativebuffered.ModelScene;
import thunderheadeng.scene3d.tools.transform.ITransformMgr;
import thunderheadeng.scene3d.transformpreview.ITransformPreview;
import thunderheadeng.util.CachedValue;
import thunderheadeng.util.IdentityHashSet;
import thunderheadeng.util.LinkedIdentityHashSet;
import thunderheadeng.util.Pair;
import thunderheadeng.util.theUtil;

public abstract class ATransformManip
extends MerlinProps
implements ITransformMgr {
    public static final Object SEL_CHANGED = "ATransformManip.SEL_CHANGED";
    public static final Object OBJS_TRANSFORMED = "ATransformManip.OBJS_TRANSFORMED";
    public static final Object CANCELLED = "ATransformManip.CANCELLED";
    public static final Object TRANSFORM_CHANGED = "ATransformManip.TRANSFORM_CHANGED";
    public static final Object COPY_MODE_CHANGED = "ATransformManip.COPY_MODE_CHANGED";
    public static final Object RANDOMIZE_COPIES = "RANDOMIZE_COPIES";
    public static final Object INPUT_CHANGED = "ATransformManip.INPUT_CHANGED";
    private final ModelView d_mv;
    private final GlobalDisplayMgr d_dispMgr;
    private final GlobalDisplayMgr d_xformDispMgr;
    private Collection<? extends IMerlinObj> d_selection = Collections.emptySet();
    private Set<IMerlinGeomSrc> d_flattenedSel = Collections.emptySet();
    private boolean d_copyModeEnabled = false;
    private int d_copies = 1;
    private boolean d_randomizeCopies = true;
    private final CachedValue<IDOF> d_dof = new CachedValue();
    private IntFunction<ITransform> d_getXform = i -> TransformUtil.IDENTITY;
    private final CachedValue<Boolean> d_isTransforming = new CachedValue();
    private final CachedValue<Boolean> d_canTransform = new CachedValue();
    private ITransformPreview d_xformPreview;

    protected abstract void reset();

    protected abstract String getActionName();

    public ATransformManip(ModelView mv, GlobalDisplayMgr dispMgr, GlobalDisplayMgr xformDispMgr) {
        this.d_dispMgr = dispMgr;
        this.d_mv = mv;
        this.d_xformDispMgr = xformDispMgr;
    }

    public void activate() {
        this.pause();
        this.setCopyMode(false);
        this.setNumCopies(1);
        MerlinData md = MerlinApp.getApp().getData();
        Set<IMerlinObj> sel = TransformAction.getValidObjs(md);
        this.setSelection(sel);
        this.resume();
    }

    public void deactivate() {
        this.setSelection(Collections.emptyList());
    }

    public void setSelection(Collection<? extends IMerlinObj> objs) {
        if (!this.lock()) {
            return;
        }
        this.d_selection = objs;
        this.d_flattenedSel = new IdentityHashSet<IMerlinGeomSrc>(TransformAction.getGeom(MerlinApp.getAppData(), objs));
        this.d_isTransforming.clear();
        this.d_dof.clear();
        this.endPreview();
        this.firePropChanged(SEL_CHANGED);
        this.release();
    }

    public Collection<? extends IMerlinObj> getSelection() {
        return this.d_selection;
    }

    public void setNumCopies(int numCopies) {
        if (this.d_copies == numCopies || !this.lock()) {
            return;
        }
        assert (numCopies >= 1);
        this.d_copies = numCopies;
        this.firePropChanged(COPY_MODE_CHANGED);
        this.release();
    }

    public int getNumCopies() {
        return this.d_copies;
    }

    @Override
    public boolean getCopyMode() {
        return this.d_copyModeEnabled;
    }

    @Override
    public void setCopyMode(boolean copyMode) {
        if (copyMode == this.d_copyModeEnabled || !this.lock()) {
            return;
        }
        this.d_copyModeEnabled = copyMode;
        if (this.d_copyModeEnabled && this.d_copies < 1) {
            this.d_copies = 1;
        }
        if (this.d_xformPreview != null) {
            this.d_xformPreview.setCopyMode(copyMode);
        }
        this.firePropChanged(COPY_MODE_CHANGED);
        this.release();
    }

    public void setRandomizeCopies(boolean randomize) {
        if (this.d_randomizeCopies == randomize || !this.lock()) {
            return;
        }
        this.d_randomizeCopies = randomize;
        this.firePropChanged(RANDOMIZE_COPIES);
        this.release();
    }

    public boolean getRandomizeCopies() {
        return this.d_randomizeCopies;
    }

    @Override
    public void cancel() {
        this.localReset();
        this.firePropChanged(CANCELLED);
    }

    private void localReset() {
        this.d_dof.clear();
        this.d_getXform = i -> TransformUtil.IDENTITY;
        this.d_canTransform.clear();
        this.d_isTransforming.clear();
        this.reset();
        this.endPreview();
    }

    private void endPreview() {
        for (IMerlinDispMgr<?> dm : this.d_xformDispMgr.getManagers()) {
            dm.removeAll();
        }
        this.applyToScenes(scene -> scene.setTransform(null));
        if (this.d_xformPreview != null) {
            this.d_mv.setVisible(HandleMgr.FILTER_TYPE, true, false);
            this.d_xformPreview.end();
            this.d_xformPreview = null;
        }
    }

    @Override
    public void commit(Runnable postOp) {
        this.transform(Application.getApp().getActiveFrame(), postOp);
    }

    public void transform(Component c, final Runnable postOp) {
        if (this.d_selection.isEmpty()) {
            this.localReset();
            postOp.run();
            return;
        }
        final int numCopies = this.getCopyMode() ? this.getNumCopies() : 0;
        final TransformInfo[] xforms = new TransformInfo[numCopies > 0 ? numCopies : 1];
        for (int m = 0; m < xforms.length; ++m) {
            xforms[m] = this.d_getXform.apply(m).getInfo();
        }
        final String actionName = this.getActionName();
        final ArrayList<? extends IMerlinObj> objs = new ArrayList<IMerlinObj>(this.d_selection);
        final boolean randomizeCopies = this.d_randomizeCopies;
        AMerlinOp op = new AMerlinOp(){

            @Override
            public void run(MerlinApp app, MerlinData data) {
                if (ATransformManip.this.getCopyMode() && data.scenarios.anyOverriden(objs)) {
                    Copy.showScenarioWarning(app.getActiveFrame());
                }
                try (MerlinData.WriteLock lock = data.lockWrite();){
                    String name = numCopies > 0 ? Intl.intl("Copy") + "/" + actionName : actionName;
                    Undo.begin(name);
                    Undo.insertUndoEntry_restoreSelection(data);
                    if (numCopies <= 0) {
                        assert (xforms.length == 1);
                        Collection<IMerlinGeomSrc> geomObjs = TransformAction.getGeom(data, objs);
                        TransformAction.transform(MerlinApp.getApp(), data, theUtil.map(geomObjs, obj -> new Pair<IMerlinGeomSrc, TransformInfo>((IMerlinGeomSrc)obj, xforms[0])));
                    } else {
                        List<List<IMerlinObj>> copies = TransformAction.transformCopies(MerlinApp.getApp(), data, objs, xforms);
                        if (randomizeCopies) {
                            for (List<IMerlinObj> objs2 : copies) {
                                for (ICompElement obj2 : MerlinUtil.flatten(objs2, ICompElement.class, MerlinUtil::canRandomize)) {
                                    obj2.setProp(MerlinData.SEED, MerlinUtil.newSeed());
                                }
                            }
                        }
                    }
                    Undo.end(data);
                }
                ATransformManip.this.localReset();
                postOp.run();
                ATransformManip.this.firePropChanged(OBJS_TRANSFORMED);
            }
        };
        UIHook.run(c, "ATransformManip.transform", op, 4);
    }

    private void tryBegin() {
        if (this.d_xformPreview != null || !this.isTransforming() || !this.isTransformValid()) {
            return;
        }
        LinkedIdentityHashSet<IMutableGeomSrc> previewObjs = new LinkedIdentityHashSet<IMutableGeomSrc>(MerlinUtil.flatten(this.d_flattenedSel, IMutableGeomSrc.class));
        this.d_mv.setVisible(HandleMgr.FILTER_TYPE, false, false);
        this.d_xformPreview = this.d_dispMgr.getTransformPreview(this.d_xformDispMgr, (Collection<? extends Object>)previewObjs, this.d_copyModeEnabled);
    }

    @Override
    public boolean isTransforming() {
        return this.d_isTransforming.get(() -> {
            if (this.d_selection.isEmpty()) {
                return false;
            }
            ITransform xform = this.d_getXform.apply(0);
            return !xform.isIdentity();
        });
    }

    @Override
    public boolean isTransforming(Object obj) {
        return this.isTransforming() && !this.getCopyMode() && this.d_flattenedSel.contains(obj);
    }

    @Override
    public Object getProxySource(Object obj) {
        HandleMgr handleMgr;
        if (obj instanceof IHandle && (handleMgr = this.d_mv.getHandleMgr()).getCurrentHandles().contains(obj)) {
            return handleMgr.getCurrentSourceObj();
        }
        return obj;
    }

    @Override
    public IDOF getDOF() {
        return this.d_dof.get(() -> ATransformManip.getDOF(this.d_flattenedSel));
    }

    private static IDOF getDOF(Collection<? extends IMutableGeomSrc> geoms) {
        LinkedHashSet<IDOF> dofs = new LinkedHashSet<IDOF>();
        for (IMutableGeomSrc iMutableGeomSrc : geoms) {
            dofs.add(iMutableGeomSrc.getGeom().getDOF());
        }
        return IDOF.group(dofs);
    }

    @Override
    public void modify(IntFunction<ITransform> xform) {
        this.d_getXform = xform;
        this.d_isTransforming.clear();
        this.d_canTransform.clear();
        this.tryBegin();
        if (this.d_xformPreview != null) {
            IdentityXform xform0 = this.isTransformValid() ? this.d_getXform.apply(0) : TransformUtil.IDENTITY;
            Matrix4d mat = xform0.toMatrix(false);
            this.d_xformPreview.setTransform(mat);
            this.applyToScenes(scene -> scene.setTransform(mat));
        }
        this.firePropChanged(TRANSFORM_CHANGED);
    }

    @Override
    public void inputChanged() {
        this.d_isTransforming.clear();
        this.d_canTransform.clear();
        this.firePropChanged(INPUT_CHANGED);
    }

    private void applyToScenes(Consumer<ModelScene> function) {
        for (IMerlinDispMgr<?> dm : this.d_xformDispMgr.getManagers()) {
            dm.getScenes(function);
        }
    }

    @Override
    public boolean isTransformValid() {
        return this.d_canTransform.get(() -> {
            ITransform xform = this.d_getXform.apply(0);
            return !xform.isIdentity() && xform.isInvertible();
        });
    }
}

