/*
 * Decompiled with CFR 0.152.
 */
package merlin.legacy.v0013.data.geom;

import java.io.Serializable;
import java.util.ArrayList;
import merlin.legacy.v0013.data.geom.FaceProp;
import merlin.legacy.v0013.data.geom.Geom3D;
import thunderheadeng.geometry.objs.GeomUtil;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.scene3d.geom.IPrimProps;
import thunderheadeng.scene3d.geom.IPropsSrc;
import thunderheadeng.scene3d.geom.PropsBuilder;
import thunderheadeng.util.HashPool;

public class Mesh
extends Geom3D {
    static final long serialVersionUID = 1L;
    public static final byte POLYTYPE_POINTS = 0;
    public static final byte POLYTYPE_LINESEGS = 1;
    public static final byte POLYTYPE_TRIANGLES = 2;
    public static final byte POLYTYPE_QUADS = 3;
    public FaceSet[] d_faceSets;

    @Override
    protected IGeom convertGeom() {
        ArrayList<thunderheadeng.geometry.objs.Mesh> meshes = new ArrayList<thunderheadeng.geometry.objs.Mesh>(this.d_faceSets.length);
        for (FaceSet fs : this.d_faceSets) {
            meshes.add(new thunderheadeng.geometry.objs.Mesh(this.d_points, fs.d_indices, switch (fs.d_faceType) {
                case 1 -> 1;
                case 2 -> 2;
                case 3 -> 3;
                default -> 0;
            }));
        }
        return GeomUtil.group(meshes);
    }

    @Override
    protected IPropsSrc convertProps(HashPool<IPrimProps> propsPool, IGeom geom) {
        IPrimProps baseProps = super.convertMeta(propsPool, Mesh.getPrimTypes(geom), false);
        PropsBuilder props = new PropsBuilder();
        for (FaceSet fs : this.d_faceSets) {
            int numElements = fs.getNumElements();
            for (int m = 0; m < numElements; ++m) {
                IPrimProps fprops = fs.getProps(m, baseProps);
                fprops = propsPool.getExisting(fprops);
                props.add(fprops);
            }
        }
        return props.finalizeProps();
    }

    public static class FaceSet
    implements Serializable {
        static final long serialVersionUID = 1L;
        public byte d_faceType;
        public int[] d_indices;
        public FaceProp[] d_faceProps;

        private int getNumElements() {
            switch (this.d_faceType) {
                case 2: {
                    return this.d_indices.length / 3;
                }
                case 3: {
                    return this.d_indices.length / 4;
                }
                case 1: {
                    return this.d_indices.length / 2;
                }
            }
            return this.d_indices.length;
        }

        private IPrimProps getProps(int element, IPrimProps defProps) {
            if (this.d_faceProps == null) {
                return defProps;
            }
            FaceProp prop = this.d_faceProps[element];
            if (prop == null) {
                return defProps;
            }
            return new IPrimProps.GenericProps(prop.color, null, defProps.getEdgeWidth(), defProps.getEdgeStipple(), defProps.getPointSize(), defProps.getOptions()).optimize(switch (this.d_faceType) {
                case 2, 3 -> 1;
                case 1 -> 2;
                default -> 4;
            });
        }
    }
}

