/*
 * Decompiled with CFR 0.152.
 */
package merlin.gui.value;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Window;
import java.util.Objects;
import javax.swing.SwingUtilities;
import merlin.Intl;
import merlin.data.value.IVariant;
import merlin.gui.value.IVariantEditor;
import merlin.unitsystem.UnitSystem;
import thunderheadeng.gui.HTMLBtn;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiPanel;

public class VariantButton<T>
extends HTMLBtn {
    private static final long serialVersionUID = 1L;
    public static final String VALUE = "value";
    private final IVariantEditor<T> d_varEditor;
    private final String d_propDesc;
    private IVariant<T> d_currVal;

    public VariantButton(String propDesc, IVariantEditor<T> editor) {
        super("");
        this.d_varEditor = editor;
        this.d_propDesc = propDesc;
        this.sync();
        this.addActionListener(e -> {
            IVariant<T> newVal;
            guiPanel editorPnl = this.d_varEditor.getEditorPanel(UnitSystem.getType(1, true));
            this.d_varEditor.load(editorPnl, this.d_currVal);
            Window parent = SwingUtilities.getWindowAncestor(this);
            String title = String.format(Intl.intl("Edit %s"), propDesc);
            guiDialog dlg = new guiDialog(parent, title, 9);
            guiPanel c = dlg.getDialogPane();
            c.setLayout(new BorderLayout());
            c.add((Component)editorPnl, "Center");
            if (dlg.doModal() == 1 && dlg.isModified() && (newVal = this.d_varEditor.save(editorPnl)) != null && !Objects.equals(this.d_currVal, newVal)) {
                IVariant<T> oldVal = this.d_currVal;
                this.d_currVal = newVal;
                this.firePropertyChange(VALUE, oldVal, newVal);
                this.sync();
            }
        });
    }

    public String getPropDescription() {
        return this.d_propDesc;
    }

    public void setValue(IVariant<T> value) {
        this.d_currVal = value;
        this.sync();
    }

    public IVariant<T> getValue() {
        return this.d_currVal;
    }

    private void sync() {
        if (this.d_currVal != null) {
            this.setText(this.d_varEditor.describe(this.d_currVal));
        } else {
            this.setText("&lt;" + Intl.intl("varies") + "&gt;");
        }
    }
}

