/*
 * Decompiled with CFR 0.152.
 */
package merlin.gui.value;

import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.Mediator;
import thunderheadeng.gui.value.IValEditor;
import thunderheadeng.util.Property;

public class PropertyToValEditor<T>
implements IValEditor<T> {
    private final Class<T> d_type;
    private final IValEditor<Property<T>> d_editor;

    public PropertyToValEditor(Class<T> type, IValEditor<Property<T>> editor) {
        this.d_type = type;
        this.d_editor = editor;
    }

    @Override
    public boolean isLive() {
        return this.d_editor.isLive();
    }

    @Override
    public String formatNonLiveValue() {
        return this.d_editor.formatNonLiveValue();
    }

    @Override
    public <DomainT extends Mediator> T commit(DomainT domain) {
        this.d_editor.commit(domain);
        return this.getValue();
    }

    @Override
    public Class<T> getType() {
        return this.d_type;
    }

    @Override
    public T getValue() {
        return this.d_editor.getValue().orElse(null);
    }

    @Override
    public void setValue(T value) {
        this.d_editor.setValue(Property.ofNullable(value));
    }

    @Override
    public JComponent getComponent() {
        return this.d_editor.getComponent();
    }

    @Override
    public void add(GridBagHelper gb) {
        this.d_editor.add(gb);
    }

    @Override
    public void addListener(String prop, PropertyChangeListener listener) {
        this.d_editor.addListener(prop, listener);
    }

    @Override
    public void removeListener(String prop, PropertyChangeListener listener) {
        this.d_editor.removeListener(prop, listener);
    }

    @Override
    public PropertyChangeListener[] getListeners(String prop) {
        return this.d_editor.getListeners(prop);
    }
}

